/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.SkillSpecAPI;
import com.fs.starfarer.api.impl.campaign.skills.BaseSkillEffectDescription;
import com.fs.starfarer.api.impl.campaign.skills.NeuralLinkScript;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class NeuralLink {

    public static class Level0
    implements DescriptionSkillEffect {
        @Override
        public String getString() {
            String control = Global.getSettings().getControlStringForEnumName(NeuralLinkScript.TRANSFER_CONTROL);
            String desc = Global.getSettings().getControlDescriptionForEnumName(NeuralLinkScript.TRANSFER_CONTROL);
            return "\n*Use the \"" + desc + "\" control [" + control + "] to switch between ships.";
        }

        @Override
        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h};
        }

        @Override
        public String[] getHighlights() {
            String control = Global.getSettings().getControlStringForEnumName(NeuralLinkScript.TRANSFER_CONTROL);
            String desc = Global.getSettings().getControlDescriptionForEnumName(NeuralLinkScript.TRANSFER_CONTROL);
            return new String[]{control};
        }

        @Override
        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    extends BaseSkillEffectDescription
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            if (stats.isPlayerStats()) {
                stats.getDynamic().getMod("has_neural_link").modifyFlat(id, 1.0f);
            }
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            if (stats.isPlayerStats()) {
                stats.getDynamic().getMod("has_neural_link").unmodifyFlat(id);
            }
        }

        @Override
        public void createCustomDescription(MutableCharacterStatsAPI stats, SkillSpecAPI skill, TooltipMakerAPI info, float width) {
            this.init(stats, skill);
            String dp = "" + (int)NeuralLinkScript.INSTANT_TRANSFER_DP;
            info.addPara("Allows two ships to benefit from your combat skills at the same time and enables rapid switching between them.", this.hc, 0.0f);
            info.addPara("The destination ship must not be under the command of an officer or an AI core.", this.hc, 5.0f);
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }
}

