/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;

public class ShipDesign {
    public static final float CAPACITORS_BONUS = 20.0f;
    public static final float VENTS_BONUS = 20.0f;
    public static final float OP_BONUS = 10.0f;

    public static class Level1
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getMaxCapacitorsBonus().modifyPercent(id, 20.0f);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getMaxCapacitorsBonus().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+20% maximum flux capacitors";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level2
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getMaxVentsBonus().modifyPercent(id, 20.0f);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getMaxVentsBonus().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+20% maximum flux vents";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }

    public static class Level3
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getShipOrdnancePointBonus().modifyPercent(id, 10.0f);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getShipOrdnancePointBonus().unmodify(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "+10% ordnance points";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

