/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.util.Misc;

public class RangeBlockerUtil {
    private int resolution;
    private float maxRange;
    private float degreesPerUnit;
    private float[] limits;
    private float[] curr;
    private boolean wasUpdated = false;
    private boolean isAnythingShortened = false;

    public RangeBlockerUtil(int resolution, float maxRange) {
        this.resolution = resolution;
        this.maxRange = maxRange;
        this.degreesPerUnit = 360.0f / (float)resolution;
        this.limits = new float[resolution];
        this.curr = new float[resolution];
    }

    public boolean wasEverUpdated() {
        return this.wasUpdated;
    }

    public void updateAndSync(SectorEntityToken entity, SectorEntityToken exclude, float diffMult) {
        this.updateLimits(entity, exclude, diffMult);
        this.sync();
    }

    public void sync() {
        int i = 0;
        while (i < this.resolution) {
            this.curr[i] = this.limits[i];
            ++i;
        }
    }

    public float getShortenAmountAt(float angle) {
        return this.maxRange - this.getCurrMaxAt(angle);
    }

    public float getCurrMaxAt(float angle) {
        angle = Misc.normalizeAngle(angle);
        float index = angle / 360.0f * (float)this.resolution;
        int i1 = (int)Math.floor(index);
        int i2 = (int)Math.ceil(index);
        while (i1 >= this.resolution) {
            i1 -= this.resolution;
        }
        while (i2 >= this.resolution) {
            i2 -= this.resolution;
        }
        float v1 = this.curr[i1];
        float v2 = this.curr[i2];
        return v1 + (v2 - v1) * (index - (float)((int)index));
    }

    public float getAlphaAt(float angle) {
        return 1.0f;
    }

    public void advance(float amount, float minApproachSpeed, float diffMult) {
        int i = 0;
        while (i < this.resolution) {
            this.curr[i] = Misc.approach(this.curr[i], this.limits[i], minApproachSpeed, diffMult, amount);
            ++i;
        }
    }

    public void updateLimits(SectorEntityToken entity, SectorEntityToken exclude, float diffMult) {
        int i = 0;
        while (i < this.resolution) {
            this.limits[i] = this.maxRange;
            ++i;
        }
        this.isAnythingShortened = false;
        for (PlanetAPI planet : entity.getContainingLocation().getPlanets()) {
            float dist;
            if (planet == entity || planet == exclude || (dist = Misc.getDistance(entity.getLocation(), planet.getLocation())) > this.maxRange) continue;
            float graceRadius = 100.0f;
            graceRadius = 0.0f;
            graceRadius = planet.getRadius() + 100.0f;
            float span = Misc.computeAngleSpan(planet.getRadius() + graceRadius, dist);
            float angle = Misc.getAngleInDegrees(entity.getLocation(), planet.getLocation());
            float offsetSize = this.maxRange * 0.2f;
            float spanOffset = span * 0.4f * 1.0f / diffMult;
            spanOffset = 0.0f;
            float f = angle - span / 2.0f - spanOffset;
            while (f <= angle + span / 2.0f - spanOffset) {
                float offset = Math.abs(f - angle) / (span / 2.0f);
                if (offset > 1.0f) {
                    offset = 1.0f;
                }
                offset = 1.0f - (float)Math.cos(offset * 3.1416f / 2.0f);
                offset *= offset;
                int index = this.getIndexForAngle(f);
                this.limits[index] = Math.min(dist - planet.getRadius() * 0.5f + (offset *= offsetSize), this.limits[index]);
                this.isAnythingShortened = true;
                f += this.degreesPerUnit;
            }
        }
        this.wasUpdated = true;
    }

    public void block(float angle, float arc, float limit) {
        float offsetSize = Math.max(limit, this.maxRange * 0.1f);
        float f = angle - arc / 2.0f;
        while (f <= angle + arc / 2.0f) {
            float offset = Math.abs(f - angle) / (arc / 2.0f);
            if (offset > 1.0f) {
                offset = 1.0f;
            }
            offset = 1.0f - (float)Math.cos(offset * 3.1416f / 2.0f);
            offset += 1.0f;
            offset *= offset;
            offset -= 1.0f;
            offset *= offsetSize;
            offset = Math.abs(offset);
            int index = this.getIndexForAngle(f);
            this.limits[index] = Math.min(limit + offset, this.limits[index]);
            this.isAnythingShortened = true;
            f += this.degreesPerUnit;
        }
    }

    public int getIndexForAngle(float angle) {
        int index = Math.round((angle = Misc.normalizeAngle(angle)) / 360.0f * (float)this.resolution);
        if (index < 0) {
            index = 0;
        }
        while (index >= this.resolution) {
            index -= this.resolution;
        }
        return index;
    }

    public boolean isAnythingShortened() {
        return this.isAnythingShortened;
    }

    public float getMaxRange() {
        return this.maxRange;
    }
}

