/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.terrain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TerrainAIFlags;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberViewAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.impl.campaign.terrain.AuroraRenderer;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.CRLossPerSecondBuff;
import com.fs.starfarer.api.impl.campaign.terrain.EventHorizonPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.FlareManager;
import com.fs.starfarer.api.impl.campaign.terrain.PeakPerformanceBuff;
import com.fs.starfarer.api.impl.campaign.terrain.RangeBlockerUtil;
import com.fs.starfarer.api.loading.Description;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class StarCoronaTerrainPlugin
extends BaseRingTerrain
implements AuroraRenderer.AuroraRendererDelegate,
FlareManager.FlareManagerDelegate {
    public static final float CR_LOSS_MULT_GLOBAL = 0.25f;
    protected transient SpriteAPI texture = null;
    protected transient Color color;
    protected AuroraRenderer renderer;
    protected FlareManager flareManager;
    protected CoronaParams params;
    protected transient RangeBlockerUtil blocker = null;
    private transient EnumSet<CampaignEngineLayers> layers = EnumSet.of(CampaignEngineLayers.TERRAIN_7);

    @Override
    public void init(String terrainId, SectorEntityToken entity, Object param) {
        super.init(terrainId, entity, param);
        this.params = (CoronaParams)param;
        this.name = this.params.name;
        if (this.name == null) {
            this.name = "Corona";
        }
    }

    @Override
    public String getNameForTooltip() {
        return "Corona";
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        this.texture = Global.getSettings().getSprite("terrain", "aurora");
        this.layers = EnumSet.of(CampaignEngineLayers.TERRAIN_7);
        if (this.renderer == null) {
            this.renderer = new AuroraRenderer(this);
        }
        if (this.flareManager == null) {
            this.flareManager = new FlareManager(this);
        }
        if (this.blocker == null) {
            this.blocker = new RangeBlockerUtil(360, ((BaseRingTerrain)this).params.bandWidthInEngine + 1000.0f);
        }
        return this;
    }

    @Override
    Object writeReplace() {
        return this;
    }

    @Override
    protected boolean shouldPlayLoopOne() {
        return super.shouldPlayLoopOne() && !this.flareManager.isInActiveFlareArc(Global.getSector().getPlayerFleet());
    }

    @Override
    protected boolean shouldPlayLoopTwo() {
        return super.shouldPlayLoopTwo() && this.flareManager.isInActiveFlareArc(Global.getSector().getPlayerFleet());
    }

    @Override
    public EnumSet<CampaignEngineLayers> getActiveLayers() {
        return this.layers;
    }

    public CoronaParams getParams() {
        return this.params;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        this.renderer.advance(amount);
        this.flareManager.advance(amount);
        if (amount > 0.0f && this.blocker != null) {
            this.blocker.updateLimits(this.entity, this.params.relatedEntity, 0.5f);
            this.blocker.advance(amount, 100.0f, 0.5f);
        }
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        if (this.blocker != null && !this.blocker.wasEverUpdated()) {
            this.blocker.updateAndSync(this.entity, this.params.relatedEntity, 0.5f);
        }
        this.renderer.render(viewport.getAlphaMult());
    }

    @Override
    public float getRenderRange() {
        FlareManager.Flare curr = this.flareManager.getActiveFlare();
        if (curr != null) {
            float outerRadiusWithFlare = this.computeRadiusWithFlare(this.flareManager.getActiveFlare());
            return outerRadiusWithFlare + 200.0f;
        }
        return super.getRenderRange();
    }

    @Override
    public boolean containsPoint(Vector2f point, float radius) {
        float dist;
        if (this.blocker != null && this.blocker.isAnythingShortened()) {
            float max;
            float angle = Misc.getAngleInDegrees(this.entity.getLocation(), point);
            dist = Misc.getDistance(this.entity.getLocation(), point);
            if (dist > (max = this.blocker.getCurrMaxAt(angle))) {
                return false;
            }
        }
        if (this.flareManager.isInActiveFlareArc(point)) {
            float outerRadiusWithFlare = this.computeRadiusWithFlare(this.flareManager.getActiveFlare());
            dist = Misc.getDistance(this.entity.getLocation(), point);
            if (dist > outerRadiusWithFlare + radius) {
                return false;
            }
            return !(dist + radius < this.params.middleRadius - this.params.bandWidthInEngine / 2.0f);
        }
        return super.containsPoint(point, radius);
    }

    protected float computeRadiusWithFlare(FlareManager.Flare flare) {
        float inner = this.getAuroraInnerRadius();
        float outer = this.params.middleRadius + this.params.bandWidthInEngine * 0.5f;
        float thickness = outer - inner;
        thickness *= flare.extraLengthMult;
        return inner + (thickness += flare.extraLengthFlat);
    }

    @Override
    protected float getExtraSoundRadius() {
        float base = super.getExtraSoundRadius();
        float angle = Misc.getAngleInDegrees(this.params.relatedEntity.getLocation(), Global.getSector().getPlayerFleet().getLocation());
        float extra = 0.0f;
        if (this.flareManager.isInActiveFlareArc(angle)) {
            extra = this.computeRadiusWithFlare(this.flareManager.getActiveFlare()) - this.params.bandWidthInEngine;
        }
        return base + extra;
    }

    @Override
    public void applyEffect(SectorEntityToken entity, float days) {
        if (entity instanceof CampaignFleetAPI) {
            float fleetAccelMult;
            float intensity;
            if (!entity.isInCurrentLocation() && this instanceof EventHorizonPlugin) {
                return;
            }
            CampaignFleetAPI fleet = (CampaignFleetAPI)entity;
            boolean inFlare = false;
            if (this.flareManager.isInActiveFlareArc(fleet)) {
                inFlare = true;
            }
            if ((intensity = this.getIntensityAtPoint(fleet.getLocation())) <= 0.0f) {
                return;
            }
            if (fleet.hasTag("fleet_ignores_corona")) {
                return;
            }
            String buffId = this.getModId();
            float buffDur = 0.1f;
            boolean protectedFromCorona = false;
            if (fleet.isInCurrentLocation() && Misc.getDistance(fleet, Global.getSector().getPlayerFleet()) < 500.0f) {
                for (SectorEntityToken sectorEntityToken : fleet.getContainingLocation().getCustomEntitiesWithTag("protects_from_corona_in_battle")) {
                    float dist = Misc.getDistance(sectorEntityToken, fleet);
                    if (!(dist < sectorEntityToken.getRadius() + fleet.getRadius() + 10.0f)) continue;
                    protectedFromCorona = true;
                    break;
                }
            }
            for (FleetMemberAPI fleetMemberAPI : fleet.getFleetData().getMembersListCopy()) {
                float curr;
                float adjustedLossMult;
                float loss;
                float recoveryRate = fleetMemberAPI.getStats().getBaseCRRecoveryRatePercentPerDay().getModifiedValue();
                float lossRate = fleetMemberAPI.getStats().getBaseCRRecoveryRatePercentPerDay().getBaseValue();
                float resistance = fleetMemberAPI.getStats().getDynamic().getValue("corona_resistance");
                if (protectedFromCorona) {
                    resistance = 0.0f;
                }
                float lossMult = 1.0f;
                if (inFlare) {
                    lossMult = 2.0f;
                }
                if ((loss = (-1.0f * recoveryRate + -1.0f * lossRate * (adjustedLossMult = 0.0f + this.params.crLossMult * intensity * resistance * lossMult * 0.25f)) * days * 0.01f) > (curr = fleetMemberAPI.getRepairTracker().getBaseCR())) {
                    loss = curr;
                }
                if (resistance > 0.0f) {
                    if (inFlare) {
                        fleetMemberAPI.getRepairTracker().applyCREvent(loss, "flare", "Solar flare effect");
                    } else {
                        fleetMemberAPI.getRepairTracker().applyCREvent(loss, "corona", "Star corona effect");
                    }
                }
                float peakFraction = 1.0f / Math.max(1.3333f, 1.0f + this.params.crLossMult * intensity);
                float peakLost = 1.0f - peakFraction;
                float degradationMult = 1.0f + this.params.crLossMult * intensity * resistance / 2.0f;
                fleetMemberAPI.getBuffManager().addBuffOnlyUpdateStat(new PeakPerformanceBuff(String.valueOf(buffId) + "_1", 1.0f - (peakLost *= resistance), buffDur));
                fleetMemberAPI.getBuffManager().addBuffOnlyUpdateStat(new CRLossPerSecondBuff(String.valueOf(buffId) + "_2", degradationMult, buffDur));
            }
            float f = fleet.getFleetData().getBurnLevel();
            float currFleetBurn = fleet.getCurrBurnLevel();
            float maxWindBurn = this.params.windBurnLevel;
            if (inFlare) {
                maxWindBurn *= 2.0f;
            }
            float currWindBurn = intensity * maxWindBurn;
            float maxFleetBurnIntoWind = f - Math.abs(currWindBurn);
            float angle = Misc.getAngleInDegreesStrict(this.entity.getLocation(), fleet.getLocation());
            Vector2f windDir = Misc.getUnitVectorAtDegreeAngle(angle);
            if (currWindBurn < 0.0f) {
                windDir.negate();
            }
            Vector2f velDir = Misc.normalise(new Vector2f((ReadableVector2f)fleet.getVelocity()));
            velDir.scale(currFleetBurn);
            float fleetBurnAgainstWind = -1.0f * Vector2f.dot((Vector2f)windDir, (Vector2f)velDir);
            float accelMult = 0.5f;
            if (fleetBurnAgainstWind > maxFleetBurnIntoWind) {
                accelMult += 0.75f + 0.25f * (fleetBurnAgainstWind - maxFleetBurnIntoWind);
            }
            if ((fleetAccelMult = fleet.getStats().getAccelerationMult().getModifiedValue()) > 0.0f) {
                accelMult /= fleetAccelMult;
            }
            float seconds = days * Global.getSector().getClock().getSecondsPerDay();
            Vector2f vel = fleet.getVelocity();
            windDir.scale(seconds * fleet.getAcceleration() * accelMult);
            fleet.setVelocity(vel.x + windDir.x, vel.y + windDir.y);
            Color glowColor = this.getAuroraColorForAngle(angle);
            int alpha = glowColor.getAlpha();
            if (alpha < 75) {
                glowColor = Misc.setAlpha(glowColor, 75);
            }
            float dist = Misc.getDistance(this.entity.getLocation(), fleet.getLocation());
            float check = 100.0f;
            if (this.params.relatedEntity != null) {
                check = this.params.relatedEntity.getRadius() * 0.5f;
            }
            if (dist > check) {
                float durIn = 1.0f;
                float durOut = 10.0f;
                Misc.normalise(windDir);
                float sizeNormal = 5.0f + 10.0f * intensity;
                float sizeFlare = 10.0f + 15.0f * intensity;
                for (FleetMemberViewAPI view : fleet.getViews()) {
                    if (inFlare) {
                        view.getWindEffectDirX().shift(String.valueOf(this.getModId()) + "_flare", windDir.x * sizeFlare, durIn, durOut, 1.0f);
                        view.getWindEffectDirY().shift(String.valueOf(this.getModId()) + "_flare", windDir.y * sizeFlare, durIn, durOut, 1.0f);
                        view.getWindEffectColor().shift(String.valueOf(this.getModId()) + "_flare", glowColor, durIn, durOut, intensity);
                        continue;
                    }
                    view.getWindEffectDirX().shift(this.getModId(), windDir.x * sizeNormal, durIn, durOut, 1.0f);
                    view.getWindEffectDirY().shift(this.getModId(), windDir.y * sizeNormal, durIn, durOut, 1.0f);
                    view.getWindEffectColor().shift(this.getModId(), glowColor, durIn, durOut, intensity);
                }
            }
        }
    }

    public float getIntensityAtPoint(Vector2f point) {
        float angle = Misc.getAngleInDegrees(this.params.relatedEntity.getLocation(), point);
        float maxDist = this.params.bandWidthInEngine;
        if (this.flareManager.isInActiveFlareArc(angle)) {
            maxDist = this.computeRadiusWithFlare(this.flareManager.getActiveFlare());
        }
        float minDist = this.params.relatedEntity.getRadius();
        float dist = Misc.getDistance(point, this.params.relatedEntity.getLocation());
        if (dist > maxDist) {
            return 0.0f;
        }
        float intensity = 1.0f;
        if (minDist < maxDist) {
            intensity = 1.0f - (dist - minDist) / (maxDist - minDist);
            if (intensity < 0.0f) {
                intensity = 0.0f;
            }
            if (intensity > 1.0f) {
                intensity = 1.0f;
            }
        }
        return intensity;
    }

    @Override
    public Color getNameColor() {
        Color bad = Misc.getNegativeHighlightColor();
        Color base = super.getNameColor();
        return Misc.interpolateColor(base, bad, Global.getSector().getCampaignUI().getSharedFader().getBrightness() * 1.0f);
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    @Override
    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded) {
        float pad = 10.0f;
        float small = 5.0f;
        Color gray = Misc.getGrayColor();
        Color highlight = Misc.getHighlightColor();
        Color fuel = Global.getSettings().getColor("progressBarFuelColor");
        Color bad = Misc.getNegativeHighlightColor();
        tooltip.addTitle(this.name);
        tooltip.addPara(Global.getSettings().getDescription(this.getTerrainId(), Description.Type.TERRAIN).getText1(), pad);
        float nextPad = pad;
        if (expanded) {
            tooltip.addSectionHeading("Travel", Alignment.MID, pad);
            nextPad = small;
        }
        tooltip.addPara("Reduces the combat readiness of all ships in the corona at a steady pace.", nextPad);
        tooltip.addPara("The heavy solar wind also makes the star difficult to approach.", pad);
        tooltip.addPara("Occasional solar flare activity takes these effects to even more dangerous levels.", pad);
        if (expanded) {
            tooltip.addSectionHeading("Combat", Alignment.MID, pad);
            tooltip.addPara("Reduces the peak performance time of ships and increases the rate of combat readiness degradation in protracted engagements.", small);
        }
    }

    @Override
    public boolean isTooltipExpandable() {
        return true;
    }

    @Override
    public float getTooltipWidth() {
        return 350.0f;
    }

    @Override
    public String getTerrainName() {
        if (this.flareManager.isInActiveFlareArc(Global.getSector().getPlayerFleet())) {
            return "Solar Flare";
        }
        return super.getTerrainName();
    }

    @Override
    public String getEffectCategory() {
        return null;
    }

    @Override
    public float getAuroraAlphaMultForAngle(float angle) {
        return 1.0f;
    }

    @Override
    public float getAuroraBandWidthInTexture() {
        return 256.0f;
    }

    @Override
    public float getAuroraTexPerSegmentMult() {
        return 1.0f;
    }

    @Override
    public Vector2f getAuroraCenterLoc() {
        return this.params.relatedEntity.getLocation();
    }

    @Override
    public Color getAuroraColorForAngle(float angle) {
        if (this.color == null) {
            this.color = this.params.relatedEntity instanceof PlanetAPI ? ((PlanetAPI)this.params.relatedEntity).getSpec().getCoronaColor() : Color.white;
            this.color = Misc.setAlpha(this.color, 25);
        }
        if (this.flareManager.isInActiveFlareArc(angle)) {
            return this.flareManager.getColorForAngle(this.color, angle);
        }
        return this.color;
    }

    @Override
    public float getAuroraInnerRadius() {
        return this.params.relatedEntity.getRadius() + 50.0f;
    }

    @Override
    public float getAuroraOuterRadius() {
        return this.params.middleRadius + this.params.bandWidthInEngine * 0.5f;
    }

    @Override
    public float getAuroraShortenMult(float angle) {
        return 0.85f + this.flareManager.getShortenMod(angle);
    }

    @Override
    public float getAuroraInnerOffsetMult(float angle) {
        return this.flareManager.getInnerOffsetMult(angle);
    }

    @Override
    public SpriteAPI getAuroraTexture() {
        return this.texture;
    }

    @Override
    public RangeBlockerUtil getAuroraBlocker() {
        return this.blocker;
    }

    @Override
    public float getAuroraThicknessFlat(float angle) {
        if (this.flareManager.isInActiveFlareArc(angle)) {
            return this.flareManager.getExtraLengthFlat(angle);
        }
        return 0.0f;
    }

    @Override
    public float getAuroraThicknessMult(float angle) {
        if (this.flareManager.isInActiveFlareArc(angle)) {
            return this.flareManager.getExtraLengthMult(angle);
        }
        return 1.0f;
    }

    @Override
    public List<Color> getFlareColorRange() {
        ArrayList<Color> result = new ArrayList<Color>();
        if (this.params.relatedEntity instanceof PlanetAPI) {
            Color color = ((PlanetAPI)this.params.relatedEntity).getSpec().getCoronaColor();
            result.add(Misc.setAlpha(color, 255));
        } else {
            result.add(Color.white);
        }
        return result;
    }

    @Override
    public float getFlareArcMax() {
        return 60.0f;
    }

    @Override
    public float getFlareArcMin() {
        return 30.0f;
    }

    @Override
    public float getFlareExtraLengthFlatMax() {
        return 500.0f;
    }

    @Override
    public float getFlareExtraLengthFlatMin() {
        return 200.0f;
    }

    @Override
    public float getFlareExtraLengthMultMax() {
        return 1.5f;
    }

    @Override
    public float getFlareExtraLengthMultMin() {
        return 1.0f;
    }

    @Override
    public float getFlareFadeInMax() {
        return 10.0f;
    }

    @Override
    public float getFlareFadeInMin() {
        return 3.0f;
    }

    @Override
    public float getFlareFadeOutMax() {
        return 10.0f;
    }

    @Override
    public float getFlareFadeOutMin() {
        return 3.0f;
    }

    @Override
    public float getFlareOccurrenceAngle() {
        return 0.0f;
    }

    @Override
    public float getFlareOccurrenceArc() {
        return 360.0f;
    }

    @Override
    public float getFlareProbability() {
        return this.params.flareProbability;
    }

    @Override
    public float getFlareSmallArcMax() {
        return 20.0f;
    }

    @Override
    public float getFlareSmallArcMin() {
        return 10.0f;
    }

    @Override
    public float getFlareSmallExtraLengthFlatMax() {
        return 100.0f;
    }

    @Override
    public float getFlareSmallExtraLengthFlatMin() {
        return 50.0f;
    }

    @Override
    public float getFlareSmallExtraLengthMultMax() {
        return 1.05f;
    }

    @Override
    public float getFlareSmallExtraLengthMultMin() {
        return 1.0f;
    }

    @Override
    public float getFlareSmallFadeInMax() {
        return 2.0f;
    }

    @Override
    public float getFlareSmallFadeInMin() {
        return 1.0f;
    }

    @Override
    public float getFlareSmallFadeOutMax() {
        return 2.0f;
    }

    @Override
    public float getFlareSmallFadeOutMin() {
        return 1.0f;
    }

    @Override
    public float getFlareShortenFlatModMax() {
        return 0.05f;
    }

    @Override
    public float getFlareShortenFlatModMin() {
        return 0.05f;
    }

    @Override
    public float getFlareSmallShortenFlatModMax() {
        return 0.05f;
    }

    @Override
    public float getFlareSmallShortenFlatModMin() {
        return 0.05f;
    }

    @Override
    public int getFlareMaxSmallCount() {
        return 3;
    }

    @Override
    public int getFlareMinSmallCount() {
        return 5;
    }

    @Override
    public float getFlareSkipLargeProbability() {
        return 0.0f;
    }

    @Override
    public SectorEntityToken getFlareCenterEntity() {
        return this.entity;
    }

    @Override
    public boolean hasAIFlag(Object flag) {
        return flag == TerrainAIFlags.CR_DRAIN || flag == TerrainAIFlags.BREAK_OTHER_ORBITS || flag == TerrainAIFlags.EFFECT_DIMINISHED_WITH_RANGE;
    }

    @Override
    public float getMaxEffectRadius(Vector2f locFrom) {
        float angle = Misc.getAngleInDegrees(this.params.relatedEntity.getLocation(), locFrom);
        float maxDist = this.params.bandWidthInEngine;
        if (this.flareManager.isInActiveFlareArc(angle)) {
            maxDist = this.computeRadiusWithFlare(this.flareManager.getActiveFlare());
        }
        return maxDist;
    }

    @Override
    public float getMinEffectRadius(Vector2f locFrom) {
        return 0.0f;
    }

    @Override
    public float getOptimalEffectRadius(Vector2f locFrom) {
        return this.params.relatedEntity.getRadius();
    }

    @Override
    public boolean canPlayerHoldStationIn() {
        return false;
    }

    public FlareManager getFlareManager() {
        return this.flareManager;
    }

    public static class CoronaParams
    extends BaseRingTerrain.RingParams {
        public float windBurnLevel;
        public float flareProbability;
        public float crLossMult;

        public CoronaParams(float bandWidthInEngine, float middleRadius, SectorEntityToken relatedEntity, float windBurnLevel, float flareProbability, float crLossMult) {
            super(bandWidthInEngine, middleRadius, relatedEntity);
            this.windBurnLevel = windBurnLevel;
            this.flareProbability = flareProbability;
            this.crLossMult = crLossMult;
        }
    }
}

