/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.PhaseCloakSystemAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;

public class PhaseCloakStats
extends BaseShipSystemScript {
    public static Color JITTER_COLOR = new Color(255, 175, 255, 255);
    public static float JITTER_FADE_TIME = 0.5f;
    public static float SHIP_ALPHA_MULT = 0.25f;
    public static float VULNERABLE_FRACTION = 0.0f;
    public static float INCOMING_DAMAGE_MULT = 0.25f;
    public static float MAX_TIME_MULT = 3.0f;
    public static boolean FLUX_LEVEL_AFFECTS_SPEED = true;
    public static float MIN_SPEED_MULT = 0.33f;
    public static float BASE_FLUX_LEVEL_FOR_MIN_SPEED = 0.5f;
    protected Object STATUSKEY1 = new Object();
    protected Object STATUSKEY2 = new Object();
    protected Object STATUSKEY3 = new Object();
    protected Object STATUSKEY4 = new Object();

    public static float getMaxTimeMult(MutableShipStatsAPI stats) {
        return 1.0f + (MAX_TIME_MULT - 1.0f) * stats.getDynamic().getValue("phase_time_mult");
    }

    protected boolean isDisruptable(ShipSystemAPI cloak) {
        return cloak.getSpecAPI().hasTag("disruptable");
    }

    protected float getDisruptionLevel(ShipAPI ship) {
        if (FLUX_LEVEL_AFFECTS_SPEED) {
            float threshold = ship.getMutableStats().getDynamic().getMod("phase_cloak_flux_level_for_min_speed_mod").computeEffective(BASE_FLUX_LEVEL_FOR_MIN_SPEED);
            if (threshold <= 0.0f) {
                return 1.0f;
            }
            float level = ship.getHardFluxLevel() / threshold;
            if (level > 1.0f) {
                level = 1.0f;
            }
            return level;
        }
        return 0.0f;
    }

    protected void maintainStatus(ShipAPI playerShip, ShipSystemStatsScript.State state, float effectLevel) {
        float level = effectLevel;
        float f = VULNERABLE_FRACTION;
        ShipSystemAPI cloak = playerShip.getPhaseCloak();
        if (cloak == null) {
            cloak = playerShip.getSystem();
        }
        if (cloak == null) {
            return;
        }
        if (level > f) {
            Global.getCombatEngine().maintainStatusForPlayerShip(this.STATUSKEY2, cloak.getSpecAPI().getIconSpriteName(), cloak.getDisplayName(), "time flow altered", false);
        }
        if (FLUX_LEVEL_AFFECTS_SPEED && level > f) {
            if (this.getDisruptionLevel(playerShip) <= 0.0f) {
                Global.getCombatEngine().maintainStatusForPlayerShip(this.STATUSKEY3, cloak.getSpecAPI().getIconSpriteName(), "phase coils stable", "top speed at 100%", false);
            } else {
                String speedPercentStr = String.valueOf(Math.round(this.getSpeedMult(playerShip, effectLevel) * 100.0f)) + "%";
                Global.getCombatEngine().maintainStatusForPlayerShip(this.STATUSKEY3, cloak.getSpecAPI().getIconSpriteName(), "phase coil stress", "top speed at " + speedPercentStr, true);
            }
        }
    }

    public float getSpeedMult(ShipAPI ship, float effectLevel) {
        if (this.getDisruptionLevel(ship) <= 0.0f) {
            return 1.0f;
        }
        return MIN_SPEED_MULT + (1.0f - MIN_SPEED_MULT) * (1.0f - this.getDisruptionLevel(ship) * effectLevel);
    }

    @Override
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = null;
        boolean player = false;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        player = ship == Global.getCombatEngine().getPlayerShip();
        id = String.valueOf(id) + "_" + ship.getId();
        if (player) {
            this.maintainStatus(ship, state, effectLevel);
        }
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        ShipSystemAPI cloak = ship.getPhaseCloak();
        if (cloak == null) {
            cloak = ship.getSystem();
        }
        if (cloak == null) {
            return;
        }
        if (FLUX_LEVEL_AFFECTS_SPEED && (state == ShipSystemStatsScript.State.ACTIVE || state == ShipSystemStatsScript.State.OUT || state == ShipSystemStatsScript.State.IN)) {
            float mult = this.getSpeedMult(ship, effectLevel);
            if (mult < 1.0f) {
                stats.getMaxSpeed().modifyMult(String.valueOf(id) + "_2", mult);
            } else {
                stats.getMaxSpeed().unmodifyMult(String.valueOf(id) + "_2");
            }
            ((PhaseCloakSystemAPI)((Object)cloak)).setMinCoilJitterLevel(this.getDisruptionLevel(ship));
        }
        if (state == ShipSystemStatsScript.State.COOLDOWN || state == ShipSystemStatsScript.State.IDLE) {
            this.unapply(stats, id);
            return;
        }
        float speedPercentMod = stats.getDynamic().getMod("phase_cloak_speed").computeEffective(0.0f);
        float accelPercentMod = stats.getDynamic().getMod("phase_cloak_accel").computeEffective(0.0f);
        stats.getMaxSpeed().modifyPercent(id, speedPercentMod * effectLevel);
        stats.getAcceleration().modifyPercent(id, accelPercentMod * effectLevel);
        stats.getDeceleration().modifyPercent(id, accelPercentMod * effectLevel);
        float speedMultMod = stats.getDynamic().getMod("phase_cloak_speed").getMult();
        float accelMultMod = stats.getDynamic().getMod("phase_cloak_accel").getMult();
        stats.getMaxSpeed().modifyMult(id, speedMultMod * effectLevel);
        stats.getAcceleration().modifyMult(id, accelMultMod * effectLevel);
        stats.getDeceleration().modifyMult(id, accelMultMod * effectLevel);
        float level = effectLevel;
        float jitterLevel = 0.0f;
        float jitterRangeBonus = 0.0f;
        float levelForAlpha = level;
        if (state == ShipSystemStatsScript.State.IN || state == ShipSystemStatsScript.State.ACTIVE) {
            ship.setPhased(true);
            levelForAlpha = level;
        } else if (state == ShipSystemStatsScript.State.OUT) {
            if (level > 0.5f) {
                ship.setPhased(true);
            } else {
                ship.setPhased(false);
            }
            levelForAlpha = level;
        }
        ship.setExtraAlphaMult(1.0f - (1.0f - SHIP_ALPHA_MULT) * levelForAlpha);
        ship.setApplyExtraAlphaToEngines(true);
        float extra = 0.0f;
        float shipTimeMult = 1.0f + (PhaseCloakStats.getMaxTimeMult(stats) - 1.0f) * levelForAlpha * (1.0f - extra);
        stats.getTimeMult().modifyMult(id, shipTimeMult);
        if (player) {
            Global.getCombatEngine().getTimeMult().modifyMult(id, 1.0f / shipTimeMult);
        } else {
            Global.getCombatEngine().getTimeMult().unmodify(id);
        }
    }

    @Override
    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        Global.getCombatEngine().getTimeMult().unmodify(id);
        stats.getTimeMult().unmodify(id);
        stats.getMaxSpeed().unmodify(id);
        stats.getMaxSpeed().unmodifyMult(String.valueOf(id) + "_2");
        stats.getAcceleration().unmodify(id);
        stats.getDeceleration().unmodify(id);
        ship.setPhased(false);
        ship.setExtraAlphaMult(1.0f);
        ShipSystemAPI cloak = ship.getPhaseCloak();
        if (cloak == null) {
            cloak = ship.getSystem();
        }
        if (cloak != null) {
            ((PhaseCloakSystemAPI)((Object)cloak)).setMinCoilJitterLevel(0.0f);
        }
    }

    @Override
    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }
}

