/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.impl.combat.dweller.DarkenedGazeSystemScript;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class DarkenedGazeSystemAI
implements ShipSystemAIScript {
    protected ShipAPI ship;
    protected CombatEngineAPI engine;
    protected ShipwideAIFlags flags;
    protected ShipSystemAPI system;
    protected DarkenedGazeSystemScript script;
    protected float systemFluxPerSecond;
    protected IntervalUtil tracker = new IntervalUtil(0.75f, 1.25f);
    protected ShipAPI targetOverride = null;

    @Override
    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
        this.system = system;
        this.script = (DarkenedGazeSystemScript)system.getScript();
        this.systemFluxPerSecond = system.getFluxPerSecond();
    }

    @Override
    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        this.tracker.advance(amount);
        if (this.system.isActive()) {
            if (this.ship.getAI() instanceof ShipAIPlugin) {
                ShipAIPlugin b = (ShipAIPlugin)this.ship.getAI();
                b.setTargetOverride(this.targetOverride);
            }
        } else {
            this.targetOverride = null;
        }
        if (this.tracker.intervalElapsed()) {
            if (this.system.getCooldownRemaining() > 0.0f) {
                return;
            }
            if (this.system.isOutOfAmmo()) {
                return;
            }
            if (this.ship.getFluxTracker().isOverloadedOrVenting()) {
                return;
            }
            if (target != null && (target.isHulk() || !target.isAlive())) {
                target = null;
            }
            float activeTimeRemaining = (this.ship.getMaxFlux() - this.ship.getCurrFlux()) / Math.max(1.0f, this.systemFluxPerSecond);
            boolean missilesInOpenArc = false;
            boolean inRange = false;
            boolean inArc = false;
            boolean isFarFromArc = false;
            if (target != null) {
                float range = Misc.getDistance(this.ship.getLocation(), target.getLocation()) - Misc.getTargetingRadius(this.ship.getLocation(), target, false);
                inRange = range < this.script.getRange();
                inArc = Misc.isInArc(this.ship.getFacing(), 5.0f, Misc.getAngleInDegrees(this.ship.getLocation(), target.getLocation()));
                if (!inArc) {
                    isFarFromArc = !Misc.isInArc(this.ship.getFacing(), Math.max(30.0f, 60.0f - range * 0.05f), Misc.getAngleInDegrees(this.ship.getLocation(), target.getLocation()));
                }
            }
            Vector2f to = Misc.getUnitVectorAtDegreeAngle(this.ship.getFacing());
            to.scale(this.script.getRange());
            Vector2f.add((Vector2f)this.ship.getLocation(), (Vector2f)to, (Vector2f)to);
            boolean ffDanger = false;
            if (this.script.isFFAConcern()) {
                ffDanger = Global.getSettings().getFriendlyFireDanger(this.ship, null, this.ship.getLocation(), to, Float.MAX_VALUE, 3.0f, this.script.getRange()) > 0.1f;
            } else {
                boolean bl = ffDanger = Global.getSettings().getFriendlyFireDanger(this.ship, null, this.ship.getLocation(), to, Float.MAX_VALUE, 3.0f, this.script.getRange()) > 0.5f;
            }
            if (this.system.isActive()) {
                this.flags.setFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT);
                if (target == null || !inRange || isFarFromArc || missilesInOpenArc || ffDanger) {
                    this.giveCommand();
                    return;
                }
                if (activeTimeRemaining < 3.0f) {
                    this.giveCommand();
                    return;
                }
                return;
            }
            float minFireTime = this.system.getSpecAPI().getIn() + 6.0f;
            float fluxLevel = this.ship.getFluxLevel();
            if (fluxLevel > 0.9f || activeTimeRemaining < minFireTime) {
                return;
            }
            if (inRange && inArc && !missilesInOpenArc && !ffDanger) {
                this.giveCommand();
                this.targetOverride = target;
            }
        }
    }

    public void giveCommand() {
        this.ship.giveCommand(ShipCommand.USE_SYSTEM, null, 0);
    }
}

