/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class FragmentCoordinatorHullmod
extends BaseHullMod {
    public static float SIZE_INCREASE = 60.0f;
    public static float SMOD_SIZE_INCREASE = 40.0f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getDynamic().getMod("fragment_swarm_size_mod").modifyPercent(id, SIZE_INCREASE);
        boolean sMod = this.isSMod(stats);
        if (sMod) {
            stats.getDynamic().getMod("fragment_swarm_size_mod").modifyPercent(id, SMOD_SIZE_INCREASE);
        }
    }

    @Override
    public CargoStackAPI getRequiredItem() {
        return Global.getSettings().createCargoStack(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("threat_processing_unit", null), null);
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return (int)SIZE_INCREASE + "%";
        }
        return null;
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        if (index == 0) {
            return (int)SMOD_SIZE_INCREASE + "%";
        }
        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return ship.getVariant().hasHullMod("fragment_swarm");
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        return "Requires Fragment Swarm hullmod";
    }
}

