/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.threat.FragmentWeapon;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.impl.combat.threat.SwarmLauncherEffect;
import com.fs.starfarer.api.impl.combat.threat.VoltaicDischargeOnFireEffect;
import com.fs.starfarer.api.util.ColorShifterUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;

public class FragmentSwarmHullmod
extends BaseHullMod {
    public static String STANDARD_SWARM_EXCHANGE_CLASS = "standard_swarm_exchange_class";
    public static String STANDARD_SWARM_FLOCKING_CLASS = "standard_swarm_flocking_class";
    public static String CONSTRUCTION_SWARM_FLOCKING_CLASS = "construction_swarm_flocking_class";
    public static String RECLAMATION_SWARM_FLOCKING_CLASS = "reclamation_swarm_flocking_class";
    public static String RECLAMATION_SWARM_EXCHANGE_CLASS = "reclamation_swarm_exchange_class";
    public static boolean SHOW_OVERLAY_ON_THREAT_SHIPS = false;
    public static float SMOD_CR_PENALTY = 0.2f;
    public static float SMOD_MAINTENANCE_PENALTY = 50.0f;
    public static Object STATUS_KEY1 = new Object();

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        boolean sMod = this.isSMod(stats);
        if (sMod) {
            stats.getMaxCombatReadiness().modifyFlat(id, (float)(-Math.round(SMOD_CR_PENALTY * 100.0f)) * 0.01f, "Fragment swarm");
            stats.getSuppliesPerMonth().modifyPercent(id, SMOD_MAINTENANCE_PENALTY);
        }
    }

    @Override
    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        if (SHOW_OVERLAY_ON_THREAT_SHIPS || !ship.getHullSpec().hasTag("threat")) {
            ship.setExtraOverlay(Global.getSettings().getSpriteName("misc", "fragment_swarm"));
            ship.setExtraOverlayMatchHullColor(false);
            ship.setExtraOverlayShadowOpacity(1.0f);
        }
    }

    @Override
    public void advanceInCombat(ShipAPI ship, float amount) {
        if (amount <= 0.0f || ship == null) {
            return;
        }
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(ship);
        if (swarm == null) {
            swarm = FragmentSwarmHullmod.createSwarmFor(ship);
        }
        if (ship.isFighter()) {
            return;
        }
        boolean playerShip = Global.getCurrentState() == GameState.COMBAT && Global.getCombatEngine() != null && Global.getCombatEngine().getPlayerShip() == ship;
        RoilingSwarmEffect.RoilingSwarmParams params = swarm.params;
        params.baseMembersToMaintain = (int)ship.getMutableStats().getDynamic().getValue("fragment_swarm_size_mod", FragmentSwarmHullmod.getBaseSwarmSize(ship.getHullSize()));
        params.memberRespawnRate = FragmentSwarmHullmod.getBaseSwarmRespawnRateMult(ship.getHullSize()) * ship.getMutableStats().getDynamic().getValue("fragment_swarm_respawn_rate_mult");
        params.maxNumMembersToAlwaysRemoveAbove = (int)((float)params.baseMembersToMaintain * 1.5f);
        params.initialMembers = params.baseMembersToMaintain;
        if (playerShip) {
            int active = swarm.getNumActiveMembers();
            int maxRequired = 0;
            for (WeaponAPI w : ship.getAllWeapons()) {
                if (!(w.getEffectPlugin() instanceof FragmentWeapon)) continue;
                FragmentWeapon fw = (FragmentWeapon)((Object)w.getEffectPlugin());
                maxRequired = Math.max(maxRequired, fw.getNumFragmentsToFire());
            }
            boolean debuff = active < maxRequired;
            Global.getCombatEngine().maintainStatusForPlayerShip(STATUS_KEY1, Global.getSettings().getSpriteName("ui", "icon_tactical_fragment_swarm"), this.spec.getDisplayName(), "FRAGMENTS: " + active, debuff);
        }
    }

    public static RoilingSwarmEffect createSwarmFor(final ShipAPI ship) {
        RoilingSwarmEffect existing = RoilingSwarmEffect.getSwarmFor(ship);
        if (existing != null) {
            return existing;
        }
        RoilingSwarmEffect.RoilingSwarmParams params = new RoilingSwarmEffect.RoilingSwarmParams();
        if (ship.isFighter()) {
            String wingId;
            float radius = 20.0f;
            int numMembers = 50;
            String string = wingId = ship.getWing() == null ? null : ship.getWing().getWingId();
            if (SwarmLauncherEffect.SWARM_RADIUS.containsKey(wingId)) {
                radius = SwarmLauncherEffect.SWARM_RADIUS.get(wingId).intValue();
            }
            if (SwarmLauncherEffect.FRAGMENT_NUM.containsKey(wingId)) {
                numMembers = SwarmLauncherEffect.FRAGMENT_NUM.get(wingId);
            }
            params.memberExchangeClass = STANDARD_SWARM_EXCHANGE_CLASS;
            params.flockingClass = STANDARD_SWARM_FLOCKING_CLASS;
            params.maxSpeed = ship.getMaxSpeedWithoutBoost() + Math.max(ship.getMaxSpeedWithoutBoost() * 0.25f + 50.0f, 100.0f);
            params.flashRateMult = 0.25f;
            params.flashCoreRadiusMult = 0.0f;
            params.flashRadius = 120.0f;
            params.flashFringeColor = new Color(255, 0, 0, 40);
            params.flashCoreColor = new Color(255, 255, 255, 127);
            params.maxOffset = radius;
            params.baseMembersToMaintain = params.initialMembers = numMembers;
        } else {
            params.memberExchangeClass = STANDARD_SWARM_EXCHANGE_CLASS;
            params.maxSpeed = ship.getMaxSpeedWithoutBoost() + Math.max(ship.getMaxSpeedWithoutBoost() * 0.25f + 50.0f, 100.0f) + ship.getMutableStats().getZeroFluxSpeedBoost().getModifiedValue();
            params.flashRateMult = 0.25f;
            params.flashCoreRadiusMult = 0.0f;
            params.flashRadius = 120.0f;
            params.flashFringeColor = new Color(255, 0, 0, 40);
            params.flashCoreColor = new Color(255, 255, 255, 127);
            params.minOffset = 0.0f;
            params.maxOffset = Math.min(100.0f, ship.getCollisionRadius() * 0.5f);
            params.generateOffsetAroundAttachedEntityOval = true;
            params.despawnSound = null;
            params.spawnOffsetMult = 0.33f;
            params.spawnOffsetMultForInitialSpawn = 1.0f;
            params.baseMembersToMaintain = FragmentSwarmHullmod.getBaseSwarmSize(ship.getHullSize());
            params.memberRespawnRate = FragmentSwarmHullmod.getBaseSwarmRespawnRateMult(ship.getHullSize());
            params.maxNumMembersToAlwaysRemoveAbove = params.baseMembersToMaintain * 2;
            params.initialMembers = 0;
            params.initialMembers = params.baseMembersToMaintain;
            params.removeMembersAboveMaintainLevel = false;
        }
        final ArrayList<WeaponAPI> glowWeapons = new ArrayList<WeaponAPI>();
        for (WeaponAPI w : ship.getAllWeapons()) {
            if (w.usesAmmo() && w.getSpec().hasTag("fragment_glow")) {
                glowWeapons.add(w);
            }
            if (!w.getSpec().hasTag("overseer_charge") && (!ship.isFighter() || !w.getSpec().hasTag("overseer_charge_fighter"))) continue;
            w.setAmmo(0);
        }
        return new RoilingSwarmEffect(ship, params){
            protected ColorShifterUtil glowColorShifter;
            protected boolean resetFlash;
            {
                super($anonymous0, $anonymous1);
                this.glowColorShifter = new ColorShifterUtil(new Color(0, 0, 0, 0));
                this.resetFlash = false;
            }

            @Override
            public int getNumMembersToMaintain() {
                if (ship.isFighter()) {
                    return Math.round((0.2f + 0.8f * ship.getHullLevel()) * (float)super.getNumMembersToMaintain());
                }
                return super.getNumMembersToMaintain();
            }

            @Override
            public void advance(float amount) {
                super.advance(amount);
                this.glowColorShifter.advance(amount);
                if (VoltaicDischargeOnFireEffect.isSwarmPhaseMode(ship)) {
                    this.params.flashFrequency = 4.0f;
                    this.params.flashProbability = 1.0f;
                    this.resetFlash = true;
                } else if (!glowWeapons.isEmpty()) {
                    int glowAlpha;
                    float extraGlow;
                    float ammoFractionTotal = 0.0f;
                    float totalOP = 0.0f;
                    for (WeaponAPI w : glowWeapons) {
                        float f = (float)w.getAmmo() / Math.max(1.0f, (float)w.getMaxAmmo());
                        Color glowColor = w.getSpec().getGlowColor();
                        this.glowColorShifter.shift(w, glowColor, 0.5f, 0.5f, 1.0f);
                        float weight = w.getSpec().getOrdnancePointCost(null);
                        ammoFractionTotal += f * weight;
                        totalOP += weight;
                    }
                    float ammoFraction = ammoFractionTotal / Math.max(1.0f, totalOP);
                    this.params.flashFrequency = (1.0f + ammoFraction) * 2.0f;
                    this.params.flashFrequency *= Math.max(1.0f, Math.min(2.0f, (float)this.params.baseMembersToMaintain / 50.0f));
                    this.params.flashProbability = 1.0f;
                    if (ammoFraction <= 0.0f) {
                        this.params.flashProbability = 0.0f;
                    }
                    float glowAlphaBase = 30.0f;
                    if (ship.isFighter()) {
                        glowAlphaBase = 18.0f;
                    }
                    if ((extraGlow = (totalOP - 10.0f) / 90.0f) < 0.0f) {
                        extraGlow = 0.0f;
                    }
                    if (extraGlow > 1.0f) {
                        extraGlow = 1.0f;
                    }
                    if ((glowAlpha = (int)(glowAlphaBase + glowAlphaBase * (ammoFraction + extraGlow * 0.5f))) > 255) {
                        glowAlpha = 255;
                    }
                    this.params.flashFringeColor = Misc.setBrightness(this.glowColorShifter.getCurr(), 255);
                    this.params.flashFringeColor = Misc.setAlpha(this.params.flashFringeColor, glowAlpha);
                    this.resetFlash = true;
                } else if (this.resetFlash) {
                    this.params.flashProbability = 0.0f;
                    this.resetFlash = false;
                }
            }
        };
    }

    public static int getBaseSwarmSize(ShipAPI.HullSize size) {
        switch (size) {
            case CAPITAL_SHIP: {
                return 100;
            }
            case CRUISER: {
                return 60;
            }
            case DESTROYER: {
                return 40;
            }
            case FRIGATE: {
                return 20;
            }
            case FIGHTER: {
                return 50;
            }
            case DEFAULT: {
                return 20;
            }
        }
        return 20;
    }

    public static float getBaseSwarmRespawnRateMult(ShipAPI.HullSize size) {
        switch (size) {
            case CAPITAL_SHIP: {
                return 5.0f;
            }
            case CRUISER: {
                return 3.0f;
            }
            case DESTROYER: {
                return 2.0f;
            }
            case FRIGATE: {
                return 1.0f;
            }
            case FIGHTER: {
                return 0.0f;
            }
            case DEFAULT: {
                return 0.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public CargoStackAPI getRequiredItem() {
        return Global.getSettings().createCargoStack(CargoAPI.CargoItemType.SPECIAL, new SpecialItemData("fragment_fabricator", null), null);
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return ship == null || !ship.getHullSpec().isPhase();
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        return "Can not be installed on a phase ship";
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + FragmentSwarmHullmod.getBaseSwarmSize(ShipAPI.HullSize.FRIGATE);
        }
        if (index == 1) {
            return "" + FragmentSwarmHullmod.getBaseSwarmSize(ShipAPI.HullSize.DESTROYER);
        }
        if (index == 2) {
            return "" + FragmentSwarmHullmod.getBaseSwarmSize(ShipAPI.HullSize.CRUISER);
        }
        if (index == 3) {
            return "" + FragmentSwarmHullmod.getBaseSwarmSize(ShipAPI.HullSize.CAPITAL_SHIP);
        }
        if (index == 4) {
            return "" + (int)FragmentSwarmHullmod.getBaseSwarmRespawnRateMult(ShipAPI.HullSize.FRIGATE);
        }
        if (index == 5) {
            return "" + (int)FragmentSwarmHullmod.getBaseSwarmRespawnRateMult(ShipAPI.HullSize.DESTROYER);
        }
        if (index == 6) {
            return "" + (int)FragmentSwarmHullmod.getBaseSwarmRespawnRateMult(ShipAPI.HullSize.CRUISER);
        }
        if (index == 7) {
            return "" + (int)FragmentSwarmHullmod.getBaseSwarmRespawnRateMult(ShipAPI.HullSize.CAPITAL_SHIP);
        }
        return null;
    }

    @Override
    public String getSModDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        if (index == 0) {
            return Math.round(SMOD_CR_PENALTY * 100.0f) + "%";
        }
        if (index == 1) {
            return Math.round(SMOD_MAINTENANCE_PENALTY) + "%";
        }
        return null;
    }

    @Override
    public boolean isSModEffectAPenalty() {
        return true;
    }
}

