/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import com.fs.starfarer.api.impl.combat.SquallOnFireEffect;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class VoidblasterEffect
implements OnHitEffectPlugin,
OnFireEffectPlugin,
EveryFrameWeaponEffectPlugin,
DamageDealtModifier {
    protected String weaponId;

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        ShipAPI ship = weapon.getShip();
        if (!ship.hasListenerOfClass(SquallOnFireEffect.class)) {
            ship.addListener(this);
            this.weaponId = weapon.getId();
        }
    }

    @Override
    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        Vector2f vel = target.getVelocity();
        engine.addNegativeParticle(point, vel, 50.0f, 0.0f, 0.5f, Color.white);
        engine.addNegativeParticle(point, vel, 30.0f, 0.0f, 0.5f, Color.white);
        engine.addNegativeNebulaParticle(point, vel, 30.0f, 2.0f, 0.0f, 0.0f, 0.5f, Color.white);
        if (!shieldHit) {
            float dir = 0.0f;
            float arc = 360.0f;
            dir = Misc.getAngleInDegrees(target.getLocation(), point);
            arc = 150.0f;
            engine.spawnDebrisSmall(point, vel, 12, dir, arc, 20.0f, 20.0f, 720.0f);
            engine.spawnDebrisMedium(point, vel, 4, dir, arc, 10.0f, 20.0f, 360.0f);
            engine.spawnDebrisLarge(point, vel, 1, dir, arc, 10.0f, 10.0f, 180.0f);
        }
    }

    @Override
    public String modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
        DamagingProjectileAPI p;
        if (param instanceof DamagingProjectileAPI && (p = (DamagingProjectileAPI)param).getWeapon() != null && p.getWeapon().getId().equals(this.weaponId)) {
            if (target instanceof ShipAPI) {
                ((ShipAPI)target).setSkipNextDamagedExplosion(true);
            }
            if (shieldHit) {
                damage.setSoftFlux(true);
            }
            return "voidblaster";
        }
        return null;
    }
}

