/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.hullmods;

import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.DamageDealtModifier;
import com.fs.starfarer.api.loading.WeaponSpecAPI;
import org.lwjgl.util.vector.Vector2f;

public class PDIntegration
extends BaseHullMod {
    public static int OP_REDUCTION = 3;
    public static float DAMAGE_BONUS_PERCENT = 25.0f;

    @Override
    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getDynamic().getMod("small_pd_mod").modifyFlat(id, -OP_REDUCTION);
    }

    @Override
    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        ship.addListener(new PDIDamageDealtMod());
    }

    @Override
    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize, ShipAPI ship) {
        if (index == 0) {
            return "" + OP_REDUCTION;
        }
        if (index == 1) {
            return Math.round(DAMAGE_BONUS_PERCENT) + "%";
        }
        return null;
    }

    @Override
    public boolean affectsOPCosts() {
        return true;
    }

    @Override
    public boolean canBeAddedOrRemovedNow(ShipAPI ship, MarketAPI marketOrNull, CampaignUIAPI.CoreUITradeMode mode) {
        if (ship == null || ship.getVariant() == null) {
            return true;
        }
        if (!ship.getVariant().hasHullMod("pdintegration")) {
            return true;
        }
        for (String slotId : ship.getVariant().getFittedWeaponSlots()) {
            WeaponSpecAPI spec = ship.getVariant().getWeaponSpec(slotId);
            if (!spec.getAIHints().contains((Object)WeaponAPI.AIHints.PD)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getCanNotBeInstalledNowReason(ShipAPI ship, MarketAPI marketOrNull, CampaignUIAPI.CoreUITradeMode mode) {
        return "Can not remove while ship has point-defense weapons installed";
    }

    public static class PDIDamageDealtMod
    implements DamageDealtModifier {
        @Override
        public String modifyDamageDealt(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            WeaponAPI weapon = null;
            if (param instanceof DamagingProjectileAPI) {
                weapon = ((DamagingProjectileAPI)param).getWeapon();
            } else if (param instanceof BeamAPI) {
                weapon = ((BeamAPI)param).getWeapon();
            } else if (param instanceof MissileAPI) {
                weapon = ((MissileAPI)param).getWeapon();
            }
            if (weapon == null) {
                return null;
            }
            if (!weapon.hasAIHint(WeaponAPI.AIHints.PD)) {
                return null;
            }
            String id = "pdi_dam_mod";
            damage.getModifier().modifyPercent(id, DAMAGE_BONUS_PERCENT);
            return id;
        }
    }
}

