/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.LayeredRenderable;
import com.fs.graphics.LayeredRenderer;
import com.fs.graphics.particle.BaseParticle;
import com.fs.graphics.particle.DynamicParticleGroup;
import com.fs.graphics.particle.GenericTextureParticle;
import com.fs.graphics.util.Fader;
import com.fs.graphics.util.OoOO;
import com.fs.profiler.Profiler;
import com.fs.starfarer.D;
import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.InteractionDialogImageVisual;
import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CommDirectoryAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityPlugin;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetStubAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.NascentGravityWellAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.ParticleControllerAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.RingBandAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpawnPointPlugin;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.characters.AbilityPlugin;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.ProcgenUsedNames;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.terrain.AsteroidBeltTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.BaseRingTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.RadioChatterTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.util.ColorShifterAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.BackgroundAndStars;
import com.fs.starfarer.campaign.BaseCampaignEntity;
import com.fs.starfarer.campaign.CampaignAsteroid;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.CampaignEntity;
import com.fs.starfarer.campaign.CampaignOrbitalStation;
import com.fs.starfarer.campaign.CampaignPlanet;
import com.fs.starfarer.campaign.CampaignTerrain;
import com.fs.starfarer.campaign.CircularOrbit;
import com.fs.starfarer.campaign.CircularOrbitWithSpin;
import com.fs.starfarer.campaign.CustomCampaignEntity;
import com.fs.starfarer.campaign.Faction;
import com.fs.starfarer.campaign.JumpPoint;
import com.fs.starfarer.campaign.ParticleController;
import com.fs.starfarer.campaign.RingBand;
import com.fs.starfarer.campaign.StarSystem;
import com.fs.starfarer.campaign.econ.Market;
import com.fs.starfarer.campaign.fleet.Battle;
import com.fs.starfarer.campaign.fleet.CampaignFleet;
import com.fs.starfarer.campaign.rules.Memory;
import com.fs.starfarer.combat.CombatViewport;
import com.fs.starfarer.prototype.Utils;
import com.fs.starfarer.renderers.oo0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.oOOO.new;
import com.fs.util.DoNotObfuscate;
import com.fs.util.container.repo.ObjectRepository;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class BaseLocation
implements LocationAPI,
DoNotObfuscate {
    private static Logger log = Logger.getLogger(BaseLocation.class);
    private ObjectRepository objects = new ObjectRepository();
    private transient LayeredRenderer<CampaignEngineLayers, CombatViewport> renderer = new LayeredRenderer(CampaignEngineLayers.class);
    private BackgroundAndStars background;
    private DynamicParticleGroup hitParticles = new DynamicParticleGroup(2000);
    private Vector2f location = new Vector2f();
    private String displayName = "Unnamed";
    private String backgroundTextureFilename;
    private final boolean hyperspaceMode;
    private Color lightColor = Color.white;
    private Fader lightHeight;
    private List<FleetStubAPI> fleetStubs = new ArrayList<FleetStubAPI>();
    private Map<String, Object> persistentData = new HashMap<String, Object>();
    private long lastPlayerVisitTimestamp = 0L;
    private List<SpawnPointPlugin> spawnPoints = new ArrayList<SpawnPointPlugin>();
    private List<EveryFrameScript> scripts = new ArrayList<EveryFrameScript>();
    private transient Map<String, SectorEntityToken> idToEntity = null;
    private boolean activeThisFrame = false;
    private HashSet<String> tags = null;
    private Memory memory = null;

    public BaseLocation(boolean bl) {
        this.hyperspaceMode = bl;
        this.background = new BackgroundAndStars(bl);
        this.backgroundTextureFilename = this.background.getSprite().getOriginalTextureId();
        this.lightHeight = new Fader(1.0f, 10.0f, 10.0f, true, true);
        this.lightHeight.fadeOut();
    }

    public ColorShifterAPI getBackgroundColorShifter() {
        return this.background.getColorShifter();
    }

    public ColorShifterAPI getBackgroundParticleColorShifter() {
        return this.background.getParticleColorShifter();
    }

    public LayeredRenderer<CampaignEngineLayers, CombatViewport> getRenderer() {
        return this.renderer;
    }

    public void setBackgroundOffset(float f2, float f3) {
        if (this.background != null) {
            this.background.setBackgroundOffset(f2, f3);
        }
    }

    public Map<String, Object> getPersistentData() {
        return this.persistentData;
    }

    public String getId() {
        return this.displayName.toLowerCase();
    }

    public boolean isHyperspaceMode() {
        return this.hyperspaceMode;
    }

    private void reinitRenderer() {
        this.renderer = new LayeredRenderer(CampaignEngineLayers.class);
        for (Object e2 : this.objects.getList(Object.class)) {
            if (!(e2 instanceof LayeredRenderable)) continue;
            if (((LayeredRenderable)e2).getActiveLayers() == null) {
                throw new RuntimeException("Renderable has no active layers; likely error in save loading logic: " + e2);
            }
            this.renderer.add((LayeredRenderable)e2);
            if (!(e2 instanceof CampaignFleet)) continue;
            CampaignFleet campaignFleet = (CampaignFleet)e2;
            this.renderer.add((LayeredRenderable)campaignFleet.getAbilityRenderer());
        }
    }

    Object readResolve() {
        if (this.persistentData == null) {
            this.persistentData = new HashMap<String, Object>();
        }
        if (this.lightHeight == null) {
            this.lightHeight = new Fader(1.0f, 10.0f, 10.0f, true, true);
            this.lightHeight.fadeOut();
        }
        if (this.background == null) {
            this.background = new BackgroundAndStars(this.hyperspaceMode);
            this.backgroundTextureFilename = this.background.getSprite().getOriginalTextureId();
        }
        if (this.scripts == null) {
            this.scripts = new ArrayList<EveryFrameScript>();
        }
        if (this.fleetStubs == null) {
            this.fleetStubs = new ArrayList<FleetStubAPI>();
        }
        return this;
    }

    Object writeReplace() {
        if (this.tags != null && this.tags.isEmpty()) {
            this.tags = null;
        }
        return this;
    }

    public List<FleetStubAPI> getFleetStubs() {
        return this.fleetStubs;
    }

    public void removeFleetStub(FleetStubAPI fleetStubAPI) {
        this.fleetStubs.remove(fleetStubAPI);
    }

    public void addFleetStub(FleetStubAPI fleetStubAPI) {
        this.fleetStubs.add(fleetStubAPI);
        if (fleetStubAPI.getContainingLocation() != null && fleetStubAPI.getContainingLocation() != this) {
            fleetStubAPI.getContainingLocation().getFleetStubs().remove(fleetStubAPI);
        }
        fleetStubAPI.setContainingLocation((LocationAPI)this);
    }

    public String getBackgroundTextureFilename() {
        return this.backgroundTextureFilename;
    }

    public void setBackgroundTextureFilename(String string) {
        this.backgroundTextureFilename = string;
        this.background.replaceBackground(string);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setName(String string) {
        this.setDisplayName(string);
    }

    public String getName() {
        return this.getDisplayName();
    }

    public String getNameWithLowercaseTypeShort() {
        if (this.isNebula()) {
            return this.getDisplayName().replaceAll("Nebula", "nebula");
        }
        return this.getDisplayName().replaceAll("Star System", "system");
    }

    public String getNameWithTypeShort() {
        if (this.isNebula()) {
            return this.getDisplayName().replaceAll("Nebula", "Nebula");
        }
        return this.getDisplayName().replaceAll("Star System", "System");
    }

    public String getNameWithLowercaseType() {
        if (this.isNebula()) {
            return this.getDisplayName().replaceAll("Nebula", "nebula");
        }
        return this.getDisplayName().replaceAll("Star System", "star system");
    }

    public String getNameWithTypeIfNebula() {
        if (this.isNebula()) {
            return this.getDisplayName();
        }
        return this.getDisplayName().replaceAll(" Star System", "");
    }

    public String getNameWithNoType() {
        if (this.isNebula()) {
            return this.getDisplayName().replaceAll(" Nebula", "");
        }
        return this.getDisplayName().replaceAll(" Star System", "");
    }

    public BackgroundAndStars getBackground() {
        return this.background;
    }

    public ObjectRepository getObjects() {
        return this.objects;
    }

    public void addObject(Object object) {
        this.addObjectReal(object);
    }

    private void addObjectReal(Object object) {
        this.objects.add(object);
        if (object instanceof BaseCampaignEntity) {
            ((BaseCampaignEntity)object).setContainingLocation(this);
        }
        if (object instanceof JumpPoint) {
            if (this.isHyperspaceMode()) {
                ((JumpPoint)object).forceOpen();
            } else {
                ((JumpPoint)object).forceClose();
            }
        }
        if (object instanceof LayeredRenderable) {
            if (this.renderer == null) {
                this.reinitRenderer();
            }
            this.renderer.add((LayeredRenderable)object);
        }
        if (object instanceof CampaignFleet) {
            CampaignFleet campaignFleet = (CampaignFleet)object;
            this.renderer.add((LayeredRenderable)campaignFleet.getAbilityRenderer());
            if (!campaignFleet.isReportedSpawned()) {
                campaignFleet.setReportedSpawned(true);
                CampaignEngine.getInstance().reportFleetSpawned(campaignFleet);
            }
        }
    }

    public void removeObject(Object object) {
        this.removeObjectReal(object);
    }

    private void removeObjectReal(Object object) {
        this.objects.remove(object);
        if (object instanceof LayeredRenderable) {
            if (this.renderer == null) {
                this.reinitRenderer();
            }
            this.renderer.remove((LayeredRenderable)object);
        }
        if (object instanceof CampaignFleet) {
            CampaignFleet campaignFleet = (CampaignFleet)object;
            this.renderer.remove((LayeredRenderable)campaignFleet.getAbilityRenderer());
        }
    }

    public void renderingLayersUpdated(SectorEntityToken sectorEntityToken) {
        if (this.renderer != null && sectorEntityToken instanceof LayeredRenderable) {
            this.renderer.recompile((LayeredRenderable)sectorEntityToken);
        }
    }

    public void executeAdds() {
    }

    public void executeRemoves() {
    }

    public void updateStarfield(float f2, float f3, float f4, float f5) {
        this.background.updateStarfield(f2, f3, f4, f5);
    }

    public void renderBG(float f2, float f3) {
        Profiler.\u00d200000((String)"CampaignEngine rendering bg and stars");
        this.background.renderBG(f2, f3);
        Profiler.o00000();
    }

    public void renderBG(float f2, float f3, float f4) {
        this.background.renderBG(f2, f3, f4);
    }

    public void renderStarfield(float f2, float f3) {
        Profiler.\u00d200000((String)"CampaignEngine rendering starfield");
        this.background.renderStarfield(f2, f3);
        Profiler.o00000();
    }

    public void render(CombatViewport combatViewport) {
        if (this.renderer == null) {
            this.reinitRenderer();
        }
        Profiler.\u00d200000((String)"LayeredRenderer rendering");
        this.renderer.render((Object)combatViewport);
        Profiler.o00000();
        this.hitParticles.render(0.0f, 0.0f);
    }

    public void renderIndicators(CombatViewport combatViewport, boolean bl) {
        Profiler.\u00d200000((String)"Rendering UI indicators");
        List list = this.objects.getList(CampaignEntity.class);
        float f2 = combatViewport.getAlphaMult();
        for (CampaignEntity campaignEntity : list) {
            if (!combatViewport.isNearViewport(campaignEntity.getLocation(), campaignEntity.getRadius() + 20.0f) || campaignEntity.isHidden() || campaignEntity instanceof CustomCampaignEntity && !((CustomCampaignEntity)campaignEntity).isShowInCampaign()) continue;
            if (!campaignEntity.getContactIndicator().isEmpty()) {
                campaignEntity.getContactIndicator().render(f2);
            }
            if (bl) continue;
            float f3 = campaignEntity.getSensorFader().getBrightness();
            if (!campaignEntity.hasSensorProfile() && campaignEntity.getAlwaysUseSensorFaderBrightness() == null) {
                f3 = 1.0f;
            }
            boolean bl2 = !campaignEntity.getIndicator().\u00f400000().isIdle();
            boolean bl3 = campaignEntity.getMemoryWithoutUpdate().getBoolean("$missionImportant");
            if (f3 > 0.0f && (bl3 || campaignEntity.isRenderCircleIndicator() || campaignEntity.isRenderCircleIndicatorSelectionFlash() && bl2)) {
                CampaignFleet campaignFleet;
                if (campaignEntity.hasSensorProfile()) {
                    f3 *= campaignEntity.getSensorContactFader().getBrightness();
                }
                if (campaignEntity instanceof CampaignFleet) {
                    campaignFleet = (CampaignFleet)campaignEntity;
                    campaignFleet.getIndicator().\u00d500000(campaignFleet.getLocation().x, campaignFleet.getLocation().y, f3 * f2 * (0.75f + 0.25f * (1.0f - campaignFleet.getNoCombatPulse().getBrightness())));
                } else {
                    if (!campaignEntity.isRenderCircleIndicator()) {
                        campaignEntity.getIndicator().super(oo0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.o00000, null, 0);
                    }
                    campaignEntity.getIndicator().\u00d500000(campaignEntity.getLocation().x, campaignEntity.getLocation().y, f2 * f3);
                }
                if (!bl3) {
                    bl3 |= Misc.doesMarketHaveMissionImportantPeopleOrIsMarketMissionImportant((SectorEntityToken)campaignEntity);
                }
                if (bl3) {
                    float f4;
                    campaignFleet = StarfarerSettings.return("systemMap", "mission_indicator");
                    boolean bl4 = campaignEntity instanceof PlanetAPI;
                    float f5 = 20.0f;
                    if (bl4) {
                        f5 = 32.0f;
                    }
                    if ((f4 = CampaignEngine.getInstance().getCampaignUI().getZoomFactor()) < 1.0f) {
                        f4 = 1.0f;
                    }
                    if (f5 < 16.0f) {
                        f5 = 16.0f;
                    }
                    campaignFleet.setSize(f5 *= f4, f5);
                    campaignFleet.setAlphaMult(f2 * f3);
                    campaignFleet.setColor(D.interface);
                    float f6 = campaignEntity.getLocation().x;
                    float f7 = campaignEntity.getLocation().y;
                    campaignFleet.setNormalBlend();
                    float f8 = (campaignEntity.getRadius() + f5 / 2.0f) / 1.41f;
                    if (bl4) {
                        f8 += 20.0f;
                    }
                    campaignFleet.renderAtCenter(f6 + f8, f7 + f8);
                }
            }
            campaignEntity.getSelectionIndicator().o00000(f2);
        }
        for (CampaignEntity campaignEntity : list) {
            if (!(campaignEntity instanceof CampaignFleet)) continue;
            CampaignFleet campaignFleet = (CampaignFleet)campaignEntity;
            campaignFleet.renderSensorRange(f2);
        }
        Profiler.o00000();
        this.hitParticles.render(0.0f, 0.0f);
    }

    public void advanceEvenIfPaused(float f2, new new_) {
        Object object;
        Object object22;
        this.executeAdds();
        this.executeRemoves();
        if (this.scripts == null) {
            return;
        }
        if (this.objects == null) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.objects.getList(CampaignEntity.class));
        for (Object object22 : arrayList) {
            if (object22 == null) continue;
            object22.getIndicator().\u00d500000(f2);
        }
        for (Object object22 : arrayList) {
            if (object22 == null) continue;
            object = this.lightColor;
            object22.setContainingLocation(this);
            MemoryAPI memoryAPI = object22.getMemoryWithoutUpdate();
            SectorEntityToken sectorEntityToken = (SectorEntityToken)memoryAPI.get("$lightSourceOverride");
            Color color = (Color)memoryAPI.get("$lightColorOverride");
            if (sectorEntityToken != null && color != null) {
                object22.setLightSource(sectorEntityToken, color);
            } else if (this instanceof StarSystem) {
                PlanetAPI planetAPI;
                StarSystem starSystem = (StarSystem)this;
                SectorEntityToken sectorEntityToken2 = starSystem.getCenter();
                if (object22.getOrbitFocus() instanceof PlanetAPI) {
                    planetAPI = (PlanetAPI)object22.getOrbitFocus();
                    if (planetAPI.isStar()) {
                        sectorEntityToken2 = planetAPI;
                    } else if (planetAPI.getOrbitFocus() instanceof PlanetAPI && (planetAPI = (PlanetAPI)planetAPI.getOrbitFocus()).isStar()) {
                        sectorEntityToken2 = planetAPI;
                    }
                }
                if (sectorEntityToken2 instanceof PlanetAPI && (planetAPI = (PlanetAPI)sectorEntityToken2).getLightColorOverrideIfStar() != null) {
                    object = planetAPI.getLightColorOverrideIfStar();
                }
                object22.setLightSource(sectorEntityToken2, (Color)object);
            } else {
                object22.setLightSource(null, this.lightColor);
            }
            object22.advanceEvenIfPaused(f2);
        }
        object22 = new ArrayList<EveryFrameScript>(this.scripts);
        object = object22.iterator();
        while (object.hasNext()) {
            EveryFrameScript everyFrameScript = (EveryFrameScript)object.next();
            if (everyFrameScript == null) continue;
            if (everyFrameScript.isDone()) {
                this.scripts.remove(everyFrameScript);
                continue;
            }
            if (!everyFrameScript.runWhilePaused() && CampaignEngine.getInstance().isPaused()) continue;
            everyFrameScript.advance(f2);
            if (!everyFrameScript.isDone()) continue;
            this.scripts.remove(everyFrameScript);
        }
    }

    public Fader getLightHeight() {
        return this.lightHeight;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void advance(float var1_1, new var2_2) {
        block42: {
            if (CampaignEngine.getInstance().isPaused()) break block42;
            if (this.memory != null) {
                this.memory.advance(var1_1);
            }
            this.idToEntity = null;
            var3_3 = CampaignEngine.getInstance().getClock().convertToDays(var1_1);
            this.lightHeight.advance(var3_3);
            if (this.background != null && this.isCurrentLocation()) {
                this.background.advance(var1_1);
            }
            this.hitParticles.advance(var1_1);
            this.executeAdds();
            this.executeRemoves();
            Profiler.\u00d200000((String)"Entity advance");
            var4_4 = new ArrayList<E>(this.objects.getList(CampaignEntity.class));
            for (Object var5_7 : var4_4) {
                if (var5_7.isExpired()) {
                    this.removeObject(var5_7);
                    continue;
                }
                var5_7.setContainingLocation(this);
                var7_8 = this.lightColor;
                var5_7.setContainingLocation(this);
                var8_9 = var5_7.getMemoryWithoutUpdate();
                var9_12 = (SectorEntityToken)var8_9.get("$lightSourceOverride");
                var10_15 /* !! */  = (Color)var8_9.get("$lightColorOverride");
                if (var9_12 != null && var10_15 /* !! */  != null) {
                    var5_7.setLightSource(var9_12, (Color)var10_15 /* !! */ );
                } else if (this instanceof StarSystem) {
                    var11_17 = (StarSystem)this;
                    var12_22 = var11_17.getCenter();
                    if (var5_7.getOrbitFocus() instanceof PlanetAPI) {
                        var13_27 = (PlanetAPI)var5_7.getOrbitFocus();
                        if (var13_27.isStar()) {
                            var12_22 = var13_27;
                        } else if (var13_27.getOrbitFocus() instanceof PlanetAPI && (var13_27 = (PlanetAPI)var13_27.getOrbitFocus()).isStar()) {
                            var12_22 = var13_27;
                        }
                    }
                    if (var12_22 instanceof PlanetAPI && (var13_27 = (PlanetAPI)var12_22).getLightColorOverrideIfStar() != null) {
                        var7_8 = var13_27.getLightColorOverrideIfStar();
                    }
                    var5_7.setLightSource(var12_22, (Color)var7_8);
                } else {
                    var5_7.setLightSource(null, this.lightColor);
                }
                var5_7.advance(var1_1);
                if (var5_7.getOrbit() != null) {
                    var5_7.getOrbit().advance(var1_1);
                }
                var11_17 = var5_7.getVelocity();
                var12_22 = var5_7.getLocation();
                var12_22.x += var11_17.x * var1_1;
                var12_22.y += var11_17.y * var1_1;
                if (var5_7.getIndicator() == null) continue;
                var5_7.getIndicator().\u00d500000(var1_1);
            }
            Profiler.o00000();
            Profiler.\u00d200000((String)"LocationTokens advance");
            var5_7 = new ArrayList<E>(this.objects.getList(LocationToken.class));
            var7_8 = var5_7.iterator();
            while (var7_8.hasNext()) {
                var6_5 = (LocationToken)var7_8.next();
                if (var6_5.getOrbit() != null) {
                    var6_5.getOrbit().advance(var1_1);
                }
                var8_9 = var6_5.getVelocity();
                var9_12 = var6_5.getLocation();
                var9_12.x += var8_9.x * var1_1;
                var9_12.y += var8_9.y * var1_1;
            }
            Profiler.o00000();
            Profiler.\u00d200000((String)"Adds and removes");
            this.executeAdds();
            this.executeRemoves();
            Profiler.o00000();
            if (var1_1 <= 0.0f) {
                return;
            }
            Profiler.\u00d200000((String)"Checking combat initiation");
            var6_6 = false;
            var7_8 = this.objects.getList(CampaignFleet.class);
            var8_10 = 0;
            while (var8_10 < var7_8.size()) {
                block43: {
                    var9_12 = (CampaignFleet)var7_8.get(var8_10);
                    if (!var9_12.canBeEngaged()) break block43;
                    var10_16 = var8_10 + 1;
                    while (var10_16 < var7_8.size()) {
                        block44: {
                            block46: {
                                block45: {
                                    var11_17 = (CampaignFleet)var7_8.get(var10_16);
                                    if (!var11_17.canBeEngaged()) break block44;
                                    var12_24 = Utils.\u00d800000(var9_12.getLocation(), var11_17.getLocation());
                                    var13_29 = var9_12.getSelectionSize() + var11_17.getSelectionSize();
                                    if (CampaignEngine.getInstance().isInFastAdvance()) {
                                        var13_29 += 1000.0f;
                                    }
                                    if (!(var9_12.getBattle() != null ^ var11_17.getBattle() != null)) break block45;
                                    var14_32 = var9_12.getBattle();
                                    var15_36 = var11_17;
                                    if (var14_32 == null) {
                                        var14_32 = var11_17.getBattle();
                                        var15_36 = var9_12;
                                    }
                                    if ((var16_40 = var14_32.getClosestInvolvedFleetTo((CampaignFleetAPI)var15_36)) == null || !var15_36.isStationMode() || !(var17_41 = Misc.isStationInSupportRange((CampaignFleetAPI)var16_40, (CampaignFleetAPI)var15_36)) || !var14_32.canJoin((CampaignFleetAPI)var15_36)) break block45;
                                    var14_32.join((CampaignFleetAPI)var15_36);
                                    break block44;
                                }
                                if (var9_12.getInteractionTarget() != var11_17 && var11_17.getInteractionTarget() != var9_12) break block44;
                                var14_33 = var9_12.isPlayerFleet() != false || var11_17.isPlayerFleet() != false;
                                var15_37 = Utils.\u00d800000(Global.getSector().getPlayerFleet().getLocation(), var9_12.getLocation());
                                if (!(var9_12.getBattle() != null ^ var11_17.getBattle() != null)) ** GOTO lbl-1000
                                var16_40 = var9_12.getBattle();
                                var17_42 = var11_17;
                                if (var16_40 == null) {
                                    var16_40 = var11_17.getBattle();
                                    var17_42 = var9_12;
                                }
                                if ((var18_44 = var16_40.getClosestInvolvedFleetTo((CampaignFleetAPI)var17_42)) == null) ** GOTO lbl-1000
                                if (!var17_42.isStationMode()) break block46;
                                var19_46 = Misc.isStationInSupportRange((CampaignFleetAPI)var18_44, (CampaignFleetAPI)var17_42);
                                if (!var19_46 || !var16_40.canJoin((CampaignFleetAPI)var17_42)) ** GOTO lbl-1000
                                var16_40.join((CampaignFleetAPI)var17_42);
                                break block44;
                            }
                            var19_47 = Utils.\u00d800000(var18_44.getLocation(), var17_42.getLocation());
                            if (var19_47 < var18_44.getRadius() + var17_42.getRadius() && !var14_33 && var17_42.getAI() != null && var17_42.getAI().wantsToJoin((BattleAPI)var16_40, false) && var16_40.canJoin((CampaignFleetAPI)var17_42)) {
                                var16_40.join((CampaignFleetAPI)var17_42);
                            } else if (var12_24 < var13_29 && var9_12.getFaction() != var11_17.getFaction()) {
                                var16_40 = CampaignEngine.getInstance().getListener();
                                var17_43 = CampaignEngine.getInstance().getPlayerFleet();
                                var18_45 = var9_12.getAI() != null && var9_12.getAI().isHostileTo((CampaignFleetAPI)var11_17) != false;
                                var18_45 |= var11_17.getAI() != null && var11_17.getAI().isHostileTo((CampaignFleetAPI)var9_12) != false;
                                if (var14_33 && var16_40 != null && !var6_6) {
                                    var19_48 = var9_12;
                                    if (var9_12.isPlayerFleet()) {
                                        var19_48 = var11_17;
                                    }
                                    if (var19_48.getAI() != null) {
                                        var19_48.getAI().notifyInteractedWith((CampaignFleetAPI)var17_43);
                                    }
                                    var16_40.startEncounterInvolvingPlayerFleet(var17_43, (BaseCampaignEntity)var19_48);
                                    var6_6 = true;
                                } else if (!(var14_33 || !var9_12.getFaction().isAtBest(var11_17.getFaction(), RepLevel.HOSTILE) && !var18_45 || var9_12.isStationMode() && var11_17.isStationMode())) {
                                    if (var9_12.getAI() != null) {
                                        var9_12.getAI().notifyInteractedWith((CampaignFleetAPI)var11_17);
                                    }
                                    if (var11_17.getAI() != null) {
                                        var11_17.getAI().notifyInteractedWith((CampaignFleetAPI)var9_12);
                                    }
                                    if (var9_12.getBattle() == null && var11_17.getBattle() == null) {
                                        new Battle((CampaignFleetAPI)var9_12, (CampaignFleetAPI)var11_17);
                                    }
                                }
                            }
                        }
                        ++var10_16;
                    }
                }
                ++var8_10;
            }
            Profiler.o00000();
            Profiler.\u00d200000((String)"Checking station interaction");
            var8_11 = this.objects.getList(CampaignOrbitalStation.class);
            var9_13 = 0;
            while (var9_13 < var7_8.size()) {
                var10_15 /* !! */  = (CampaignFleet)var7_8.get(var9_13);
                if (var10_15 /* !! */ .canBeEngaged()) {
                    var11_19 = 0;
                    while (var11_19 < var8_11.size()) {
                        var12_25 = (CampaignOrbitalStation)var8_11.get(var11_19);
                        var13_30 = Utils.\u00d800000(var10_15 /* !! */ .getLocation(), var12_25.getLocation());
                        var14_34 = var10_15 /* !! */ .getSelectionSize() + var12_25.getSelectionSize();
                        if (var10_15 /* !! */ .getInteractionTarget() == var12_25 && var13_30 < var14_34) {
                            var15_38 = CampaignEngine.getInstance().getListener();
                            var16_40 = CampaignEngine.getInstance().getPlayerFleet();
                            if (var10_15 /* !! */ .isPlayerFleet() && var15_38 != null) {
                                var15_38.startEncounterInvolvingPlayerFleet((CampaignFleet)var16_40, var12_25);
                            }
                        }
                        ++var11_19;
                    }
                }
                ++var9_13;
            }
            Profiler.o00000();
            Profiler.\u00d200000((String)"Player combat initiation");
            var9_14 = CampaignEngine.getInstance().getPlayerFleet();
            if (!var6_6 && var9_14.getInteractionTarget() != null && var9_14.canBeEngaged()) {
                var10_15 /* !! */  = this.objects.getList(BaseCampaignEntity.class);
                var10_15 /* !! */  = new ArrayList<E>(var10_15 /* !! */ );
                for (BaseCampaignEntity var11_20 : var10_15 /* !! */ ) {
                    if (var11_20 instanceof CampaignFleet && !((CampaignFleet)var11_20).canBeEngaged()) continue;
                    var13_31 = Utils.\u00d800000(var9_14.getLocation(), var11_20.getLocation());
                    var14_35 = var9_14.getSelectionSize() + var11_20.getRadius();
                    if (var9_14.getInteractionTarget() != var11_20 || !(var13_31 < var14_35) || (var15_39 = CampaignEngine.getInstance().getListener()) == null || var6_6) continue;
                    var15_39.startEncounterInvolvingPlayerFleet(var9_14, var11_20);
                    var6_6 = true;
                }
            }
            Profiler.o00000();
            Profiler.\u00d200000((String)"Spawn points (obsolete)");
            for (ArrayList<E> var10_15 : this.spawnPoints) {
                var10_15 /* !! */ .advance(CampaignEngine.getInstance(), this);
            }
            Profiler.o00000();
        }
        if (this == CampaignEngine.getInstance().getCurrentLocation()) {
            this.lastPlayerVisitTimestamp = CampaignEngine.getInstance().getClock().getTimestamp();
        }
    }

    public long getLastPlayerVisitTimestamp() {
        return this.lastPlayerVisitTimestamp;
    }

    public float getDaysSinceLastPlayerVisit() {
        if (this.lastPlayerVisitTimestamp == 0L) {
            return Float.MAX_VALUE;
        }
        return CampaignEngine.getInstance().getClock().getElapsedDaysSince(this.lastPlayerVisitTimestamp);
    }

    private void updateFrameOfReferenceVelocity() {
        CampaignFleetAPI campaignFleetAPI = Global.getSector().getPlayerFleet();
        if (campaignFleetAPI == null) {
            return;
        }
        if (campaignFleetAPI.getContainingLocation() != this) {
            return;
        }
        if (this.isHyperspace()) {
            return;
        }
        for (CampaignFleetAPI campaignFleetAPI2 : this.getFleets()) {
            Object var4_4 = null;
            float f2 = 0.0f;
            for (PlanetAPI planetAPI : this.getPlanets()) {
                float f3 = Misc.getDistance((Vector2f)planetAPI.getLocation(), (Vector2f)campaignFleetAPI2.getLocation());
            }
        }
    }

    public void addSpawnPoint(SpawnPointPlugin spawnPointPlugin) {
        this.spawnPoints.add(spawnPointPlugin);
    }

    public List<EveryFrameScript> getScripts() {
        return this.scripts;
    }

    public void addScript(EveryFrameScript everyFrameScript) {
        this.scripts.add(everyFrameScript);
    }

    public void removeScriptsOfClass(Class clazz) {
        Iterator<EveryFrameScript> iterator = this.scripts.iterator();
        while (iterator.hasNext()) {
            EveryFrameScript everyFrameScript = iterator.next();
            if (everyFrameScript.getClass() != clazz) continue;
            iterator.remove();
        }
    }

    public void removeScript(EveryFrameScript everyFrameScript) {
        Iterator<EveryFrameScript> iterator = this.scripts.iterator();
        while (iterator.hasNext()) {
            EveryFrameScript everyFrameScript2 = iterator.next();
            if (everyFrameScript2 != everyFrameScript) continue;
            iterator.remove();
        }
    }

    public void spawnFleet(SectorEntityToken sectorEntityToken, float f2, float f3, CampaignFleetAPI campaignFleetAPI) {
        this.addObject(campaignFleetAPI);
        Vector2f vector2f = new Vector2f();
        if (sectorEntityToken != null) {
            vector2f.set((ReadableVector2f)sectorEntityToken.getLocation());
        }
        vector2f.x += f2;
        vector2f.y += f3;
        campaignFleetAPI.setLocation(vector2f.x, vector2f.y);
        ((CampaignFleet)campaignFleetAPI).setNoEngaging(3.0f);
    }

    public void addHitParticle(Vector2f vector2f, Vector2f vector2f2, float f2, float f3, float f4, Color color) {
        this.addParticle(vector2f, vector2f2, f2, f3, 0.0f, f4, color);
    }

    public ParticleControllerAPI addParticle(Vector2f vector2f, Vector2f vector2f2, float f2, float f3, float f4, float f5, Color color) {
        if (CampaignEngine.getInstance().getCurrentLocation() != this) {
            return null;
        }
        CombatViewport combatViewport = CampaignEngine.getInstance().getViewport();
        if (!combatViewport.isNearViewport(vector2f, f2 * 4.0f)) {
            return null;
        }
        GenericTextureParticle genericTextureParticle = new GenericTextureParticle("graphics/fx/hit_glow.png", OoOO.\u00d200000((Color)color, (int)((int)(255.0f * f3))), f2, f2, 0.0f);
        genericTextureParticle.setBlendFunc(770, 1);
        genericTextureParticle.setPos(vector2f.x, vector2f.y);
        if (vector2f2 != null) {
            genericTextureParticle.setVel(vector2f2.x, vector2f2.y);
        }
        genericTextureParticle.setMaxAge(f5);
        if (f4 > 0.0f) {
            genericTextureParticle.setRampUpPeriod(f4);
        }
        this.hitParticles.add((BaseParticle)genericTextureParticle);
        return new ParticleController((BaseParticle)genericTextureParticle);
    }

    public void addEntity(SectorEntityToken sectorEntityToken) {
        if (sectorEntityToken == null) {
            return;
        }
        this.addObject(sectorEntityToken);
    }

    public void removeEntity(SectorEntityToken sectorEntityToken) {
        if (sectorEntityToken == null) {
            return;
        }
        this.removeObject(sectorEntityToken);
    }

    public Vector2f getLocation() {
        return this.location;
    }

    public SectorEntityToken createToken(float f2, float f3) {
        return new LocationToken(this, f2, f3);
    }

    public SectorEntityToken createToken(Vector2f vector2f) {
        return new LocationToken(this, vector2f.x, vector2f.y);
    }

    public List<CampaignFleetAPI> getFleets() {
        return Collections.unmodifiableList(this.getObjects().getList(CampaignFleetAPI.class));
    }

    public List<CampaignTerrain> getTerrain() {
        return Collections.unmodifiableList(this.getObjects().getList(CampaignTerrain.class));
    }

    public List<CampaignTerrainAPI> getTerrainCopy() {
        return new ArrayList<CampaignTerrainAPI>(this.getObjects().getList(CampaignTerrain.class));
    }

    public List<SectorEntityToken> getAsteroids() {
        return Collections.unmodifiableList(this.getObjects().getList(CampaignAsteroid.class));
    }

    public List<SectorEntityToken> getJumpPoints() {
        return Collections.unmodifiableList(this.getObjects().getList(JumpPoint.class));
    }

    public List<NascentGravityWellAPI> getGravityWells() {
        return Collections.unmodifiableList(this.getObjects().getList(NascentGravityWellAPI.class));
    }

    public List<SectorEntityToken> getOrbitalStations() {
        return Collections.unmodifiableList(this.getObjects().getList(CampaignOrbitalStation.class));
    }

    public List<PlanetAPI> getPlanets() {
        return Collections.unmodifiableList(this.getObjects().getList(CampaignPlanet.class));
    }

    public SectorEntityToken getEntityByName(String string) {
        if (string != null && string.equals("Fleet")) {
            return CampaignEngine.getInstance().getPlayerFleet();
        }
        List list = this.getObjects().getList(SectorEntityToken.class);
        for (SectorEntityToken sectorEntityToken : list) {
            if (sectorEntityToken.getName() == null || !sectorEntityToken.getName().equals(string)) continue;
            return sectorEntityToken;
        }
        return null;
    }

    public SectorEntityToken getEntityById(String string) {
        Object object;
        if (this.idToEntity == null) {
            this.rebuildIDToEntityMap();
        }
        if (this.idToEntity.containsKey(string) && (this.idToEntity.get(string) instanceof BaseCampaignEntity ? ((BaseCampaignEntity)(object = (BaseCampaignEntity)this.idToEntity.get(string))).getContainingLocation() != null && ((BaseCampaignEntity)object).getContainingLocation().getAllEntities().contains(object) : this.idToEntity.get(string) instanceof LocationToken && ((LocationToken)(object = (LocationToken)this.idToEntity.get(string))).getContainingLocation() != null && ((LocationToken)object).getContainingLocation().getAllEntities().contains(object))) {
            return object;
        }
        object = this.getObjects().getList(SectorEntityToken.class);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            SectorEntityToken sectorEntityToken = (SectorEntityToken)iterator.next();
            if (sectorEntityToken.getId() == null || !sectorEntityToken.getId().toLowerCase().equals(string.toLowerCase())) continue;
            return sectorEntityToken;
        }
        return null;
    }

    private void rebuildIDToEntityMap() {
        this.idToEntity = new HashMap<String, SectorEntityToken>();
        for (SectorEntityToken sectorEntityToken : this.getAllEntities()) {
            this.idToEntity.put(sectorEntityToken.getId(), sectorEntityToken);
        }
    }

    public List<CustomCampaignEntityAPI> getCustomEntitiesWithTag(String string) {
        ArrayList<CustomCampaignEntityAPI> arrayList = new ArrayList<CustomCampaignEntityAPI>();
        List list = this.objects.getList(CustomCampaignEntity.class);
        for (CustomCampaignEntityAPI customCampaignEntityAPI : list) {
            if (!customCampaignEntityAPI.hasTag(string)) continue;
            arrayList.add(customCampaignEntityAPI);
        }
        return arrayList;
    }

    public List<CustomCampaignEntityAPI> getCustomEntities() {
        ArrayList<CustomCampaignEntityAPI> arrayList = new ArrayList<CustomCampaignEntityAPI>();
        List list = this.objects.getList(CustomCampaignEntity.class);
        for (CustomCampaignEntityAPI customCampaignEntityAPI : list) {
            arrayList.add(customCampaignEntityAPI);
        }
        return arrayList;
    }

    public List<SectorEntityToken> getEntitiesWithTag(String string) {
        ArrayList<SectorEntityToken> arrayList = new ArrayList<SectorEntityToken>();
        List list = this.objects.getList(SectorEntityToken.class);
        for (SectorEntityToken sectorEntityToken : list) {
            if (!sectorEntityToken.hasTag(string)) continue;
            arrayList.add(sectorEntityToken);
        }
        return arrayList;
    }

    public List getEntities(Class clazz) {
        return this.objects.getList(clazz);
    }

    public List<SectorEntityToken> getAllEntities() {
        return this.objects.getList(SectorEntityToken.class);
    }

    public Color getLightColor() {
        return this.lightColor;
    }

    public void setLightColor(Color color) {
        this.lightColor = color;
    }

    public SectorEntityToken addAsteroidBelt(SectorEntityToken sectorEntityToken, int n2, float f2, float f3, float f4, float f5) {
        return this.addAsteroidBelt(sectorEntityToken, n2, f2, f3, f4, f5, "asteroid_belt", null);
    }

    public SectorEntityToken addAsteroidBelt(SectorEntityToken sectorEntityToken, int n2, float f2, float f3, float f4, float f5, String string, String string2) {
        CampaignTerrainAPI campaignTerrainAPI = this.addTerrain(string, new AsteroidBeltTerrainPlugin.AsteroidBeltParams(n2, f2, f3, f4, f5, 4.0f, 16.0f, string2));
        campaignTerrainAPI.setCircularOrbit(sectorEntityToken, 0.0f, 0.0f, 100.0f);
        return campaignTerrainAPI;
    }

    public AsteroidAPI addAsteroid(float f2) {
        CampaignAsteroid campaignAsteroid = new CampaignAsteroid(f2, 0.0f, 0.0f, null);
        this.addObject(campaignAsteroid);
        return campaignAsteroid;
    }

    public void addOrbitalJunk(SectorEntityToken sectorEntityToken, String string, int n2, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        int n3 = 0;
        while (n3 < n2) {
            float f10 = f2 + (float)Math.random() * (f3 - f2);
            float f11 = 0.0f;
            CustomCampaignEntityAPI customCampaignEntityAPI = this.addCustomEntity(null, null, string, "neutral", f11, f10, f10);
            float f12 = f4 - f5 / 2.0f + (float)Math.random() * f5;
            float f13 = (float)Math.random() * 360.0f;
            CircularOrbitWithSpin circularOrbitWithSpin = new CircularOrbitWithSpin((SectorEntityToken)customCampaignEntityAPI, sectorEntityToken, f12, f13, f8, f9);
            circularOrbitWithSpin.setPeriod(f6 + (float)Math.random() * (f7 - f6));
            customCampaignEntityAPI.setOrbit((OrbitAPI)circularOrbitWithSpin);
            ++n3;
        }
    }

    public SectorEntityToken addOrbitalStation(String string, SectorEntityToken sectorEntityToken, float f2, float f3, float f4, String string2, String string3) {
        return this.addOrbitalStation(string, sectorEntityToken, "stations", "default_station", 75.0f, f2, f3, f4, string2, string3);
    }

    public SectorEntityToken addOrbitalStation(String string, SectorEntityToken sectorEntityToken, String string2, String string3, float f2, float f3, float f4, float f5, String string4, String string5) {
        CampaignOrbitalStation campaignOrbitalStation = new CampaignOrbitalStation(string, string4, string5, string2, string3, f2, this.getLightSource());
        this.addObject(campaignOrbitalStation);
        campaignOrbitalStation.setOrbit(new CircularOrbit(campaignOrbitalStation, sectorEntityToken, f4).setPeriod(f5).setCurrAngle(f3));
        this.executeAdds();
        return campaignOrbitalStation;
    }

    public CustomCampaignEntityAPI addCustomEntity(String string, String string2, String string3, String string4) {
        return this.addCustomEntity(string, string2, string3, string4, null);
    }

    public CustomCampaignEntityAPI addCustomEntity(String string, String string2, String string3, String string4, Object object) {
        CustomCampaignEntity customCampaignEntity = new CustomCampaignEntity(string, string2, string3, string4, -1.0f, -1.0f, -1.0f, this.getLightSource(), object);
        this.addObject(customCampaignEntity);
        return customCampaignEntity;
    }

    public CustomCampaignEntityAPI addCustomEntity(String string, String string2, String string3, String string4, float f2, float f3, float f4) {
        return this.addCustomEntity(string, string2, string3, string4, f2, f3, f4, null);
    }

    public CustomCampaignEntityAPI addCustomEntity(String string, String string2, String string3, String string4, float f2, float f3, float f4, Object object) {
        CustomCampaignEntity customCampaignEntity = new CustomCampaignEntity(string, string2, string3, string4, f2, f3, f4, this.getLightSource(), object);
        this.addObject(customCampaignEntity);
        return customCampaignEntity;
    }

    public PlanetAPI addPlanet(String string, SectorEntityToken sectorEntityToken, String string2, String string3, float f2, float f3, float f4, float f5) {
        CampaignPlanet campaignPlanet = new CampaignPlanet(string, string2, string3, f3, this.getLightSource());
        this.addObject(campaignPlanet);
        ProcgenUsedNames.notifyUsed((String)string2);
        if (sectorEntityToken != null && f3 >= 1.0f) {
            campaignPlanet.setOrbit(new CircularOrbit(campaignPlanet, sectorEntityToken, f4).setPeriod(f5).setCurrAngle(f2));
        }
        this.executeAdds();
        if (campaignPlanet != null && !campaignPlanet.isStar()) {
            Misc.initConditionMarket((PlanetAPI)campaignPlanet);
        }
        return campaignPlanet;
    }

    public SectorEntityToken addCorona(SectorEntityToken sectorEntityToken, float f2, float f3, float f4, float f5) {
        return this.addCorona(sectorEntityToken, "corona", f2, f3, f4, f5);
    }

    public SectorEntityToken addCorona(SectorEntityToken sectorEntityToken, String string, float f2, float f3, float f4, float f5) {
        CampaignTerrainAPI campaignTerrainAPI = this.addTerrain(string, new StarCoronaTerrainPlugin.CoronaParams(sectorEntityToken.getRadius() + f2, (sectorEntityToken.getRadius() + f2) / 2.0f, sectorEntityToken, f3, f4, f5));
        campaignTerrainAPI.setCircularOrbit(sectorEntityToken, 0.0f, 0.0f, 100.0f);
        return campaignTerrainAPI;
    }

    public SectorEntityToken addRadioChatter(SectorEntityToken sectorEntityToken, float f2) {
        CampaignTerrainAPI campaignTerrainAPI = this.addTerrain("radio_chatter", new RadioChatterTerrainPlugin.RadioChatterParams(sectorEntityToken.getRadius() + f2, (sectorEntityToken.getRadius() + f2) / 2.0f, sectorEntityToken));
        campaignTerrainAPI.setCircularOrbit(sectorEntityToken, 0.0f, 0.0f, 100.0f);
        return campaignTerrainAPI;
    }

    public RingBandAPI addRingBand(SectorEntityToken sectorEntityToken, String string, String string2, float f2, int n2, Color color, float f3, float f4, float f5) {
        RingBand ringBand = new RingBand(sectorEntityToken, string, string2, f2, n2, color, f3, f4, f5);
        this.addEntity(ringBand);
        return ringBand;
    }

    public SectorEntityToken addRingBand(SectorEntityToken sectorEntityToken, String string, String string2, float f2, int n2, Color color, float f3, float f4, float f5, String string3, String string4) {
        RingBandAPI ringBandAPI = this.addRingBand(sectorEntityToken, string, string2, f2, n2, color, f3, f4, f5);
        if (string3 != null) {
            CampaignTerrainAPI campaignTerrainAPI = this.addTerrain(string3, new BaseRingTerrain.RingParams(f3 * 0.75f, f4, (SectorEntityToken)ringBandAPI, string4));
            campaignTerrainAPI.setCircularOrbit(sectorEntityToken, 0.0f, 0.0f, 100.0f);
            return campaignTerrainAPI;
        }
        return ringBandAPI;
    }

    public CampaignEntity getLightSource() {
        return null;
    }

    public boolean isHyperspace() {
        return this == CampaignEngine.getInstance().getHyperspace();
    }

    public void removeSpawnPoint(SpawnPointPlugin spawnPointPlugin) {
        this.spawnPoints.remove(spawnPointPlugin);
    }

    public List<SpawnPointPlugin> getSpawnPoints() {
        return this.spawnPoints;
    }

    public boolean isDeepSpace() {
        if (this instanceof StarSystemAPI) {
            StarSystemAPI starSystemAPI = (StarSystemAPI)this;
            return starSystemAPI.getType() == StarSystemGenerator.StarSystemType.DEEP_SPACE;
        }
        return false;
    }

    public boolean activeThisFrame() {
        return this.activeThisFrame;
    }

    public void setActiveThisFrame(boolean bl) {
        this.activeThisFrame = bl;
    }

    public CampaignTerrainAPI addTerrain(String string, Object object) {
        CampaignTerrain campaignTerrain = new CampaignTerrain(string, object);
        this.addObject(campaignTerrain);
        return campaignTerrain;
    }

    public void updateAllOrbits() {
        ArrayList arrayList = new ArrayList(this.getObjects().getList(SectorEntityToken.class));
        int n2 = 0;
        while (n2 < 4) {
            for (SectorEntityToken sectorEntityToken : arrayList) {
                if (sectorEntityToken instanceof CampaignEntity) {
                    ((CampaignEntity)sectorEntityToken).setContainingLocation(this);
                }
                if (sectorEntityToken.getOrbit() == null) continue;
                sectorEntityToken.getOrbit().advance(0.0f);
            }
            ++n2;
        }
    }

    public boolean isNebula() {
        return false;
    }

    public Constellation getConstellation() {
        return null;
    }

    public boolean isInConstellation() {
        return false;
    }

    public boolean hasTag(String string) {
        if (this.tags == null) {
            return false;
        }
        return this.tags.contains(string);
    }

    public void addTag(String string) {
        if (this.tags == null) {
            this.tags = new HashSet();
        }
        this.tags.add(string);
    }

    public void removeTag(String string) {
        if (this.tags == null) {
            return;
        }
        this.tags.remove(string);
        if (this.tags.isEmpty()) {
            this.tags = null;
        }
    }

    public Collection<String> getTags() {
        if (this.tags == null) {
            return new ArrayList<String>();
        }
        return this.tags;
    }

    public void clearTags() {
        if (this.tags != null) {
            this.tags.clear();
        }
    }

    public void setMemory(MemoryAPI memoryAPI) {
        this.memory = (Memory)memoryAPI;
    }

    public MemoryAPI getMemoryWithoutUpdate() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        return this.memory;
    }

    public boolean isCurrentLocation() {
        return this == Global.getSector().getCurrentLocation();
    }

    public static class LocationToken
    implements SectorEntityToken,
    DoNotObfuscate {
        private Vector2f loc;
        private final LocationAPI where;
        private OrbitAPI orbit;
        private String id = Misc.genUID();
        private String name = null;
        private Faction faction;
        private HashSet<String> tags = null;
        private Memory memory = null;
        private Market market;
        private Map<String, Object> customData = null;
        Boolean expired = null;

        public LocationToken(LocationAPI locationAPI, float f2, float f3) {
            this.where = locationAPI;
            this.loc = new Vector2f(f2, f3);
            this.setFaction("neutral");
        }

        Object writeReplace() {
            if (this.customData != null && this.customData.isEmpty()) {
                this.customData = null;
            }
            return this;
        }

        public Vector2f getLocation() {
            return this.loc;
        }

        public CargoAPI getCargo() {
            return null;
        }

        public OrbitAPI getOrbit() {
            return this.orbit;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return "unknown location";
        }

        public String getFullName() {
            if (this.name != null) {
                return this.name;
            }
            return "unknown location";
        }

        public void setFaction(String string) {
            this.faction = CampaignEngine.getInstance().getFaction(string);
        }

        public LocationAPI getContainingLocation() {
            return this.where;
        }

        public float getRadius() {
            return 0.0f;
        }

        public void setOrbit(OrbitAPI orbitAPI) {
            this.orbit = orbitAPI;
            if (orbitAPI != null) {
                this.orbit.setEntity((SectorEntityToken)this);
                orbitAPI.advance(0.0f);
            }
        }

        public FactionAPI getFaction() {
            return this.faction;
        }

        public String getCustomDescriptionId() {
            return null;
        }

        public void setCustomDescriptionId(String string) {
        }

        public InteractionDialogImageVisual getCustomInteractionDialogImageVisual() {
            return null;
        }

        public void setCustomInteractionDialogImageVisual(InteractionDialogImageVisual interactionDialogImageVisual) {
        }

        public boolean isFreeTransfer() {
            return false;
        }

        public void setFreeTransfer(boolean bl) {
        }

        public String getId() {
            return this.id;
        }

        public boolean hasTag(String string) {
            if (this.tags == null) {
                return false;
            }
            return this.tags.contains(string);
        }

        public void addTag(String string) {
            if (this.tags == null) {
                this.tags = new HashSet();
            }
            this.tags.add(string);
        }

        public void removeTag(String string) {
            if (this.tags == null) {
                return;
            }
            this.tags.remove(string);
            if (this.tags.isEmpty()) {
                this.tags = null;
            }
        }

        public Collection<String> getTags() {
            if (this.tags == null) {
                return new ArrayList<String>();
            }
            return this.tags;
        }

        public void clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
        }

        public void setCircularOrbit(SectorEntityToken sectorEntityToken, float f2, float f3, float f4) {
            CircularOrbit circularOrbit = new CircularOrbit(this, sectorEntityToken, f3, f2);
            circularOrbit.setPeriod(f4);
            this.setOrbit(circularOrbit);
        }

        public void setFixedLocation(float f2, float f3) {
        }

        public MemoryAPI getMemory() {
            if (this.memory == null) {
                this.memory = new Memory();
            }
            return this.memory;
        }

        public float getFacing() {
            return 0.0f;
        }

        public void setCircularOrbitPointingDown(SectorEntityToken sectorEntityToken, float f2, float f3, float f4) {
        }

        public void setFacing(float f2) {
        }

        public MemoryAPI getMemoryWithoutUpdate() {
            if (this.memory == null) {
                this.memory = new Memory();
            }
            return this.memory;
        }

        public MarketAPI getMarket() {
            return this.market;
        }

        public void setMarket(MarketAPI marketAPI) {
            this.market = (Market)marketAPI;
        }

        public void setCircularOrbitWithSpin(SectorEntityToken sectorEntityToken, float f2, float f3, float f4, float f5, float f6) {
        }

        public Vector2f getLocationInHyperspace() {
            if (this.getContainingLocation() == null || this.getContainingLocation().isHyperspace()) {
                return this.getLocation();
            }
            return this.getContainingLocation().getLocation();
        }

        public boolean isInHyperspace() {
            return this.getContainingLocation() != null && this.getContainingLocation().isHyperspace();
        }

        public void addScript(EveryFrameScript everyFrameScript) {
        }

        public void removeScript(EveryFrameScript everyFrameScript) {
        }

        public void removeScriptsOfClass(Class clazz) {
        }

        public boolean isInOrNearSystem(StarSystemAPI starSystemAPI) {
            return false;
        }

        public Vector2f getVelocity() {
            return new Vector2f();
        }

        public boolean isInCurrentLocation() {
            return this.getContainingLocation() == CampaignEngine.getInstance().getCurrentLocation();
        }

        public boolean isPlayerFleet() {
            return false;
        }

        public void setInteractionImage(String string, String string2) {
        }

        public void setName(String string) {
            this.name = string;
        }

        public boolean isAlive() {
            return true;
        }

        public CommDirectoryAPI getCommDirectory() {
            return null;
        }

        public void initCommDirectory() {
        }

        public void addPerson(PersonAPI personAPI) {
        }

        public PersonAPI getActivePerson() {
            return null;
        }

        public List<PersonAPI> getPeopleCopy() {
            return null;
        }

        public void removePerson(PersonAPI personAPI) {
        }

        public void setActivePerson(PersonAPI personAPI) {
        }

        public boolean isVisibleToPlayerFleet() {
            return false;
        }

        public boolean isVisibleToSensorsOf(SectorEntityToken sectorEntityToken) {
            return false;
        }

        public SectorEntityToken.VisibilityLevel getVisibilityLevelTo(SectorEntityToken sectorEntityToken) {
            return SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS;
        }

        public SectorEntityToken.VisibilityLevel getVisibilityLevelToPlayerFleet() {
            return SectorEntityToken.VisibilityLevel.COMPOSITION_DETAILS;
        }

        public void addAbility(String string) {
        }

        public Map<String, AbilityPlugin> getAbilities() {
            return null;
        }

        public AbilityPlugin getAbility(String string) {
            return null;
        }

        public boolean hasAbility(String string) {
            return false;
        }

        public void removeAbility(String string) {
        }

        public boolean isTransponderOn() {
            return false;
        }

        public void setTransponderOn(boolean bl) {
        }

        public void addFloatingText(String string, Color color, float f2) {
        }

        public Color getLightColor() {
            return Color.white;
        }

        public SectorEntityToken getLightSource() {
            return null;
        }

        public void setMemory(MemoryAPI memoryAPI) {
            this.memory = (Memory)memoryAPI;
        }

        public Map<String, Object> getCustomData() {
            if (this.customData == null) {
                this.customData = new HashMap<String, Object>();
            }
            return this.customData;
        }

        public Color getIndicatorColor() {
            return new Color(0, 0, 0, 0);
        }

        public CustomCampaignEntityPlugin getCustomPlugin() {
            return null;
        }

        public float getCircularOrbitRadius() {
            return 0.0f;
        }

        public SectorEntityToken getOrbitFocus() {
            if (this.orbit != null) {
                return this.orbit.getFocus();
            }
            return null;
        }

        public float getCircularOrbitPeriod() {
            return 0.0f;
        }

        public void setId(String string) {
            this.id = string;
        }

        public String getAutogenJumpPointNameInHyper() {
            return null;
        }

        public String getAutogenJumpPointNameInSystem() {
            return null;
        }

        public void setAutogenJumpPointNameInHyper(String string) {
        }

        public void setAutogenJumpPointNameInSystem(String string) {
        }

        public boolean isSkipForJumpPointAutoGen() {
            return false;
        }

        public void setSkipForJumpPointAutoGen(boolean bl) {
        }

        public float getCircularOrbitAngle() {
            return 0.0f;
        }

        public String getCustomEntityType() {
            return null;
        }

        public float getBaseSensorRangeToDetect(float f2) {
            return 0.0f;
        }

        public StatBonus getDetectedRangeMod() {
            return new StatBonus();
        }

        public float getMaxSensorRangeToDetect(SectorEntityToken sectorEntityToken) {
            return 0.0f;
        }

        public float getSensorProfile() {
            return 0.0f;
        }

        public StatBonus getSensorRangeMod() {
            return new StatBonus();
        }

        public float getSensorStrength() {
            return 0.0f;
        }

        public boolean hasSensorProfile() {
            return false;
        }

        public boolean hasSensorStrength() {
            return false;
        }

        public void setSensorProfile(Float f2) {
        }

        public void setSensorStrength(Float f2) {
        }

        public boolean isDiscoverable() {
            return false;
        }

        public void setDiscoverable(Boolean bl) {
        }

        public CustomEntitySpecAPI getCustomEntitySpec() {
            return null;
        }

        public void addDropRandom(String string, int n2) {
        }

        public void addDropRandom(String string, int n2, int n3) {
        }

        public void addDropValue(String string, int n2) {
        }

        public List<SalvageEntityGenDataSpec.DropData> getDropRandom() {
            return null;
        }

        public List<SalvageEntityGenDataSpec.DropData> getDropValue() {
            return null;
        }

        public boolean isExpired() {
            return this.expired != null && this.expired != false;
        }

        public void setExpired(boolean bl) {
            this.expired = bl;
        }

        public float getSensorContactFaderBrightness() {
            return 0.0f;
        }

        public float getSensorFaderBrightness() {
            return 0.0f;
        }

        public void forceSensorFaderBrightness(float f2) {
        }

        public Float getDiscoveryXP() {
            return Float.valueOf(0.0f);
        }

        public boolean hasDiscoveryXP() {
            return false;
        }

        public void setDiscoveryXP(Float f2) {
        }

        public void addDropRandom(SalvageEntityGenDataSpec.DropData dropData) {
        }

        public void addDropValue(SalvageEntityGenDataSpec.DropData dropData) {
        }

        public Boolean getAlwaysUseSensorFaderBrightness() {
            return null;
        }

        public void setAlwaysUseSensorFaderBrightness(Boolean bl) {
        }

        public void advance(float f2) {
        }

        public boolean hasScriptOfClass(Class clazz) {
            return false;
        }

        public void setContainingLocation(LocationAPI locationAPI) {
        }

        public void clearAbilities() {
        }

        public Constellation getConstellation() {
            if (this.getContainingLocation() == null) {
                return null;
            }
            return this.getContainingLocation().getConstellation();
        }

        public boolean isStar() {
            return false;
        }

        public Float getSalvageXP() {
            return Float.valueOf(0.0f);
        }

        public boolean hasSalvageXP() {
            return false;
        }

        public void setSalvageXP(Float f2) {
        }

        public Float getDetectionRangeDetailsOverrideMult() {
            return null;
        }

        public void setDetectionRangeDetailsOverrideMult(Float f2) {
        }

        public SectorEntityToken.VisibilityLevel getVisibilityLevelOfPlayerFleet() {
            return SectorEntityToken.VisibilityLevel.NONE;
        }

        public void setCircularOrbitAngle(float f2) {
        }

        public void addFloatingText(String string, Color color, float f2, boolean bl) {
        }

        public boolean isSystemCenter() {
            return this.getContainingLocation() instanceof StarSystemAPI && ((StarSystemAPI)this.getContainingLocation()).getCenter() == this;
        }

        public StarSystemAPI getStarSystem() {
            if (this.getContainingLocation() instanceof StarSystemAPI) {
                return (StarSystemAPI)this.getContainingLocation();
            }
            return null;
        }

        public void clearFloatingText() {
        }

        public void setLocation(float f2, float f3) {
            this.loc.set(f2, f3);
        }

        public void autoUpdateHyperLocationBasedOnInSystemEntityAtRadius(SectorEntityToken sectorEntityToken, float f2) {
        }

        public void forceSensorContactFaderBrightness(float f2) {
        }

        public void forceSensorFaderOut() {
        }

        public void setLightSource(SectorEntityToken sectorEntityToken, Color color) {
        }

        public List<EveryFrameScript> getScripts() {
            return new ArrayList<EveryFrameScript>();
        }

        public float getExtendedDetectedAtRange() {
            return 0.0f;
        }

        public void setExtendedDetectedAtRange(Float f2) {
        }

        public void setRadius(float f2) {
        }

        public void fadeOutIndicator() {
        }

        public void fadeInIndicator() {
        }

        public void forceOutIndicator() {
        }

        public void setOrbitFocus(SectorEntityToken sectorEntityToken) {
        }
    }
}

