/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.graphics.util.OoOO;
import com.fs.starfarer.D;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.characters.RelationshipAPI;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;

public class Relationship
implements RelationshipAPI,
DoNotObfuscate {
    private static final float REP_EPSILON = 0.01f;
    private float rel = 0.0f;
    private RelationshipAPI.RelationshipTarget target;

    public Relationship(RelationshipAPI.RelationshipTarget relationshipTarget) {
        this.target = relationshipTarget;
    }

    public RelationshipAPI.RelationshipTarget getTarget() {
        return this.target;
    }

    public void setTarget(RelationshipAPI.RelationshipTarget relationshipTarget) {
        this.target = relationshipTarget;
    }

    public float getRel() {
        return this.rel;
    }

    public void setRel(float f2) {
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f2 < -1.0f) {
            f2 = -1.0f;
        }
        this.rel = f2;
    }

    public int getRepInt() {
        return RepLevel.getRepInt((float)this.getRel());
    }

    public RepLevel getLevel() {
        return RepLevel.getLevelFor((float)this.rel);
    }

    public boolean isAtWorst(RepLevel repLevel) {
        return this.getLevel().isAtWorst(repLevel);
    }

    public boolean isAtBest(RepLevel repLevel) {
        return this.getLevel().isAtBest(repLevel);
    }

    public void setLevel(RepLevel repLevel) {
        if (repLevel == RepLevel.NEUTRAL) {
            this.setRel(0.0f);
        } else if (repLevel.isPositive()) {
            this.setRel(repLevel.getMin() + 0.01f);
        } else {
            this.setRel(-repLevel.getMin() - 0.01f);
        }
    }

    public boolean adjustRelationship(float f2, RepLevel repLevel) {
        if (f2 == 0.0f) {
            return false;
        }
        float f3 = this.rel;
        float f4 = f3 + f2;
        if (f2 > 0.0f) {
            if (repLevel == null) {
                repLevel = RepLevel.COOPERATIVE;
            }
            float f5 = repLevel.getMax();
            if (repLevel.isNegative()) {
                f5 = -repLevel.getMin() - 0.01f;
            }
            if ((f4 = Math.min(f4, f5)) > f3) {
                this.setRel(f4);
                return true;
            }
        } else if (f2 < 0.0f) {
            if (repLevel == null) {
                repLevel = RepLevel.VENGEFUL;
            }
            float f6 = -repLevel.getMax();
            if (repLevel.isPositive()) {
                f6 = repLevel.getMin() + 0.01f;
            }
            if ((f4 = Math.max(f4, f6)) < f3) {
                this.setRel(f4);
                return true;
            }
        }
        return false;
    }

    public boolean ensureAtBest(RepLevel repLevel) {
        RepLevel repLevel2 = this.getLevel();
        if (!repLevel2.isAtBest(repLevel)) {
            this.setLevel(repLevel);
            return true;
        }
        return false;
    }

    public boolean ensureAtWorst(RepLevel repLevel) {
        RepLevel repLevel2 = this.getLevel();
        if (!repLevel2.isAtWorst(repLevel)) {
            this.setLevel(repLevel);
            return true;
        }
        return false;
    }

    public boolean isHostile() {
        return this.isAtBest(RepLevel.HOSTILE);
    }

    public Color getRelColor() {
        Color color = new Color(125, 125, 125, 255);
        if (this.rel > 0.0f) {
            color = OoOO.o00000((Color)color, (Color)D.\u00f5o0000, (float)Math.max(0.15f, this.rel));
        } else if (this.rel < 0.0f) {
            color = OoOO.o00000((Color)color, (Color)D.while.new, (float)Math.max(0.15f, -this.rel));
        }
        return color;
    }

    public Color getRelColor(RepLevel repLevel) {
        Color color = new Color(125, 125, 125, 255);
        float f2 = repLevel.getMax();
        if (repLevel.isNegative()) {
            f2 = -f2;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (f2 < -1.0f) {
            f2 = -1.0f;
        }
        if (f2 > 0.0f) {
            color = OoOO.o00000((Color)color, (Color)D.\u00f5o0000, (float)Math.max(0.15f, f2));
        } else if (f2 < 0.0f) {
            color = OoOO.o00000((Color)color, (Color)D.while.new, (float)Math.max(0.15f, -f2));
        }
        return color;
    }
}

