/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.ai;

import com.fs.starfarer.api.loading.FormationType;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.prototype.Utils;
import com.fs.util.DoNotObfuscate;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class FighterWingFormation
implements DoNotObfuscate {
    private FormationType type;

    public FighterWingFormation(FormationType formationType) {
        this.type = formationType;
    }

    public FighterWingFormation() {
    }

    public void setType(FormationType formationType) {
        this.type = formationType;
    }

    public Vector2f getLocationInFormation(Ship ship, int n2) {
        return this.getFormationLocation(ship, n2);
    }

    public Vector2f getLocationInEscort(Ship ship, Ship ship2, int n2) {
        return this.getEscortLocation(ship, ship2, n2);
    }

    private Vector2f getEscortLocation(Ship ship, Ship ship2, int n2) {
        float f2 = ship.getFacing();
        float f3 = ship.getCollisionRadius() * 1.0f;
        float f4 = ship2.getCollisionRadius() * 4.0f;
        return this.getFormationOffset(ship.getLocation(), f2, f3, f4, ++n2);
    }

    private Vector2f getFormationLocation(Ship ship, int n2) {
        float f2 = Utils.\u00d300000(ship.getVelocity());
        if (ship.getVelocity().length() <= 1.0f || ship.getWing() != null && ship.getWing().getSpec().isBomber()) {
            f2 = ship.getFacing();
        }
        float f3 = ship.getCollisionRadius() * 4.0f;
        return this.getFormationOffset(ship.getLocation(), f2, f3, f3, n2);
    }

    private Vector2f getOffsetLoc(Vector2f vector2f, float f2, float f3, float f4) {
        Vector2f vector2f2 = new Vector2f((ReadableVector2f)vector2f);
        float f5 = (float)Math.toRadians(f2);
        float f6 = (float)Math.sin(f5);
        float f7 = (float)Math.cos(f5);
        vector2f2.x += f3 * f7 - f4 * f6;
        vector2f2.y += f3 * f6 + f4 * f7;
        return vector2f2;
    }

    public Vector2f getFormationOffset(Vector2f vector2f, float f2, float f3, float f4, int n2) {
        if (this.type == FormationType.DIAMOND) {
            f4 /= 1.41f;
            switch (n2) {
                case 0: {
                    return vector2f;
                }
                case 1: {
                    return this.getOffsetLoc(vector2f, f2, -f4, f4);
                }
                case 2: {
                    return this.getOffsetLoc(vector2f, f2, -f4, -f4);
                }
                case 3: {
                    return this.getOffsetLoc(vector2f, f2, -f4 * 2.0f, 0.0f);
                }
                case 4: {
                    return this.getOffsetLoc(vector2f, f2, -f4 * 2.0f, f4 * 2.0f);
                }
                case 5: {
                    return this.getOffsetLoc(vector2f, f2, -f4 * 2.0f, -f4 * 2.0f);
                }
                case 6: {
                    return this.getOffsetLoc(vector2f, f2, -f4 * 3.0f, f4 * 1.0f);
                }
                case 7: {
                    return this.getOffsetLoc(vector2f, f2, -f4 * 3.0f, -f4 * 1.0f);
                }
                case 8: {
                    return this.getOffsetLoc(vector2f, f2, -f4 * 4.0f, 0.0f);
                }
            }
            return vector2f;
        }
        if (this.type == FormationType.BOX) {
            switch (n2) {
                case 0: {
                    return vector2f;
                }
                case 1: {
                    return this.getOffsetLoc(vector2f, f2, 0.0f, -f4);
                }
                case 2: {
                    return this.getOffsetLoc(vector2f, f2, -f4, 0.0f);
                }
                case 3: {
                    return this.getOffsetLoc(vector2f, f2, -f4, -f4);
                }
                case 4: {
                    return this.getOffsetLoc(vector2f, f2, 0.0f, -f4 * 2.0f);
                }
                case 5: {
                    return this.getOffsetLoc(vector2f, f2, -f4, -f4 * 2.0f);
                }
                case 6: {
                    return this.getOffsetLoc(vector2f, f2, -f4 * 2.0f, -f4 * 0.0f);
                }
                case 7: {
                    return this.getOffsetLoc(vector2f, f2, -f4 * 2.0f, -f4 * 1.0f);
                }
                case 8: {
                    return this.getOffsetLoc(vector2f, f2, -f4 * 2.0f, -f4 * 2.0f);
                }
                case 9: {
                    return this.getOffsetLoc(vector2f, f2, 0.0f, -f4 * 3.0f);
                }
                case 10: {
                    return this.getOffsetLoc(vector2f, f2, -f4 * 1.0f, -f4 * 3.0f);
                }
                case 11: {
                    return this.getOffsetLoc(vector2f, f2, -f4 * 2.0f, -f4 * 3.0f);
                }
            }
            return vector2f;
        }
        if (this.type == FormationType.V) {
            float f5;
            float f6;
            float f7;
            float f8 = 0.0f;
            if (n2 > 0) {
                f8 += f3;
            }
            Vector2f vector2f2 = new Vector2f((ReadableVector2f)vector2f);
            if (f3 > f4) {
                f7 = (float)Math.toRadians(f2 + (float)(n2 % 2 == 1 ? 90 : -90));
                f6 = (float)Math.sin(f7);
                f5 = (float)Math.cos(f7);
                vector2f2.x += f5 * f8;
                vector2f2.y += f6 * f8;
                f8 = 0.0f;
            }
            f7 = (float)Math.toRadians(f2 + (float)(n2 % 2 == 1 ? 130 : -130));
            n2 = (n2 + 1) / 2;
            float f9 = n2 > 0 ? (float)n2 - 1.0f : 0.0f;
            f6 = (float)Math.sin(f7);
            f5 = (float)Math.cos(f7);
            vector2f2.x += f5 * (f8 += f9 * f4);
            vector2f2.y += f6 * f8;
            return vector2f2;
        }
        if (this.type == FormationType.CLAW) {
            float f10;
            float f11;
            float f12;
            Vector2f vector2f3 = new Vector2f((ReadableVector2f)vector2f);
            float f13 = 0.0f;
            if (n2 > 0) {
                f13 += f3;
            }
            float f14 = n2 % 2 == 1 ? 1 : -1;
            if (f3 > f4) {
                f12 = (float)Math.toRadians(f2 + f14 * 90.0f);
                f11 = (float)Math.sin(f12);
                f10 = (float)Math.cos(f12);
                vector2f3.x += f10 * f13;
                vector2f3.y += f11 * f13;
                f13 = 0.0f;
            }
            n2 = (n2 + 1) / 2;
            f12 = (float)Math.toRadians(f2 + 90.0f * f14 - (float)n2 * f14 * 15.0f);
            float f15 = n2 > 0 ? (float)n2 - 1.0f : 0.0f;
            f11 = (float)Math.sin(f12);
            f10 = (float)Math.cos(f12);
            vector2f3.x += f10 * (f13 += f15 * f4);
            vector2f3.y += f11 * f13;
            return vector2f3;
        }
        return vector2f;
    }
}

