/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.util;

import com.fs.util.DoNotObfuscate;

public class IntervalTracker
implements DoNotObfuscate {
    private float minInterval;
    private float maxInterval;
    private float currInterval;
    private float elapsed = 0.0f;
    private boolean intervalElapsed = false;

    public IntervalTracker(float f2, float f3) {
        this.setInterval(f2, f3);
    }

    public void forceCurrInterval(float f2) {
        this.currInterval = f2;
    }

    public void randomize() {
        this.advance((float)Math.random() * this.minInterval);
    }

    public void forceIntervalElapsed() {
        this.elapsed = this.currInterval;
    }

    private void nextInterval() {
        this.currInterval = this.minInterval + (this.maxInterval - this.minInterval) * (float)Math.random();
        this.elapsed = 0.0f;
        this.intervalElapsed = false;
    }

    public void advance(float f2) {
        if (this.intervalElapsed) {
            this.nextInterval();
        }
        this.elapsed += f2;
        if (this.elapsed >= this.currInterval) {
            this.intervalElapsed = true;
        }
    }

    public boolean intervalElapsed() {
        return this.intervalElapsed;
    }

    public float getIntervalDuration() {
        return this.currInterval;
    }

    public void setInterval(float f2, float f3) {
        this.minInterval = f2;
        this.maxInterval = f3;
        this.nextInterval();
    }

    public void setRemaining(float f2) {
        this.currInterval = f2;
        this.elapsed = 0.0f;
    }

    public float getRemaining() {
        return Math.max(0.0f, this.currInterval - this.elapsed);
    }
}

