/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.GenericFieldItemSprite;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class GenericFieldItemManager {
    protected transient List<GenericFieldItemSprite> items;
    protected transient boolean inited = false;
    protected SectorEntityToken entity;
    public int numPieces;
    public int cellSize;
    public float minSize;
    public float maxSize;
    public String category;
    public String key;

    public GenericFieldItemManager(SectorEntityToken entity) {
        this.entity = entity;
    }

    Object readResolve() {
        return this;
    }

    public void advance(float amount) {
        if (amount <= 0.0f) {
            return;
        }
        if (!this.entity.isInCurrentLocation()) {
            this.items = null;
            this.inited = false;
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.initDebrisIfNeeded();
        ArrayList<GenericFieldItemSprite> remove = new ArrayList<GenericFieldItemSprite>();
        for (GenericFieldItemSprite item : this.items) {
            item.advance(days);
            if (!item.isDone()) continue;
            remove.add(item);
        }
        this.items.removeAll(remove);
        this.addPiecesToMax();
    }

    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        float alphaMult = viewport.getAlphaMult();
        alphaMult *= this.entity.getSensorFaderBrightness();
        if ((alphaMult *= this.entity.getSensorContactFaderBrightness()) <= 0.0f) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.entity.getLocation().x, (float)this.entity.getLocation().y, (float)0.0f);
        this.initDebrisIfNeeded();
        for (GenericFieldItemSprite item : this.items) {
            item.render(alphaMult);
        }
        GL11.glPopMatrix();
    }

    protected void addPiecesToMax() {
        while (this.items.size() < this.numPieces) {
            float size = this.minSize + (this.maxSize - this.minSize) * (float)Math.random();
            GenericFieldItemSprite item = new GenericFieldItemSprite(this.entity, this.category, this.key, this.cellSize, size, this.entity.getRadius() * 0.75f);
            this.items.add(item);
        }
    }

    protected void initDebrisIfNeeded() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.items = new ArrayList<GenericFieldItemSprite>();
        this.addPiecesToMax();
        for (GenericFieldItemSprite piece : this.items) {
            piece.advance(0.1f);
        }
    }
}

