/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.campaign.AsteroidAPI;
import com.fs.starfarer.api.campaign.CampaignEngineLayers;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.impl.campaign.BaseCustomEntityPlugin;
import com.fs.starfarer.api.util.Misc;

public class HiddenCacheEntityPlugin
extends BaseCustomEntityPlugin {
    private AsteroidAPI asteroid;

    @Override
    public void init(SectorEntityToken entity, Object pluginParams) {
        super.init(entity, pluginParams);
        this.readResolve();
    }

    Object readResolve() {
        return this;
    }

    protected void createAsteroidIfNeeded() {
        if (this.asteroid != null) {
            return;
        }
        if (this.entity.getContainingLocation() == null) {
            return;
        }
        this.asteroid = this.entity.getContainingLocation().addAsteroid(16.0f);
        this.asteroid.setLocation(this.entity.getLocation().x, this.entity.getLocation().y);
        this.asteroid.setFacing(Misc.random.nextFloat() * 360.0f);
        this.entity.getContainingLocation().removeEntity(this.asteroid);
    }

    @Override
    public void advance(float amount) {
        if (this.entity.isInCurrentLocation()) {
            this.createAsteroidIfNeeded();
            if (this.asteroid != null) {
                this.asteroid.advance(amount);
            }
        }
    }

    @Override
    public float getRenderRange() {
        return this.entity.getRadius() + 100.0f;
    }

    @Override
    public void render(CampaignEngineLayers layer, ViewportAPI viewport) {
        if (this.asteroid != null) {
            this.asteroid.setLocation(this.entity.getLocation().x, this.entity.getLocation().y);
            this.asteroid.setLightSource(this.entity.getLightSource(), this.entity.getLightColor());
            this.asteroid.forceRender();
        }
    }
}

