/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.impl.campaign.intel.BaseEventManager;
import com.fs.starfarer.api.impl.campaign.intel.FactionHostilityIntel;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import com.fs.starfarer.api.util.TimeoutTracker;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class FactionHostilityManager
extends BaseEventManager {
    public static final String KEY = "$core_factionHostilityManager";
    public static final float TIMEOUT_AFTER_ENDING = 30.0f;
    public static final float CHECK_DAYS = 10.0f;
    public static final float CHECK_PROB = 0.5f;
    protected Random random = new Random();
    protected TimeoutTracker<String> recentlyEnded = new TimeoutTracker();

    public static String getConflictId(FactionAPI a, FactionAPI b) {
        String id2;
        String id1 = a.getId();
        if (id1.compareTo(id2 = b.getId()) < 0) {
            return String.valueOf(id1) + "_" + id2;
        }
        return String.valueOf(id2) + "_" + id1;
    }

    public static FactionHostilityManager getInstance() {
        Object test = Global.getSector().getMemoryWithoutUpdate().get(KEY);
        return (FactionHostilityManager)test;
    }

    public FactionHostilityManager() {
        Global.getSector().getMemoryWithoutUpdate().set(KEY, this);
    }

    public boolean areHostilitiesOngoing(FactionAPI a, FactionAPI b) {
        FactionHostilityIntel intel = this.getHostilties(a, b);
        return intel != null && !intel.isEnding();
    }

    public FactionHostilityIntel getHostilties(FactionAPI a, FactionAPI b) {
        String id = FactionHostilityManager.getConflictId(a, b);
        for (EveryFrameScript s : this.getActive()) {
            FactionHostilityIntel intel = (FactionHostilityIntel)s;
            if (!intel.getId().equals(id)) continue;
            return intel;
        }
        return null;
    }

    public List<FactionHostilityIntel> getHostilitiesInvolving(FactionAPI faction) {
        ArrayList<FactionHostilityIntel> result = new ArrayList<FactionHostilityIntel>();
        for (EveryFrameScript s : this.getActive()) {
            FactionHostilityIntel intel = (FactionHostilityIntel)s;
            if (intel.getOne() != faction && intel.getTwo() != faction) continue;
            result.add(intel);
        }
        return result;
    }

    @Override
    protected int getMinConcurrent() {
        List<FactionAPI> factions = this.getEligibleFactions(true);
        float mult = Global.getSettings().getFloat("minFactionHostilitiesMult");
        return (int)Math.ceil((float)factions.size() * mult);
    }

    @Override
    protected int getMaxConcurrent() {
        List<FactionAPI> factions = this.getEligibleFactions(true);
        float mult = Global.getSettings().getFloat("maxFactionHostilitiesMult");
        return (int)Math.ceil((float)factions.size() * mult);
    }

    protected List<FactionAPI> getEligibleFactions(boolean checkNumMarkets) {
        List<FactionAPI> factions = Global.getSector().getAllFactions();
        ArrayList<FactionAPI> result = new ArrayList<FactionAPI>();
        int i = 0;
        while (i < factions.size()) {
            int count;
            FactionAPI faction = factions.get(i);
            if (!(!faction.getCustom().optBoolean("engagesInHostilities") || faction.isPlayerFaction() || checkNumMarkets && (count = Misc.getFactionMarkets(faction).size()) <= 0)) {
                result.add(faction);
            }
            ++i;
        }
        return result;
    }

    @Override
    protected float getBaseInterval() {
        return 10.0f;
    }

    public void startHostilities(String a, String b) {
        this.startHostilities(Global.getSector().getFaction(a), Global.getSector().getFaction(b));
    }

    public void startHostilities(FactionAPI a, FactionAPI b) {
        if (this.areHostilitiesOngoing(a, b)) {
            return;
        }
        FactionHostilityIntel intel = new FactionHostilityIntel(a, b);
        this.addActive(intel);
    }

    @Override
    protected EveryFrameScript createEvent() {
        if (this.random.nextFloat() < 0.5f) {
            return null;
        }
        Pair<FactionAPI, FactionAPI> pick = this.pickFactions();
        if (pick == null) {
            return null;
        }
        FactionHostilityIntel intel = new FactionHostilityIntel((FactionAPI)pick.one, (FactionAPI)pick.two);
        return intel;
    }

    public void notifyRecentlyEnded(String id) {
        this.recentlyEnded.add(id, 30.0f);
    }

    public TimeoutTracker<String> getRecentlyEnded() {
        return this.recentlyEnded;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        float days = Global.getSector().getClock().convertToDays(amount);
        this.recentlyEnded.advance(days);
    }

    protected Pair<FactionAPI, FactionAPI> pickFactions() {
        ArrayList<FactionAPI> factions = new ArrayList<FactionAPI>();
        HashMap<FactionAPI, Integer> marketCounts = new HashMap<FactionAPI, Integer>();
        for (FactionAPI faction : this.getEligibleFactions(false)) {
            int count = Misc.getFactionMarkets(faction).size();
            if (count <= 0) continue;
            marketCounts.put(faction, count);
            factions.add(faction);
        }
        WeightedRandomPicker<FactionAPI> picker = new WeightedRandomPicker<FactionAPI>(this.random);
        boolean weighCommissionedMore = false;
        FactionAPI commission = Misc.getCommissionFaction();
        if (commission != null && this.getHostilitiesInvolving(commission).isEmpty()) {
            weighCommissionedMore = true;
        }
        for (FactionAPI faction : factions) {
            float w = 1.0f;
            if (commission == faction && weighCommissionedMore) {
                w = factions.size();
            }
            picker.add(faction, w);
        }
        FactionAPI one = (FactionAPI)picker.pick();
        if (one == null) {
            return null;
        }
        picker.clear();
        for (FactionAPI faction : factions) {
            String id;
            if (faction == one || faction.isHostileTo(one) || faction.isAtWorst(one, RepLevel.COOPERATIVE) || this.recentlyEnded.contains(id = FactionHostilityManager.getConflictId(one, faction))) continue;
            float w = ((Integer)marketCounts.get(faction)).intValue();
            picker.add(faction, w);
        }
        FactionAPI two = (FactionAPI)picker.pick();
        if (two == null) {
            return null;
        }
        return new Pair<FactionAPI, FactionAPI>(one, two);
    }
}

