/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.enc.SlipstreamPirateEPEC;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetRouteManager;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityCause2;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.PirateHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.rulecmd.HA_CMD;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.MapParams;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.ui.UIPanelAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Range;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class PirateBasePirateActivityCause2
extends BaseHostileActivityCause2 {
    public static boolean DEAL_PROVIDES_NEGATIVE_PROGRESS = false;
    public static float MAX_MAG = 0.5f;
    transient boolean ignoreDeal = false;

    public static List<MarketAPI> getColoniesAffectedBy(PirateBaseIntel base) {
        ArrayList<MarketAPI> result = new ArrayList<MarketAPI>();
        for (StarSystemAPI system : PirateBasePirateActivityCause2.getSystemsAffectedBy(base)) {
            result.addAll(Misc.getMarketsInLocation(system, "player"));
        }
        return result;
    }

    public static List<StarSystemAPI> getSystemsAffectedBy(PirateBaseIntel base) {
        ArrayList<StarSystemAPI> result = new ArrayList<StarSystemAPI>();
        for (StarSystemAPI system : Misc.getSystemsWithPlayerColonies(false)) {
            if (PirateBasePirateActivityCause2.getBaseIntel(system) != base) continue;
            result.add(system);
        }
        return result;
    }

    public static PirateBaseIntel getBaseIntel(StarSystemAPI system) {
        if (system == null) {
            return null;
        }
        PirateBaseIntel base = SlipstreamPirateEPEC.getClosestPirateBase(system.getLocation());
        return base;
    }

    public PirateBasePirateActivityCause2(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public void addExtraRows(TooltipMakerAPI info, BaseEventIntel intel) {
        LinkedHashSet<PirateBaseIntel> seen = new LinkedHashSet<PirateBaseIntel>();
        for (StarSystemAPI system : Misc.getSystemsWithPlayerColonies(false)) {
            final PirateBaseIntel base = PirateBasePirateActivityCause2.getBaseIntel(system);
            if (base == null || seen.contains(base)) continue;
            int numColonies = 0;
            final ArrayList<String> affected = new ArrayList<String>();
            for (StarSystemAPI curr : PirateBasePirateActivityCause2.getSystemsAffectedBy(base)) {
                affected.add(curr.getNameWithNoType());
                numColonies += Misc.getMarketsInLocation(curr, "player").size();
            }
            if (affected.isEmpty()) continue;
            seen.add(base);
            final String colonies = numColonies != 1 ? "colonies" : "colony";
            final String isOrAre = numColonies != 1 ? "are" : "is";
            String desc = "Hidden pirate base near your " + colonies;
            if (base.isPlayerVisible()) {
                desc = "Pirate base in the " + base.getSystem().getNameWithLowercaseTypeShort();
            }
            this.ignoreDeal = true;
            final int progress = this.getProgressForBase(base);
            this.ignoreDeal = false;
            String progressStr = "+" + progress;
            if (progress < 0) {
                progressStr = "" + progress;
            }
            Color descColor = this.getDescColor(intel);
            Color progressColor = this.getProgressColor(intel);
            if (base.playerHasDealWithBaseCommander()) {
                if (DEAL_PROVIDES_NEGATIVE_PROGRESS) {
                    int p = this.getProgressForBase(base);
                    progressStr = "+" + p;
                    if (p < 0) {
                        progressStr = "" + p;
                    }
                    descColor = Misc.getTextColor();
                } else {
                    progressStr = "---";
                    descColor = Misc.getGrayColor();
                }
                progressColor = Misc.getPositiveHighlightColor();
            } else if (DEAL_PROVIDES_NEGATIVE_PROGRESS) {
                descColor = Misc.getTextColor();
            }
            info.addRowWithGlow(new Object[]{Alignment.LMID, descColor, "    " + desc, Alignment.RMID, progressColor, progressStr});
            BaseFactorTooltip t = new BaseFactorTooltip(){

                @Override
                public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                    float opad = 10.0f;
                    String aStr = Misc.getAndJoined(affected);
                    String systems = "systems";
                    if (affected.size() == 1) {
                        systems = "system";
                    }
                    MapParams params = new MapParams();
                    for (StarSystemAPI curr : PirateBasePirateActivityCause2.getSystemsAffectedBy(base)) {
                        params.showSystem(curr);
                    }
                    if (base.playerHasDealWithBaseCommander() || base.isPlayerVisible()) {
                        params.showMarket(base.getMarket(), 1.0f);
                    }
                    float w = tooltip.getWidthSoFar();
                    float h = Math.round(w / 1.6f);
                    params.positionToShowAllMarkersAndSystems(true, Math.min(w, h));
                    UIPanelAPI map = tooltip.createSectorMap(w, h, params, String.valueOf(aStr) + " " + systems);
                    if (base.playerHasDealWithBaseCommander()) {
                        String systemStr = "in the " + base.getSystem().getNameWithLowercaseTypeShort();
                        tooltip.addPara("Your " + colonies + " in the " + aStr + " " + systems + " " + isOrAre + " within range of a pirate base located " + systemStr + ". " + "You have an agreement with " + "the base commander, and fleets from this base do not, as a rule, " + "harass your colonies or shipping.", 0.0f, Misc.getPositiveHighlightColor(), "agreement");
                        int payment = HA_CMD.computePirateProtectionPaymentPerMonth(base);
                        String extra = "";
                        if (DEAL_PROVIDES_NEGATIVE_PROGRESS) {
                            extra = " instead of providing a reduction in progress";
                        }
                        tooltip.addPara("Assuming current colony income levels, this agreement costs you %s per month. If it was not in effect, this base would contribute %s points of event progress per month" + extra + ".", opad, Misc.getHighlightColor(), Misc.getDGSCredits(payment), "" + progress);
                    } else {
                        String systemStr = "in a nearby system";
                        if (base.isPlayerVisible()) {
                            systemStr = "in the " + base.getSystem().getNameWithLowercaseTypeShort();
                        }
                        tooltip.addPara("Your " + colonies + " in the " + aStr + " " + systems + " " + isOrAre + " within range of a pirate base located " + systemStr + ". " + "This results in a greater volume of pirate " + "fleets preying on trade. %s should address this.", 0.0f, Misc.getHighlightColor(), "Dealing with the base");
                    }
                    tooltip.addCustom(map, opad);
                }
            };
            info.addTooltipToAddedRow(t, TooltipMakerAPI.TooltipLocation.RIGHT, false);
        }
    }

    public boolean playerHasDealWithAnyBases() {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            PirateBaseIntel curr = (PirateBaseIntel)intel;
            if (!curr.playerHasDealWithBaseCommander()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldShow() {
        return this.getProgress() != 0 || this.playerHasDealWithAnyBases();
    }

    @Override
    public int getProgress() {
        if (PirateHostileActivityFactor.isDefeatedLargePirateRaid()) {
            return 0;
        }
        int total = 0;
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            PirateBaseIntel curr = (PirateBaseIntel)intel;
            total += this.getProgressForBase(curr);
        }
        return total;
    }

    protected int getProgressForBase(PirateBaseIntel base) {
        if (!DEAL_PROVIDES_NEGATIVE_PROGRESS && !this.ignoreDeal && base.playerHasDealWithBaseCommander()) {
            return 0;
        }
        boolean ignore = this.ignoreDeal;
        if (!ignore && DEAL_PROVIDES_NEGATIVE_PROGRESS) {
            this.ignoreDeal = true;
        }
        int total = 0;
        for (StarSystemAPI system : PirateBasePirateActivityCause2.getSystemsAffectedBy(base)) {
            total += this.getProgressForSystem(system);
        }
        if (!ignore && DEAL_PROVIDES_NEGATIVE_PROGRESS) {
            this.ignoreDeal = false;
        }
        if (DEAL_PROVIDES_NEGATIVE_PROGRESS && !this.ignoreDeal && base.playerHasDealWithBaseCommander()) {
            total *= -1;
        }
        return total;
    }

    protected int getProgressForSystem(StarSystemAPI system) {
        float mag = this.getMagnitudeContribution(system);
        if (mag <= 0.0f) {
            return 0;
        }
        if ((mag /= MAX_MAG) > 1.0f) {
            mag = 1.0f;
        }
        Range r = new Range("pirateBaseProximityPoints");
        return r.interpInt(mag);
    }

    @Override
    public String getDesc() {
        return null;
    }

    @Override
    public float getMagnitudeContribution(StarSystemAPI system) {
        if (EconomyFleetRouteManager.ENEMY_STRENGTH_CHECK_EXCLUDE_PIRATES) {
            return 0.0f;
        }
        List<MarketAPI> markets = Misc.getMarketsInLocation(system, "player");
        float maxSize = 0.0f;
        for (MarketAPI market : markets) {
            maxSize = Math.max(maxSize, (float)market.getSize());
        }
        PirateBaseIntel base = PirateBasePirateActivityCause2.getBaseIntel(system);
        float mag = SlipstreamPirateEPEC.getPirateBaseProximityFactor(base, system.getLocation());
        mag *= 0.5f;
        mag *= maxSize / 6.0f;
        if (base != null) {
            mag *= ((float)base.getTier().ordinal() + 1.0f) / 5.0f;
        }
        if (mag > MAX_MAG) {
            mag = MAX_MAG;
        }
        mag = (float)Math.round(mag * 100.0f) / 100.0f;
        if (base != null && base.playerHasDealWithBaseCommander() && !this.ignoreDeal) {
            mag = 0.0f;
        }
        return mag;
    }
}

