/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.events;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.econ.PiracyRespite;
import com.fs.starfarer.api.impl.campaign.intel.bases.PirateBaseIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseFactorTooltip;
import com.fs.starfarer.api.impl.campaign.intel.events.BaseHostileActivityFactor;
import com.fs.starfarer.api.impl.campaign.intel.events.HostileActivityEventIntel;
import com.fs.starfarer.api.impl.campaign.intel.events.PiracyRespiteScript;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.impl.campaign.missions.FleetCreatorMission;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.KantaCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class PirateHostileActivityFactor
extends BaseHostileActivityFactor
implements FleetGroupIntel.FGIEventListener {
    public static String RAID_KEY = "$PirateRaid_ref";
    public static String SMALL_RAID_KEY = "$SmallPirateRaid_ref";
    public static final String DEFEATED_LARGE_PIRATE_RAID = "$defeatedLargePirateRaid";

    public static boolean isDefeatedLargePirateRaid() {
        return Global.getSector().getPlayerMemoryWithoutUpdate().getBoolean(DEFEATED_LARGE_PIRATE_RAID);
    }

    public static void setDefeatedLargePirateRaid(boolean value) {
        Global.getSector().getPlayerMemoryWithoutUpdate().set(DEFEATED_LARGE_PIRATE_RAID, value);
    }

    public PirateHostileActivityFactor(HostileActivityEventIntel intel) {
        super(intel);
    }

    @Override
    public String getProgressStr(BaseEventIntel intel) {
        return "";
    }

    @Override
    public int getProgress(BaseEventIntel intel) {
        if (PiracyRespiteScript.get() != null) {
            return 0;
        }
        return super.getProgress(intel);
    }

    @Override
    public String getDesc(BaseEventIntel intel) {
        return "Pirate activity";
    }

    @Override
    public String getNameForThreatList(boolean first) {
        if (first) {
            return "Pirates";
        }
        return "Pirates";
    }

    @Override
    public Color getDescColor(BaseEventIntel intel) {
        if (this.getProgress(intel) <= 0) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("pirates").getBaseUIColor();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getMainRowTooltip(BaseEventIntel intel) {
        return new BaseFactorTooltip(){

            @Override
            public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                float opad = 10.0f;
                tooltip.addPara("Piracy follows interstellar civilization almost without exception.", 0.0f);
                if (KantaCMD.playerHasProtection()) {
                    tooltip.addPara("However, you have %s, which is enough dissuade most pirates from attacking your interests.", opad, Misc.getPositiveHighlightColor(), "Kanta's protection");
                } else if (KantaCMD.playerEverHadProtection()) {
                    tooltip.addPara("You've %s, and it's not the sort of thing you can do over.", opad, Misc.getNegativeHighlightColor(), "lost Kanta's protection");
                } else {
                    tooltip.addPara("Having %s, however, should be enough dissuade most pirates from attacking your interests.", opad, Misc.getHighlightColor(), "Kanta's protection");
                }
            }
        };
    }

    @Override
    public boolean shouldShow(BaseEventIntel intel) {
        return this.getProgress(intel) > 0 || KantaCMD.playerHasProtection();
    }

    @Override
    public Color getNameColorForThreatList() {
        return Global.getSector().getFaction("pirates").getBaseUIColor();
    }

    public Color getNameColor(float mag) {
        if (mag <= 0.0f) {
            return Misc.getGrayColor();
        }
        return Global.getSector().getFaction("pirates").getBaseUIColor();
    }

    @Override
    public int getMaxNumFleets(StarSystemAPI system) {
        if (this.getProgress(this.intel) <= 0) {
            return 1;
        }
        return super.getMaxNumFleets(system);
    }

    @Override
    public CampaignFleetAPI createFleet(StarSystemAPI system, Random random) {
        int minDiff;
        float f = 0.0f;
        if ((f += this.getEffectMagnitude(system)) > 1.0f) {
            f = 1.0f;
        }
        int difficulty = 0;
        difficulty += Math.round(f * 7.0f);
        float mult = 1.0f;
        if (this.getProgress(this.intel) <= 0) {
            mult = 0.5f;
        }
        if (difficulty < (minDiff = Math.round(this.intel.getMarketPresenceFactor(system) * 6.0f * mult))) {
            difficulty = minDiff;
        }
        FleetCreatorMission m = new FleetCreatorMission(random);
        m.beginFleet();
        Vector2f loc = system.getLocation();
        String factionId = "pirates";
        m.createStandardFleet(difficulty += random.nextInt(4), factionId, loc);
        m.triggerSetPirateFleet();
        m.triggerMakeLowRepImpact();
        CampaignFleetAPI fleet = m.createFleet();
        return fleet;
    }

    @Override
    public void addBulletPointForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Rumors of pirate raid", tc, initPad);
    }

    @Override
    public void addBulletPointForEventReset(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        info.addPara("Pirate raid averted", tc, initPad);
    }

    @Override
    public void addStageDescriptionForEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, TooltipMakerAPI info) {
        float small = 0.0f;
        float opad = 10.0f;
        small = 8.0f;
        info.addPara("There are rumors that a pirate raid targeting your colonies may be organized in the near future. If the raid is successful, the targeted colonies will suffer from reduced stability.", small, Misc.getNegativeHighlightColor(), "reduced stability");
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            if (PiracyRespite.NEW_MODE) {
                info.addPara("If the raid is defeated, your colonies will suffer less shipping disruptions from piracy for the foreseeable future.", opad, Misc.getPositiveHighlightColor(), "less shipping disruptions");
            } else if (PiracyRespiteScript.DURATION < 0.0f) {
                info.addPara("If the raid is defeated, your colonies will permanently gain increased accessibility.", opad, Misc.getPositiveHighlightColor(), "increased accessibility");
            } else {
                info.addPara("If the raid is defeated, your colonies will gain increased accessibility for several cycles.", opad, Misc.getPositiveHighlightColor(), "increased accessibility");
            }
        }
        stage.addResetReq(info, false, "crisis", -1, -1, opad);
        this.addBorder(info, Global.getSector().getFaction("pirates").getBaseUIColor());
    }

    @Override
    public String getEventStageIcon(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        return Global.getSector().getFaction("pirates").getCrest();
    }

    @Override
    public TooltipMakerAPI.TooltipCreator getStageTooltipImpl(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT || stage.id == HostileActivityEventIntel.Stage.MINOR_EVENT) {
            if (stage.id == HostileActivityEventIntel.Stage.MINOR_EVENT) {
                return new BaseFactorTooltip(){

                    @Override
                    public void createTooltip(TooltipMakerAPI tooltip, boolean expanded, Object tooltipParam) {
                        float opad = 10.0f;
                        tooltip.addTitle("Pirate raid");
                        tooltip.addPara("A pirate raid will be launched against one of your star systems.", opad);
                    }
                };
            }
            return this.getDefaultEventTooltip("Pirate raid", intel, stage);
        }
        return null;
    }

    @Override
    public float getEventFrequency(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        if (KantaCMD.playerHasProtection()) {
            return 0.0f;
        }
        if (PiracyRespiteScript.get() != null) {
            return 0.0f;
        }
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT || stage.id == HostileActivityEventIntel.Stage.MINOR_EVENT) {
            StarSystemAPI target = this.findRaidTarget(intel, stage);
            MarketAPI source = this.findRaidSource(intel, stage, target);
            if (target != null && source != null) {
                return 10.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public void rollEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        HostileActivityEventIntel.HAERandomEventData data = new HostileActivityEventIntel.HAERandomEventData(this, stage);
        stage.rollData = data;
        intel.sendUpdateIfPlayerHasIntel((Object)data, false);
    }

    @Override
    public boolean fireEvent(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        StarSystemAPI target = this.findRaidTarget(intel, stage);
        MarketAPI source = this.findRaidSource(intel, stage, target);
        if (source == null || target == null) {
            return false;
        }
        stage.rollData = null;
        return this.startRaid(source, target, stage, this.getRandomizedStageRandom(5));
    }

    public StarSystemAPI findRaidTarget(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage) {
        WeightedRandomPicker<StarSystemAPI> picker = new WeightedRandomPicker<StarSystemAPI>(this.getRandomizedStageRandom(3));
        for (StarSystemAPI system : Misc.getPlayerSystems(false)) {
            float mag = this.getEffectMagnitude(system);
            if (mag < 0.1f && stage.id != HostileActivityEventIntel.Stage.MINOR_EVENT) continue;
            picker.add(system, mag * mag);
        }
        return (StarSystemAPI)picker.pick();
    }

    public MarketAPI findRaidSource(HostileActivityEventIntel intel, BaseEventIntel.EventStageData stage, final StarSystemAPI target) {
        float dist;
        if (target == null) {
            return null;
        }
        ArrayList<MarketAPI> list = new ArrayList<MarketAPI>();
        float maxDist = Global.getSettings().getFloat("sectorWidth") * 0.5f;
        for (IntelInfoPlugin curr : Global.getSector().getIntelManager().getIntel(PirateBaseIntel.class)) {
            PirateBaseIntel base = (PirateBaseIntel)curr;
            if (base.playerHasDealWithBaseCommander() || (dist = Misc.getDistance(target.getLocation(), base.getMarket().getLocationInHyperspace())) > maxDist) continue;
            list.add(base.getMarket());
        }
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!"pirates".equals(market.getFaction().getId())) continue;
            for (MarketAPI other : Misc.getMarketsInLocation(market.getContainingLocation())) {
                float dist2;
                if (other == market || !other.getFaction().isHostileTo(market.getFaction()) || other.getSize() <= market.getSize() - 2 || (dist2 = Misc.getDistance(market.getPrimaryEntity().getLocation(), other.getPrimaryEntity().getLocation())) < 8000.0f) continue;
                list.add(market);
            }
        }
        Collections.sort(list, new Comparator<MarketAPI>(){

            @Override
            public int compare(MarketAPI m1, MarketAPI m2) {
                float d1 = Misc.getDistance(target.getLocation(), m1.getLocationInHyperspace());
                float d2 = Misc.getDistance(target.getLocation(), m2.getLocationInHyperspace());
                return (int)Math.signum(d1 - d2);
            }
        });
        WeightedRandomPicker<MarketAPI> picker = new WeightedRandomPicker<MarketAPI>(this.getRandomizedStageRandom());
        int i = 0;
        while (i < list.size() && i < 4) {
            MarketAPI market = (MarketAPI)list.get(i);
            dist = Misc.getDistance(target.getLocation(), market.getLocationInHyperspace());
            float w = 100000.0f / (dist * dist);
            picker.add(market, w);
            ++i;
        }
        return (MarketAPI)picker.pick();
    }

    public static void avertOrAbortRaid() {
        HostileActivityEventIntel intel;
        if (GenericRaidFGI.get(SMALL_RAID_KEY) != null) {
            GenericRaidFGI.get(SMALL_RAID_KEY).finish(false);
        }
        if (GenericRaidFGI.get(RAID_KEY) != null) {
            GenericRaidFGI.get(RAID_KEY).finish(false);
        }
        if ((intel = HostileActivityEventIntel.get()) == null) {
            return;
        }
        HostileActivityEventIntel.HAERandomEventData data = intel.getRollDataForEvent();
        if (data != null && data.factor instanceof PirateHostileActivityFactor) {
            intel.resetHA_EVENT();
        }
    }

    public boolean startRaid(MarketAPI source, StarSystemAPI target, BaseEventIntel.EventStageData stage, Random random) {
        GenericRaidFGI.GenericRaidParams params = new GenericRaidFGI.GenericRaidParams(new Random(random.nextLong()), true);
        params.factionId = source.getFactionId();
        params.source = source;
        params.prepDays = 7.0f + random.nextFloat() * 14.0f;
        params.payloadDays = 27.0f + 7.0f * random.nextFloat();
        params.raidParams.where = target;
        for (MarketAPI market : Misc.getMarketsInLocation(target)) {
            if (!market.getFaction().isHostileTo(source.getFaction()) && !market.getFaction().isPlayerFaction()) continue;
            params.raidParams.allowedTargets.add(market);
        }
        if (params.raidParams.allowedTargets.isEmpty()) {
            return false;
        }
        params.raidParams.allowNonHostileTargets = true;
        params.style = FleetCreatorMission.FleetStyle.STANDARD;
        if (stage.id == HostileActivityEventIntel.Stage.MINOR_EVENT) {
            params.fleetSizes.add(5);
            params.fleetSizes.add(3);
            params.memoryKey = SMALL_RAID_KEY;
        } else {
            params.memoryKey = RAID_KEY;
            float mag1 = this.getEffectMagnitude(target);
            if (mag1 > 1.0f) {
                mag1 = 1.0f;
            }
            float mag2 = this.intel.getMarketPresenceFactor(target);
            float totalDifficulty = (0.25f + mag1 * 0.25f + mag2 * 0.5f) * 100.0f;
            Random r = this.getRandomizedStageRandom(7);
            if (r.nextFloat() < 0.33f) {
                params.style = FleetCreatorMission.FleetStyle.QUANTITY;
            }
            while (totalDifficulty > 0.0f) {
                float min;
                float max = Math.min(10.0f, totalDifficulty * 0.5f);
                if (max < (min = Math.max(2.0f, max - 2.0f))) {
                    max = min;
                }
                int diff = Math.round(StarSystemGenerator.getNormalRandom(r, min, max));
                params.fleetSizes.add(diff);
                totalDifficulty -= (float)diff;
            }
        }
        PirateBaseIntel base = PirateBaseIntel.getIntelFor(source);
        if (base != null && Misc.isHiddenBase(source) && !base.isPlayerVisible()) {
            base.makeKnown();
            base.sendUpdateIfPlayerHasIntel(PirateBaseIntel.DISCOVERED_PARAM, false);
        }
        GenericRaidFGI raid = new GenericRaidFGI(params);
        if (stage.id == HostileActivityEventIntel.Stage.HA_EVENT) {
            raid.setListener(this);
        }
        Global.getSector().getIntelManager().addIntel(raid);
        return true;
    }

    @Override
    public void reportFGIAborted(FleetGroupIntel intel) {
        PirateHostileActivityFactor.setDefeatedLargePirateRaid(true);
        new PiracyRespiteScript();
    }

    public static void main(String[] args) {
        Random r = new Random();
        int[] counts = new int[11];
        int i = 0;
        while (i < 10000) {
            int x;
            int n = x = Math.round(PirateHostileActivityFactor.getNormalRandom(r, 7.0f, 10.0f));
            counts[n] = counts[n] + 1;
            ++i;
        }
        i = 0;
        while (i < counts.length) {
            System.out.println(String.valueOf(i) + ":\t" + counts[i]);
            ++i;
        }
    }

    public static float getNormalRandom(Random random, float min, float max) {
        double r = random.nextGaussian();
        r *= (double)0.2f;
        if ((r += 0.5) < 0.0) {
            r = 0.0;
        }
        if (r > 1.0) {
            r = 1.0;
        }
        return min + (float)r * (max - min);
    }
}

