/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.raid;

import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.inspection.HIAssembleStage;
import com.fs.starfarer.api.impl.campaign.intel.punitive.PEAssembleStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.BaseRaidStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class AssembleStage
extends BaseRaidStage {
    public static final String PREP_STAGE = "prep_stage";
    public static final String WAIT_STAGE = "wait_stage";
    protected List<MarketAPI> sources = new ArrayList<MarketAPI>();
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.2f);
    protected SectorEntityToken gatheringPoint;
    protected float spawnFP = 0.0f;
    protected float origSpawnFP = 0.0f;
    protected float minDays = 3.0f;
    protected int currSource = 0;
    protected String prevType = null;
    public static float FP_SMALL = 20.0f;
    public static float FP_MEDIUM = 45.0f;
    public static float FP_LARGE = 85.0f;

    public AssembleStage(RaidIntel raid, SectorEntityToken gatheringPoint) {
        super(raid);
        this.gatheringPoint = gatheringPoint;
        this.interval.forceIntervalElapsed();
    }

    public boolean isSourceKnown() {
        return true;
    }

    public void setSpawnFP(float spawnFP) {
        this.spawnFP = spawnFP;
        this.origSpawnFP = spawnFP;
    }

    public float getOrigSpawnFP() {
        return this.origSpawnFP;
    }

    public float getSpawnFP() {
        return this.spawnFP;
    }

    public void addSource(MarketAPI source) {
        this.sources.add(source);
    }

    public List<MarketAPI> getSources() {
        return this.sources;
    }

    @Override
    public void advance(float amount) {
        this.addRoutesAsNeeded(amount);
        this.minDays -= Misc.getDays(amount);
        super.advance(amount);
    }

    @Override
    protected void updateStatus() {
        if (this.spawnFP > 0.0f) {
            return;
        }
        if (this.minDays > 0.0f) {
            return;
        }
        this.abortIfNeededBasedOnFP(true);
        this.updateStatusBasedOnReaching(this.gatheringPoint, true);
    }

    protected float getFPSmall() {
        return FP_SMALL;
    }

    protected float getFPMedium() {
        return FP_MEDIUM;
    }

    protected float getFPLarge() {
        return FP_LARGE;
    }

    protected float getLargeSize(boolean limitToSpawnFP) {
        float mult = 1.0f;
        if (!this.getSources().isEmpty()) {
            MarketAPI source = this.getSources().get(0);
            FactionAPI.ShipPickMode mode = Misc.getShipPickMode(source);
            float base = source.getFaction().getApproximateMaxFPPerFleet(mode);
            float numShipsMult = source.getStats().getDynamic().getMod("combat_fleet_size_mult").computeEffective(0.0f);
            if (numShipsMult < 1.0f) {
                numShipsMult = 1.0f;
            }
            mult = 1.0f / numShipsMult;
            if (limitToSpawnFP) {
                return Math.min(this.spawnFP, base * mult);
            }
            return base * mult;
        }
        return 250.0f;
    }

    protected String pickNextType() {
        if (this.spawnFP >= this.getLargeSize(true) + this.getFPMedium()) {
            return "patrolLarge";
        }
        WeightedRandomPicker<String> picker = new WeightedRandomPicker<String>();
        if (!"patrolSmall".equals(this.prevType)) {
            picker.add("patrolSmall");
        }
        if (!"patrolMedium".equals(this.prevType) && this.spawnFP >= FP_MEDIUM) {
            picker.add("patrolMedium");
        }
        if (!"patrolLarge".equals(this.prevType) && this.spawnFP >= FP_LARGE) {
            picker.add("patrolLarge");
        }
        this.prevType = (String)picker.pick();
        if (this.prevType == null) {
            this.prevType = "patrolSmall";
        }
        return this.prevType;
    }

    protected float getFP(String type) {
        if (this.spawnFP >= this.getLargeSize(true) + this.getFPMedium()) {
            float fp = this.getLargeSize(true);
            this.spawnFP -= fp;
            return fp;
        }
        float base = this.getFPSmall();
        if ("patrolSmall".equals(type)) {
            base = this.getFPSmall();
        } else if ("patrolMedium".equals(type)) {
            base = this.getFPMedium();
        } else if ("patrolLarge".equals(type)) {
            base = this.getFPLarge();
        }
        base *= 1.0f + ((float)Math.random() - 0.5f) * 0.5f;
        if (base > this.spawnFP) {
            base = this.spawnFP;
        }
        this.spawnFP -= base;
        if (this.spawnFP < this.getFPSmall() * 0.5f) {
            base += this.spawnFP;
            this.spawnFP = 0.0f;
        }
        return base;
    }

    protected void addRoutesAsNeeded(float amount) {
        if (this.spawnFP <= 0.0f) {
            return;
        }
        float days = Misc.getDays(amount);
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        if (this.sources.isEmpty()) {
            this.status = RaidIntel.RaidStageStatus.FAILURE;
            return;
        }
        MarketAPI market = this.sources.get(this.currSource);
        if (!market.isInEconomy() || !market.getPrimaryEntity().isAlive()) {
            this.sources.remove(market);
            return;
        }
        ++this.currSource;
        this.currSource %= this.sources.size();
        RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData(market);
        String sid = this.intel.getRouteSourceId();
        RouteManager.RouteData route = RouteManager.getInstance().addRoute(sid, market, Misc.genRandomSeed(), extra, this.intel, null);
        extra.fleetType = this.pickNextType();
        float fp = this.getFP(extra.fleetType);
        extra.fp = Float.valueOf(fp);
        extra.strength = Float.valueOf(Misc.getAdjustedStrength(fp, market));
        float prepDays = 3.0f + 3.0f * (float)Math.random();
        float travelDays = RouteLocationCalculator.getTravelDays(market.getPrimaryEntity(), this.gatheringPoint);
        if (DebugFlags.RAID_DEBUG || DebugFlags.FAST_RAIDS || this instanceof PEAssembleStage && DebugFlags.PUNITIVE_EXPEDITION_DEBUG || this instanceof HIAssembleStage && DebugFlags.HEGEMONY_INSPECTION_DEBUG) {
            prepDays *= 0.1f;
            travelDays *= 0.1f;
        }
        route.addSegment(new RouteManager.RouteSegment(prepDays, market.getPrimaryEntity(), PREP_STAGE));
        route.addSegment(new RouteManager.RouteSegment(travelDays, market.getPrimaryEntity(), this.gatheringPoint));
        route.addSegment(new RouteManager.RouteSegment(1000.0f, this.gatheringPoint, WAIT_STAGE));
        this.maxDays = Math.max(this.maxDays, prepDays + travelDays);
    }

    @Override
    public void showStageInfo(TooltipMakerAPI info) {
        int curr = this.intel.getCurrentStage();
        int index = this.intel.getStageIndex(this);
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        if (this.status == RaidIntel.RaidStageStatus.FAILURE) {
            info.addPara("The raiding forces have failed to successfully assemble at the rendezvous point. The raid is now over.", opad);
        } else if (curr == index) {
            if (this.isSourceKnown()) {
                info.addPara("The raid is currently assembling in the " + this.gatheringPoint.getContainingLocation().getNameWithLowercaseType() + ".", opad);
            } else {
                info.addPara("The raid is currently assembling at an unknown location.", opad);
            }
        }
    }
}

