/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.impl.campaign.world.NamelessRock;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class GADetectHyperspaceOddity
extends GABaseMission {
    protected StarSystemAPI arraySystem;
    protected StarSystemAPI oneslaughtSystem;
    protected SectorEntityToken array;
    protected SectorEntityToken oneslaught;
    protected PersonAPI elek;
    protected int rewardAmount;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaDHO_ref", "$gaDHO_inProgress")) {
            return false;
        }
        this.elek = this.getImportantPerson(People.ELEK);
        if (this.elek == null) {
            return false;
        }
        this.array = (SectorEntityToken)Global.getSector().getPersistentData().get(NamelessRock.ONESLAUGHT_SENSOR_ARRAY);
        if (this.array == null) {
            return false;
        }
        this.oneslaughtSystem = Global.getSector().getStarSystem(NamelessRock.NAMELESS_ROCK_LOCATION_ID);
        if (this.oneslaughtSystem == null) {
            return false;
        }
        for (SectorEntityToken entity : this.oneslaughtSystem.getAllEntities()) {
            if (!entity.getMemoryWithoutUpdate().contains("$onslaughtMkI")) continue;
            this.oneslaught = entity;
            break;
        }
        if (this.oneslaught == null) {
            return false;
        }
        this.arraySystem = this.array.getStarSystem();
        if (this.arraySystem == null) {
            return false;
        }
        this.setStartingStage((Object)Stage.VISIT_ELEK);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.addFailureStages(new Object[]{Stage.FAILED});
        this.setStageOnGlobalFlag((Object)Stage.FAILED, "$gaDHO_declinedTwice");
        this.setStageOnGlobalFlag((Object)Stage.GO_TO_ARRAY, "$gaDHO_gotScanPackage");
        this.setStageOnGlobalFlag((Object)Stage.GO_TO_LOCATION, "$gaDHO_gotCoordinates");
        this.setStageOnGlobalFlag((Object)Stage.INVESTIGATE_SHIP, "$gaDHO_foundRock");
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_ELEK, "$gaDHO_foundOneslaught");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaDHO_completed");
        this.setStageOnGlobalFlag((Object)Stage.ARRAY_THEN_ELEK, "$gaDHO_arrayFirstThenElek");
        this.setStageOnGlobalFlag((Object)Stage.ARRAY_THEN_ABYSS, "$gaDHO_arrayFirstThenAbyss");
        this.setStageOnGlobalFlag((Object)Stage.ABYSS_NO_ELEK, "$gaDHO_playerMadeElekMad");
        this.makeImportant(this.elek, "$gaDHO_answerInvite", Stage.VISIT_ELEK);
        this.makeImportant(this.array, "$gaDHO_object", Stage.GO_TO_ARRAY);
        this.makeImportant(this.oneslaughtSystem.getEntityById("nameless_rock"), null, Stage.GO_TO_LOCATION);
        this.makeImportant(this.oneslaughtSystem.getEntityById("nameless_rock"), null, Stage.ARRAY_THEN_ABYSS);
        this.makeImportant(this.oneslaughtSystem.getEntityById("nameless_rock"), null, Stage.ABYSS_NO_ELEK);
        this.makeImportant(this.elek, "$gaDHO_elekReturn", Stage.RETURN_TO_ELEK);
        this.makeImportant(this.elek, "$gaDHO_elekReturn", Stage.ARRAY_THEN_ELEK);
        this.makeImportant(this.oneslaught, null, Stage.INVESTIGATE_SHIP);
        this.setMapMarkerNameColorBasedOnStar(this.arraySystem);
        this.setStoryMission();
        this.setStartingStage((Object)Stage.VISIT_ELEK);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.beginStageTrigger(new Object[]{Stage.VISIT_ELEK});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.MEDIUM, HubMissionWithTriggers.FleetQuality.HIGHER, "pirates", "patrolMedium", this.array.getStarSystem());
        this.triggerPickLocationAtClosestToPlayerJumpPoint(this.array.getStarSystem());
        this.triggerSpawnFleetAtPickedLocation("$gaDHO_arrayFleet", null);
        this.triggerOrderFleetPatrol(false, this.array);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$gaDHO_missionCompleted", true);
        this.endTrigger();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaDHO_stage", this.getCurrentStage());
        this.set("$gaDHO_starName", this.arraySystem.getNameWithNoType());
        this.set("$gaDHO_systemName", this.arraySystem.getNameWithLowercaseTypeShort());
        this.set("$gaDHO_dist", this.getDistanceLY(this.array));
        this.set("$gaDHO_reward", Misc.getWithDGS(this.rewardAmount));
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.VISIT_ELEK) {
            if (Global.getSector().getMemoryWithoutUpdate().contains("$gaDHO_foundArrayFirst")) {
                info.addPara("Talk to Academician " + this.elek.getNameString() + " about the sensor array data.", opad);
                info.addPara("Or go directly to the coordinates held in the array's data.", opad);
                info.addImage(this.elek.getPortraitSprite(), width, 128.0f, opad);
            } else {
                info.addPara("Talk to Academician " + this.elek.getNameString() + " about the services he requires. " + "He is at the Galatia Academy, which orbits Pontus in the Galatia system.", opad);
                info.addImage(this.elek.getPortraitSprite(), width, 128.0f, opad);
            }
        } else if (this.currentStage == Stage.GO_TO_ARRAY) {
            info.addPara("Install the modification package on the Sensor Array located in the " + this.arraySystem.getNameWithLowercaseTypeShort() + ".", opad);
            info.addImage(Global.getSettings().getSpriteName("illustrations", "sensor_array"), width, opad);
        } else if (this.currentStage == Stage.GO_TO_LOCATION) {
            info.addPara("Go to the location deep in the Abyss to find what Academician Elek's patron was looking for.", opad);
        } else if (this.currentStage == Stage.ARRAY_THEN_ABYSS) {
            info.addPara("Go to the location deep in the Abyss to find out what the sensor array detected.", opad);
        } else if (this.currentStage == Stage.ABYSS_NO_ELEK) {
            info.addPara("Go to the location deep in the Abyss to find out what the sensor array detected.", opad);
        } else if (this.currentStage == Stage.ARRAY_THEN_ELEK) {
            info.addPara("Talk to Academician " + this.elek.getNameString() + " about what his sensor array modifications were looking for. " + "He is at the Galatia Academy, which orbits Pontus in the Galatia system.", opad);
            info.addImage(this.elek.getPortraitSprite(), width, 128.0f, opad);
        } else if (this.currentStage == Stage.INVESTIGATE_SHIP) {
            info.addPara("Investigate the strange ship orbiting Nameless Rock.", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ELEK) {
            if (Global.getSector().getMemoryWithoutUpdate().contains("$gaDHO_arrayFirstThenAbyss")) {
                info.addPara("Talk to Academician " + this.elek.getNameString() + " about what he thought he was looking for.", opad);
                info.addPara("And maybe some kind of reward.", opad);
            } else {
                info.addPara("Talk to Academician " + this.elek.getNameString() + " about a reward. And about his 'patron'.", opad);
            }
            info.addImage(this.elek.getPortraitSprite(), width, 128.0f, opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.VISIT_ELEK) {
            if (Global.getSector().getMemoryWithoutUpdate().contains("$gaDHO_foundArrayFirst")) {
                info.addPara("Talk to Academician " + this.elek.getNameString() + " at the Galatia Academy about the sensor array data.", tc, pad);
                info.addPara("Or go directly to the coordinates extracted from the array's data", tc, pad);
            } else {
                info.addPara("Talk to Academician " + this.elek.getNameString() + " at the Galatia Academy, which orbits Pontus in the Galatia system.", tc, pad);
            }
            return true;
        }
        if (this.currentStage == Stage.GO_TO_ARRAY) {
            info.addPara("Go to the Sensor Array located in the " + this.arraySystem.getNameWithLowercaseTypeShort() + ".", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GO_TO_LOCATION) {
            info.addPara("Go to the location deep in the Abyss and discover what the Sensor Array found.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.ARRAY_THEN_ABYSS) {
            info.addPara("Go to the location deep in the Abyss and discover what the Sensor Array found.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.ABYSS_NO_ELEK) {
            info.addPara("Go to the location deep in the Abyss and discover what the Sensor Array found.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.ARRAY_THEN_ELEK) {
            info.addPara("Talk to Academician " + this.elek.getNameString() + " at the Galatia Academy.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_ELEK) {
            info.addPara("Talk to Academician " + this.elek.getNameString() + " at the Galatia Academy.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GO_TO_LOCATION) {
            info.addPara("Go to the location deep in the Abyss and discover what the Sensor Array found.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.INVESTIGATE_SHIP) {
            info.addPara("Investigate the strange ship orbiting Nameless Rock.", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETURN_TO_ELEK) {
            info.addPara("Talk to Academician " + this.elek.getNameString() + " at the Galatia Academy.", tc, pad);
            return true;
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return "Abyssal Space Oddity";
    }

    public static enum Stage {
        VISIT_ELEK,
        GO_TO_ARRAY,
        GO_TO_LOCATION,
        INVESTIGATE_SHIP,
        RETURN_TO_ELEK,
        COMPLETED,
        FAILED,
        ARRAY_THEN_ELEK,
        ARRAY_THEN_ABYSS,
        ABYSS_NO_ELEK;

    }
}

