/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.procgen.themes;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.AICoreOfficerPlugin;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.DefenderDataOverride;
import com.fs.starfarer.api.impl.campaign.procgen.NameAssigner;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantOfficerGeneratorPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantSeededFleetManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantStationFleetManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.SalvageSpecialAssigner;
import com.fs.starfarer.api.impl.campaign.procgen.themes.ThemeGenContext;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class RemnantThemeGenerator
extends BaseThemeGenerator {
    public static final int MIN_CONSTELLATIONS_WITH_REMNANTS = 15;
    public static final int MAX_CONSTELLATIONS_WITH_REMNANTS = 25;
    public static float CONSTELLATION_SKIP_PROB = 0.25f;

    @Override
    public String getThemeId() {
        return "remnants";
    }

    @Override
    public void generateForSector(ThemeGenContext context, float allowedUnusedFraction) {
        int numSuppressed;
        int numDestroyed;
        float total = (float)(context.constellations.size() - context.majorThemes.size()) * allowedUnusedFraction;
        if (total <= 0.0f) {
            return;
        }
        int num = (int)StarSystemGenerator.getNormalRandom(15.0f, 25.0f);
        if ((float)num > total) {
            num = (int)total;
        }
        if ((numDestroyed = (int)((float)num * (0.23f + 0.1f * this.random.nextFloat()))) < 1) {
            numDestroyed = 1;
        }
        if ((numSuppressed = (int)((float)num * (0.23f + 0.1f * this.random.nextFloat()))) < 1) {
            numSuppressed = 1;
        }
        float suppressedStationMult = 0.5f;
        int suppressedStations = (int)Math.ceil((float)numSuppressed * suppressedStationMult);
        WeightedRandomPicker<Boolean> addSuppressedStation = new WeightedRandomPicker<Boolean>(this.random);
        int i = 0;
        while (i < numSuppressed) {
            if (i < suppressedStations) {
                addSuppressedStation.add(true, 1.0f);
            } else {
                addSuppressedStation.add(false, 1.0f);
            }
            ++i;
        }
        List<Constellation> constellations = this.getSortedAvailableConstellations(context, false, new Vector2f(), null);
        Collections.reverse(constellations);
        float skipProb = CONSTELLATION_SKIP_PROB;
        if (total < (float)num / (1.0f - skipProb)) {
            skipProb = 1.0f - (float)num / total;
        }
        ArrayList<BaseThemeGenerator.StarSystemData> remnantSystems = new ArrayList<BaseThemeGenerator.StarSystemData>();
        if (DEBUG) {
            System.out.println("\n\n\n");
        }
        if (DEBUG) {
            System.out.println("Generating remnant systems");
        }
        int count = 0;
        int numUsed = 0;
        int i2 = 0;
        while (i2 < num && i2 < constellations.size()) {
            Constellation c = constellations.get(i2);
            if (this.random.nextFloat() < skipProb) {
                if (DEBUG) {
                    System.out.println("Skipping constellation " + c.getName());
                }
            } else {
                ArrayList<BaseThemeGenerator.StarSystemData> systems = new ArrayList<BaseThemeGenerator.StarSystemData>();
                for (StarSystemAPI system : c.getSystems()) {
                    BaseThemeGenerator.StarSystemData data = RemnantThemeGenerator.computeSystemData(system);
                    systems.add(data);
                }
                List<BaseThemeGenerator.StarSystemData> mainCandidates = this.getSortedSystemsSuitedToBePopulated(systems);
                int numMain = 1 + this.random.nextInt(2);
                if (numMain > mainCandidates.size()) {
                    numMain = mainCandidates.size();
                }
                if (numMain <= 0) {
                    if (DEBUG) {
                        System.out.println("Skipping constellation " + c.getName() + ", no suitable main candidates");
                    }
                } else {
                    RemnantSystemType type = RemnantSystemType.RESURGENT;
                    if (numUsed < numDestroyed) {
                        type = RemnantSystemType.DESTROYED;
                    } else if (numUsed < numDestroyed + numSuppressed) {
                        type = RemnantSystemType.SUPPRESSED;
                    }
                    context.majorThemes.put(c, "remnants");
                    ++numUsed;
                    if (DEBUG) {
                        System.out.println("Generating " + numMain + " main systems in " + c.getName());
                    }
                    int j = 0;
                    while (j < numMain) {
                        BaseThemeGenerator.StarSystemData data = mainCandidates.get(j);
                        this.populateMain(data, type);
                        data.system.addTag("theme_interesting");
                        data.system.addTag("theme_remnant");
                        if (type != RemnantSystemType.DESTROYED) {
                            data.system.addTag("theme_unsafe");
                        }
                        data.system.addTag("theme_remnant_main");
                        data.system.addTag(type.getTag());
                        remnantSystems.add(data);
                        if (!NameAssigner.isNameSpecial(data.system)) {
                            NameAssigner.assignSpecialNames(data.system);
                        }
                        if (type == RemnantSystemType.DESTROYED) {
                            fleets = new RemnantSeededFleetManager(data.system, 3, 8, 1, 2, 0.05f);
                            data.system.addScript(fleets);
                        } else if (type == RemnantSystemType.SUPPRESSED) {
                            fleets = new RemnantSeededFleetManager(data.system, 7, 12, 4, 12, 0.25f);
                            data.system.addScript(fleets);
                            Boolean addStation = this.random.nextFloat() < suppressedStationMult;
                            if (j == 0 && !addSuppressedStation.isEmpty()) {
                                addSuppressedStation.pickAndRemove();
                            }
                            if (addStation.booleanValue()) {
                                List<CampaignFleetAPI> stations = this.addBattlestations(data, 1.0f, 1, 1, this.createStringPicker("remnant_station2_Damaged", Float.valueOf(10.0f)));
                                for (CampaignFleetAPI station : stations) {
                                    int maxFleets = 2 + this.random.nextInt(3);
                                    RemnantStationFleetManager activeFleets = new RemnantStationFleetManager(station, 1.0f, 0, maxFleets, 25.0f, 6, 12);
                                    data.system.addScript(activeFleets);
                                }
                            }
                        } else if (type == RemnantSystemType.RESURGENT) {
                            List<CampaignFleetAPI> stations = this.addBattlestations(data, 1.0f, 1, 1, this.createStringPicker("remnant_station2_Standard", Float.valueOf(10.0f)));
                            for (CampaignFleetAPI station : stations) {
                                int maxFleets = 8 + this.random.nextInt(5);
                                RemnantStationFleetManager activeFleets = new RemnantStationFleetManager(station, 1.0f, 0, maxFleets, 15.0f, 8, 24);
                                data.system.addScript(activeFleets);
                            }
                        }
                        ++j;
                    }
                    for (BaseThemeGenerator.StarSystemData data : systems) {
                        int index = mainCandidates.indexOf(data);
                        if (index >= 0 && index < numMain) continue;
                        this.populateNonMain(data);
                        if (type == RemnantSystemType.DESTROYED) {
                            data.system.addTag("theme_interesting_minor");
                        } else {
                            data.system.addTag("theme_interesting");
                        }
                        data.system.addTag("theme_remnant");
                        data.system.addTag("theme_remnant_secondary");
                        data.system.addTag(type.getTag());
                        remnantSystems.add(data);
                        if (this.random.nextFloat() < 0.5f) {
                            RemnantSeededFleetManager fleets = new RemnantSeededFleetManager(data.system, 1, 3, 1, 2, 0.05f);
                            data.system.addScript(fleets);
                            continue;
                        }
                        data.system.addTag("theme_remnant_no_fleets");
                    }
                    ++count;
                }
            }
            ++i2;
        }
        SalvageSpecialAssigner.SpecialCreationContext specialContext = new SalvageSpecialAssigner.SpecialCreationContext();
        specialContext.themeId = this.getThemeId();
        SalvageSpecialAssigner.assignSpecials(remnantSystems, specialContext);
        this.addDefenders(remnantSystems);
        if (DEBUG) {
            System.out.println("Finished generating remnant systems\n\n\n\n\n");
        }
    }

    public void addDefenders(List<BaseThemeGenerator.StarSystemData> systemData) {
        for (BaseThemeGenerator.StarSystemData data : systemData) {
            float mult = 1.0f;
            if (data.system.hasTag("theme_remnant_secondary")) {
                mult = 0.5f;
            }
            for (BaseThemeGenerator.AddedEntity added : data.generated) {
                if (added.entityType == null || "wreck".equals(added.entityType)) continue;
                float prob = 0.0f;
                float min = 1.0f;
                float max = 1.0f;
                if ("station_mining_remnant".equals(added.entityType)) {
                    prob = 0.25f;
                    min = 8.0f;
                    max = 15.0f;
                } else if ("orbital_habitat_remnant".equals(added.entityType)) {
                    prob = 0.25f;
                    min = 8.0f;
                    max = 15.0f;
                } else if ("station_research_remnant".equals(added.entityType)) {
                    prob = 0.25f;
                    min = 10.0f;
                    max = 20.0f;
                }
                min *= 3.0f;
                max *= 3.0f;
                prob *= mult;
                min *= mult;
                max *= mult;
                if (min < 1.0f) {
                    min = 1.0f;
                }
                if (max < 1.0f) {
                    max = 1.0f;
                }
                if (!(this.random.nextFloat() < prob)) continue;
                Misc.setDefenderOverride(added.entity, new DefenderDataOverride("remnant", 1.0f, min, max, 4));
            }
        }
    }

    public void populateNonMain(BaseThemeGenerator.StarSystemData data) {
        boolean special;
        if (DEBUG) {
            System.out.println(" Generating secondary remnant system in " + data.system.getName());
        }
        boolean bl = special = data.isBlackHole() || data.isNebula() || data.isPulsar();
        if (special) {
            this.addResearchStations(data, 0.75f, 1, 1, this.createStringPicker("station_research_remnant", Float.valueOf(10.0f)));
        }
        if (this.random.nextFloat() < 0.5f) {
            return;
        }
        if (!data.resourceRich.isEmpty()) {
            this.addMiningStations(data, 0.5f, 1, 1, this.createStringPicker("station_mining_remnant", Float.valueOf(10.0f)));
        }
        if (!special && !data.habitable.isEmpty()) {
            this.addHabCenters(data, 0.25f, 1, 1, this.createStringPicker("orbital_habitat_remnant", Float.valueOf(10.0f)));
        }
        this.addShipGraveyard(data, 0.05f, 1, 1, this.createStringPicker("tritachyon", Float.valueOf(10.0f), "hegemony", Float.valueOf(7.0f), "independent", Float.valueOf(3.0f)));
        this.addDebrisFields(data, 0.25f, 1, 2);
        this.addDerelictShips(data, 0.5f, 0, 3, this.createStringPicker("tritachyon", Float.valueOf(10.0f), "hegemony", Float.valueOf(7.0f), "independent", Float.valueOf(3.0f)));
        this.addCaches(data, 0.25f, 0, 2, this.createStringPicker("weapons_cache_remnant", Float.valueOf(4.0f), "weapons_cache_small_remnant", Float.valueOf(10.0f), "supply_cache", Float.valueOf(4.0f), "supply_cache_small", Float.valueOf(10.0f), "equipment_cache", Float.valueOf(4.0f), "equipment_cache_small", Float.valueOf(10.0f)));
    }

    public void populateMain(BaseThemeGenerator.StarSystemData data, RemnantSystemType type) {
        if (DEBUG) {
            System.out.println(" Generating remnant center in " + data.system.getName());
        }
        StarSystemAPI system = data.system;
        RemnantThemeGenerator.addBeacon(system, type);
        if (DEBUG) {
            System.out.println("    Added warning beacon");
        }
        int maxHabCenters = 1 + this.random.nextInt(3);
        BaseThemeGenerator.HabitationLevel level = BaseThemeGenerator.HabitationLevel.LOW;
        if (maxHabCenters == 2) {
            level = BaseThemeGenerator.HabitationLevel.MEDIUM;
        }
        if (maxHabCenters >= 3) {
            level = BaseThemeGenerator.HabitationLevel.HIGH;
        }
        this.addHabCenters(data, 1.0f, maxHabCenters, maxHabCenters, this.createStringPicker("orbital_habitat_remnant", Float.valueOf(10.0f)));
        float probGate = 1.0f;
        float probRelay = 1.0f;
        float probMining = 0.5f;
        float probResearch = 0.25f;
        switch (level) {
            case HIGH: {
                probGate = 0.5f;
                probRelay = 1.0f;
                break;
            }
            case MEDIUM: {
                probGate = 0.3f;
                probRelay = 0.75f;
                break;
            }
            case LOW: {
                probGate = 0.2f;
                probRelay = 0.5f;
            }
        }
        this.addObjectives(data, probRelay);
        this.addInactiveGate(data, probGate, 0.5f, 0.5f, this.createStringPicker("tritachyon", Float.valueOf(10.0f), "hegemony", Float.valueOf(7.0f), "independent", Float.valueOf(3.0f)));
        this.addShipGraveyard(data, 0.25f, 1, 1, this.createStringPicker("tritachyon", Float.valueOf(10.0f), "hegemony", Float.valueOf(7.0f), "independent", Float.valueOf(3.0f)));
        this.addMiningStations(data, probMining, 1, 1, this.createStringPicker("station_mining_remnant", Float.valueOf(10.0f)));
        this.addResearchStations(data, probResearch, 1, 1, this.createStringPicker("station_research_remnant", Float.valueOf(10.0f)));
        this.addDebrisFields(data, 0.75f, 1, 5);
        this.addDerelictShips(data, 0.75f, 0, 7, this.createStringPicker("tritachyon", Float.valueOf(10.0f), "hegemony", Float.valueOf(7.0f), "independent", Float.valueOf(3.0f)));
        this.addCaches(data, 0.75f, 0, 3, this.createStringPicker("weapons_cache_remnant", Float.valueOf(10.0f), "weapons_cache_small_remnant", Float.valueOf(10.0f), "supply_cache", Float.valueOf(10.0f), "supply_cache_small", Float.valueOf(10.0f), "equipment_cache", Float.valueOf(10.0f), "equipment_cache_small", Float.valueOf(10.0f)));
    }

    public List<BaseThemeGenerator.StarSystemData> getSortedSystemsSuitedToBePopulated(List<BaseThemeGenerator.StarSystemData> systems) {
        ArrayList<BaseThemeGenerator.StarSystemData> result = new ArrayList<BaseThemeGenerator.StarSystemData>();
        for (BaseThemeGenerator.StarSystemData data : systems) {
            if (data.isBlackHole() || data.isNebula() || data.isPulsar() || data.planets.size() < 3 && data.habitable.size() < 1) continue;
            result.add(data);
        }
        Collections.sort(systems, new Comparator<BaseThemeGenerator.StarSystemData>(){

            @Override
            public int compare(BaseThemeGenerator.StarSystemData o1, BaseThemeGenerator.StarSystemData o2) {
                float s1 = RemnantThemeGenerator.this.getMainCenterScore(o1);
                float s2 = RemnantThemeGenerator.this.getMainCenterScore(o2);
                return (int)Math.signum(s2 - s1);
            }
        });
        return result;
    }

    public float getMainCenterScore(BaseThemeGenerator.StarSystemData data) {
        float total = 0.0f;
        total += (float)data.planets.size() * 1.0f;
        total += (float)data.habitable.size() * 2.0f;
        return total += (float)data.resourceRich.size() * 0.25f;
    }

    public static CustomCampaignEntityAPI addBeacon(StarSystemAPI system, RemnantSystemType type) {
        SectorEntityToken anchor = system.getHyperspaceAnchor();
        List points = Global.getSector().getHyperspace().getEntities(JumpPointAPI.class);
        float minRange = 600.0f;
        float closestRange = Float.MAX_VALUE;
        SectorEntityToken closestPoint = null;
        for (SectorEntityToken entity : points) {
            float dist;
            JumpPointAPI.JumpDestination dest;
            JumpPointAPI point = (JumpPointAPI)entity;
            if (point.getDestinations().isEmpty() || (dest = point.getDestinations().get(0)).getDestination().getContainingLocation() != system || (dist = Misc.getDistance(anchor.getLocation(), point.getLocation())) < minRange + point.getRadius() || !(dist < closestRange)) continue;
            closestPoint = point;
            closestRange = dist;
        }
        CustomCampaignEntityAPI beacon = Global.getSector().getHyperspace().addCustomEntity(null, null, "warning_beacon", "neutral");
        beacon.getMemoryWithoutUpdate().set(type.getBeaconFlag(), true);
        switch (type) {
            case DESTROYED: {
                beacon.addTag("beacon_low");
                break;
            }
            case SUPPRESSED: {
                beacon.addTag("beacon_medium");
                break;
            }
            case RESURGENT: {
                beacon.addTag("beacon_high");
            }
        }
        if (closestPoint == null) {
            float orbitDays = minRange / (10.0f + StarSystemGenerator.random.nextFloat() * 5.0f);
            beacon.setCircularOrbitPointingDown(anchor, StarSystemGenerator.random.nextFloat() * 360.0f, minRange, orbitDays);
        } else {
            float angleOffset = 20.0f + StarSystemGenerator.random.nextFloat() * 20.0f;
            float angle = Misc.getAngleInDegrees(anchor.getLocation(), closestPoint.getLocation()) + angleOffset;
            float radius = closestRange;
            if (closestPoint.getOrbit() != null) {
                OrbitAPI orbit = Global.getFactory().createCircularOrbitPointingDown(anchor, angle, radius, closestPoint.getOrbit().getOrbitalPeriod());
                beacon.setOrbit(orbit);
            } else {
                Vector2f beaconLoc = Misc.getUnitVectorAtDegreeAngle(angle);
                beaconLoc.scale(radius);
                Vector2f.add((Vector2f)beaconLoc, (Vector2f)anchor.getLocation(), (Vector2f)beaconLoc);
                beacon.getLocation().set((ReadableVector2f)beaconLoc);
            }
        }
        Color glowColor = new Color(255, 200, 0, 255);
        Color pingColor = new Color(255, 200, 0, 255);
        if (type == RemnantSystemType.SUPPRESSED) {
            glowColor = new Color(250, 155, 0, 255);
            pingColor = new Color(250, 155, 0, 255);
        } else if (type == RemnantSystemType.RESURGENT) {
            glowColor = new Color(250, 55, 0, 255);
            pingColor = new Color(250, 125, 0, 255);
        }
        Misc.setWarningBeaconColors(beacon, glowColor, pingColor);
        return beacon;
    }

    @Override
    protected List<Constellation> getSortedAvailableConstellations(ThemeGenContext context, boolean emptyOk, final Vector2f sortFrom, List<Constellation> exclude) {
        ArrayList<Constellation> constellations = new ArrayList<Constellation>();
        for (Constellation c : context.constellations) {
            if (context.majorThemes.containsKey(c) || !emptyOk && RemnantThemeGenerator.constellationIsEmpty(c)) continue;
            constellations.add(c);
        }
        if (exclude != null) {
            constellations.removeAll(exclude);
        }
        Collections.sort(constellations, new Comparator<Constellation>(){

            @Override
            public int compare(Constellation o1, Constellation o2) {
                float d1 = Misc.getDistance(o1.getLocation(), sortFrom);
                float d2 = Misc.getDistance(o2.getLocation(), sortFrom);
                return (int)Math.signum(d2 - d1);
            }
        });
        return constellations;
    }

    public static boolean constellationIsEmpty(Constellation c) {
        for (StarSystemAPI s : c.getSystems()) {
            if (RemnantThemeGenerator.systemIsEmpty(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean systemIsEmpty(StarSystemAPI system) {
        for (PlanetAPI p : system.getPlanets()) {
            if (p.isStar()) continue;
            return false;
        }
        return true;
    }

    public List<CampaignFleetAPI> addBattlestations(BaseThemeGenerator.StarSystemData data, float chanceToAddAny, int min, int max, WeightedRandomPicker<String> stationTypes) {
        ArrayList<CampaignFleetAPI> result = new ArrayList<CampaignFleetAPI>();
        if (this.random.nextFloat() >= chanceToAddAny) {
            return result;
        }
        int num = min + this.random.nextInt(max - min + 1);
        if (DEBUG) {
            System.out.println("    Adding " + num + " battlestations");
        }
        int i = 0;
        while (i < num) {
            BaseThemeGenerator.EntityLocation loc = RemnantThemeGenerator.pickCommonLocation(this.random, data.system, 200.0f, true, null);
            String type = stationTypes.pick();
            if (loc != null) {
                CampaignFleetAPI fleet = FleetFactoryV3.createEmptyFleet("remnant", "battlestation", null);
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, type);
                fleet.getFleetData().addFleetMember(member);
                fleet.getMemoryWithoutUpdate().set("$cfai_makeAggressive", true);
                fleet.getMemoryWithoutUpdate().set("$cfai_noJump", true);
                fleet.getMemoryWithoutUpdate().set("$cfai_makeAllowDisengage", true);
                fleet.addTag("neutrino_high");
                fleet.setStationMode(true);
                RemnantThemeGenerator.addRemnantStationInteractionConfig(fleet);
                data.system.addEntity(fleet);
                fleet.clearAbilities();
                fleet.addAbility("transponder");
                fleet.getAbility("transponder").activate();
                fleet.getDetectedRangeMod().modifyFlat("gen", 1000.0f);
                fleet.setAI(null);
                RemnantThemeGenerator.setEntityLocation(fleet, loc, null);
                RemnantThemeGenerator.convertOrbitWithSpin(fleet, 5.0f);
                boolean damaged = type.toLowerCase().contains("damaged");
                String coreId = "alpha_core";
                if (damaged) {
                    fleet.getMemoryWithoutUpdate().set("$damagedStation", true);
                    fleet.setName(String.valueOf(fleet.getName()) + " (Damaged)");
                }
                AICoreOfficerPlugin plugin = Misc.getAICoreOfficerPlugin(coreId);
                PersonAPI commander = plugin.createPerson(coreId, fleet.getFaction().getId(), this.random);
                fleet.setCommander(commander);
                fleet.getFlagship().setCaptain(commander);
                if (!damaged) {
                    RemnantOfficerGeneratorPlugin.integrateAndAdaptCoreForAIFleet(fleet.getFlagship());
                    RemnantOfficerGeneratorPlugin.addCommanderSkills(commander, fleet, null, 3, this.random);
                }
                member.getRepairTracker().setCR(member.getRepairTracker().getMaxCR());
                result.add(fleet);
            }
            ++i;
        }
        return result;
    }

    public static void addRemnantStationInteractionConfig(CampaignFleetAPI fleet) {
        fleet.getMemoryWithoutUpdate().set("$fidConifgGen", new RemnantStationInteractionConfigGen());
    }

    @Override
    public int getOrder() {
        return 1500;
    }

    public static class RemnantStationInteractionConfigGen
    implements FleetInteractionDialogPluginImpl.FIDConfigGen {
        @Override
        public FleetInteractionDialogPluginImpl.FIDConfig createConfig() {
            FleetInteractionDialogPluginImpl.FIDConfig config = new FleetInteractionDialogPluginImpl.FIDConfig();
            config.alwaysAttackVsAttack = true;
            config.leaveAlwaysAvailable = true;
            config.showFleetAttitude = false;
            config.showTransponderStatus = false;
            config.showEngageText = false;
            config.delegate = new FleetInteractionDialogPluginImpl.BaseFIDDelegate(){

                @Override
                public void postPlayerSalvageGeneration(InteractionDialogAPI dialog, FleetEncounterContext context, CargoAPI salvage) {
                    new RemnantSeededFleetManager.RemnantFleetInteractionConfigGen().createConfig().delegate.postPlayerSalvageGeneration(dialog, context, salvage);
                }

                @Override
                public void notifyLeave(InteractionDialogAPI dialog) {
                }

                @Override
                public void battleContextCreated(InteractionDialogAPI dialog, BattleCreationContext bcc) {
                    bcc.aiRetreatAllowed = false;
                    bcc.objectivesAllowed = false;
                }
            };
            return config;
        }
    }

    public static enum RemnantSystemType {
        DESTROYED("theme_remnant_destroyed", "$remnantDestroyed"),
        SUPPRESSED("theme_remnant_suppressed", "$remnantSuppressed"),
        RESURGENT("theme_remnant_resurgent", "$remnantResurgent");

        private String tag;
        private String beaconFlag;

        private RemnantSystemType(String tag, String beaconFlag) {
            this.tag = tag;
            this.beaconFlag = beaconFlag;
        }

        public String getTag() {
            return this.tag;
        }

        public String getBeaconFlag() {
            return this.beaconFlag;
        }
    }
}

