/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.rulecmd.salvage;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.CoreInteractionListener;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpecialItemData;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.econ.impl.PlanetaryShield;
import com.fs.starfarer.api.impl.campaign.intel.bar.events.PlanetaryShieldIntel;
import com.fs.starfarer.api.impl.campaign.procgen.SalvageEntityGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.themes.MiscellaneousThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.BaseCommandPlugin;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.SalvageEntity;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.BaseSalvageSpecial;
import com.fs.starfarer.api.util.Misc;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class RedPlanet
extends BaseCommandPlugin {
    protected CampaignFleetAPI playerFleet;
    protected SectorEntityToken entity;
    protected PlanetAPI planet;
    protected FactionAPI playerFaction;
    protected FactionAPI entityFaction;
    protected TextPanelAPI text;
    protected OptionPanelAPI options;
    protected CargoAPI playerCargo;
    protected MemoryAPI memory;
    protected MarketAPI market;
    protected InteractionDialogAPI dialog;
    protected Map<String, MemoryAPI> memoryMap;
    protected FactionAPI faction;

    public RedPlanet() {
    }

    public RedPlanet(SectorEntityToken entity) {
        this.init(entity);
    }

    protected void init(SectorEntityToken entity) {
        this.memory = entity.getMemoryWithoutUpdate();
        this.entity = entity;
        this.planet = (PlanetAPI)entity;
        this.playerFleet = Global.getSector().getPlayerFleet();
        this.playerCargo = this.playerFleet.getCargo();
        this.playerFaction = Global.getSector().getPlayerFaction();
        this.entityFaction = entity.getFaction();
        this.faction = entity.getFaction();
        this.market = entity.getMarket();
    }

    @Override
    public boolean execute(String ruleId, InteractionDialogAPI dialog, List<Misc.Token> params, Map<String, MemoryAPI> memoryMap) {
        this.dialog = dialog;
        this.memoryMap = memoryMap;
        String command = params.get(0).getString(memoryMap);
        if (command == null) {
            return false;
        }
        this.entity = dialog.getInteractionTarget();
        this.init(this.entity);
        this.memory = RedPlanet.getEntityMemory(memoryMap);
        this.text = dialog.getTextPanel();
        this.options = dialog.getOptionPanel();
        if (command.equals("genLoot")) {
            this.genLoot();
        }
        return true;
    }

    protected void genLoot() {
        OptionPanelAPI options = this.dialog.getOptionPanel();
        TextPanelAPI text = this.dialog.getTextPanel();
        MemoryAPI memory = this.planet.getMemoryWithoutUpdate();
        long seed = memory.getLong("$salvageSeed");
        Random random = Misc.getRandom(seed, 100);
        SalvageEntityGenDataSpec.DropData d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 5;
        d.group = "blueprints";
        this.planet.addDropRandom(d);
        d = new SalvageEntityGenDataSpec.DropData();
        d.chances = 1;
        d.group = "rare_tech";
        this.planet.addDropRandom(d);
        CargoAPI salvage = SalvageEntity.generateSalvage(random, 1.0f, 1.0f, 1.0f, 1.0f, this.planet.getDropValue(), this.planet.getDropRandom());
        CargoAPI extra = BaseSalvageSpecial.getCombinedExtraSalvage(this.memoryMap);
        salvage.addAll(extra);
        BaseSalvageSpecial.clearExtraSalvage(this.memoryMap);
        if (!extra.isEmpty()) {
            ListenerUtil.reportExtraSalvageShown(this.planet);
        }
        salvage.addSpecial(new SpecialItemData("industry_bp", "planetaryshield"), 1.0f);
        salvage.sort();
        this.dialog.getVisualPanel().showLoot("Salvaged", salvage, false, true, true, new CoreInteractionListener(){

            @Override
            public void coreUIDismissed() {
                RedPlanet.this.dialog.dismiss();
                RedPlanet.this.dialog.hideTextPanel();
                RedPlanet.this.dialog.hideVisualPanel();
                PlanetaryShieldIntel intel = (PlanetaryShieldIntel)Global.getSector().getIntelManager().getFirstIntel(PlanetaryShieldIntel.class);
                if (intel != null) {
                    Global.getSector().addScript(intel);
                    intel.endAfterDelay();
                    intel.sendUpdateIfPlayerHasIntel((Object)PlanetaryShieldIntel.PSIStage.DONE, false);
                }
                long xp = PlanetaryShieldIntel.FINISHED_XP;
                Global.getSector().getPlayerPerson().getStats().addXP(xp);
            }
        });
        options.clearOptions();
        this.dialog.setPromptText("");
        this.planet.getMemoryWithoutUpdate().unset(MiscellaneousThemeGenerator.PLANETARY_SHIELD_PLANET);
        Global.getSector().getMemoryWithoutUpdate().unset(MiscellaneousThemeGenerator.PLANETARY_SHIELD_PLANET_KEY);
        PlanetaryShield.unapplyVisuals(this.planet);
    }
}

