/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.world;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.DerelictShipEntityPlugin;
import com.fs.starfarer.api.impl.campaign.enc.AbyssalRogueStellarObjectEPEC;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.themes.BaseThemeGenerator;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.special.ShipRecoverySpecial;
import com.fs.starfarer.api.impl.campaign.world.GateHaulerLocation;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.LinkedHashMap;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class NamelessRock {
    public static String ONESLAUGHT_SENSOR_ARRAY = "$oneslaughtSensorArray";
    public static String NAMELESS_ROCK_LOCATION_ID = "nameless_rock_location";

    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Deep Space");
        system.setName("Deep Space");
        system.setOptionalUniqueId(NAMELESS_ROCK_LOCATION_ID);
        system.setType(StarSystemGenerator.StarSystemType.DEEP_SPACE);
        system.addTag("theme_hidden");
        system.addTag("theme_special");
        system.addTag("system_abyssal");
        system.setBackgroundTextureFilename("graphics/backgrounds/background5.jpg");
        Random random = StarSystemGenerator.random;
        float w = Global.getSettings().getFloat("sectorWidth");
        float h = Global.getSettings().getFloat("sectorHeight");
        Vector2f systemLoc = new Vector2f();
        float outsideMapPad = 2500.0f;
        float outsideMapRand = 2500.0f;
        float r = random.nextFloat();
        if (r < 0.5f) {
            systemLoc.x = -w / 2.0f - outsideMapPad - outsideMapRand * random.nextFloat();
            systemLoc.y = -h / 2.0f + (h + outsideMapPad * 1.0f) * random.nextFloat();
        } else {
            systemLoc.x = -w / 2.0f + (w + outsideMapPad * 1.0f) * random.nextFloat();
            systemLoc.y = -h / 2.0f - outsideMapPad - outsideMapRand * random.nextFloat();
        }
        system.getLocation().set(systemLoc.x, systemLoc.y);
        SectorEntityToken center = system.initNonStarCenter();
        system.setLightColor(GateHaulerLocation.ABYSS_AMBIENT_LIGHT_COLOR);
        center.addTag("ambient_ls");
        String name = "Nameless Rock";
        PlanetAPI rock = system.addPlanet("nameless_rock", null, name, "barren", 0.0f, 150.0f, 0.0f, 0.0f);
        rock.setDescriptionIdOverride("barren_deep_space");
        rock.getMemoryWithoutUpdate().set("$namelessRock", true);
        rock.getMarket().addCondition("no_atmosphere");
        rock.getMarket().addCondition("very_cold");
        rock.getMarket().addCondition("dark");
        rock.getMarket().addCondition("ore_rich");
        rock.getMarket().addCondition("rare_ore_moderate");
        rock.setOrbit(null);
        rock.setLocation(0.0f, 0.0f);
        this.addOnslaughtMkI(rock);
        system.autogenerateHyperspaceJumpPoints(false, false);
        AbyssalRogueStellarObjectEPEC.setAbyssalDetectedRanges(system);
        this.createSensorArrayInClosestSystem(system);
    }

    protected void addOnslaughtMkI(PlanetAPI rock) {
        ShipRecoverySpecial.PerShipData ship = new ShipRecoverySpecial.PerShipData("onslaught_mk1_Ancient", ShipRecoverySpecial.ShipCondition.WRECKED, 0.0f);
        ship.shipName = "Serial #2F38CB017";
        DerelictShipEntityPlugin.DerelictShipData params = new DerelictShipEntityPlugin.DerelictShipData(ship, false);
        CustomCampaignEntityAPI entity = (CustomCampaignEntityAPI)BaseThemeGenerator.addSalvageEntity(rock.getContainingLocation(), "wreck", "neutral", params);
        entity.getMemoryWithoutUpdate().set("$onslaughtMkI", true);
        entity.setSensorProfile(Float.valueOf(1.0f));
        entity.setDiscoverable(true);
        Random random = StarSystemGenerator.random;
        float orbitRadius = rock.getRadius() + 200.0f;
        float orbitDays = orbitRadius / (10.0f + random.nextFloat() * 5.0f);
        entity.setCircularOrbit(rock, random.nextFloat() * 360.0f, orbitRadius, orbitDays);
        ShipRecoverySpecial.ShipRecoverySpecialData data = new ShipRecoverySpecial.ShipRecoverySpecialData(null);
        data.notNowOptionExits = true;
        data.noDescriptionText = true;
        DerelictShipEntityPlugin dsep = (DerelictShipEntityPlugin)entity.getCustomPlugin();
        ShipRecoverySpecial.PerShipData copy = dsep.getData().ship.clone();
        copy.variant = Global.getSettings().getVariant(copy.variantId).clone();
        copy.variantId = null;
        copy.variant.addTag("ship_can_not_scuttle");
        copy.variant.addTag("ship_unique_signature");
        copy.nameAlwaysKnown = true;
        copy.pruneWeapons = false;
        data.addShip(copy);
        Misc.setSalvageSpecial(entity, data);
    }

    protected void createSensorArrayInClosestSystem(StarSystemAPI rockSystem) {
        float minDist = Float.MAX_VALUE;
        LocationAPI closest = null;
        for (StarSystemAPI curr : Global.getSector().getStarSystems()) {
            float dist;
            if (curr == rockSystem || Misc.getAbyssalDepth(curr.getLocation()) > 0.0f || curr.getType() == StarSystemGenerator.StarSystemType.DEEP_SPACE || !((dist = Misc.getDistance(curr.getLocation(), rockSystem.getLocation())) < minDist)) continue;
            closest = curr;
            minDist = dist;
        }
        if (closest == null) {
            return;
        }
        SectorEntityToken sensor = null;
        for (SectorEntityToken curr : closest.getEntitiesWithTag("sensor_array")) {
            if (curr.hasTag("makeshift")) continue;
            sensor = curr;
            break;
        }
        if (sensor == null) {
            LinkedHashMap<BaseThemeGenerator.LocationType, Float> weights = new LinkedHashMap<BaseThemeGenerator.LocationType, Float>();
            weights.put(BaseThemeGenerator.LocationType.STAR_ORBIT, Float.valueOf(10.0f));
            weights.put(BaseThemeGenerator.LocationType.OUTER_SYSTEM, Float.valueOf(10.0f));
            WeightedRandomPicker<BaseThemeGenerator.EntityLocation> locs = BaseThemeGenerator.getLocations(null, (StarSystemAPI)closest, null, 100.0f, weights);
            BaseThemeGenerator.EntityLocation loc = locs.pick();
            BaseThemeGenerator.AddedEntity added = BaseThemeGenerator.addNonSalvageEntity(closest, loc, "sensor_array", "neutral");
            if (added != null) {
                sensor = added.entity;
            }
        }
        if (sensor == null) {
            return;
        }
        sensor.getMemoryWithoutUpdate().set(ONESLAUGHT_SENSOR_ARRAY, true);
        Global.getSector().getPersistentData().put(ONESLAUGHT_SENSOR_ARRAY, sensor);
    }
}

