/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.impl.combat.DisintegratorEffect;
import com.fs.starfarer.api.util.Misc;
import org.lwjgl.util.vector.Vector2f;

public class BreachOnHitEffect
implements OnHitEffectPlugin {
    public static float DAMAGE = 250.0f;

    @Override
    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        if (!shieldHit && target instanceof ShipAPI) {
            float mult = 1.0f;
            BreachOnHitEffect.dealArmorDamage(projectile, (ShipAPI)target, point, DAMAGE * mult);
        }
    }

    public static void dealArmorDamage(DamagingProjectileAPI projectile, ShipAPI target, Vector2f point, float armorDamage) {
        CombatEngineAPI engine = Global.getCombatEngine();
        ArmorGridAPI grid = target.getArmorGrid();
        int[] cell = grid.getCellAtLocation(point);
        if (cell == null) {
            return;
        }
        int gridWidth = grid.getGrid().length;
        int gridHeight = grid.getGrid()[0].length;
        float damageTypeMult = DisintegratorEffect.getDamageTypeMult(projectile.getSource(), target);
        float damageDealt = 0.0f;
        int i = -2;
        while (i <= 2) {
            int j = -2;
            while (j <= 2) {
                if (i != 2 && i != -2 || j != 2 && j != -2) {
                    int cx = cell[0] + i;
                    int cy = cell[1] + j;
                    if (cx >= 0 && cx < gridWidth && cy >= 0 && cy < gridHeight) {
                        float damMult = 0.033333335f;
                        damMult = i == 0 && j == 0 ? 0.06666667f : (i <= 1 && i >= -1 && j <= 1 && j >= -1 ? 0.06666667f : 0.033333335f);
                        float armorInCell = grid.getArmorValue(cx, cy);
                        float damage = armorDamage * damMult * damageTypeMult;
                        if (!((damage = Math.min(damage, armorInCell)) <= 0.0f)) {
                            target.getArmorGrid().setArmorValue(cx, cy, Math.max(0.0f, armorInCell - damage));
                            damageDealt += damage;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        if (damageDealt > 0.0f) {
            if (Misc.shouldShowDamageFloaty(projectile.getSource(), target)) {
                engine.addFloatingDamageText(point, damageDealt, Misc.FLOATY_ARMOR_DAMAGE_COLOR, target, projectile.getSource());
            }
            target.syncWithArmorGridState();
        }
    }
}

