/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseCombatLayeredRenderingPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEngineLayers;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.OnHitEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.ApplyDamageResultAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.FaderUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class CryoblasterEffect
extends BaseCombatLayeredRenderingPlugin
implements OnFireEffectPlugin,
OnHitEffectPlugin {
    protected List<ParticleData> particles = new ArrayList<ParticleData>();
    protected DamagingProjectileAPI proj;
    protected Vector2f projVel;
    protected Vector2f projLoc;
    protected EnumSet<CombatEngineLayers> layers = EnumSet.of(CombatEngineLayers.ABOVE_SHIPS_AND_MISSILES_LAYER);
    protected boolean resetTrailSpeed = false;

    public CryoblasterEffect() {
    }

    @Override
    public void onHit(DamagingProjectileAPI projectile, CombatEntityAPI target, Vector2f point, boolean shieldHit, ApplyDamageResultAPI damageResult, CombatEngineAPI engine) {
        Color color = projectile.getProjectileSpec().getFringeColor();
        color = Misc.setAlpha(color, 100);
        Vector2f vel = new Vector2f();
        if (target instanceof ShipAPI) {
            vel.set((ReadableVector2f)target.getVelocity());
        }
        float sizeMult = Misc.getHitGlowSize(100.0f, projectile.getDamage().getBaseDamage(), damageResult) / 100.0f;
        int i = 0;
        while (i < 7) {
            float size = 40.0f * (0.75f + (float)Math.random() * 0.5f);
            float dur = 1.0f;
            float rampUp = 0.0f;
            Color c = Misc.scaleAlpha(color, projectile.getBrightness());
            engine.addNebulaParticle(point, vel, size, 5.0f + 3.0f * sizeMult, rampUp, 0.0f, dur, c, true);
            ++i;
        }
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        CryoblasterEffect trail = new CryoblasterEffect(projectile);
        CombatEntityAPI e = engine.addLayeredRenderingPlugin(trail);
        e.getLocation().set((ReadableVector2f)projectile.getLocation());
    }

    public CryoblasterEffect(DamagingProjectileAPI proj) {
        this.proj = proj;
        this.projVel = new Vector2f((ReadableVector2f)proj.getVelocity());
        this.projLoc = new Vector2f((ReadableVector2f)proj.getLocation());
        int num = 30;
        int i = 0;
        while (i < num) {
            this.particles.add(new ParticleData(proj));
            ++i;
        }
        float index = 0.0f;
        for (ParticleData p : this.particles) {
            p.offset = Misc.getPointWithinRadius(p.offset, 20.0f);
            index += 1.0f;
        }
    }

    @Override
    public float getRenderRadius() {
        return 700.0f;
    }

    @Override
    public EnumSet<CombatEngineLayers> getActiveLayers() {
        return this.layers;
    }

    @Override
    public void init(CombatEntityAPI entity) {
        super.init(entity);
    }

    @Override
    public void advance(float amount) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        this.entity.getLocation().set((ReadableVector2f)this.proj.getLocation());
        float max = 0.0f;
        for (ParticleData p : this.particles) {
            p.advance(amount);
            max = Math.max(max, p.offset.lengthSquared());
        }
        if (this.proj.getElapsed() < 0.1f) {
            this.projVel.set((ReadableVector2f)this.proj.getVelocity());
            this.projLoc.set((ReadableVector2f)this.proj.getLocation());
        } else {
            this.projLoc.x += this.projVel.x * amount;
            this.projLoc.y += this.projVel.y * amount;
            if (this.proj.didDamage()) {
                if (!this.resetTrailSpeed) {
                    for (ParticleData p : this.particles) {
                        Vector2f.add((Vector2f)p.vel, (Vector2f)this.projVel, (Vector2f)p.vel);
                    }
                    this.projVel.scale(0.0f);
                    this.resetTrailSpeed = true;
                }
                for (ParticleData p : this.particles) {
                    float dist = p.offset.length();
                    p.vel.scale(Math.min(1.0f, dist / 100.0f));
                }
            }
        }
    }

    @Override
    public boolean isExpired() {
        return this.proj.isExpired() || !Global.getCombatEngine().isEntityInPlay(this.proj);
    }

    @Override
    public void render(CombatEngineLayers layer, ViewportAPI viewport) {
        float x = this.projLoc.x;
        float y = this.projLoc.y;
        Color color = this.proj.getProjectileSpec().getFringeColor();
        color = Misc.setAlpha(color, 30);
        float b = this.proj.getBrightness();
        b *= viewport.getAlphaMult();
        for (ParticleData p : this.particles) {
            float alphaMult;
            float size = 25.0f;
            Vector2f loc = new Vector2f(x + p.offset.x, y + p.offset.y);
            float a = alphaMult = 1.0f;
            p.sprite.setAngle(p.angle);
            p.sprite.setSize(size *= p.scale, size);
            p.sprite.setAlphaMult(b * a * p.fader.getBrightness());
            p.sprite.setColor(color);
            p.sprite.renderAtCenter(loc.x, loc.y);
        }
    }

    public static class ParticleData {
        public SpriteAPI sprite;
        public Vector2f offset = new Vector2f();
        public Vector2f vel = new Vector2f();
        public float scale = 1.0f;
        public DamagingProjectileAPI proj;
        public float scaleIncreaseRate = 1.0f;
        public float turnDir = 1.0f;
        public float angle = 1.0f;
        public float maxDur;
        public Vector2f origVel;
        public FaderUtil fader;
        public Vector2f dirVelChange;

        public ParticleData(DamagingProjectileAPI proj) {
            this.proj = proj;
            this.sprite = Global.getSettings().getSprite("misc", "nebula_particles");
            float i = Misc.random.nextInt(4);
            float j = Misc.random.nextInt(4);
            this.sprite.setTexWidth(0.25f);
            this.sprite.setTexHeight(0.25f);
            this.sprite.setTexX(i * 0.25f);
            this.sprite.setTexY(j * 0.25f);
            this.sprite.setAdditiveBlend();
            this.angle = (float)Math.random() * 360.0f;
            this.maxDur = proj.getWeapon().getRange() / proj.getWeapon().getProjectileSpeed();
            this.scaleIncreaseRate = 2.5f / this.maxDur;
            this.scale = 1.0f;
            this.turnDir = Math.signum((float)Math.random() - 0.5f) * 30.0f * (float)Math.random();
            float driftDir = proj.getFacing() + 180.0f + ((float)Math.random() * 30.0f - 15.0f);
            this.vel = Misc.getUnitVectorAtDegreeAngle(driftDir);
            this.vel.scale(80.0f / this.maxDur * (0.0f + (float)Math.random() * 3.0f));
            this.origVel = new Vector2f((ReadableVector2f)this.vel);
            this.dirVelChange = Misc.getUnitVectorAtDegreeAngle(proj.getFacing() + 180.0f);
            this.fader = new FaderUtil(0.0f, 0.25f, 0.05f);
            this.fader.fadeIn();
        }

        public void advance(float amount) {
            float speed;
            this.scale += this.scaleIncreaseRate * amount;
            this.offset.x += this.vel.x * amount;
            this.offset.y += this.vel.y * amount;
            if (!this.proj.didDamage() && (speed = this.vel.length()) > 0.0f) {
                float speedIncrease = this.proj.getMoveSpeed() / this.maxDur * 0.5f;
                Vector2f dir = new Vector2f((ReadableVector2f)this.dirVelChange);
                dir.scale(speedIncrease * amount);
                Vector2f.add((Vector2f)this.vel, (Vector2f)dir, (Vector2f)this.vel);
            }
            this.angle += this.turnDir * amount;
            this.fader.advance(amount);
        }
    }
}

