/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.listeners.AdvanceableListener;
import com.fs.starfarer.api.util.TimeoutTracker;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class GravitonBeamEffect
implements BeamEffectPlugin {
    public static float EFFECT_DUR = 1.0f;
    public static float DAMAGE_PERCENT_ONE = 5.0f;
    public static float DAMAGE_PERCENT_TWO = 8.0f;
    public static float DAMAGE_PERCENT_THREE = 10.0f;
    protected boolean wasZero = true;
    public static String DAMAGE_MOD_ID = "gravitonbeam_dam_mod";

    @Override
    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        CombatEntityAPI target = beam.getDamageTarget();
        if (target instanceof ShipAPI && beam.getBrightness() >= 1.0f && beam.getWeapon() != null) {
            float dur = beam.getDamage().getDpsDuration();
            if (!this.wasZero) {
                dur = 0.0f;
            }
            boolean bl = this.wasZero = beam.getDamage().getDpsDuration() <= 0.0f;
            if (dur > 0.0f) {
                boolean hitShield;
                boolean bl2 = hitShield = target.getShield() != null && target.getShield().isWithinArc(beam.getTo());
                if (hitShield) {
                    List<GravitonBeamDamageTakenMod> listeners;
                    ShipAPI ship = (ShipAPI)target;
                    if (!ship.hasListenerOfClass(GravitonBeamDamageTakenMod.class)) {
                        ship.addListener(new GravitonBeamDamageTakenMod(ship));
                    }
                    if ((listeners = ship.getListeners(GravitonBeamDamageTakenMod.class)).isEmpty()) {
                        return;
                    }
                    GravitonBeamDamageTakenMod listener = listeners.get(0);
                    listener.notifyHit(beam.getWeapon());
                }
            }
        }
    }

    public static class GravitonBeamDamageTakenMod
    implements AdvanceableListener {
        protected ShipAPI ship;
        protected TimeoutTracker<WeaponAPI> recentHits = new TimeoutTracker();

        public GravitonBeamDamageTakenMod(ShipAPI ship) {
            this.ship = ship;
        }

        public void notifyHit(WeaponAPI w) {
            this.recentHits.add(w, EFFECT_DUR, EFFECT_DUR);
        }

        @Override
        public void advance(float amount) {
            this.recentHits.advance(amount);
            int beams = this.recentHits.getItems().size();
            float bonus = 0.0f;
            if (beams == 1) {
                bonus = DAMAGE_PERCENT_ONE;
            } else if (beams == 2) {
                bonus = DAMAGE_PERCENT_TWO;
            } else if (beams >= 3) {
                bonus = DAMAGE_PERCENT_THREE;
            }
            if (bonus > 0.0f) {
                this.ship.getMutableStats().getShieldDamageTakenMult().modifyMult(DAMAGE_MOD_ID, 1.0f + bonus * 0.01f);
            } else {
                this.ship.removeListener(this);
                this.ship.getMutableStats().getShieldDamageTakenMult().unmodify(DAMAGE_MOD_ID);
            }
        }

        public String modifyDamageTaken(Object param, CombatEntityAPI target, DamageAPI damage, Vector2f point, boolean shieldHit) {
            return null;
        }
    }
}

