/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.dweller;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.OnFireEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.dweller.ConvulsiveLungeSystemScript;
import com.fs.starfarer.api.impl.combat.dweller.DwellerShroud;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class VortexLauncherEffect
implements OnFireEffectPlugin,
EveryFrameWeaponEffectPlugin {
    public static String VORTEX_WING = "shrouded_vortex_wing";
    public static float LAUNCH_ARC = 60.0f;

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        ShipAPI ship = weapon.getShip();
        if (ship == null) {
            return;
        }
    }

    @Override
    public void onFire(DamagingProjectileAPI projectile, WeaponAPI weapon, CombatEngineAPI engine) {
        DwellerShroud sourceShroud;
        CombatFleetManagerAPI manager = engine.getFleetManager(projectile.getOwner());
        manager.setSuppressDeploymentMessages(true);
        ShipAPI vortex = manager.spawnShipOrWing(VORTEX_WING, projectile.getLocation(), projectile.getFacing(), 0.0f, null);
        manager.setSuppressDeploymentMessages(false);
        Vector2f takeoffVel = Misc.getUnitVectorAtDegreeAngle(projectile.getFacing() + LAUNCH_ARC / 2.0f - (float)Math.random() * LAUNCH_ARC);
        float velMult = 1.0f;
        if (Misc.getAngleDiff(projectile.getFacing(), weapon.getShip().getFacing()) > 150.0f) {
            velMult = 0.5f;
        }
        takeoffVel.scale(vortex.getMaxSpeed() * velMult);
        Vector2f.add((Vector2f)vortex.getVelocity(), (Vector2f)takeoffVel, (Vector2f)vortex.getVelocity());
        DwellerShroud shroud = DwellerShroud.getShroudFor(vortex);
        if (shroud != null) {
            shroud.custom1 = weapon.getShip();
        }
        if ((sourceShroud = DwellerShroud.getShroudFor(weapon.getShip())) != null) {
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(projectile.getFacing());
            Vector2f offset = Vector2f.sub((Vector2f)projectile.getLocation(), (Vector2f)sourceShroud.getAttachedTo().getLocation(), (Vector2f)new Vector2f());
            Global.getCombatEngine().addPlugin(new DisturbShroudPlugin(1.0f, dir, vortex, offset, sourceShroud, (int)((float)sourceShroud.getNumMembersToMaintain() * 0.1f)));
        }
        engine.removeEntity(projectile);
    }

    public static class DisturbShroudPlugin
    extends BaseEveryFrameCombatPlugin {
        float elapsed = 0.0f;
        float dur;
        Vector2f dir;
        DwellerShroud shroud;
        int numMembers;
        Vector2f offset;
        CombatEntityAPI disturber;

        public DisturbShroudPlugin(float dur, Vector2f dir, CombatEntityAPI disturber, Vector2f offset, DwellerShroud shroud, int numMembers) {
            this.dur = dur;
            this.dir = dir;
            this.disturber = disturber;
            this.offset = offset;
            this.shroud = shroud;
            this.numMembers = numMembers;
        }

        @Override
        public void advance(float amount, List<InputEventAPI> events) {
            if (Global.getCombatEngine().isPaused()) {
                return;
            }
            this.elapsed += amount;
            if (this.elapsed > this.dur) {
                CombatEngineAPI engine = Global.getCombatEngine();
                engine.removePlugin(this);
                return;
            }
            Vector2f loc = Vector2f.add((Vector2f)this.shroud.getAttachedTo().getLocation(), (Vector2f)this.offset, (Vector2f)new Vector2f());
            Vector2f useDir = this.dir;
            if (this.disturber != null) {
                useDir = new Vector2f((ReadableVector2f)this.disturber.getVelocity());
                useDir = Misc.normalise(useDir);
            }
            WeightedRandomPicker<RoilingSwarmEffect.SwarmMember> picker = this.shroud.getPicker(false, true, loc, 70.0f);
            int i = 0;
            while (i < this.numMembers) {
                RoilingSwarmEffect.SwarmMember pick = picker.pickAndRemove();
                if (pick == null) break;
                float accel = ConvulsiveLungeSystemScript.PARTICLE_WINDUP_ACCEL * amount * 3.0f;
                pick.vel.x += useDir.x * (accel *= 1.0f + (float)Math.random());
                pick.vel.y += useDir.y * accel;
                ++i;
            }
        }
    }
}

