/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.AssignmentTargetAPI;
import com.fs.starfarer.api.combat.BattleObjectiveAPI;
import com.fs.starfarer.api.combat.CombatAssignmentType;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.CombatTaskManagerAPI;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.impl.combat.threat.ThreatShipConstructionScript;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ThreatCombatStrategyAI {
    public static float SND_BASE = 60.0f;
    public static float SND_TIMER = 60.0f;
    public static float SND_FRACTION = 0.5f;
    protected boolean playerSide;
    protected CombatTaskManagerAPI taskManager;
    protected CombatFleetManagerAPI fleetManager;
    protected CombatFleetManagerAPI enemyFleetManager;
    protected int owner;
    protected boolean allyMode = false;
    protected IntervalUtil everySecond = new IntervalUtil(0.8f, 1.2f);
    protected CombatEngineAPI engine = Global.getCombatEngine();
    protected float mw;
    protected float mh;
    protected boolean abort = false;
    protected CombatFleetManagerAPI.AssignmentInfo mainDefend1;
    protected CombatFleetManagerAPI.AssignmentInfo mainDefend2;
    protected float captureAllTimeRemaining;
    protected boolean gaveInitialOrders = false;
    protected float untilSNDOnSkirmishUnits;

    public ThreatCombatStrategyAI(int owner) {
        this.owner = owner;
        this.allyMode = this.playerSide = owner == 0;
        this.fleetManager = this.engine.getFleetManager(owner);
        this.taskManager = this.fleetManager.getTaskManager(this.allyMode);
        this.taskManager.getCommandPointsStat().modifyFlat("ThreatCombatStrategyAI", 1.0E9f);
        this.enemyFleetManager = this.engine.getFleetManager(owner == 0 ? 1 : 0);
        if (this.fleetManager.getGoal() == FleetGoal.ESCAPE || this.enemyFleetManager.getGoal() == FleetGoal.ESCAPE) {
            this.abort = true;
        } else if (this.fleetManager.getAdmiralAI() != null) {
            this.taskManager.clearTasks();
            this.fleetManager.getAdmiralAI().setNoOrders(true);
        }
        this.mw = this.engine.getMapWidth();
        this.mh = this.engine.getMapHeight();
        this.resetSNDTimer();
    }

    protected void resetSNDTimer() {
        this.untilSNDOnSkirmishUnits = SND_TIMER * (0.75f + (float)Math.random() * 0.5f);
        this.untilSNDOnSkirmishUnits += SND_BASE;
    }

    protected void manageSND(float amount) {
        this.untilSNDOnSkirmishUnits -= amount;
        if (this.captureAllTimeRemaining > 0.0f) {
            return;
        }
        if (this.untilSNDOnSkirmishUnits <= 0.0f) {
            for (DeployedFleetMemberAPI member : this.fleetManager.getDeployedCopyDFM()) {
                ShipAPI ship = member.getShip();
                if (ship == null || ship.getAI() == null || ship.hasTag(ThreatShipConstructionScript.SHIP_UNDER_CONSTRUCTION) || !ship.getHullSpec().hasTag("threat_skirmish") || (float)Math.random() > SND_FRACTION) continue;
                this.cancelOrders(member, false);
                ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.IGNORES_ORDERS, SND_BASE * (0.75f + (float)Math.random() * 0.5f));
            }
            this.resetSNDTimer();
        }
    }

    protected void giveInitialOrders() {
        this.captureAllTimeRemaining = 80.0f;
        for (BattleObjectiveAPI curr : this.engine.getObjectives()) {
            this.taskManager.createAssignment(CombatAssignmentType.CAPTURE, curr, false);
        }
    }

    public void advance(float amount) {
        if (this.abort) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.captureAllTimeRemaining -= amount;
        this.manageSND(amount);
        this.everySecond.advance(amount);
        if (this.everySecond.intervalElapsed()) {
            List<DeployedFleetMemberAPI> deployed = this.fleetManager.getDeployedCopyDFM();
            if (deployed.isEmpty()) {
                return;
            }
            boolean someMatching = false;
            for (DeployedFleetMemberAPI member : deployed) {
                if (!member.isFighterWing() && member.getShip() != null && member.isAlly() == this.allyMode && !member.getShip().getVariant().hasHullMod("threat_hullmod")) {
                    this.abort = true;
                    return;
                }
                if (member.isFighterWing() || member.getShip() == null || member.isAlly() != this.allyMode) continue;
                someMatching = true;
            }
            if (!someMatching) {
                return;
            }
            if (!this.gaveInitialOrders) {
                this.giveInitialOrders();
                this.gaveInitialOrders = true;
            }
            float sign = 1.0f;
            if (this.owner == 0) {
                sign = -1.0f;
            }
            Vector2f enemyCom = this.getEnemyCenterOfMass();
            Vector2f fabricatorLoc = new Vector2f(0.0f, 0.0f + this.mh * 0.33f * sign);
            Vector2f axis = Misc.getUnitVector(fabricatorLoc, enemyCom);
            Vector2f perp = new Vector2f(axis.y, -axis.x);
            float distToEnemyCom = Misc.getDistance(fabricatorLoc, enemyCom);
            float hiveOffset = distToEnemyCom - 6000.0f;
            if (Math.abs(hiveOffset) < 2000.0f) {
                hiveOffset = Math.signum(hiveOffset) * 2000.0f;
            }
            if (hiveOffset > 2000.0f) {
                hiveOffset = 2000.0f;
            }
            Vector2f hiveLoc = new Vector2f((ReadableVector2f)axis);
            hiveLoc.scale(hiveOffset);
            Vector2f.add((Vector2f)hiveLoc, (Vector2f)fabricatorLoc, (Vector2f)hiveLoc);
            float enemyWeightNearFabricatorLoc = Misc.countEnemyWeightInArcAroundLocation(this.owner, fabricatorLoc, 0.0f, 360.0f, 3000.0f, null, true, true);
            int fabricators = 0;
            int hives = 0;
            for (DeployedFleetMemberAPI member : this.fleetManager.getDeployedCopyDFM()) {
                ShipAPI ship = member.getShip();
                if (ship == null || ship.getAI() == null) continue;
                if (ThreatCombatStrategyAI.isFabricator(ship)) {
                    ++fabricators;
                }
                if (!ThreatCombatStrategyAI.isHive(ship)) continue;
                ++hives;
            }
            float defDist = distToEnemyCom - 2000.0f;
            if (enemyWeightNearFabricatorLoc >= 3.0f) {
                defDist = Math.min(defDist, 3000.0f);
            }
            if (fabricators == 0 && hives == 0) {
                if (this.mainDefend1 != null) {
                    this.taskManager.removeAssignment(this.mainDefend1);
                    this.mainDefend1 = null;
                }
                if (this.mainDefend2 != null) {
                    this.taskManager.removeAssignment(this.mainDefend2);
                    this.mainDefend2 = null;
                }
            } else if (defDist < 2000.0f) {
                float dist;
                if (this.mainDefend1 != null && (dist = Misc.getDistance(this.mainDefend1.getTarget().getLocation(), fabricatorLoc)) > 1000.0f) {
                    this.taskManager.removeAssignment(this.mainDefend1);
                    this.mainDefend1 = null;
                }
                if (this.mainDefend2 != null) {
                    this.taskManager.removeAssignment(this.mainDefend2);
                    this.mainDefend2 = null;
                }
                if (this.mainDefend1 == null) {
                    AssignmentTargetAPI wp = this.taskManager.createWaypoint2(fabricatorLoc, this.allyMode);
                    this.mainDefend1 = this.taskManager.createAssignment(CombatAssignmentType.DEFEND, wp, false);
                }
                for (DeployedFleetMemberAPI member : this.fleetManager.getDeployedCopyDFM()) {
                    ShipAPI ship = member.getShip();
                    if (ship == null || ship.getAI() == null || !ThreatCombatStrategyAI.isCombatUnit(ship) || !(ship.getAI() instanceof ShipAIPlugin)) continue;
                    ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_BACK_OFF, 2.0f);
                    ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT, 2.0f);
                    ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.IGNORES_ORDERS, 2.0f);
                }
            } else {
                float dist;
                Vector2f defLoc = new Vector2f((ReadableVector2f)axis);
                defLoc.scale(defDist);
                Vector2f.add((Vector2f)defLoc, (Vector2f)fabricatorLoc, (Vector2f)defLoc);
                Vector2f defLoc1 = new Vector2f((ReadableVector2f)perp);
                defLoc1.scale(1000.0f);
                Vector2f.add((Vector2f)defLoc1, (Vector2f)defLoc, (Vector2f)defLoc1);
                Vector2f defLoc2 = new Vector2f((ReadableVector2f)perp);
                defLoc2.scale(-1000.0f);
                Vector2f.add((Vector2f)defLoc2, (Vector2f)defLoc, (Vector2f)defLoc2);
                if (this.mainDefend1 != null && (dist = Misc.getDistance(this.mainDefend1.getTarget().getLocation(), defLoc1)) > 1000.0f) {
                    this.taskManager.removeAssignment(this.mainDefend1);
                    this.mainDefend1 = null;
                }
                if (this.mainDefend2 != null && (dist = Misc.getDistance(this.mainDefend2.getTarget().getLocation(), defLoc2)) > 1000.0f) {
                    this.taskManager.removeAssignment(this.mainDefend2);
                    this.mainDefend2 = null;
                }
                if (this.mainDefend1 == null) {
                    AssignmentTargetAPI wp = this.taskManager.createWaypoint2(defLoc1, this.allyMode);
                    this.mainDefend1 = this.taskManager.createAssignment(CombatAssignmentType.DEFEND, wp, false);
                }
                if (this.mainDefend2 == null) {
                    AssignmentTargetAPI wp = this.taskManager.createWaypoint2(defLoc2, this.allyMode);
                    this.mainDefend2 = this.taskManager.createAssignment(CombatAssignmentType.DEFEND, wp, false);
                }
            }
            if (this.captureAllTimeRemaining <= 0.0f) {
                float axisAngle = Misc.getAngleInDegrees(axis);
                ArrayList<AssignmentTargetAPI> withCaptures = new ArrayList<AssignmentTargetAPI>();
                for (CombatFleetManagerAPI.AssignmentInfo info : this.taskManager.getAllAssignments()) {
                    if (info.getTarget() == null || info.getType() != CombatAssignmentType.CAPTURE && info.getType() != CombatAssignmentType.CONTROL) continue;
                    if (fabricators == 0 && hives == 0 || !this.wantsToControl(fabricatorLoc, axisAngle, distToEnemyCom, info.getTarget().getLocation())) {
                        this.taskManager.removeAssignment(info);
                        continue;
                    }
                    withCaptures.add(info.getTarget());
                }
                if (fabricators > 0 || hives > 0) {
                    for (BattleObjectiveAPI curr : this.engine.getObjectives()) {
                        if (withCaptures.contains(curr) || !this.wantsToControl(fabricatorLoc, axisAngle, distToEnemyCom, curr.getLocation())) continue;
                        this.taskManager.createAssignment(CombatAssignmentType.CAPTURE, curr, false);
                    }
                }
            }
            LinkedHashSet escorted = new LinkedHashSet();
            for (DeployedFleetMemberAPI member : this.fleetManager.getDeployedCopyDFM()) {
                float shipWeight;
                float enemyWeight;
                boolean enemiesNear;
                ShipAPI ship = member.getShip();
                if (ship == null || ship.getAI() == null || ship.hasTag(ThreatShipConstructionScript.SHIP_UNDER_CONSTRUCTION)) continue;
                float enemyCheckRange = 3000.0f;
                if (ThreatCombatStrategyAI.isHive(ship)) {
                    enemyCheckRange = 1000.0f;
                }
                boolean bl = enemiesNear = (enemyWeight = Misc.countEnemyWeightInArcAroundLocation(this.owner, ship.getLocation(), 0.0f, 360.0f, enemyCheckRange, null, true, true)) >= (shipWeight = Misc.getShipWeight(ship, true)) * 0.5f;
                if (ThreatCombatStrategyAI.isFabricator(ship)) {
                    float min = 0.0f;
                    float max = 1000.0f;
                    if (enemiesNear) {
                        min = 1000.0f;
                        max = 2000.0f;
                    }
                    this.giveMovementOrder(member, fabricatorLoc, min, max);
                    continue;
                }
                if (ThreatCombatStrategyAI.isHive(ship)) {
                    if (enemiesNear) {
                        this.cancelOrders(member, true);
                        continue;
                    }
                    this.giveMovementOrder(member, hiveLoc, 1000.0f, 1500.0f);
                    continue;
                }
                if (!ThreatCombatStrategyAI.isOverseer(ship)) continue;
                DeployedFleetMemberAPI closest = null;
                float minDist = Float.MAX_VALUE;
                for (DeployedFleetMemberAPI other : this.fleetManager.getDeployedCopyDFM()) {
                    if (other == member || other.getShip() == null || escorted.contains(other)) continue;
                    float extraDistScore = 0.0f;
                    if (other.getShip().isCruiser() && ThreatCombatStrategyAI.isCombatUnit(other.getShip())) {
                        extraDistScore = 0.0f;
                    } else if (other.getShip().isDestroyer() && ThreatCombatStrategyAI.isCombatUnit(other.getShip())) {
                        extraDistScore = 100000.0f;
                    } else if (other.getShip().isFrigate() && ThreatCombatStrategyAI.isCombatUnit(other.getShip())) {
                        extraDistScore = enemiesNear ? 500000.0f : 1000000.0f;
                    } else {
                        if (!ThreatCombatStrategyAI.isHive(other.getShip())) continue;
                        extraDistScore = enemiesNear ? 100000.0f : 1.0E7f;
                    }
                    float dist = Misc.getDistance(member.getLocation(), other.getLocation()) + extraDistScore;
                    if (!(dist < minDist)) continue;
                    closest = other;
                    minDist = dist;
                }
                if (closest == null) continue;
                member.getShip().getAIFlags().setFlag(ShipwideAIFlags.AIFlags.TIMID_ESCORT, 2.0f);
                member.getShip().getAIFlags().setFlag(ShipwideAIFlags.AIFlags.ESCORT_RANGE_MODIFIER, 2.0f, Float.valueOf(300.0f));
                this.escort(member, closest);
            }
            this.cleanUpEmptyAssignments();
        }
    }

    protected boolean wantsToControl(Vector2f fabricatorLoc, float axisAngle, float distToEnemyCom, Vector2f objectiveLoc) {
        float dist = Misc.getDistance(fabricatorLoc, objectiveLoc);
        float angle = Misc.getAngleInDegrees(fabricatorLoc, objectiveLoc);
        float angleDiff = Misc.getAngleDiff(axisAngle, angle);
        float enemyWeight = Misc.countEnemyWeightInArcAroundLocation(this.owner, objectiveLoc, 0.0f, 360.0f, 3000.0f, null, true, true);
        if (enemyWeight <= 0.0f && angleDiff > 30.0f) {
            return true;
        }
        return dist < 5000.0f || dist < distToEnemyCom && angleDiff < 45.0f;
    }

    protected void cancelOrders(DeployedFleetMemberAPI member, boolean withSearchAndDestroy) {
        CombatFleetManagerAPI.AssignmentInfo curr = this.taskManager.getAssignmentFor(member.getShip());
        if (curr != null) {
            this.taskManager.removeAssignment(curr);
        }
        if (withSearchAndDestroy) {
            this.taskManager.orderSearchAndDestroy(member, false);
        }
    }

    protected void escort(DeployedFleetMemberAPI member, DeployedFleetMemberAPI target) {
        if (member.getShip() == null) {
            return;
        }
        CombatFleetManagerAPI.AssignmentInfo curr = this.taskManager.getAssignmentFor(member.getShip());
        if (curr != null && curr.getType() == CombatAssignmentType.LIGHT_ESCORT && this.taskManager.getAssignmentTargetFor(member.getShip()) == target) {
            return;
        }
        CombatFleetManagerAPI.AssignmentInfo info = this.taskManager.createAssignment(CombatAssignmentType.LIGHT_ESCORT, target, false);
        this.taskManager.setAssignmentWeight(info, 0.0f);
        this.taskManager.giveAssignment(member, info, false);
    }

    protected void giveMovementOrder(DeployedFleetMemberAPI member, Vector2f loc, float minDist, float maxDist) {
        CombatFleetManagerAPI.AssignmentInfo curr = this.taskManager.getAssignmentFor(member.getShip());
        boolean needToMakeAssignment = curr == null || curr.getTarget() == null || Misc.getDistance(curr.getTarget().getLocation(), loc) > 100.0f;
        float dist = Misc.getDistance(member.getLocation(), loc);
        if (dist < minDist && curr != null && curr.getType() == CombatAssignmentType.RALLY_CIVILIAN) {
            this.taskManager.removeAssignment(curr);
        }
        boolean needToLeash = false;
        needToLeash |= curr == null && dist > minDist;
        if (needToMakeAssignment && (needToLeash |= curr != null && dist > maxDist)) {
            AssignmentTargetAPI wp = this.taskManager.createWaypoint2(loc, this.allyMode);
            CombatFleetManagerAPI.AssignmentInfo task = this.taskManager.createAssignment(CombatAssignmentType.RALLY_CIVILIAN, wp, false);
            this.taskManager.giveAssignment(member, task, false);
        }
    }

    public void cleanUpEmptyAssignments() {
        this.taskManager.reassign();
        ArrayList<CombatFleetManagerAPI.AssignmentInfo> remove = new ArrayList<CombatFleetManagerAPI.AssignmentInfo>();
        for (CombatFleetManagerAPI.AssignmentInfo curr : this.taskManager.getAllAssignments()) {
            if (curr.getType() == CombatAssignmentType.CONTROL || curr.getType() == CombatAssignmentType.CAPTURE || curr.getType() == CombatAssignmentType.DEFEND || !curr.getAssignedMembers().isEmpty()) continue;
            remove.add(curr);
        }
        for (CombatFleetManagerAPI.AssignmentInfo curr : remove) {
            this.taskManager.removeAssignment(curr);
        }
        this.taskManager.clearEmptyWaypoints();
    }

    protected Vector2f getEnemyCenterOfMass() {
        Vector2f com = new Vector2f();
        float weight = 0.0f;
        for (DeployedFleetMemberAPI member : this.enemyFleetManager.getDeployedCopyDFM()) {
            if (member.isFighterWing() || member.getShip() == null || !this.engine.isAwareOf(this.owner, member.getShip())) continue;
            Vector2f.add((Vector2f)member.getLocation(), (Vector2f)com, (Vector2f)com);
            weight += 1.0f;
        }
        if (weight > 0.0f) {
            com.scale(1.0f / weight);
        }
        return com;
    }

    public static boolean isCombatUnit(ShipAPI ship) {
        return ship.getHullSpec().hasTag("threat_combat");
    }

    public static boolean isOverseer(ShipAPI ship) {
        return ship.getHullSpec().hasTag("threat_overseer");
    }

    public static boolean isHive(ShipAPI ship) {
        return ship.getHullSpec().hasTag("threat_hive");
    }

    public static boolean isFabricator(ShipAPI ship) {
        return ship.getHullSpec().hasTag("threat_fabricator");
    }
}

