/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.combat.threat;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.FighterWingAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import com.fs.starfarer.api.impl.combat.threat.ConstructionSwarmSystemScript;
import com.fs.starfarer.api.impl.combat.threat.RoilingSwarmEffect;
import com.fs.starfarer.api.impl.combat.threat.SwarmLauncherEffect;
import com.fs.starfarer.api.impl.combat.threat.ThreatCombatStrategyAI;
import com.fs.starfarer.api.impl.combat.threat.ThreatShipConstructionScript;
import com.fs.starfarer.api.impl.combat.threat.VoltaicDischargeOnFireEffect;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ThreatSwarmAI
implements ShipAIPlugin {
    public static float ATTRACTOR_RANGE_MAX_SAME_WING = 1000000.0f;
    public static float ATTRACTOR_RANGE_MAX = 500.0f;
    public static float COHESION_RANGE_MIN = 150.0f;
    public static float COHESION_RANGE_MAX = 300.0f;
    public static float REPEL_RANGE_MIN = 0.0f;
    public static float REPEL_RANGE_MAX = 150.0f;
    public static float MAX_TARGET_RANGE = 3000.0f;
    public static float PROB_ENABLE_OTHER_GROUP = 0.5f;
    protected ShipwideAIFlags flags = new ShipwideAIFlags();
    protected ShipAPI ship;
    protected IntervalUtil updateInterval = new IntervalUtil(0.5f, 1.5f);
    protected IntervalUtil headingInterval = new IntervalUtil(0.5f, 1.5f);
    protected IntervalUtil attackRangeMultInterval = new IntervalUtil(0.2f, 1.8f);
    protected IntervalUtil reclamationReturnInterval = new IntervalUtil(0.2f, 1.8f);
    protected float sinceTurnedOffFlash = 0.0f;
    protected ShipAPI fabricator = null;
    protected List<FlockingData> flockingData = new ArrayList<FlockingData>();
    protected float desiredHeading = 0.0f;
    protected float headingChangeRate = 0.0f;
    protected float elapsedSincePrevHeadingUpdate = 0.0f;
    protected float attackRangeMult = 1.0f;
    protected IntervalUtil enableOtherWeaponInterval = new IntervalUtil(5.0f, 15.0f);
    protected IntervalUtil priorityTargetPickerInterval = new IntervalUtil(1.0f, 3.0f);
    protected float enableOtherWeaponDuration = 0.0f;
    protected float elapsed = 0.0f;
    protected boolean startedConstruction = false;
    private ConstructionSwarmSystemScript.SwarmConstructionData constructionData;
    private ThreatShipConstructionScript constructionScript;
    protected boolean attackSwarm = false;
    protected boolean constructionSwarm = false;
    protected boolean reclamationSwarm = false;

    public static boolean isAttackSwarm(ShipAPI ship) {
        return ship != null && ship.getVariant().getHullVariantId().equals(SwarmLauncherEffect.ATTACK_SWARM_VARIANT);
    }

    public static boolean isConstructionSwarm(ShipAPI ship) {
        return ship != null && ship.getVariant().getHullVariantId().equals(SwarmLauncherEffect.CONSTRUCTION_SWARM_VARIANT);
    }

    public static boolean isReclamationSwarm(ShipAPI ship) {
        return ship != null && ship.getVariant().getHullVariantId().equals(SwarmLauncherEffect.RECLAMATION_SWARM_VARIANT);
    }

    public ThreatSwarmAI(ShipAPI ship) {
        this.ship = ship;
        this.attackSwarm = ThreatSwarmAI.isAttackSwarm(ship);
        this.constructionSwarm = ThreatSwarmAI.isConstructionSwarm(ship);
        this.reclamationSwarm = ThreatSwarmAI.isReclamationSwarm(ship);
        this.doInitialSetup();
        this.updateInterval.forceIntervalElapsed();
        this.headingInterval.forceIntervalElapsed();
        this.attackRangeMultInterval.forceIntervalElapsed();
        this.priorityTargetPickerInterval.forceIntervalElapsed();
    }

    public SharedSwarmWingData getShared() {
        if (this.ship.getWing() == null) {
            return new SharedSwarmWingData();
        }
        String key = "SharedSwarmWingData";
        SharedSwarmWingData data = (SharedSwarmWingData)this.ship.getWing().getCustomData().get(key);
        if (data == null) {
            data = new SharedSwarmWingData();
            this.ship.getWing().getCustomData().put(key, data);
        }
        return data;
    }

    protected void doInitialSetup() {
        if (this.attackSwarm) {
            this.toggleOn(0);
            this.toggleOn(1);
            this.toggleOff(2);
            this.toggleOff(3);
            this.toggleOff(4);
            this.ship.giveCommand(ShipCommand.SELECT_GROUP, null, 6);
        }
    }

    protected void toggleOn(int groupNum) {
        List<WeaponGroupAPI> groups = this.ship.getWeaponGroupsCopy();
        if (groups.size() <= groupNum) {
            return;
        }
        groups.get(groupNum).toggleOn();
    }

    protected void toggleOff(int groupNum) {
        List<WeaponGroupAPI> groups = this.ship.getWeaponGroupsCopy();
        if (groups.size() <= groupNum) {
            return;
        }
        groups.get(groupNum).toggleOff();
    }

    protected void advanceForSpecificSwarmType(float amount) {
        if (this.attackSwarm) {
            if (this.ship.isWingLeader()) {
                this.priorityTargetPickerInterval.advance(amount);
                if (this.priorityTargetPickerInterval.intervalElapsed()) {
                    this.pickPriorityTarget();
                }
            }
            this.attackRangeMultInterval.advance(amount * 0.1f);
            if (this.attackRangeMultInterval.intervalElapsed()) {
                this.updateAttackRangeMult();
            }
            if (this.enableOtherWeaponDuration > 0.0f) {
                this.enableOtherWeaponDuration -= amount;
                if (this.enableOtherWeaponDuration <= 0.0f) {
                    this.toggleOff(2);
                    this.toggleOff(3);
                    this.toggleOff(4);
                }
            } else {
                boolean phaseMode = VoltaicDischargeOnFireEffect.isSwarmPhaseMode(this.ship);
                this.enableOtherWeaponInterval.advance(amount * 5.0f);
                if (this.enableOtherWeaponInterval.intervalElapsed() && (float)Math.random() < PROB_ENABLE_OTHER_GROUP) {
                    this.toggleOff(2);
                    this.toggleOff(3);
                    this.toggleOff(4);
                    ShipAPI target = (ShipAPI)this.flags.getCustom(ShipwideAIFlags.AIFlags.MANEUVER_TARGET);
                    boolean useSeeker = this.ship.getHullLevel() < 0.22f;
                    boolean useKinetic = true;
                    if (target == null || target.isFighter()) {
                        useSeeker = false;
                        useKinetic = false;
                    }
                    if (useSeeker) {
                        this.toggleOn(3);
                    } else if (useKinetic) {
                        this.toggleOn(2);
                    }
                    this.enableOtherWeaponDuration = 0.5f + 0.5f * (float)Math.random();
                }
            }
        }
        if (this.constructionSwarm) {
            RoilingSwarmEffect swarm;
            if (this.constructionData == null && (swarm = RoilingSwarmEffect.getSwarmFor(this.ship)) != null) {
                this.constructionData = (ConstructionSwarmSystemScript.SwarmConstructionData)swarm.custom1;
            }
            if (this.constructionData != null && this.elapsed > this.constructionData.preConstructionTravelTime && !this.startedConstruction) {
                this.startedConstruction = true;
                RoilingSwarmEffect swarm2 = RoilingSwarmEffect.getSwarmFor(this.ship);
                if (swarm2 != null) {
                    this.constructionScript = new ThreatShipConstructionScript(this.constructionData.variantId, this.ship, 0.0f, this.constructionData.constructionTime);
                    Global.getCombatEngine().addPlugin(this.constructionScript);
                }
            }
        }
        if (this.reclamationSwarm) {
            if (this.fabricator == null) {
                this.reclamationReturnInterval.advance(amount);
                if (this.reclamationReturnInterval.intervalElapsed()) {
                    int owner = this.ship.getOriginalOwner();
                    CombatEngineAPI engine = Global.getCombatEngine();
                    for (ShipAPI curr : engine.getShips()) {
                        float dist;
                        if (curr == this.ship || curr.getOwner() != owner || curr.isHulk() || curr.getOwner() == 100 || !ThreatCombatStrategyAI.isFabricator(curr) || !((dist = Misc.getDistance(curr.getLocation(), this.ship.getLocation())) < curr.getCollisionRadius() + 200.0f)) continue;
                        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(this.ship);
                        swarm.params.flashFrequency = 0.0f;
                        swarm.params.flashProbability = 0.0f;
                        this.fabricator = curr;
                        break;
                    }
                }
            } else {
                this.sinceTurnedOffFlash += amount;
                if (this.sinceTurnedOffFlash > 3.0f) {
                    CombatEngineAPI engine = Global.getCombatEngine();
                    if (this.fabricator.isAlive()) {
                        this.fabricator.setCurrentCR(Math.min(1.0f, this.fabricator.getCurrentCR() + 0.01f * this.ship.getHullLevel()));
                        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(this.ship);
                        RoilingSwarmEffect swarmFabricator = RoilingSwarmEffect.getSwarmFor(this.fabricator);
                        if (swarm != null && swarmFabricator != null) {
                            swarm.transferMembersTo(swarmFabricator, swarm.getNumActiveMembers());
                        }
                    }
                    this.ship.setHitpoints(0.0f);
                    this.ship.setSpawnDebris(false);
                    engine.applyDamage(this.ship, this.ship.getLocation(), 100.0f, DamageType.ENERGY, 0.0f, true, false, this.ship, false);
                }
            }
        }
    }

    protected void pickPriorityTarget() {
        SharedSwarmWingData data = this.getShared();
        if (data.target != null && data.target.isAlive()) {
            return;
        }
        WeightedRandomPicker<ShipAPI> picker = new WeightedRandomPicker<ShipAPI>();
        CombatEngineAPI engine = Global.getCombatEngine();
        int owner = this.ship.getOriginalOwner();
        for (ShipAPI curr : engine.getShips()) {
            if (curr == this.ship || curr.isFighter() || curr.isHulk() || curr.getOwner() == 100 || curr.getOwner() == owner || !engine.isAwareOf(owner, curr)) continue;
            float weight = ThreatSwarmAI.getShipWeight(curr);
            if (curr.isFrigate()) {
                weight *= 1.0E-4f;
            }
            picker.add(curr, weight);
        }
        data.target = (ShipAPI)picker.pick();
    }

    protected void updateAttackRangeMult() {
        this.attackRangeMult = 0.5f + 1.0f * (float)Math.random();
    }

    @Override
    public void advance(float amount) {
        this.elapsed += amount;
        this.advanceForSpecificSwarmType(amount);
        this.updateInterval.advance(amount);
        if (this.updateInterval.intervalElapsed()) {
            this.updateFlockingData();
        }
        this.headingInterval.advance(amount * 5.0f);
        if (this.headingInterval.intervalElapsed()) {
            this.computeDesiredHeading();
            this.elapsedSincePrevHeadingUpdate = 0.0f;
        }
        this.giveMovementCommands();
        this.elapsedSincePrevHeadingUpdate += amount;
    }

    protected void giveMovementCommands() {
        if (this.constructionScript != null && this.constructionScript.getShip() != null) {
            this.ship.giveCommand(ShipCommand.DECELERATE, null, 0);
            return;
        }
        String source = "swarm_wingman_catch_up_speed_bonus";
        MutableShipStatsAPI stats = this.ship.getMutableStats();
        if (this.ship.isWingLeader() || this.ship.getWingLeader() == null) {
            stats.getMaxSpeed().unmodifyMult(source);
            stats.getAcceleration().unmodifyMult(source);
            stats.getDeceleration().unmodifyMult(source);
        } else {
            ShipAPI leader = this.ship.getWingLeader();
            float dist = Misc.getDistance(this.ship.getLocation(), leader.getLocation());
            float mult = (dist - COHESION_RANGE_MAX * 0.5f - this.ship.getCollisionRadius() * 0.5f - leader.getCollisionRadius() * 0.5f) / COHESION_RANGE_MAX;
            if (mult < 0.0f) {
                mult = 0.0f;
            }
            if (mult > 1.0f) {
                mult = 1.0f;
            }
            stats.getMaxSpeed().modifyMult(source, 1.0f + 0.25f * mult);
            stats.getAcceleration().modifyMult(source, 1.0f + 0.5f * mult);
            stats.getDeceleration().modifyMult(source, 1.0f + 0.5f * mult);
        }
        float useHeading = this.desiredHeading;
        CombatEngineAPI engine = Global.getCombatEngine();
        engine.headInDirectionWithoutTurning(this.ship, useHeading, 10000.0f);
        Misc.turnTowardsFacingV2(this.ship, useHeading, 0.0f);
    }

    protected void computeDesiredHeading() {
        Vector2f loc = this.ship.getLocation();
        Vector2f vel = this.ship.getVelocity();
        float facing = this.ship.getFacing();
        Vector2f total = new Vector2f();
        for (FlockingData curr : this.flockingData) {
            Vector2f dir;
            float dist = Misc.getDistance(curr.loc, loc);
            if (curr.maxR > 0.0f && dist < curr.maxR) {
                float repelWeight = curr.repelWeight;
                if (dist > curr.minR && curr.maxR > curr.minR) {
                    repelWeight = (dist - curr.minR) / (curr.maxR - curr.minR);
                    if (repelWeight > 1.0f) {
                        repelWeight = 1.0f;
                    }
                    repelWeight = 1.0f - repelWeight;
                    repelWeight *= curr.repelWeight;
                }
                dir = Misc.getUnitVector(curr.loc, loc);
                float distIntoRepel = curr.maxR - dist;
                float repelAdjustmentAngle = 0.0f;
                if (distIntoRepel < curr.repelAtAngleDist && curr.repelAtAngleDist > 0.0f) {
                    float repelMult = 1.0f - distIntoRepel / curr.repelAtAngleDist;
                    repelAdjustmentAngle = 90.0f * repelMult;
                    repelWeight *= 1.0f - repelMult;
                    float repelAngle = Misc.getAngleInDegrees(dir);
                    float turnDir = Misc.getClosestTurnDirection(dir, vel);
                    dir = Misc.getUnitVectorAtDegreeAngle(repelAngle + (repelAdjustmentAngle *= turnDir));
                }
                dir.scale(repelWeight);
                Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
            }
            if (curr.maxA > 0.0f && dist < curr.maxA) {
                float attractWeight = curr.attractWeight;
                if (dist > curr.minA && curr.maxA > curr.minA) {
                    attractWeight = (dist - curr.minA) / (curr.maxA - curr.minA);
                    if (attractWeight > 1.0f) {
                        attractWeight = 1.0f;
                    }
                    attractWeight = 1.0f - attractWeight;
                    attractWeight *= curr.attractWeight;
                }
                dir = Misc.getUnitVector(loc, curr.loc);
                dir.scale(attractWeight);
                Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
            }
            if (!(curr.maxC > 0.0f) || !(dist < curr.maxC)) continue;
            float cohesionWeight = curr.cohesionWeight;
            if (dist > curr.minC && curr.maxC > curr.minC) {
                cohesionWeight = (dist - curr.minC) / (curr.maxC - curr.minC);
                if (cohesionWeight > 1.0f) {
                    cohesionWeight = 1.0f;
                }
                cohesionWeight = 1.0f - cohesionWeight;
                cohesionWeight *= curr.cohesionWeight;
            }
            dir = new Vector2f((ReadableVector2f)curr.vel);
            Misc.normalise(dir);
            dir.scale(cohesionWeight);
            Vector2f.add((Vector2f)total, (Vector2f)dir, (Vector2f)total);
        }
        if (total.length() <= 0.0f) {
            this.desiredHeading = this.ship.getFacing();
            this.headingChangeRate = this.ship.getAngularVelocity() * 0.5f;
        } else {
            float prev = this.desiredHeading;
            this.desiredHeading = Misc.getAngleInDegrees(total);
            this.headingChangeRate = this.elapsedSincePrevHeadingUpdate > 0.0f ? Misc.getAngleDiff(prev, this.desiredHeading) / this.elapsedSincePrevHeadingUpdate : this.ship.getAngularVelocity() * 0.5f;
        }
    }

    protected void updateFlockingData() {
        float dist;
        this.flockingData.clear();
        CombatEngineAPI engine = Global.getCombatEngine();
        if (this.constructionScript != null && this.constructionScript.getShip() != null) {
            return;
        }
        int owner = this.ship.getOriginalOwner();
        FighterWingAPI wing = this.ship.getWing();
        if (wing == null) {
            return;
        }
        Vector2f loc = this.ship.getLocation();
        boolean wingLeader = this.ship.isWingLeader();
        float attackRange = wing.getSpec().getAttackRunRange();
        attackRange *= this.attackRangeMult;
        float radius = this.ship.getCollisionRadius() * 0.5f;
        RoilingSwarmEffect swarm = RoilingSwarmEffect.getSwarmFor(this.ship);
        if (swarm != null) {
            radius = swarm.params.maxOffset;
        }
        SharedSwarmWingData shared = this.getShared();
        ShipAPI target = null;
        float targetDist = Float.MAX_VALUE;
        for (ShipAPI shipAPI : engine.getShips()) {
            FlockingData data;
            float currRadius;
            if (shipAPI == this.ship || shipAPI.isFighter() && (!shipAPI.isWingLeader() || shipAPI.getOwner() == owner || !this.attackSwarm)) continue;
            if (this.constructionSwarm) {
                currRadius = shipAPI.getCollisionRadius() * 2.0f;
                data = new FlockingData();
                data.facing = shipAPI.getFacing();
                data.loc = shipAPI.getLocation();
                data.vel = shipAPI.getVelocity();
                data.attractWeight = 0.0f;
                data.repelWeight = ThreatSwarmAI.getShipWeight(shipAPI) * 1.0f;
                data.minA = 0.0f;
                data.maxA = 0.0f;
                data.minR = radius + currRadius;
                data.maxR = radius + currRadius + Math.min(100.0f, currRadius * 1.0f);
                data.repelAtAngleDist = (data.maxR - data.minR) * 0.5f;
                this.flockingData.add(data);
                continue;
            }
            if (shipAPI.isHulk() || shipAPI.getOwner() == 100) continue;
            if (this.reclamationSwarm) {
                if (!ThreatCombatStrategyAI.isFabricator(shipAPI) || shipAPI.getOwner() != owner) continue;
                currRadius = shipAPI.getCollisionRadius() * 0.5f;
                data = new FlockingData();
                data.facing = shipAPI.getFacing();
                data.loc = shipAPI.getLocation();
                data.vel = shipAPI.getVelocity();
                data.attractWeight = ThreatSwarmAI.getShipWeight(shipAPI) * (1.0f - this.ship.getCurrentCR());
                data.repelWeight = data.attractWeight * 10.0f;
                data.minA = radius + currRadius;
                data.maxA = 1000000.0f;
                data.minR = radius + currRadius;
                data.maxR = radius + currRadius + 100.0f;
                data.repelAtAngleDist = (data.maxR - data.minR) * 0.5f;
                this.flockingData.add(data);
                continue;
            }
            currRadius = shipAPI.getCollisionRadius() * 0.5f;
            if (shipAPI.getOwner() != owner && engine.isAwareOf(owner, shipAPI)) {
                data = new FlockingData();
                data.facing = shipAPI.getFacing();
                data.loc = shipAPI.getLocation();
                data.vel = shipAPI.getVelocity();
                data.attractWeight = ThreatSwarmAI.getShipWeight(shipAPI);
                data.repelWeight = data.attractWeight * 10.0f;
                data.minA = attackRange + radius + currRadius;
                data.maxA = 1000000.0f;
                data.repelAtAngleDist = Math.min(attackRange * 0.5f, 400.0f);
                data.minR = radius + currRadius;
                data.maxR = attackRange + radius + currRadius;
                if (shipAPI == shared.target) {
                    float maxDiff;
                    float angleDiffFromFront = Misc.getAngleDiff(shipAPI.getFacing(), Misc.getAngleInDegrees(shipAPI.getLocation(), this.ship.getLocation()));
                    if (angleDiffFromFront < (maxDiff = 45.0f)) {
                        data.minR += (data.maxR - data.minR) * 0.5f;
                        data.minR += 500.0f * (1.0f - angleDiffFromFront / maxDiff);
                        data.maxR += 500.0f * (1.0f - angleDiffFromFront / maxDiff);
                        data.repelAtAngleDist += 500.0f * (1.0f - angleDiffFromFront / maxDiff);
                    }
                    data.attractWeight += 200.0f;
                    data.repelWeight += 600.0f;
                }
                this.flockingData.add(data);
                dist = Misc.getDistance(loc, shipAPI.getLocation());
                if (dist < targetDist && dist < MAX_TARGET_RANGE) {
                    target = shipAPI;
                    targetDist = dist;
                }
                if (!shipAPI.isDestroyer() && !shipAPI.isCruiser() && !shipAPI.isCapital() || shipAPI != shared.target) continue;
                data = new FlockingData();
                Vector2f dir = Misc.getUnitVectorAtDegreeAngle(shipAPI.getFacing() + 180.0f);
                dir.scale(shipAPI.getCollisionRadius() * 0.5f + attackRange * this.attackRangeMult);
                data.facing = shipAPI.getFacing();
                data.loc = Vector2f.add((Vector2f)shipAPI.getLocation(), (Vector2f)dir, (Vector2f)new Vector2f());
                data.vel = shipAPI.getVelocity();
                data.attractWeight = ThreatSwarmAI.getShipWeight(shipAPI) * 1.0f;
                data.minA = attackRange + radius + currRadius;
                data.maxA = 1000000.0f;
                if (shipAPI == shared.target) {
                    data.attractWeight += 200.0f;
                }
                this.flockingData.add(data);
                continue;
            }
            if (shipAPI.getOwner() != owner) continue;
            data = new FlockingData();
            data.facing = shipAPI.getFacing();
            data.loc = shipAPI.getLocation();
            data.vel = shipAPI.getVelocity();
            data.attractWeight = ThreatSwarmAI.getShipWeight(shipAPI) * 0.1f;
            data.repelWeight = data.attractWeight * 50.0f;
            data.minA = attackRange + radius + currRadius;
            data.maxA = 1000000.0f;
            data.minR = radius + currRadius;
            data.maxR = attackRange * 0.75f + radius + currRadius;
            data.repelAtAngleDist = Math.min(attackRange * 0.5f, 400.0f);
            this.flockingData.add(data);
        }
        if (target != null) {
            this.flags.setFlag(ShipwideAIFlags.AIFlags.MANEUVER_TARGET, 3.0f, target);
        } else {
            this.flags.unsetFlag(ShipwideAIFlags.AIFlags.MANEUVER_TARGET);
        }
        if (this.flockingData.isEmpty() && !this.constructionSwarm) {
            FlockingData flockingData = new FlockingData();
            flockingData.facing = 0.0f;
            flockingData.loc = new Vector2f();
            flockingData.vel = new Vector2f();
            flockingData.attractWeight = 5.0f;
            flockingData.repelWeight = flockingData.attractWeight * 10.0f;
            flockingData.minA = 1000.0f;
            flockingData.maxA = 1000000.0f;
            flockingData.minR = 1000.0f;
            flockingData.maxR = 3000.0f;
            flockingData.repelAtAngleDist = 1000.0f;
            this.flockingData.add(flockingData);
        }
        if (swarm != null && swarm.params.flockingClass != null && swarm.attachedTo != null) {
            for (RoilingSwarmEffect roilingSwarmEffect : RoilingSwarmEffect.getFlockingMap().getList(swarm.params.flockingClass)) {
                if (roilingSwarmEffect == swarm || roilingSwarmEffect.attachedTo == this.ship || roilingSwarmEffect.attachedTo == null || roilingSwarmEffect.attachedTo.getOwner() != owner || !swarm.params.flockingClass.equals(roilingSwarmEffect.params.flockingClass)) continue;
                if (this.constructionSwarm) {
                    float currRadius = roilingSwarmEffect.params.maxOffset;
                    FlockingData data = new FlockingData();
                    data.facing = roilingSwarmEffect.attachedTo.getFacing();
                    data.loc = roilingSwarmEffect.attachedTo.getLocation();
                    data.vel = roilingSwarmEffect.attachedTo.getVelocity();
                    data.attractWeight = 0.0f;
                    data.repelWeight = 8.0f;
                    data.minA = 0.0f;
                    data.maxA = 0.0f;
                    data.minR = radius + currRadius;
                    data.maxR = radius + currRadius + Math.min(100.0f, currRadius * 1.0f);
                    data.repelAtAngleDist = (data.maxR - data.minR) * 0.5f;
                    this.flockingData.add(data);
                    continue;
                }
                boolean sameWing = wing == ((ShipAPI)roilingSwarmEffect.attachedTo).getWing();
                boolean otherWingLeader = ((ShipAPI)roilingSwarmEffect.attachedTo).isWingLeader();
                if (wingLeader && sameWing || !sameWing && (dist = Misc.getDistance(loc, roilingSwarmEffect.attachedTo.getLocation())) > ATTRACTOR_RANGE_MAX + 500.0f) continue;
                float currRadius = roilingSwarmEffect.attachedTo.getCollisionRadius() * 0.5f;
                FlockingData data = new FlockingData();
                data.facing = roilingSwarmEffect.attachedTo.getFacing();
                data.loc = roilingSwarmEffect.attachedTo.getLocation();
                data.vel = roilingSwarmEffect.attachedTo.getVelocity();
                data.attractWeight = 1.0f;
                data.repelWeight = 10.0f;
                data.cohesionWeight = 1.0f;
                if (sameWing) {
                    data.attractWeight = wingLeader ? 0.1f : 3.0f;
                    data.minA = 0.0f + radius + currRadius;
                    data.maxA = ATTRACTOR_RANGE_MAX_SAME_WING + radius + currRadius;
                } else {
                    data.minA = 0.0f + radius + currRadius;
                    data.maxA = ATTRACTOR_RANGE_MAX + radius + currRadius;
                }
                data.minR = REPEL_RANGE_MIN + radius + currRadius;
                data.maxR = REPEL_RANGE_MAX + radius + currRadius;
                if (wingLeader && otherWingLeader) {
                    data.maxR = ATTRACTOR_RANGE_MAX + radius + currRadius;
                }
                data.minC = COHESION_RANGE_MIN + radius + currRadius;
                data.maxC = COHESION_RANGE_MAX + radius + currRadius;
                if (this.reclamationSwarm) {
                    data.minR *= 0.33f;
                    data.maxR *= 0.33f;
                }
                this.flockingData.add(data);
            }
        }
    }

    @Override
    public ShipwideAIFlags getAIFlags() {
        return this.flags;
    }

    public static float getShipWeight(ShipAPI ship) {
        return ThreatSwarmAI.getShipWeight(ship, true);
    }

    public static float getShipWeight(ShipAPI ship, boolean adjustForNonCombat) {
        boolean nonCombat = ship.isNonCombat(false);
        float weight = 0.0f;
        switch (ship.getHullSize()) {
            case CAPITAL_SHIP: {
                weight += 8.0f;
                break;
            }
            case CRUISER: {
                weight += 4.0f;
                break;
            }
            case DESTROYER: {
                weight += 2.0f;
                break;
            }
            case FRIGATE: {
                weight += 1.0f;
                break;
            }
            case FIGHTER: {
                weight += 1.0f;
            }
        }
        if (nonCombat && adjustForNonCombat) {
            weight *= 0.25f;
        }
        if (ship.isDrone()) {
            weight *= 0.1f;
        }
        return weight;
    }

    @Override
    public void setDoNotFireDelay(float amount) {
    }

    @Override
    public void forceCircumstanceEvaluation() {
    }

    @Override
    public boolean needsRefit() {
        return false;
    }

    @Override
    public void cancelCurrentManeuver() {
    }

    @Override
    public ShipAIConfig getConfig() {
        return null;
    }

    public static class FlockingData {
        public Vector2f loc;
        public Vector2f vel;
        public float minA;
        public float maxA;
        public float minR;
        public float maxR;
        public float repelAtAngleDist;
        public float minC;
        public float maxC;
        public float attractWeight;
        public float repelWeight;
        public float cohesionWeight;
        public float facing;
    }

    public static class SharedSwarmWingData {
        public ShipAPI target = null;
    }
}

