/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.ui;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.ui.MapFilterData;
import com.fs.starfarer.api.ui.MarkerData;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MapParams {
    public static final float GRID_SIZE_MAP_UNITS = 2000.0f;
    public static final float GRID_SIZE_PIXELS = 75.0f;
    public SectorEntityToken entityToShow;
    public MapFilterData filterData = null;
    public boolean smallConstellations = false;
    public List<IntelInfoPlugin.ArrowData> arrows = new ArrayList<IntelInfoPlugin.ArrowData>();
    public boolean showFilter = false;
    public boolean smallFilter = true;
    public boolean showTabs = false;
    public float starSelectionRadiusMult = 1.0f;
    public float starAlphaMult = 1.0f;
    public boolean useFullAlphaForShownSystems = false;
    public Color borderColor = null;
    public boolean renderTopBorder = true;
    public float maxZoomMapSizePadding = 4000.0f;
    public float zoomLevel = 0.0f;
    public LocationAPI location = null;
    public Set<StarSystemAPI> showSystems = null;
    public Set<Constellation> showConsellations = null;
    public Vector2f centerOn = null;
    public List<MarkerData> markers = null;
    public boolean withLayInCourse = false;
    public boolean skipCurrLocMarkerRendering = false;

    public MapParams() {
        this.filterData = new MapFilterData(false);
        this.filterData.starscape = true;
        this.filterData.names = true;
        this.starSelectionRadiusMult = 0.8f;
        this.starAlphaMult = 0.5f;
        this.borderColor = Misc.getDarkPlayerColor();
        this.renderTopBorder = true;
        this.location = Global.getSector().getHyperspace();
        this.zoomLevel = 1.0f;
        Vector2f loc = Global.getSector().getPlayerFleet().getLocationInHyperspace();
        this.centerOn = new Vector2f((ReadableVector2f)loc);
    }

    public void positionToShowAllMarkersAndSystems(boolean showPlayerFleet, float heightOnScreen) {
        Vector2f loc;
        Vector2f p;
        Vector2f center = new Vector2f();
        float total = 0.0f;
        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        MarkerData playerMarker = null;
        if (showPlayerFleet) {
            this.skipCurrLocMarkerRendering = true;
            if (this.markers == null) {
                this.markers = new ArrayList<MarkerData>();
            }
            playerMarker = new MarkerData(player.getLocationInHyperspace(), null, null);
            this.markers.add(playerMarker);
        }
        Vector2f min = new Vector2f();
        Vector2f max = new Vector2f();
        if (this.showSystems != null) {
            for (StarSystemAPI starSystemAPI : this.showSystems) {
                p = starSystemAPI.getLocation();
                min.x = Math.min(min.x, p.x);
                min.y = Math.min(min.y, p.y);
                max.x = Math.max(max.x, p.x);
                max.y = Math.max(max.y, p.y);
                Vector2f.add((Vector2f)center, (Vector2f)p, (Vector2f)center);
                total += 1.0f;
            }
        }
        if (this.markers != null) {
            for (MarkerData markerData : this.markers) {
                if (markerData == playerMarker) continue;
                p = markerData.coordinates;
                min.x = Math.min(min.x, p.x);
                min.y = Math.min(min.y, p.y);
                max.x = Math.max(max.x, p.x);
                max.y = Math.max(max.y, p.y);
                Vector2f.add((Vector2f)center, (Vector2f)p, (Vector2f)center);
                total += 1.0f;
            }
        }
        if (total > 0.0f) {
            center.scale(1.0f / total);
        }
        float f = 0.0375f;
        float distance = Misc.getDistance(player.getLocationInHyperspace(), center);
        Vector2f diff = Vector2f.sub((Vector2f)max, (Vector2f)min, (Vector2f)new Vector2f());
        distance += diff.length() * 0.5f;
        distance *= 1.2f;
        float maxShown = heightOnScreen;
        float zoom = (float)Math.ceil((distance *= f) / maxShown) + 1.0f;
        if (zoom < 3.0f) {
            zoom = 3.0f;
        }
        this.zoomLevel = zoom;
        this.centerOn = loc = Misc.interpolateVector(Global.getSector().getPlayerFleet().getLocationInHyperspace(), center, 0.5f);
    }

    public void showSystem(StarSystemAPI system) {
        if (this.showSystems == null) {
            this.showSystems = new HashSet<StarSystemAPI>();
        }
        this.showSystems.add(system);
    }

    public void showMarket(MarketAPI market) {
        float scale = 1.0f;
        if (market != null && !market.isPlanetConditionMarketOnly()) {
            scale = MarkerData.getScaleForMarket(market);
        }
        this.showMarket(market, scale);
    }

    public void showMarket(MarketAPI market, float scale) {
        if (this.markers == null) {
            this.markers = new ArrayList<MarkerData>();
        }
        this.markers.add(new MarkerData(market.getLocationInHyperspace(), null, market.getFaction().getBaseUIColor(), scale));
    }
}

