/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.util.ColorShifterAPI;
import com.fs.starfarer.api.util.FaderUtil;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ColorShifterUtil
implements ColorShifterAPI {
    protected Color base;
    protected Color curr;
    protected boolean useSquareOfProgress = true;
    protected Map<Object, ShiftData2> data = new LinkedHashMap<Object, ShiftData2>();

    public ColorShifterUtil(Color base) {
        this.base = base;
        this.curr = base;
    }

    public boolean isUseSquareOfProgress() {
        return this.useSquareOfProgress;
    }

    public void setUseSquareOfProgress(boolean useSquareOfProgress) {
        this.useSquareOfProgress = useSquareOfProgress;
    }

    @Override
    public Color getBase() {
        return this.base;
    }

    @Override
    public void setBase(Color base) {
        this.base = base;
    }

    @Override
    public Color getCurr() {
        return this.curr;
    }

    @Override
    public void shift(Object source, Color to, float durIn, float durOut, float shift) {
        if (to == null) {
            this.data.remove(source);
            return;
        }
        ShiftData2 sd = this.data.get(source);
        if (sd == null) {
            sd = new ShiftData2();
            sd.fader = new FaderUtil(0.0f, durIn, durOut);
            sd.fader.setBounceDown(true);
            this.data.put(source, sd);
        }
        sd.to = to;
        sd.shift = shift;
        sd.fader.setDuration(durIn, durOut);
        sd.fader.fadeIn();
        sd.nudged = true;
    }

    public void advance(float amount) {
        Iterator<ShiftData2> iter = this.data.values().iterator();
        while (iter.hasNext()) {
            ShiftData2 sd = iter.next();
            if (!sd.nudged) {
                sd.fader.fadeOut();
            }
            sd.nudged = false;
            sd.fader.advance(amount);
            if (!sd.fader.isFadedOut()) continue;
            iter.remove();
        }
        this.updateCurr();
    }

    public boolean isShifted() {
        return !this.data.isEmpty();
    }

    protected void updateCurr() {
        if (this.data.isEmpty()) {
            this.curr = this.base;
            return;
        }
        this.curr = this.getCurrForBase(this.base);
    }

    @Override
    public Color getCurrForBase(Color diffBase) {
        if (this.data == null || this.data.isEmpty()) {
            return diffBase;
        }
        float totalWeight = 0.0f;
        for (ShiftData2 sd : this.data.values()) {
            float progress = sd.fader.getBrightness();
            if (this.useSquareOfProgress) {
                progress *= progress;
            }
            totalWeight += progress;
        }
        if (totalWeight <= 0.0f) {
            return diffBase;
        }
        float red = diffBase.getRed();
        float green = diffBase.getGreen();
        float blue = diffBase.getBlue();
        float alpha = diffBase.getAlpha();
        for (ShiftData2 sd : this.data.values()) {
            float progress = sd.fader.getBrightness();
            if (this.useSquareOfProgress) {
                progress *= progress;
            }
            float currWeight = totalWeight - progress + 1.0f;
            red += ((float)sd.to.getRed() - (float)diffBase.getRed()) * sd.shift * progress / currWeight;
            green += ((float)sd.to.getGreen() - (float)diffBase.getGreen()) * sd.shift * progress / currWeight;
            blue += ((float)sd.to.getBlue() - (float)diffBase.getBlue()) * sd.shift * progress / currWeight;
            alpha += ((float)sd.to.getAlpha() - (float)diffBase.getAlpha()) * sd.shift * progress / currWeight;
        }
        if (red > 255.0f) {
            red = 255.0f;
        }
        if (green > 255.0f) {
            green = 255.0f;
        }
        if (blue > 255.0f) {
            blue = 255.0f;
        }
        if (alpha > 255.0f) {
            alpha = 255.0f;
        }
        if (red < 0.0f) {
            red = 0.0f;
        }
        if (green < 0.0f) {
            green = 0.0f;
        }
        if (blue < 0.0f) {
            blue = 0.0f;
        }
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        return new Color((int)red, (int)green, (int)blue, (int)alpha);
    }

    public static void main(String[] args) {
        ColorShifterUtil c = new ColorShifterUtil(Color.red);
        int i = 0;
        while (i < 10) {
            c.shift("c1", Color.green, 1.0f, 1.0f, 1.0f);
            c.shift("c2", Color.blue, 1.0f, 1.0f, 0.5f);
            c.advance(0.1f);
            ++i;
        }
        System.out.println(c.getCurr());
    }

    public static class ShiftData2 {
        public Color to;
        public FaderUtil fader;
        public float shift;
        public boolean nudged;
    }
}

