/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.util;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.lwjgl.util.vector.Vector2f;

public class RadialLattice {
    protected long updateTimestamp;
    protected List<RadialLatticeBucket> buckets = new ArrayList<RadialLatticeBucket>();
    protected int numBuckets = 8;
    protected float arc = 360 / this.numBuckets * 2 + 20;

    public void update() {
        this.buckets.clear();
        float anglePer = 360.0f / (float)(this.numBuckets * 2);
        int i = 0;
        while (i < this.numBuckets) {
            RadialLatticeBucket bucket = new RadialLatticeBucket((float)i * anglePer);
            this.buckets.add(bucket);
            ++i;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        Vector2f origin = playerFleet.getLocation();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            float f = Misc.getAngleInDegrees(origin, system.getLocation());
        }
    }

    public RadialLatticeBucket getBucket(float angle) {
        float anglePer;
        int index = (int)((angle = Misc.normalizeAngle(angle)) / (anglePer = 360.0f / (float)(this.numBuckets * 2)));
        if (index >= this.numBuckets) {
            index -= this.numBuckets;
        }
        return this.buckets.get(index);
    }

    public static class RadialLatticeBucket {
        public Set<StarSystemAPI> systems = new LinkedHashSet<StarSystemAPI>();
        public Set<MarketAPI> markets = new LinkedHashSet<MarketAPI>();
        public float angle;

        public RadialLatticeBucket(float angle) {
            this.angle = angle;
        }
    }
}

