/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign;

import com.fs.starfarer.D;
import com.fs.starfarer.D.M;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.characters.AfterShipCreationSkillEffect;
import com.fs.starfarer.api.characters.FleetTotalItem;
import com.fs.starfarer.api.characters.FleetTotalSource;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.SkillEffectType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.StatBonus;
import com.fs.starfarer.api.impl.campaign.intel.MessageIntel;
import com.fs.starfarer.api.impl.campaign.plog.PlaythroughLog;
import com.fs.starfarer.api.plugins.LevelupPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.combat.entities.ship.E;
import com.fs.starfarer.coreui.refit.auto.oooO;
import com.fs.starfarer.loading.SkillSpec;
import com.fs.starfarer.loading.SpecStore;
import com.fs.starfarer.loading.scripts.ScriptStore;
import com.fs.starfarer.settings.StarfarerSettings;
import com.fs.starfarer.util.DynamicStats;
import com.fs.util.DoNotObfuscate;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CharacterStats
implements DoNotObfuscate,
Cloneable,
MutableCharacterStatsAPI {
    private static Map<String, List<o>> effectCache;
    private transient List<AptitudeLevel> aptitudes = new ArrayList<AptitudeLevel>();
    private transient List<SkillLevel> skills = new ArrayList<SkillLevel>();
    private String a;
    private String s;
    private long xpAtLastStoryPointGain = 0L;
    private long xp = 0L;
    private long bonusXp = 0L;
    private long deferredBonusXp = 0L;
    private int level = 1;
    private int points = 0;
    private int storyPoints = 0;
    private CampaignFleetAPI fleet;
    private DynamicStats dynamic = new DynamicStats();
    private MutableStat adminNumber = new MutableStat(StarfarerSettings.\u00f600000("baseMaxAdmins"));
    private MutableStat outpostNumber = new MutableStat(StarfarerSettings.\u00f600000("baseMaxOutposts"));
    private MutableStat weaponOPCostMult = new MutableStat(1.0f);
    private StatBonus smallWeaponOPCost = new StatBonus();
    private StatBonus mediumWeaponOPCost = new StatBonus();
    private StatBonus largeWeaponOPCost = new StatBonus();
    private StatBonus shipOrdnancePointBonus = new StatBonus();
    private MutableStat repairRateMult = new MutableStat(1.0f);
    private MutableStat commandPoints = new MutableStat((float)StarfarerSettings.\u00f8\u00d20000());
    private MutableStat marineEffectivnessMult = new MutableStat(1.0f);
    private StatBonus combatDeploymentCost = new StatBonus();
    private StatBonus maxCapacitorsBonus = new StatBonus();
    private StatBonus maxVentsBonus = new StatBonus();
    private StatBonus travelSpeedBonus = new StatBonus();
    private MutableStat officerNumber = new MutableStat(StarfarerSettings.return.String());
    private transient String bonusXPGainReason = null;
    private transient boolean onlyAddBonusXPDoNotSpendStoryPoints = false;
    private transient boolean skipRefresh = true;

    public long getDeferredBonusXp() {
        return this.deferredBonusXp;
    }

    public void setDeferredBonusXp(long l2) {
        this.deferredBonusXp = l2;
    }

    public CharacterStats clone() {
        try {
            CharacterStats characterStats = (CharacterStats)super.clone();
            characterStats.aptitudes = new ArrayList<AptitudeLevel>();
            for (AptitudeLevel object : this.aptitudes) {
                characterStats.aptitudes.add(object.clone());
            }
            characterStats.skills = new ArrayList<SkillLevel>();
            for (SkillLevel skillLevel : this.skills) {
                characterStats.skills.add(skillLevel.clone());
            }
            characterStats.officerNumber = this.officerNumber.createCopy();
            characterStats.adminNumber = this.adminNumber.createCopy();
            characterStats.weaponOPCostMult = this.weaponOPCostMult.createCopy();
            characterStats.smallWeaponOPCost = this.smallWeaponOPCost.createCopy();
            characterStats.mediumWeaponOPCost = this.mediumWeaponOPCost.createCopy();
            characterStats.largeWeaponOPCost = this.largeWeaponOPCost.createCopy();
            characterStats.shipOrdnancePointBonus = this.shipOrdnancePointBonus.createCopy();
            characterStats.marineEffectivnessMult = this.marineEffectivnessMult.createCopy();
            characterStats.commandPoints = this.commandPoints.createCopy();
            characterStats.combatDeploymentCost = this.combatDeploymentCost.createCopy();
            characterStats.maxCapacitorsBonus = this.maxCapacitorsBonus.createCopy();
            characterStats.maxVentsBonus = this.maxVentsBonus.createCopy();
            characterStats.travelSpeedBonus = this.travelSpeedBonus.createCopy();
            characterStats.officerNumber = this.officerNumber.createCopy();
            if (this.dynamic != null) {
                characterStats.dynamic = new DynamicStats();
                for (String string : this.dynamic.getStats().keySet()) {
                    characterStats.dynamic.getStats().put(string, this.dynamic.getStats().get(string).createCopy());
                }
                for (String string : this.dynamic.getMods().keySet()) {
                    characterStats.dynamic.getMods().put(string, this.dynamic.getMods().get(string).createCopy());
                }
            }
            return characterStats;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean sameAs(CharacterStats characterStats) {
        if (characterStats == null) {
            return false;
        }
        if (characterStats.points != this.points) {
            return false;
        }
        if (characterStats.storyPoints != this.storyPoints) {
            return false;
        }
        for (SkillLevel skillLevel : this.skills) {
            if (skillLevel.getLevel() == characterStats.getSkillLevel(skillLevel.getSkill())) continue;
            return false;
        }
        for (SkillLevel skillLevel : characterStats.skills) {
            if (skillLevel.getLevel() == this.getSkillLevel(skillLevel.getSkill())) continue;
            return false;
        }
        return true;
    }

    public static Map<String, List<o>> getEffectCache() {
        if (effectCache == null) {
            effectCache = new HashMap<String, List<o>>();
        }
        return effectCache;
    }

    public long getBonusXp() {
        return this.bonusXp;
    }

    public void setBonusXp(long l2) {
        this.bonusXp = l2;
    }

    public void addBonusXP(long l2, boolean bl, TextPanelAPI textPanelAPI, boolean bl2) {
        if (l2 <= 0L) {
            return;
        }
        this.bonusXp += l2;
        if (CampaignEngine.getInstance().getPlayerStats() == this && bl) {
            String string = Misc.getWithDGS((float)l2);
            String string2 = "Gained " + string + " bonus experience";
            if (this.bonusXPGainReason != null) {
                string2 = String.valueOf(string2) + " " + this.bonusXPGainReason;
            }
            if (bl2 && textPanelAPI == null) {
                Global.getSector().getCampaignUI().getMessageDisplay().addMessage(string2, string, D.interface);
            } else if (textPanelAPI != null) {
                textPanelAPI.setFontSmallInsignia();
                textPanelAPI.addParagraph(string2, Misc.getStoryOptionColor());
                textPanelAPI.highlightLastInLastPara(string + " bonus experience", Misc.getStoryOptionColor());
                textPanelAPI.setFontInsignia();
            } else {
                MessageIntel messageIntel = new MessageIntel(string2, Misc.getBasePlayerColor(), new String[]{string}, new Color[]{Misc.getHighlightColor()});
                Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
            }
        }
    }

    public void spendStoryPoints(int n2, boolean bl, TextPanelAPI textPanelAPI, boolean bl2, String string) {
        this.spendStoryPoints(n2, bl, textPanelAPI, bl2, 0.0f, string);
    }

    public void setOnlyAddBonusXPDoNotSpendStoryPoints(boolean bl) {
        this.onlyAddBonusXPDoNotSpendStoryPoints = bl;
    }

    public void setBonusXPGainReason(String string) {
        this.bonusXPGainReason = string;
    }

    public void spendStoryPoints(int n2, boolean bl, TextPanelAPI textPanelAPI, boolean bl2, float f2, String string) {
        if (!this.onlyAddBonusXPDoNotSpendStoryPoints) {
            this.storyPoints -= n2;
        }
        if (this.storyPoints < 0) {
            this.storyPoints = 0;
        }
        if (CampaignEngine.getInstance().getPlayerStats() == this) {
            if (string != null) {
                PlaythroughLog.getInstance().addEntry(string);
            }
            if (bl && !this.onlyAddBonusXPDoNotSpendStoryPoints) {
                String string2 = "" + n2;
                String string3 = "point";
                if (n2 != 1) {
                    string3 = "points";
                }
                String string4 = "Used " + string2 + " " + Misc.STORY + " " + string3;
                if (bl2 && textPanelAPI == null) {
                    Global.getSector().getCampaignUI().getMessageDisplay().addMessage(string4, string2, D.interface);
                } else if (textPanelAPI != null) {
                    textPanelAPI.setFontSmallInsignia();
                    textPanelAPI.addParagraph(string4, Misc.getStoryOptionColor());
                    textPanelAPI.highlightLastInLastPara(string2 + " " + Misc.STORY + " " + string3, Misc.getStoryOptionColor());
                    textPanelAPI.setFontInsignia();
                } else {
                    MessageIntel messageIntel = new MessageIntel(string4, Misc.getBasePlayerColor(), new String[]{string2}, new Color[]{Misc.getHighlightColor()});
                    Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
                }
            }
            float f3 = 0.0f;
            int n3 = 0;
            while (n3 < n2) {
                boolean bl3;
                float f4 = Math.round((float)this.getTotalBonusAndDeferredXPForStoryPoint() * f2);
                float f5 = Math.round((float)this.getBonusXPForSpendingStoryPointBeforeSpendingIt() * f2);
                LevelupPlugin levelupPlugin = ScriptStore.o00000(LevelupPlugin.class);
                int n4 = levelupPlugin.getMaxLevel();
                boolean bl4 = bl3 = this.level >= n4;
                if (bl3) {
                    f5 = f4;
                }
                f3 += f5;
                this.deferredBonusXp = (long)((float)this.deferredBonusXp + Math.max(0.0f, f4 - f5));
                ++n3;
            }
            if (f3 > 0.0f) {
                this.addBonusXP(Math.round(f3), bl, textPanelAPI, bl2);
            }
        }
    }

    public long getXPThresholdForNextStoryPoint(long l2) {
        LevelupPlugin levelupPlugin = ScriptStore.o00000(LevelupPlugin.class);
        int n2 = levelupPlugin.getStoryPointsPerLevel();
        int n3 = levelupPlugin.getMaxLevel();
        long l3 = levelupPlugin.getXPForLevel(this.level);
        long l4 = levelupPlugin.getXPForLevel(this.level + 1);
        long l5 = (l4 - l3) / (long)n2;
        if (l5 <= 0L) {
            l5 = 100000L;
        }
        long l6 = l3;
        int n4 = this.level + 1;
        int n5 = 1;
        while ((l6 += l5) <= l2) {
            if (n5 % n2 == 0 && n4 < n3 + 1) {
                long l7 = l4;
                l4 = levelupPlugin.getXPForLevel(++n4);
                l5 = (l4 - l7) / (long)n2;
            }
            ++n5;
        }
        return l6;
    }

    public long getTotalBonusAndDeferredXPForStoryPoint() {
        LevelupPlugin levelupPlugin = ScriptStore.o00000(LevelupPlugin.class);
        int n2 = levelupPlugin.getStoryPointsPerLevel();
        int n3 = levelupPlugin.getMaxLevel() + 1;
        long l2 = levelupPlugin.getXPForLevel(n3 - 1);
        long l3 = levelupPlugin.getXPForLevel(n3);
        return (l3 - l2) / (long)n2;
    }

    public long getBonusXPForSpendingStoryPointBeforeSpendingIt() {
        LevelupPlugin levelupPlugin = ScriptStore.o00000(LevelupPlugin.class);
        int n2 = levelupPlugin.getStoryPointsPerLevel();
        int n3 = 1;
        while (levelupPlugin.getXPForLevel(n3 + 1) <= this.xp + this.bonusXp * 2L) {
            if (++n3 >= levelupPlugin.getMaxLevel()) break;
        }
        if (n3 < levelupPlugin.getMaxLevel() - 1) {
            long l2 = levelupPlugin.getXPForLevel(n3);
            long l3 = levelupPlugin.getXPForLevel(n3 + 1);
            long l4 = levelupPlugin.getXPForLevel(n3 + 2);
            float f2 = (float)(this.xp + this.bonusXp * 2L - l2) / (float)(l3 -= l2);
            float f3 = 1.0f / (float)n2;
            float f4 = f2 + f3 * 2.0f;
            float f5 = Math.max(0.0f, Math.min(1.0f, f4) - f2) * (float)l3;
            float f6 = Math.max(0.0f, f4 - 1.0f) * (float)((l4 -= l2) - l3);
            return Math.round((f5 + f6) * 0.5f);
        }
        int n4 = this.level + 1;
        n4 = Math.min(n4, levelupPlugin.getMaxLevel() + 1);
        long l5 = levelupPlugin.getXPForLevel(n4 - 1);
        long l6 = levelupPlugin.getXPForLevel(n4);
        return (l6 - l5) / (long)n2;
    }

    public int getStoryPoints() {
        return this.storyPoints;
    }

    public void setStoryPoints(int n2) {
        this.storyPoints = n2;
    }

    public void addStoryPoints(int n2) {
        this.storyPoints += n2;
        if (this.storyPoints < 0) {
            this.storyPoints = 0;
        }
    }

    public void addStoryPoints(int n2, TextPanelAPI textPanelAPI, boolean bl) {
        this.addStoryPoints(n2);
        M.super("ui_char_gained_story_point", 1.0f, 1.0f);
        String string = "points";
        if (n2 == 1) {
            string = "point";
        }
        String string2 = "Gained " + n2 + " " + Misc.STORY + " " + string;
        if (textPanelAPI != null) {
            textPanelAPI.setFontSmallInsignia();
            textPanelAPI.addParagraph(string2, D.oo0000);
            textPanelAPI.highlightLastInLastPara(n2 + " " + Misc.STORY + " " + string, Misc.getStoryOptionColor());
            textPanelAPI.setFontInsignia();
        } else {
            MessageIntel messageIntel = new MessageIntel(string2, Misc.getBasePlayerColor(), new String[]{n2 + " " + Misc.STORY + " " + string}, new Color[]{Misc.getStoryOptionColor()});
            messageIntel.setIcon(CampaignEngine.getInstance().getPlayerPerson().getPortraitSprite());
            Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel, CommMessageAPI.MessageClickAction.CHARACTER_TAB);
        }
        if (bl) {
            CampaignEngine.getInstance().getUIData().setOpenedCharacterTabSinceLevelUp(false);
        }
    }

    public MutableStat getAdminNumber() {
        return this.adminNumber;
    }

    public MutableStat getOutpostNumber() {
        return this.outpostNumber;
    }

    public DynamicStats getDynamic() {
        if (this.dynamic == null) {
            this.dynamic = new DynamicStats();
        }
        return this.dynamic;
    }

    public CharacterStats() {
        for (com.fs.starfarer.loading.E e2 : SpecStore.OO0000()) {
            this.setAptitudeLevel(e2.\u00f800000(), 0.0f);
        }
        this.skipRefresh = false;
    }

    public CampaignFleetAPI getFleet() {
        return this.fleet;
    }

    public void setFleet(CampaignFleetAPI campaignFleetAPI) {
        this.fleet = campaignFleetAPI;
    }

    Object readResolve() {
        Cloneable cloneable;
        String string;
        int n2;
        int n3;
        String[] stringArray;
        String[] stringArray2;
        this.aptitudes = new ArrayList<AptitudeLevel>();
        this.skills = new ArrayList<SkillLevel>();
        this.weaponOPCostMult = new MutableStat(1.0f);
        this.smallWeaponOPCost = new StatBonus();
        this.mediumWeaponOPCost = new StatBonus();
        this.largeWeaponOPCost = new StatBonus();
        this.marineEffectivnessMult = new MutableStat(1.0f);
        this.combatDeploymentCost = new StatBonus();
        this.maxCapacitorsBonus = new StatBonus();
        this.maxVentsBonus = new StatBonus();
        this.travelSpeedBonus = new StatBonus();
        this.shipOrdnancePointBonus = new StatBonus();
        this.officerNumber = new MutableStat(StarfarerSettings.return.String());
        this.adminNumber = new MutableStat(StarfarerSettings.\u00f600000("baseMaxAdmins"));
        this.outpostNumber = new MutableStat(StarfarerSettings.\u00f600000("baseMaxOutposts"));
        if (this.repairRateMult == null) {
            this.repairRateMult = new MutableStat(1.0f);
        }
        if (this.commandPoints == null) {
            this.commandPoints = new MutableStat((float)StarfarerSettings.\u00f8\u00d20000());
        }
        if (this.a != null) {
            try {
                JSONObject object2 = new JSONObject(this.a);
                stringArray2 = JSONObject.getNames((JSONObject)object2);
                if (stringArray2 != null) {
                    stringArray = stringArray2;
                    n3 = stringArray2.length;
                    n2 = 0;
                    while (n2 < n3) {
                        string = stringArray[n2];
                        cloneable = new AptitudeLevel(string);
                        cloneable.level = (float)object2.getDouble(string);
                        this.aptitudes.add((AptitudeLevel)cloneable);
                        ++n2;
                    }
                    Collections.sort(this.aptitudes, new Comparator<AptitudeLevel>(){

                        public int o00000(AptitudeLevel aptitudeLevel, AptitudeLevel aptitudeLevel2) {
                            return aptitudeLevel.aptitude.o00000() - aptitudeLevel2.aptitude.o00000();
                        }
                    });
                }
            }
            catch (JSONException jSONException) {
                throw new RuntimeException(jSONException);
            }
        }
        if (this.s != null) {
            try {
                JSONObject jSONException = new JSONObject(this.s);
                stringArray2 = JSONObject.getNames((JSONObject)jSONException);
                if (stringArray2 != null) {
                    stringArray = stringArray2;
                    n3 = stringArray2.length;
                    n2 = 0;
                    while (n2 < n3) {
                        string = stringArray[n2];
                        cloneable = new SkillLevel(string);
                        ((SkillLevel)cloneable).level = (float)jSONException.getDouble(string);
                        this.skills.add((SkillLevel)cloneable);
                        ++n2;
                    }
                }
            }
            catch (JSONException jSONException) {
                throw new RuntimeException(jSONException);
            }
        }
        for (com.fs.starfarer.loading.E e2 : SpecStore.OO0000()) {
            if (this.getAptitudeLevelAsLevel(e2.\u00f800000()) != null) continue;
            this.setAptitudeLevel(e2.\u00f800000(), 0.0f);
        }
        this.refreshCharacterStatsEffects();
        return this;
    }

    Object writeReplace() {
        JSONObject jSONObject;
        boolean bl;
        if (this.dynamic != null) {
            this.dynamic.removeUmodified();
            if (this.dynamic.isEmpty()) {
                this.dynamic = null;
            }
        }
        CharacterStats characterStats = this.clone();
        boolean bl2 = bl = Global.getSector().getCharacterData().getPerson().getStats() == this;
        if (!bl) {
            jSONObject = characterStats.aptitudes.iterator();
            while (jSONObject.hasNext()) {
                AptitudeLevel object3 = (AptitudeLevel)jSONObject.next();
                if (!(object3.getLevel() <= 0.0f) || !(characterStats.getSkillLevel(object3.getAptitude().public()) <= 0.0f)) continue;
                jSONObject.remove();
            }
            Iterator<SkillLevel> iterator = characterStats.skills.iterator();
            while (iterator.hasNext()) {
                SkillLevel skillLevel = iterator.next();
                if (!(skillLevel.getLevel() <= 0.0f)) continue;
                iterator.remove();
            }
        }
        try {
            jSONObject = new JSONObject();
            for (AptitudeLevel aptitudeLevel : characterStats.aptitudes) {
                jSONObject.put(aptitudeLevel.aptitude.\u00f800000(), (double)aptitudeLevel.level);
            }
            characterStats.a = jSONObject.toString();
            JSONObject jSONObject2 = new JSONObject();
            for (SkillLevel skillLevel : characterStats.skills) {
                jSONObject2.put(skillLevel.skill.getId(), (double)skillLevel.level);
            }
            characterStats.s = jSONObject2.toString();
            if (JSONObject.getNames((JSONObject)jSONObject) == null) {
                characterStats.a = null;
            }
            if (JSONObject.getNames((JSONObject)jSONObject2) == null) {
                characterStats.s = null;
            }
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
        if (this.isUnmodified(this.weaponOPCostMult) || !bl) {
            characterStats.weaponOPCostMult = null;
        }
        if (this.isUnmodified(this.smallWeaponOPCost) || !bl) {
            characterStats.smallWeaponOPCost = null;
        }
        if (this.isUnmodified(this.mediumWeaponOPCost) || !bl) {
            characterStats.mediumWeaponOPCost = null;
        }
        if (this.isUnmodified(this.largeWeaponOPCost) || !bl) {
            characterStats.largeWeaponOPCost = null;
        }
        if (this.isUnmodified(this.shipOrdnancePointBonus) || !bl) {
            characterStats.shipOrdnancePointBonus = null;
        }
        if (this.isUnmodified(this.repairRateMult) || !bl) {
            characterStats.repairRateMult = null;
        }
        if (this.isUnmodified(this.commandPoints) || !bl) {
            characterStats.commandPoints = null;
        }
        if (this.isUnmodified(this.marineEffectivnessMult) || !bl) {
            characterStats.marineEffectivnessMult = null;
        }
        if (this.isUnmodified(this.combatDeploymentCost) || !bl) {
            characterStats.combatDeploymentCost = null;
        }
        if (this.isUnmodified(this.maxCapacitorsBonus) || !bl) {
            characterStats.maxCapacitorsBonus = null;
        }
        if (this.isUnmodified(this.maxVentsBonus) || !bl) {
            characterStats.maxVentsBonus = null;
        }
        if (this.isUnmodified(this.travelSpeedBonus) || !bl) {
            characterStats.travelSpeedBonus = null;
        }
        if (this.isUnmodified(this.officerNumber) || !bl) {
            characterStats.officerNumber = null;
        }
        if (this.isUnmodified(this.adminNumber) || !bl) {
            characterStats.adminNumber = null;
        }
        if (this.isUnmodified(this.outpostNumber) || !bl) {
            characterStats.outpostNumber = null;
        }
        return characterStats;
    }

    private boolean isUnmodified(StatBonus statBonus) {
        return statBonus.getFlatBonuses().isEmpty() && statBonus.getMultBonuses().isEmpty() && statBonus.getPercentBonuses().isEmpty();
    }

    private boolean isUnmodified(MutableStat mutableStat) {
        return mutableStat.getFlatMods().isEmpty() && mutableStat.getMultMods().isEmpty() && mutableStat.getPercentMods().isEmpty();
    }

    public void increaseSkill(String string) {
        SkillLevel skillLevel = this.getSkillLevelAsLevel(string);
        if (skillLevel == null) {
            SkillSpec skillSpec = SpecStore.super(SkillSpec.class, string);
            skillLevel = new SkillLevel(skillSpec);
            this.skills.add(skillLevel);
        }
        skillLevel.level += 1.0f;
        int n2 = 1;
        if (skillLevel.getSkill().isElite()) {
            n2 = 2;
        }
        if (skillLevel.level > (float)n2) {
            skillLevel.level = n2;
        }
        this.refreshCharacterStatsEffects();
    }

    public boolean isSkipRefresh() {
        return this.skipRefresh;
    }

    public void setSkipRefresh(boolean bl) {
        this.skipRefresh = bl;
    }

    public void refreshCharacterStatsEffects() {
        this.refreshCharacterStatsEffects(true);
    }

    public void refreshCharacterStatsEffects(boolean bl) {
        Object object;
        if (this.skipRefresh) {
            return;
        }
        ListenerUtil.reportAboutToRefreshCharacterStatEffects();
        String string = "refreshCharacterStatsEffects";
        List<o> list = CharacterStats.getEffectCache().get(string);
        if (list == null) {
            list = new ArrayList<o>();
            CharacterStats.getEffectCache().put(string, list);
            ArrayList<String> arrayList2 = new ArrayList<String>(SpecStore.String(SkillSpec.class));
            for (String string2 : arrayList2) {
                object = SpecStore.super(SkillSpec.class, string2);
                int n2 = 0;
                for (SkillSpec.SkillEffectSpec skillEffectSpec : ((SkillSpec)object).getEffects()) {
                    if (skillEffectSpec.getType() == SkillEffectType.CHARACTER_STATS || skillEffectSpec.getType() == SkillEffectType.FLEET) {
                        String string3 = String.valueOf(((SkillSpec)object).getId()) + "_stats_" + n2;
                        list.add(new o(skillEffectSpec, string3));
                    }
                    ++n2;
                }
            }
        }
        for (o o2 : list) {
            if (o2.super.getType() == SkillEffectType.CHARACTER_STATS) {
                o2.super.getAsStatsEffect().unapply((MutableCharacterStatsAPI)this, o2.\u00d200000);
                continue;
            }
            if (o2.super.getType() != SkillEffectType.FLEET || this.fleet == null || this.fleet.getStats() == null) continue;
            o2.super.getAsFleetEffect().unapply(this.fleet.getStats(), o2.\u00d200000);
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (SkillLevel skillLevel : this.skills) {
            if (skillLevel.getSkill().isAptitudeEffect() || skillLevel.getLevel() <= 0.0f) continue;
            object = skillLevel.getSkill().getGoverningAptitudeId();
            Integer n3 = (Integer)hashMap.get(object);
            if (n3 == null) {
                n3 = 0;
            }
            n3 = Math.max(n3, skillLevel.getSkill().getTier());
            hashMap.put(object, n3);
        }
        for (AptitudeLevel aptitudeLevel : this.aptitudes) {
            object = (Integer)hashMap.get(aptitudeLevel.getAptitude().\u00f800000());
            if (object == null) {
                object = 0;
            }
            aptitudeLevel.setMaxTier((Integer)object);
        }
        for (o o3 : this.getStatsEffects()) {
            float f2 = this.getSkillLevel(o3.super.getGoverningSkill());
            o3.super.getAsStatsEffect().apply((MutableCharacterStatsAPI)this, o3.\u00d200000, f2);
        }
        if (this.fleet != null && this.fleet.getStats() != null) {
            for (o o4 : this.getFleetEffects()) {
                float f3 = this.getSkillLevel(o4.super.getGoverningSkill());
                o4.super.getAsFleetEffect().apply(this.fleet.getStats(), o4.\u00d200000, f3);
            }
        }
        if (CampaignEngine.getInstance().getPlayerStats() == this && bl) {
            this.refreshAllOutpostsEffectsForPlayerOutposts();
        }
        if (CampaignEngine.getInstance().getPlayerStats() == this) {
            ListenerUtil.reportRefreshedCharacterStatEffects();
        }
    }

    public void decreaseSkill(String string) {
        SkillLevel skillLevel = this.getSkillLevelAsLevel(string);
        if (skillLevel == null) {
            SkillSpec skillSpec = SpecStore.super(SkillSpec.class, string);
            skillLevel = new SkillLevel(skillSpec);
            this.skills.add(skillLevel);
        }
        skillLevel.level -= 1.0f;
        if (skillLevel.level < 0.0f) {
            skillLevel.level = 0.0f;
            this.skills.remove(skillLevel);
        }
        this.refreshCharacterStatsEffects();
    }

    public float getAptitudeLevel(String string) {
        for (AptitudeLevel aptitudeLevel : this.aptitudes) {
            if (!aptitudeLevel.getAptitude().\u00f800000().equals(string)) continue;
            return aptitudeLevel.getLevel();
        }
        return 0.0f;
    }

    public AptitudeLevel getAptitudeLevelAsLevel(String string) {
        for (AptitudeLevel aptitudeLevel : this.aptitudes) {
            if (!aptitudeLevel.getAptitude().\u00f800000().equals(string)) continue;
            return aptitudeLevel;
        }
        return null;
    }

    public float getSkillLevel(SkillSpec skillSpec) {
        return this.getSkillLevel(skillSpec.getId());
    }

    public float getSkillLevel(String string) {
        for (SkillLevel skillLevel : this.skills) {
            if (!skillLevel.getSkill().getId().equals(string)) continue;
            return skillLevel.getLevel();
        }
        return 0.0f;
    }

    public SkillLevel getSkillLevelAsLevel(String string) {
        for (SkillLevel skillLevel : this.skills) {
            if (!skillLevel.getSkill().getId().equals(string)) continue;
            return skillLevel;
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n2) {
        this.level = n2;
    }

    public List<String> getAvailableHullmodIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SkillLevel skillLevel : this.skills) {
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.getGoverningSkill());
                if (!(f2 > 0.0f) || skillEffectSpec.getType() != SkillEffectType.HULLMOD_UNLOCK || skillEffectSpec.getHullModUnlocks() == null) continue;
                arrayList.addAll(skillEffectSpec.getUnlockedHullMods(f2));
            }
        }
        return arrayList;
    }

    public List<String> getGrantedAbilityIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SkillLevel skillLevel : this.skills) {
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.getGoverningSkill());
                if (!(f2 >= skillEffectSpec.getRequiredSkillLevel()) || skillEffectSpec.getType() != SkillEffectType.ABILITY_UNLOCK || skillEffectSpec.getAbilityUnlocks() == null) continue;
                arrayList.addAll(skillEffectSpec.getAbilityUnlocks());
            }
        }
        return arrayList;
    }

    public boolean isHullModAvailable(String string) {
        return this.getAvailableHullmodIds().contains(string);
    }

    public List<o> getShipEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n2 = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.getGoverningSkill());
                if (skillEffectSpec.getType() == SkillEffectType.SHIP && f2 >= skillEffectSpec.getRequiredSkillLevel()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_ship_" + n2));
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public List<oooO> getFleetTotals() {
        ArrayList<FleetTotalItem> arrayList = new ArrayList<FleetTotalItem>();
        HashSet<String> hashSet = new HashSet<String>();
        LinkedHashMap<String, oooO> linkedHashMap = new LinkedHashMap<String, oooO>();
        for (SkillLevel cloneable2 : this.skills) {
            for (SkillSpec.SkillEffectSpec skillEffectSpec : cloneable2.getSkill().getEffects()) {
                String string;
                FleetTotalItem fleetTotalItem;
                float f2 = this.getSkillLevel(skillEffectSpec.getGoverningSkill());
                if (!(f2 >= skillEffectSpec.getRequiredSkillLevel())) continue;
                FleetTotalSource fleetTotalSource = skillEffectSpec.getAsFleetTotalSource();
                if (fleetTotalSource != null) {
                    fleetTotalItem = fleetTotalSource.getFleetTotalItem();
                    String string2 = string = fleetTotalItem != null ? String.valueOf(fleetTotalItem.label) + "_" + fleetTotalItem.value : "";
                    if (fleetTotalItem != null && !hashSet.contains(string)) {
                        arrayList.add(fleetTotalItem);
                        hashSet.add(string);
                    }
                }
                if (fleetTotalSource == null) continue;
                fleetTotalItem = fleetTotalSource.getFleetTotalItem();
                string = fleetTotalItem != null ? String.valueOf(fleetTotalItem.label) + "_" + fleetTotalItem.value : "";
                oooO oooO2 = (oooO)linkedHashMap.get(string);
                if (oooO2 == null) {
                    oooO2 = new oooO();
                    oooO2.new = fleetTotalItem;
                    linkedHashMap.put(string, oooO2);
                }
                oooO2.o00000.add(cloneable2);
            }
        }
        ArrayList<oooO> arrayList2 = new ArrayList<oooO>(linkedHashMap.values());
        Collections.sort(arrayList2, new Comparator<oooO>(){

            public int o00000(oooO oooO2, oooO oooO3) {
                return (int)Math.signum(oooO2.new.sortOrder - oooO3.new.sortOrder);
            }
        });
        for (Object oooO3 : arrayList2) {
            Collections.sort(((oooO)oooO3).o00000, new Comparator<MutableCharacterStatsAPI.SkillLevelAPI>(){

                public int o00000(MutableCharacterStatsAPI.SkillLevelAPI skillLevelAPI, MutableCharacterStatsAPI.SkillLevelAPI skillLevelAPI2) {
                    return (int)Math.signum(skillLevelAPI.getSkill().getOrder() - skillLevelAPI2.getSkill().getOrder());
                }
            });
        }
        return arrayList2;
    }

    public List<o> getOutpostEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n2 = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.getGoverningSkill());
                if (skillEffectSpec.getType() == SkillEffectType.GOVERNED_OUTPOST && f2 >= skillEffectSpec.getRequiredSkillLevel()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_GO_" + n2));
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public List<o> getAllOutpostEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n2 = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.getGoverningSkill());
                if (skillEffectSpec.getType() == SkillEffectType.ALL_OUTPOSTS && f2 >= skillEffectSpec.getRequiredSkillLevel()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_AO_" + n2));
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public List<o> getAllShipsInFleetEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n2 = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.getGoverningSkill());
                if (skillEffectSpec.getType() == SkillEffectType.ALL_SHIPS_IN_FLEET && f2 >= skillEffectSpec.getRequiredSkillLevel()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_ships_" + n2));
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public List<o> getAllFightersInFleetEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n2 = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.getGoverningSkill());
                if (skillEffectSpec.getType() == SkillEffectType.ALL_FIGHTERS_IN_FLEET && f2 >= skillEffectSpec.getRequiredSkillLevel()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_all_fighters_" + n2));
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public List<o> getShipFightersEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n2 = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.getGoverningSkill());
                if (skillEffectSpec.getType() == SkillEffectType.SHIP_FIGHTERS && f2 >= skillEffectSpec.getRequiredSkillLevel()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_ship_fighters_" + n2));
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public List<o> getStatsEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n2 = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.getGoverningSkill());
                if (skillEffectSpec.getType() == SkillEffectType.CHARACTER_STATS && f2 >= skillEffectSpec.getRequiredSkillLevel()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_stats_" + n2));
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public List<o> getFleetEffects() {
        ArrayList<o> arrayList = new ArrayList<o>();
        for (SkillLevel skillLevel : this.skills) {
            int n2 = 0;
            for (SkillSpec.SkillEffectSpec skillEffectSpec : skillLevel.getSkill().getEffects()) {
                float f2 = this.getSkillLevel(skillEffectSpec.getGoverningSkill());
                if (skillEffectSpec.getType() == SkillEffectType.FLEET && f2 >= skillEffectSpec.getRequiredSkillLevel()) {
                    arrayList.add(new o(skillEffectSpec, String.valueOf(skillLevel.getSkill().getId()) + "_stats_" + n2));
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public void applyFleetwideToShip(Ship ship) {
        if (ship.isFighter()) {
            return;
        }
        this.applyFleetwideToStats(ship.getStats(), ship.getHullSize());
    }

    public void applyFleetwideToStats(E e2, ShipAPI.HullSize hullSize) {
        if (hullSize == ShipAPI.HullSize.FIGHTER) {
            return;
        }
        for (o o2 : this.getAllShipsInFleetEffects()) {
            float f2 = this.getSkillLevel(o2.super.getGoverningSkill());
            o2.super.getAsShipEffect().apply((MutableShipStatsAPI)e2, hullSize, o2.\u00d200000, f2);
        }
    }

    public void unapplyFleetwideToShip(Ship ship) {
        if (ship.isFighter()) {
            return;
        }
        for (o o2 : this.getAllShipsInFleetEffects()) {
            o2.super.getAsShipEffect().unapply(ship.getMutableStats(), ship.getHullSize(), o2.\u00d200000);
        }
    }

    public void applyFleetwideAfterShipCreationToShip(Ship ship) {
        if (ship.isFighter()) {
            return;
        }
        for (o o2 : this.getAllShipsInFleetEffects()) {
            AfterShipCreationSkillEffect afterShipCreationSkillEffect = o2.super.getAsAfterShipCreationEffect();
            if (afterShipCreationSkillEffect == null) continue;
            afterShipCreationSkillEffect.unapplyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
            afterShipCreationSkillEffect.applyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
        }
        if (ship.getSystem() != null) {
            ship.getSystem().updateValuesFromStats();
        }
        if (ship.getPhaseCloak() != null) {
            ship.getPhaseCloak().updateValuesFromStats();
        }
    }

    public void unapplyFleetwideAfterShipCreationToShip(Ship ship) {
        if (ship.isFighter()) {
            return;
        }
        for (o o2 : this.getAllShipsInFleetEffects()) {
            AfterShipCreationSkillEffect afterShipCreationSkillEffect = o2.super.getAsAfterShipCreationEffect();
            if (afterShipCreationSkillEffect == null) continue;
            afterShipCreationSkillEffect.unapplyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
        }
        if (ship.getSystem() != null) {
            ship.getSystem().updateValuesFromStats();
        }
        if (ship.getPhaseCloak() != null) {
            ship.getPhaseCloak().updateValuesFromStats();
        }
    }

    public void applyPersonalToShip(Ship ship) {
        this.applyPersonalToStats(ship.getStats(), ship.getHullSize());
        this.applyPersonalAfterShipCreationToShip(ship);
        if (ship.getFleetCommander() != null) {
            ship.getFleetCommander().getStats().applyFleetwideToShip(ship);
            ship.getFleetCommander().getStats().applyFleetwideAfterShipCreationToShip(ship);
        }
    }

    public void unapplyPersonalToShip(Ship ship) {
        for (o o2 : this.getShipEffects()) {
            o2.super.getAsShipEffect().unapply(ship.getMutableStats(), ship.getHullSize(), o2.\u00d200000);
        }
        this.unapplyPersonalAfterShipCreationToShip(ship);
        if (ship.getFleetCommander() != null) {
            ship.getFleetCommander().getStats().unapplyFleetwideToShip(ship);
            ship.getFleetCommander().getStats().unapplyFleetwideAfterShipCreationToShip(ship);
        }
    }

    public void applyPersonalToStats(E e2, ShipAPI.HullSize hullSize) {
        for (o o2 : this.getShipEffects()) {
            float f2 = this.getSkillLevel(o2.super.getGoverningSkill());
            o2.super.getAsShipEffect().apply((MutableShipStatsAPI)e2, hullSize, o2.\u00d200000, f2);
        }
    }

    public void applyPersonalAfterShipCreationToShip(Ship ship) {
        for (o o2 : this.getShipEffects()) {
            AfterShipCreationSkillEffect afterShipCreationSkillEffect = o2.super.getAsAfterShipCreationEffect();
            if (afterShipCreationSkillEffect == null) continue;
            afterShipCreationSkillEffect.unapplyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
            afterShipCreationSkillEffect.applyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
        }
        if (ship.getSystem() != null) {
            ship.getSystem().updateValuesFromStats();
        }
        if (ship.getPhaseCloak() != null) {
            ship.getPhaseCloak().updateValuesFromStats();
        }
    }

    public void unapplyPersonalAfterShipCreationToShip(Ship ship) {
        for (o o2 : this.getShipEffects()) {
            AfterShipCreationSkillEffect afterShipCreationSkillEffect = o2.super.getAsAfterShipCreationEffect();
            if (afterShipCreationSkillEffect == null) continue;
            afterShipCreationSkillEffect.unapplyEffectsAfterShipCreation((ShipAPI)ship, o2.\u00d200000);
        }
        if (ship.getSystem() != null) {
            ship.getSystem().updateValuesFromStats();
        }
        if (ship.getPhaseCloak() != null) {
            ship.getPhaseCloak().updateValuesFromStats();
        }
    }

    public void applyGovernedOutpostEffectsToMarket(MarketAPI marketAPI) {
        for (o o2 : this.getOutpostEffects()) {
            float f2 = this.getSkillLevel(o2.super.getGoverningSkill());
            o2.super.getAsMarketEffect().apply(marketAPI, o2.\u00d200000, f2);
        }
    }

    public void applyAllOutpostEffectsToMarket(MarketAPI marketAPI) {
        for (o o2 : this.getAllOutpostEffects()) {
            float f2 = this.getSkillLevel(o2.super.getGoverningSkill());
            o2.super.getAsMarketEffect().apply(marketAPI, o2.\u00d200000, f2);
        }
    }

    public void refreshGovernedOutpostEffects(MarketAPI marketAPI) {
        String string = "refreshGovernedOutpostEffects";
        List<o> list = CharacterStats.getEffectCache().get(string);
        if (list == null) {
            list = new ArrayList<o>();
            CharacterStats.getEffectCache().put(string, list);
            ArrayList<String> object = new ArrayList<String>(SpecStore.String(SkillSpec.class));
            for (Object object2 : object) {
                SkillSpec skillSpec = SpecStore.super(SkillSpec.class, (String)object2);
                int n2 = 0;
                for (SkillSpec.SkillEffectSpec skillEffectSpec : skillSpec.getEffects()) {
                    if (skillEffectSpec.getType() == SkillEffectType.GOVERNED_OUTPOST) {
                        String string2 = String.valueOf(skillSpec.getId()) + "_GO_" + n2;
                        list.add(new o(skillEffectSpec, string2));
                    }
                    ++n2;
                }
            }
        }
        for (o o2 : list) {
            if (o2.super.getType() != SkillEffectType.GOVERNED_OUTPOST) continue;
            o2.super.getAsMarketEffect().unapply(marketAPI, o2.\u00d200000);
        }
        this.applyGovernedOutpostEffectsToMarket(marketAPI);
    }

    public void refreshAllOutpostsEffectsForPlayerOutposts() {
        for (MarketAPI marketAPI : Global.getSector().getEconomy().getMarketsCopy()) {
            if (!marketAPI.isPlayerOwned()) continue;
            this.refreshAllOutpostsEffects(marketAPI);
            if (marketAPI.getAdmin().getStats() == this) {
                this.refreshGovernedOutpostEffects(marketAPI);
            }
            marketAPI.reapplyConditions();
            marketAPI.reapplyIndustries();
        }
    }

    public void refreshAllOutpostsEffects(MarketAPI marketAPI) {
        String string = "refreshAllOutpostsEffects";
        List<o> list = CharacterStats.getEffectCache().get(string);
        if (list == null) {
            list = new ArrayList<o>();
            CharacterStats.getEffectCache().put(string, list);
            ArrayList<String> object = new ArrayList<String>(SpecStore.String(SkillSpec.class));
            for (Object object2 : object) {
                SkillSpec skillSpec = SpecStore.super(SkillSpec.class, (String)object2);
                int n2 = 0;
                for (SkillSpec.SkillEffectSpec skillEffectSpec : skillSpec.getEffects()) {
                    if (skillEffectSpec.getType() == SkillEffectType.ALL_OUTPOSTS) {
                        String string2 = String.valueOf(skillSpec.getId()) + "_AO_" + n2;
                        list.add(new o(skillEffectSpec, string2));
                    }
                    ++n2;
                }
            }
        }
        for (o o2 : list) {
            if (o2.super.getType() != SkillEffectType.ALL_OUTPOSTS) continue;
            o2.super.getAsMarketEffect().unapply(marketAPI, o2.\u00d200000);
        }
        if (marketAPI.isPlayerOwned()) {
            this.applyAllOutpostEffectsToMarket(marketAPI);
        }
    }

    public void applyShipFightersToStats(E e2, ShipAPI.HullSize hullSize) {
        for (o o2 : this.getShipFightersEffects()) {
            float f2 = this.getSkillLevel(o2.super.getGoverningSkill());
            o2.super.getAsShipEffect().apply((MutableShipStatsAPI)e2, hullSize, o2.\u00d200000, f2);
        }
    }

    public void applyAllFightersToStats(E e2, ShipAPI.HullSize hullSize) {
        for (o o2 : this.getAllFightersInFleetEffects()) {
            float f2 = this.getSkillLevel(o2.super.getGoverningSkill());
            o2.super.getAsShipEffect().apply((MutableShipStatsAPI)e2, hullSize, o2.\u00d200000, f2);
        }
    }

    public void setAptitudeLevel(String string, float f2) {
        for (AptitudeLevel object2 : this.aptitudes) {
            if (!object2.getAptitude().\u00f800000().equals(string)) continue;
            object2.setLevel(f2);
            SkillSpec skillSpec = object2.getAptitude().int();
            if (skillSpec != null) {
                this.setSkillLevel(skillSpec.getId(), f2);
            }
            return;
        }
        com.fs.starfarer.loading.E e2 = SpecStore.super(com.fs.starfarer.loading.E.class, string);
        AptitudeLevel aptitudeLevel = new AptitudeLevel(e2);
        aptitudeLevel.setLevel(f2);
        SkillSpec skillSpec = e2.int();
        if (skillSpec != null) {
            this.setSkillLevel(skillSpec.getId(), f2);
        }
        this.aptitudes.add(aptitudeLevel);
    }

    public void setSkillLevel(String string, float f2) {
        for (SkillLevel object2 : this.skills) {
            if (!object2.getSkill().getId().equals(string)) continue;
            object2.setLevel(f2);
            this.refreshCharacterStatsEffects();
            return;
        }
        SkillSpec skillSpec = SpecStore.super(SkillSpec.class, string);
        SkillLevel skillLevel = new SkillLevel(skillSpec);
        this.skills.add(skillLevel);
        skillLevel.setLevel(f2);
        this.refreshCharacterStatsEffects();
    }

    public boolean hasSkill(SkillSpec skillSpec) {
        return this.hasSkill(skillSpec.getId());
    }

    public boolean hasSkill(String string) {
        for (SkillLevel skillLevel : this.skills) {
            if (!skillLevel.getSkill().getId().equals(string) || !(skillLevel.getLevel() > 0.0f)) continue;
            return true;
        }
        return false;
    }

    public List<AptitudeLevel> getAptitudes() {
        return this.aptitudes;
    }

    public List<SkillLevel> getSkills() {
        return this.skills;
    }

    public List<MutableCharacterStatsAPI.SkillLevelAPI> getSkillsCopy() {
        if (this.skills == null) {
            return new ArrayList<MutableCharacterStatsAPI.SkillLevelAPI>();
        }
        return new ArrayList<MutableCharacterStatsAPI.SkillLevelAPI>(this.skills);
    }

    public long getXP() {
        return this.xp;
    }

    public void setXP(long l2) {
        this.xp = l2;
    }

    public boolean isPlayerStats() {
        return CampaignEngine.getInstance().getPlayerStats() == this;
    }

    public void addXP(long l2) {
        this.addXP(l2, null);
    }

    public void addXP(long l2, TextPanelAPI textPanelAPI) {
        this.addXP(l2, textPanelAPI, true);
    }

    public void addXP(long l2, TextPanelAPI textPanelAPI, boolean bl) {
        this.addXP(l2, textPanelAPI, bl, true);
    }

    public void addXP(long l2, TextPanelAPI textPanelAPI, boolean bl, boolean bl2) {
        this.addXP(l2, textPanelAPI, bl, bl2, true);
    }

    public long getBonusXPUsed(long l2) {
        long l3;
        LevelupPlugin levelupPlugin;
        float f2 = 1.0f;
        if (CampaignEngine.getInstance().getPlayerStats() == this && this.level == (levelupPlugin = ScriptStore.o00000(LevelupPlugin.class)).getMaxLevel()) {
            f2 = levelupPlugin.getBonusXPUseMultAtMaxLevel();
        }
        if ((l3 = Math.min((long)((float)l2 * f2), this.bonusXp)) < 0L) {
            l3 = 0L;
        }
        return l3;
    }

    public void addXP(long l2, TextPanelAPI textPanelAPI, boolean bl, boolean bl2, boolean bl3) {
        long l3 = 0L;
        if (bl2 && this.bonusXp > 0L) {
            l3 = this.getBonusXPUsed(l2);
            l2 += l3;
            this.bonusXp -= l3;
        }
        this.xp += l2;
        if (CampaignEngine.getInstance().getPlayerStats() == this && bl) {
            if (l3 > 0L) {
                String string = Misc.getWithDGS((float)l3);
                String string2 = Misc.getWithDGS((float)l2);
                String string3 = "Gained " + string2 + " experience (" + string + " bonus XP used)";
                if (textPanelAPI != null) {
                    textPanelAPI.setFontSmallInsignia();
                    textPanelAPI.addParagraph(string3, D.oo0000);
                    textPanelAPI.highlightInLastPara(new String[]{string2, string});
                    textPanelAPI.setHighlightColorsInLastPara(new Color[]{D.interface, Misc.getStoryOptionColor()});
                    textPanelAPI.setFontInsignia();
                } else {
                    MessageIntel messageIntel = new MessageIntel(string3, Misc.getBasePlayerColor(), new String[]{string2, string}, new Color[]{Misc.getHighlightColor(), Misc.getStoryOptionColor()});
                    Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
                }
            } else {
                String string = Misc.getWithDGS((float)l2);
                String string4 = "Gained " + string + " experience";
                if (textPanelAPI != null) {
                    textPanelAPI.setFontSmallInsignia();
                    textPanelAPI.addParagraph(string4, D.oo0000);
                    textPanelAPI.highlightLastInLastPara(string, D.interface);
                    textPanelAPI.setFontInsignia();
                } else {
                    MessageIntel messageIntel = new MessageIntel(string4, Misc.getBasePlayerColor(), new String[]{string}, new Color[]{Misc.getHighlightColor()});
                    Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
                }
            }
        }
        if (bl3) {
            this.levelUpIfNeeded(textPanelAPI);
        }
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int n2) {
        this.points = n2;
    }

    public void addPoints(int n2) {
        this.points += n2;
        if (this.points < 0) {
            this.points = 0;
        }
    }

    public void levelUpIfNeeded() {
        this.levelUpIfNeeded(null);
    }

    public void levelUpIfNeeded(TextPanelAPI textPanelAPI) {
        String string;
        boolean bl;
        LevelupPlugin levelupPlugin = ScriptStore.o00000(LevelupPlugin.class);
        boolean bl2 = CampaignEngine.getInstance().getPlayerStats() == this;
        int n2 = levelupPlugin.getMaxLevel();
        boolean bl3 = bl = this.level >= n2;
        if (!bl2 && bl) {
            return;
        }
        boolean bl4 = false;
        if (bl2) {
            long l2 = 0L;
            while ((l2 = this.getXPThresholdForNextStoryPoint(this.xpAtLastStoryPointGain)) <= this.xp) {
                bl4 = true;
                ++this.storyPoints;
                this.xpAtLastStoryPointGain = l2;
            }
        }
        boolean bl5 = false;
        while (!bl && this.getXP() >= levelupPlugin.getXPForLevel(this.level + 1)) {
            Object object;
            bl5 = true;
            ++this.level;
            bl = this.level >= n2;
            int n3 = levelupPlugin.getPointsAtLevel(this.level);
            this.points += n3;
            if (CampaignEngine.getInstance().getPlayerStats() != this) continue;
            string = "You have advanced to level " + this.level;
            if (bl) {
                string = String.valueOf(string) + " (maximum)";
            }
            if (textPanelAPI != null) {
                textPanelAPI.setFontSmallInsignia();
                textPanelAPI.addParagraph(string, D.oo0000);
                textPanelAPI.highlightLastInLastPara("" + this.level, D.interface);
                textPanelAPI.setFontInsignia();
            } else {
                object = new MessageIntel(string, Misc.getBasePlayerColor(), new String[]{"" + this.level}, new Color[]{Misc.getHighlightColor()});
                Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)object);
            }
            if (this.deferredBonusXp <= 0L || !bl) continue;
            object = Misc.getWithDGS((float)this.deferredBonusXp);
            this.bonusXp += this.deferredBonusXp;
            string = "Gained " + (String)object + " bonus experience from " + Misc.STORY + " points spent earlier";
            if (textPanelAPI != null) {
                textPanelAPI.setFontSmallInsignia();
                textPanelAPI.addParagraph(string, D.oo0000);
                textPanelAPI.highlightLastInLastPara((String)object, D.interface);
                textPanelAPI.setFontInsignia();
                continue;
            }
            MessageIntel messageIntel = new MessageIntel(string, Misc.getBasePlayerColor(), new String[]{object}, new Color[]{Misc.getHighlightColor()});
            Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel);
        }
        if (bl2) {
            if (bl) {
                long l3 = levelupPlugin.getXPForLevel(this.level + 0);
                long l4 = levelupPlugin.getXPForLevel(this.level + 1);
                long l5 = l4 - l3;
                if (l5 <= 0L) {
                    l5 = 100000L;
                }
                while (this.xp >= l4) {
                    this.xp -= l5;
                    this.xpAtLastStoryPointGain -= l5;
                }
            }
            if (bl4) {
                if (!bl5) {
                    M.super("ui_char_gained_story_point", 1.0f, 1.0f);
                }
                String string2 = "points";
                if (this.storyPoints == 1) {
                    string2 = "point";
                }
                string = "You have " + this.storyPoints + " " + Misc.STORY + " " + string2 + " to spend";
                if (textPanelAPI != null) {
                    textPanelAPI.setFontSmallInsignia();
                    textPanelAPI.addParagraph(string, D.oo0000);
                    textPanelAPI.highlightLastInLastPara(this.storyPoints + " " + Misc.STORY + " " + string2, Misc.getStoryOptionColor());
                    textPanelAPI.setFontInsignia();
                } else {
                    MessageIntel messageIntel = new MessageIntel(string, Misc.getBasePlayerColor(), new String[]{this.storyPoints + " " + Misc.STORY + " " + string2}, new Color[]{Misc.getStoryOptionColor()});
                    messageIntel.setIcon(CampaignEngine.getInstance().getPlayerPerson().getPortraitSprite());
                    Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel, CommMessageAPI.MessageClickAction.CHARACTER_TAB);
                }
                CampaignEngine.getInstance().getUIData().setOpenedCharacterTabSinceLevelUp(false);
            }
            if (bl5) {
                M.super("ui_char_level_up", 1.0f, 1.0f);
                if (this.points > 0) {
                    String string3 = "points";
                    if (this.points == 1) {
                        string3 = "point";
                    }
                    string = "You have " + this.points + " skill " + string3 + " to spend";
                    if (textPanelAPI != null) {
                        textPanelAPI.setFontSmallInsignia();
                        textPanelAPI.addParagraph(string, D.oo0000);
                        textPanelAPI.highlightLastInLastPara(this.points + " skill " + string3, D.interface);
                        textPanelAPI.setFontInsignia();
                    } else {
                        MessageIntel messageIntel = new MessageIntel(string, Misc.getBasePlayerColor(), new String[]{this.points + " skill " + string3}, new Color[]{Misc.getHighlightColor()});
                        messageIntel.setIcon(CampaignEngine.getInstance().getPlayerPerson().getPortraitSprite());
                        Global.getSector().getCampaignUI().addMessage((IntelInfoPlugin)messageIntel, CommMessageAPI.MessageClickAction.CHARACTER_TAB);
                    }
                }
                CampaignEngine.getInstance().getUIData().setOpenedCharacterTabSinceLevelUp(false);
            }
        }
    }

    public MutableStat getWeaponOPCostMult() {
        return this.weaponOPCostMult;
    }

    public StatBonus getSmallWeaponOPCost() {
        return this.smallWeaponOPCost;
    }

    public StatBonus getMediumWeaponOPCost() {
        return this.mediumWeaponOPCost;
    }

    public StatBonus getLargeWeaponOPCost() {
        return this.largeWeaponOPCost;
    }

    public StatBonus getShipOrdnancePointBonus() {
        return this.shipOrdnancePointBonus;
    }

    public MutableStat getCommandPoints() {
        return this.commandPoints;
    }

    public MutableStat getMarineEffectivnessMult() {
        return this.marineEffectivnessMult;
    }

    public StatBonus getCombatDeploymentCost() {
        return this.combatDeploymentCost;
    }

    public StatBonus getMaxCapacitorsBonus() {
        return this.maxCapacitorsBonus;
    }

    public StatBonus getMaxVentsBonus() {
        return this.maxVentsBonus;
    }

    public StatBonus getTravelSpeedBonus() {
        return this.travelSpeedBonus;
    }

    public MutableStat getOfficerNumber() {
        return this.officerNumber;
    }

    public void increaseAptitude(String string) {
        this.setAptitudeLevel(string, this.getAptitudeLevel(string) + 1.0f);
    }

    public MutableStat getRepairRateMult() {
        return this.repairRateMult;
    }

    public static class AptitudeLevel
    implements DoNotObfuscate,
    Cloneable {
        private transient com.fs.starfarer.loading.E aptitude;
        private float level;
        private int maxTier = 0;
        private String savedId = null;

        protected AptitudeLevel clone() {
            try {
                return (AptitudeLevel)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public AptitudeLevel(com.fs.starfarer.loading.E e2) {
            this.aptitude = e2;
            this.level = 0.0f;
        }

        public AptitudeLevel(String string) {
            this.savedId = string;
            this.level = 0.0f;
            this.readResolve();
        }

        public float getLevel() {
            return this.level;
        }

        public void setLevel(float f2) {
            this.level = f2;
        }

        public com.fs.starfarer.loading.E getAptitude() {
            return this.aptitude;
        }

        public int getMaxTier() {
            return this.maxTier;
        }

        public void setMaxTier(int n2) {
            this.maxTier = n2;
        }

        Object readResolve() {
            this.aptitude = SpecStore.super(com.fs.starfarer.loading.E.class, this.savedId);
            return this;
        }

        Object writeReplace() {
            this.savedId = this.aptitude.\u00f800000();
            return this;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class o {
        public SkillSpec.SkillEffectSpec super;
        public String \u00d200000;

        public o(SkillSpec.SkillEffectSpec skillEffectSpec, String string) {
            this.super = skillEffectSpec;
            this.\u00d200000 = string;
        }
    }

    public static class SkillLevel
    implements DoNotObfuscate,
    Cloneable,
    MutableCharacterStatsAPI.SkillLevelAPI {
        private transient SkillSpec skill;
        private String savedId = null;
        private float level;

        protected SkillLevel clone() {
            try {
                return (SkillLevel)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public SkillLevel(SkillSpec skillSpec) {
            this.skill = skillSpec;
            this.level = 0.0f;
        }

        public SkillLevel(String string) {
            this.savedId = string;
            this.level = 0.0f;
            this.readResolve();
        }

        public float getLevel() {
            return this.level;
        }

        public void setLevel(float f2) {
            this.level = f2;
        }

        public SkillSpec getSkill() {
            return this.skill;
        }

        Object readResolve() {
            this.skill = SpecStore.super(SkillSpec.class, this.savedId);
            return this;
        }

        Object writeReplace() {
            this.savedId = this.skill.getId();
            return this;
        }

        public String toString() {
            return String.valueOf(this.skill.getName()) + ": " + Math.round(this.getLevel());
        }
    }
}

