/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.econ.contract;

import com.fs.starfarer.api.campaign.econ.CommodityFlowAPI;
import com.fs.starfarer.api.campaign.econ.TransferTotalAPI;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.ValueHistory;
import com.fs.starfarer.campaign.econ.CommodityOnMarket;
import com.fs.starfarer.campaign.econ.Economy;
import com.fs.starfarer.loading.F;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class CommodityFlow
implements DoNotObfuscate,
CommodityFlowAPI {
    public static final float SAMPLING_INTERVAL = 1.0f;
    private String commodityId;
    private String marketId;
    private Map<String, TransferTracker> importsOpen = new LinkedHashMap<String, TransferTracker>();
    private Map<String, TransferTracker> importsSmuggled = new LinkedHashMap<String, TransferTracker>();
    private Map<String, TransferTracker> exportsOpen = new LinkedHashMap<String, TransferTracker>();
    private Map<String, TransferTracker> exportsSmuggled = new LinkedHashMap<String, TransferTracker>();
    private ValueHistory demandHistory = new ValueHistory();
    private ValueHistory stockpileHistory = new ValueHistory();
    private ValueHistory supplyHistory = new ValueHistory();
    private ValueHistory importHistory = new ValueHistory();
    private ValueHistory exportHistory = new ValueHistory();
    private final CommodityOnMarket com;
    private float sinceLastSample = 1.0f;

    public CommodityFlow(CommodityOnMarket commodityOnMarket, String string) {
        this.com = commodityOnMarket;
        this.commodityId = commodityOnMarket.getId();
        this.marketId = string;
    }

    Object readResolve() {
        if (this.demandHistory == null) {
            this.demandHistory = new ValueHistory();
        }
        if (this.stockpileHistory == null) {
            this.stockpileHistory = new ValueHistory();
        }
        return this;
    }

    public void advance(float f2) {
        float f3 = Economy.ECONOMY_INTERVAL_IN_GAME_DAYS;
        this.advance(this.importsOpen, f2, f3);
        this.advance(this.importsSmuggled, f2, f3);
        this.advance(this.exportsOpen, f2, f3);
        this.advance(this.exportsSmuggled, f2, f3);
        this.sinceLastSample += f2;
        if (this.sinceLastSample > 1.0f) {
            while (this.sinceLastSample > 1.0f) {
                this.sinceLastSample -= 1.0f;
                this.stockpileHistory.addSample(this.com.getStockpile());
                this.demandHistory.addSample(this.com.getDemand().getDemandValue());
                this.importHistory.addSample(this.getTotalIncoming());
                this.exportHistory.addSample(this.getTotalOutgoing());
            }
        }
    }

    public void advance(Map<String, TransferTracker> map, float f2, float f3) {
        for (String string : new ArrayList<String>(map.keySet())) {
            TransferTracker transferTracker = map.get(string);
            transferTracker.advance(f2, f3);
            if (transferTracker.getTotalQuantity() > 0) continue;
            map.remove(string);
        }
    }

    public TransferTracker getImportsOpen(String string) {
        return this.getTracker(string, this.importsOpen);
    }

    public TransferTracker getImportsSmuggled(String string) {
        return this.getTracker(string, this.importsSmuggled);
    }

    public TransferTracker getExportsOpen(String string) {
        return this.getTracker(string, this.exportsOpen);
    }

    public TransferTracker getExportsSmuggled(String string) {
        return this.getTracker(string, this.exportsSmuggled);
    }

    protected TransferTracker getTracker(String string, Map<String, TransferTracker> map) {
        TransferTracker transferTracker = map.get(string);
        if (transferTracker == null) {
            transferTracker = new TransferTracker();
            map.put(string, transferTracker);
        }
        return transferTracker;
    }

    public float getTotalIncoming() {
        TransferTracker transferTracker;
        float f2 = 0.0f;
        for (String string : this.importsOpen.keySet()) {
            transferTracker = this.importsOpen.get(string);
            f2 += (float)transferTracker.getTotalQuantity();
        }
        for (String string : this.importsSmuggled.keySet()) {
            transferTracker = this.importsSmuggled.get(string);
            f2 += (float)transferTracker.getTotalQuantity();
        }
        return f2;
    }

    public float getTotalOutgoing() {
        TransferTracker transferTracker;
        float f2 = 0.0f;
        for (String string : this.exportsOpen.keySet()) {
            transferTracker = this.exportsOpen.get(string);
            f2 += (float)transferTracker.getTotalQuantity();
        }
        for (String string : this.exportsSmuggled.keySet()) {
            transferTracker = this.exportsSmuggled.get(string);
            f2 += (float)transferTracker.getTotalQuantity();
        }
        return f2;
    }

    public float getTotalIncomingPrice() {
        return this.getTotalIncomingPrice(false);
    }

    public float getTotalIncomingPrice(boolean bl) {
        TransferTracker transferTracker;
        float f2 = 0.0f;
        if (!bl) {
            for (String string : this.importsOpen.keySet()) {
                transferTracker = this.importsOpen.get(string);
                f2 += (float)transferTracker.getTotalPrice();
            }
        }
        for (String string : this.importsSmuggled.keySet()) {
            transferTracker = this.importsSmuggled.get(string);
            f2 += (float)transferTracker.getTotalPrice();
        }
        return f2;
    }

    public float getTotalOutgoingPrice() {
        return this.getTotalOutgoingPrice(false);
    }

    public float getTotalOutgoingPrice(boolean bl) {
        TransferTracker transferTracker;
        float f2 = 0.0f;
        if (!bl) {
            for (String string : this.exportsOpen.keySet()) {
                transferTracker = this.exportsOpen.get(string);
                f2 += (float)transferTracker.getTotalPrice();
            }
        }
        for (String string : this.exportsSmuggled.keySet()) {
            transferTracker = this.exportsSmuggled.get(string);
            f2 += (float)transferTracker.getTotalPrice();
        }
        return f2;
    }

    public float getTotalSmuggling() {
        return this.getTotalOutgoingPrice(true) + this.getTotalIncomingPrice(true);
    }

    public List<TransferTotalAPI> getIncoming() {
        TransferTotal transferTotal;
        TransferTracker transferTracker;
        ArrayList<TransferTotalAPI> arrayList = new ArrayList<TransferTotalAPI>();
        for (String string : this.importsOpen.keySet()) {
            transferTracker = this.importsOpen.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, false);
            arrayList.add(transferTotal);
        }
        for (String string : this.importsSmuggled.keySet()) {
            transferTracker = this.importsSmuggled.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, true);
            arrayList.add(transferTotal);
        }
        return arrayList;
    }

    public List<TransferTotalAPI> getOutgoing() {
        TransferTotal transferTotal;
        TransferTracker transferTracker;
        ArrayList<TransferTotalAPI> arrayList = new ArrayList<TransferTotalAPI>();
        for (String string : this.exportsOpen.keySet()) {
            transferTracker = this.exportsOpen.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, false);
            arrayList.add(transferTotal);
        }
        for (String string : this.exportsSmuggled.keySet()) {
            transferTracker = this.exportsSmuggled.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, true);
            arrayList.add(transferTotal);
        }
        return arrayList;
    }

    public List<TransferTotal> getSortedIncoming() {
        TransferTotal transferTotal;
        TransferTracker transferTracker;
        ArrayList<TransferTotal> arrayList = new ArrayList<TransferTotal>();
        for (String string : this.importsOpen.keySet()) {
            transferTracker = this.importsOpen.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, false);
            arrayList.add(transferTotal);
        }
        for (String string : this.importsSmuggled.keySet()) {
            transferTracker = this.importsSmuggled.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, true);
            arrayList.add(transferTotal);
        }
        Collections.sort(arrayList, new Comparator<TransferTotal>(){

            public int super(TransferTotal transferTotal, TransferTotal transferTotal2) {
                return (int)Math.signum(transferTotal2.quantity - transferTotal.quantity);
            }
        });
        return arrayList;
    }

    public List<TransferTotal> getSortedOutgoing() {
        TransferTotal transferTotal;
        TransferTracker transferTracker;
        ArrayList<TransferTotal> arrayList = new ArrayList<TransferTotal>();
        for (String string : this.exportsOpen.keySet()) {
            transferTracker = this.exportsOpen.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, false);
            arrayList.add(transferTotal);
        }
        for (String string : this.exportsSmuggled.keySet()) {
            transferTracker = this.exportsSmuggled.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, true);
            arrayList.add(transferTotal);
        }
        Collections.sort(arrayList, new Comparator<TransferTotal>(){

            public int super(TransferTotal transferTotal, TransferTotal transferTotal2) {
                return (int)Math.signum(transferTotal2.quantity - transferTotal.quantity);
            }
        });
        return arrayList;
    }

    public List<TransferTotalAPI> getTopImports(int n2) {
        TransferTotal transferTotal;
        TransferTracker transferTracker;
        ArrayList<TransferTotal> arrayList = new ArrayList<TransferTotal>();
        for (String string : this.importsOpen.keySet()) {
            transferTracker = this.importsOpen.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, false);
            arrayList.add(transferTotal);
        }
        for (String string : this.importsSmuggled.keySet()) {
            transferTracker = this.importsSmuggled.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, true);
            arrayList.add(transferTotal);
        }
        return this.findTop(arrayList, n2);
    }

    public List<TransferTotalAPI> getTopExports(int n2) {
        TransferTotal transferTotal;
        TransferTracker transferTracker;
        ArrayList<TransferTotal> arrayList = new ArrayList<TransferTotal>();
        for (String string : this.exportsOpen.keySet()) {
            transferTracker = this.exportsOpen.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, false);
            arrayList.add(transferTotal);
        }
        for (String string : this.exportsSmuggled.keySet()) {
            transferTracker = this.exportsSmuggled.get(string);
            transferTotal = new TransferTotal(this.commodityId, transferTracker.getTotalQuantity(), transferTracker.getTotalPrice(), string, true);
            arrayList.add(transferTotal);
        }
        return this.findTop(arrayList, n2);
    }

    public List<TransferTotalAPI> findTop(Collection<TransferTotal> collection, int n2) {
        if (collection.size() <= 0) {
            return new ArrayList<TransferTotalAPI>();
        }
        PriorityQueue<TransferTotal> priorityQueue = new PriorityQueue<TransferTotal>(collection.size(), new Comparator<TransferTotal>(){

            public int o00000(TransferTotal transferTotal, TransferTotal transferTotal2) {
                return transferTotal.quantity - transferTotal2.quantity;
            }
        });
        for (TransferTotal object2 : collection) {
            if (object2.quantity <= 0) continue;
            if (priorityQueue.size() < n2) {
                priorityQueue.add(object2);
                continue;
            }
            if (priorityQueue.peek().quantity >= object2.quantity) continue;
            priorityQueue.poll();
            priorityQueue.add(object2);
        }
        ArrayList<TransferTotalAPI> arrayList = new ArrayList<TransferTotalAPI>();
        while (!priorityQueue.isEmpty()) {
            arrayList.add(0, priorityQueue.poll());
        }
        return arrayList;
    }

    public ValueHistory getDemandHistory() {
        return this.demandHistory;
    }

    public ValueHistory getStockpileHistory() {
        return this.stockpileHistory;
    }

    public ValueHistory getSupplyHistory() {
        return this.supplyHistory;
    }

    public ValueHistory getImportHistory() {
        return this.importHistory;
    }

    public ValueHistory getExportHistory() {
        return this.exportHistory;
    }

    public CommodityOnMarket getCommodity() {
        return this.com;
    }

    public static class TransferItem
    implements DoNotObfuscate {
        private int quantity = 0;
        private int price;
        private float elapsed = 0.0f;

        public TransferItem(int n2, int n3) {
            this.quantity = n2;
            this.price = n3;
        }

        public float getQuantity() {
            return this.quantity;
        }

        public float getPrice() {
            return this.price;
        }

        public float getElapsed() {
            return this.elapsed;
        }
    }

    public static class TransferTotal
    implements DoNotObfuscate,
    TransferTotalAPI {
        private String commodityId;
        private int quantity;
        private int price;
        private String marketId;
        private boolean smuggled = false;

        public TransferTotal(String string, int n2, int n3, String string2, boolean bl) {
            this.commodityId = string;
            this.quantity = n2;
            this.price = n3;
            this.marketId = string2;
            this.smuggled = bl;
        }

        public float getQuantity() {
            return this.quantity;
        }

        public float getPrice() {
            return this.price;
        }

        public String getMarketId() {
            return this.marketId;
        }

        public boolean isSmuggled() {
            return this.smuggled;
        }

        public String getCommodityId() {
            return this.commodityId;
        }

        public void setCommodityId(String string) {
            this.commodityId = string;
        }

        public void setQuantity(int n2) {
            this.quantity = n2;
        }

        public void setPrice(int n2) {
            this.price = n2;
        }

        public void setMarketId(String string) {
            this.marketId = string;
        }

        public void setSmuggled(boolean bl) {
            this.smuggled = bl;
        }

        public F getCommoditySpec() {
            return (F)CampaignEngine.getInstance().getEconomy().getCommoditySpec(this.commodityId);
        }
    }

    public static class TransferTracker
    implements DoNotObfuscate {
        private transient List<TransferItem> transfers = new ArrayList<TransferItem>();
        private String s = null;

        Object readResolve() {
            this.transfers = new ArrayList<TransferItem>();
            if (this.s != null) {
                String[] stringArray = this.s.split("\\|");
                int n2 = 0;
                while (n2 < stringArray.length) {
                    TransferItem transferItem = new TransferItem(0, 0);
                    transferItem.quantity = Integer.parseInt(stringArray[n2 + 0]);
                    transferItem.price = Integer.parseInt(stringArray[n2 + 1]);
                    transferItem.elapsed = Float.parseFloat(stringArray[n2 + 2]);
                    this.transfers.add(transferItem);
                    n2 += 3;
                }
            }
            return this;
        }

        Object writeReplace() {
            this.s = "";
            for (TransferItem transferItem : this.transfers) {
                this.s = String.valueOf(this.s) + transferItem.quantity + "|";
                this.s = String.valueOf(this.s) + transferItem.price + "|";
                this.s = String.valueOf(this.s) + (float)Math.round(transferItem.getElapsed() * 100.0f) / 100.0f + "|";
            }
            if (this.s.length() > 0) {
                this.s = this.s.substring(0, this.s.length() - 1);
            }
            return this;
        }

        public List<TransferItem> getTransfers() {
            return this.transfers;
        }

        public void add(float f2, float f3) {
            if (!this.transfers.isEmpty()) {
                TransferItem transferItem = this.transfers.get(this.transfers.size() - 1);
                if (transferItem.elapsed < 1.0f) {
                    transferItem.quantity = (int)((float)transferItem.quantity + f2);
                    transferItem.price = (int)((float)transferItem.price + f3);
                    return;
                }
            }
            this.transfers.add(new TransferItem((int)f2, (int)f3));
        }

        public int getTotalQuantity() {
            int n2 = 0;
            for (TransferItem transferItem : this.transfers) {
                n2 += transferItem.quantity;
            }
            return n2;
        }

        public int getTotalPrice() {
            int n2 = 0;
            for (TransferItem transferItem : this.transfers) {
                n2 += transferItem.price;
            }
            return n2;
        }

        public void advance(float f2, float f3) {
            Iterator<TransferItem> iterator = this.transfers.iterator();
            while (iterator.hasNext()) {
                TransferItem transferItem = iterator.next();
                transferItem.elapsed += f2;
                if (!(transferItem.elapsed > f3)) continue;
                iterator.remove();
            }
        }
    }
}

