/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.campaign.fleet;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.FleetOrStubAPI;
import com.fs.starfarer.api.campaign.FleetStubAPI;
import com.fs.starfarer.api.campaign.FleetStubConverterPlugin;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.FleetStubAI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.campaign.CampaignEngine;
import com.fs.starfarer.campaign.ai.CampaignFleetAI;
import com.fs.starfarer.campaign.fleet.A;
import com.fs.starfarer.campaign.rules.Memory;
import com.fs.util.DoNotObfuscate;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class FleetStub
implements DoNotObfuscate,
FleetStubAPI,
FleetOrStubAPI {
    private String id = Misc.genUID();
    private Vector2f loc = new Vector2f();
    private LocationAPI containingLocation;
    private String admiralRank;
    private String admiralPost;
    private List<String> cargo = new ArrayList<String>();
    private Memory memory;
    private Object params;
    private List<CampaignFleetAI.FleetAssignmentData> assignments = new ArrayList<CampaignFleetAI.FleetAssignmentData>();
    private CampaignFleetAPI fleet;
    private transient FleetStubAI ai;
    private transient FleetStubConverterPlugin converter;
    private List<FleetEventListener> despawnListeners = null;
    private List<EveryFrameScript> scripts;

    public FleetStub() {
        this.readResolve();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    protected Object readResolve() {
        this.ai = new A(this);
        return this;
    }

    protected Object writeReplace() {
        if (this.cargo != null && this.cargo.isEmpty()) {
            this.cargo = null;
        }
        if (this.assignments != null && this.assignments.isEmpty()) {
            this.assignments = null;
        }
        if (this.memory != null && this.memory.isEmpty()) {
            this.memory = null;
        }
        if (this.despawnListeners != null && this.despawnListeners.isEmpty()) {
            this.despawnListeners = null;
        }
        return this;
    }

    public LocationAPI getContainingLocation() {
        return this.containingLocation;
    }

    public void setContainingLocation(LocationAPI locationAPI) {
        this.containingLocation = locationAPI;
    }

    public void advance(float f2) {
        this.runScripts(f2);
        if (this.ai != null) {
            this.ai.advance(f2);
        }
    }

    public String getAdmiralRank() {
        return this.admiralRank;
    }

    public void setAdmiralRank(String string) {
        this.admiralRank = string;
    }

    public String getAdmiralPost() {
        return this.admiralPost;
    }

    public void setAdmiralPost(String string) {
        this.admiralPost = string;
    }

    public List<CampaignFleetAI.FleetAssignmentData> getAssignments() {
        if (this.assignments == null) {
            this.assignments = new ArrayList<CampaignFleetAI.FleetAssignmentData>();
        }
        return this.assignments;
    }

    public FleetAssignmentDataAPI getCurrentAssignment() {
        CampaignFleetAI.FleetAssignmentData fleetAssignmentData = this.getAssignments().isEmpty() ? null : this.getAssignments().get(0);
        return fleetAssignmentData;
    }

    public List<FleetAssignmentDataAPI> getAssignmentsCopy() {
        return new ArrayList<FleetAssignmentDataAPI>(this.getAssignments());
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, Script script) {
        this.getAssignments().add(new CampaignFleetAI.FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, null, script));
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, Script script) {
        this.getAssignments().add(new CampaignFleetAI.FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, string, script));
    }

    public void addAssignmentAtStart(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string, Script script) {
        this.getAssignments().add(0, new CampaignFleetAI.FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, string, script));
    }

    public void addAssignmentAtStart(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, Script script) {
        this.getAssignments().add(0, new CampaignFleetAI.FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, null, script));
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2, String string) {
        this.getAssignments().add(0, new CampaignFleetAI.FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, string, null));
    }

    public void addAssignment(FleetAssignment fleetAssignment, SectorEntityToken sectorEntityToken, float f2) {
        this.getAssignments().add(0, new CampaignFleetAI.FleetAssignmentData(fleetAssignment, sectorEntityToken, f2, null, null));
    }

    public boolean isCurrentAssignment(FleetAssignment fleetAssignment) {
        FleetAssignmentDataAPI fleetAssignmentDataAPI = this.getCurrentAssignment();
        return fleetAssignmentDataAPI != null && fleetAssignmentDataAPI.getAssignment() == fleetAssignment;
    }

    public void removeFirstAssignmentIfItIs(FleetAssignment fleetAssignment) {
        FleetAssignmentDataAPI fleetAssignmentDataAPI = this.getCurrentAssignment();
        if (fleetAssignmentDataAPI != null && fleetAssignmentDataAPI.getAssignment() == fleetAssignment) {
            this.removeFirstAssignment();
        }
    }

    public void removeFirstAssignment() {
        if (!this.getAssignments().isEmpty()) {
            this.getAssignments().remove(0);
        }
    }

    public void clearAssignments() {
        this.getAssignments().clear();
    }

    public Memory getMemoryWithoutUpdate() {
        if (this.memory == null) {
            this.memory = new Memory();
        }
        return this.memory;
    }

    public void setMemory(MemoryAPI memoryAPI) {
        this.memory = memoryAPI != null ? (Memory)memoryAPI : null;
    }

    public Object getParams() {
        return this.params;
    }

    public void setParams(Object object) {
        this.params = object;
    }

    public Vector2f getLocation() {
        return this.loc;
    }

    public List<String> getCargoList() {
        if (this.cargo == null) {
            this.cargo = new ArrayList<String>();
        }
        return this.cargo;
    }

    public void addEventListener(FleetEventListener fleetEventListener) {
        if (this.despawnListeners == null) {
            this.despawnListeners = new ArrayList<FleetEventListener>();
        }
        this.despawnListeners.add(fleetEventListener);
    }

    public void despawn() {
        this.despawn(CampaignEventListener.FleetDespawnReason.NO_REASON_PROVIDED, null);
    }

    public void despawn(CampaignEventListener.FleetDespawnReason fleetDespawnReason, Object object) {
        if (this.despawnListeners != null) {
            for (FleetEventListener fleetEventListener : this.despawnListeners) {
            }
        }
    }

    public boolean isFleet() {
        return false;
    }

    public boolean isStub() {
        return true;
    }

    public void addScript(EveryFrameScript everyFrameScript) {
        if (everyFrameScript == null) {
            return;
        }
        if (this.scripts == null) {
            this.scripts = new ArrayList<EveryFrameScript>();
        }
        this.scripts.add(everyFrameScript);
    }

    public List<FleetEventListener> getEventListeners() {
        return this.despawnListeners;
    }

    public List<EveryFrameScript> getScripts() {
        return this.scripts;
    }

    private void runScripts(float f2) {
        if (this.scripts == null) {
            return;
        }
        ArrayList<EveryFrameScript> arrayList = new ArrayList<EveryFrameScript>(this.scripts);
        for (EveryFrameScript everyFrameScript : arrayList) {
            if (everyFrameScript.isDone()) {
                this.scripts.remove(everyFrameScript);
                continue;
            }
            if (!everyFrameScript.runWhilePaused() && CampaignEngine.getInstance().isPaused()) continue;
            everyFrameScript.advance(f2);
            if (!everyFrameScript.isDone()) continue;
            this.scripts.remove(everyFrameScript);
        }
    }

    public FleetStubConverterPlugin getConverter() {
        if (this.converter == null) {
            this.converter = Global.getSector().getPluginPicker().pickFleetStubConverter((FleetStubAPI)this);
        }
        return this.converter;
    }

    public void repickConverter() {
        this.converter = Global.getSector().getPluginPicker().pickFleetStubConverter((FleetStubAPI)this);
    }

    public CampaignFleetAPI getFleet() {
        return this.fleet;
    }

    public void setFleet(CampaignFleetAPI campaignFleetAPI) {
        this.fleet = campaignFleetAPI;
    }

    public Vector2f getLocationInHyperspace() {
        if (this.getContainingLocation() == null || this.getContainingLocation().isHyperspace()) {
            return this.getLocation();
        }
        return this.getContainingLocation().getLocation();
    }

    public void removeEventListener(FleetEventListener fleetEventListener) {
    }
}

