/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.combat.ai;

import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.combat.ai.AI;
import com.fs.starfarer.combat.ai.M;
import com.fs.starfarer.combat.class.new;
import com.fs.starfarer.combat.entities.Ship;
import com.fs.starfarer.prototype.Utils;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class FighterWingLeaderAI
implements AI {
    private Ship fighter;
    private float approachDistance = 500.0f;
    private float attackRunLength = 500.0f;
    private float updateInterval = 0.5f;
    private Vector2f runStart = new Vector2f();
    private Vector2f runEnd = new Vector2f();
    private Ship target;
    private o task;
    private float sinceRecheck = 0.0f;

    public FighterWingLeaderAI(Ship ship) {
        this.fighter = ship;
        this.task = o.null;
    }

    @Override
    public void advance(float f2) {
        if (this.task == o.null) {
            this.pickTarget();
        } else if (this.task == o.\u00d400000) {
            this.approachTarget();
            this.recheckTargetAndUpdateRunEnd(f2, false);
        } else if (this.task == o.\u00d300000) {
            this.pickStartLocation();
        } else if (this.task == o.\u00d800000) {
            this.navigateToRunStart();
        } else if (this.task == o.class) {
            this.turnTowardsRunEnd();
        } else if (this.task == o.\u00d600000) {
            this.executeAttackRun();
            this.recheckTargetAndUpdateRunEnd(f2, true);
        }
        if (this.isTargetValid()) {
            M.float(this.fighter, this.target);
        }
    }

    private void approachTarget() {
        float f2 = M.o00000(this.fighter, this.target.getLocation(), true);
        if (f2 < this.approachDistance) {
            this.task = o.\u00d300000;
        }
    }

    private void pickTarget() {
        if (!this.isTargetValid()) {
            this.target = (Ship)M.o00000((new)this.fighter, CollisionClass.SHIP, CollisionClass.FIGHTER);
        }
        if (!this.isTargetValid()) {
            this.task = o.new;
            return;
        }
        this.task = o.\u00d400000;
    }

    private void recheckTargetAndUpdateRunEnd(float f2, boolean bl) {
        this.sinceRecheck += f2;
        if (this.sinceRecheck < this.updateInterval) {
            return;
        }
        this.sinceRecheck = 0.0f;
        if (!this.isTargetValid()) {
            this.task = o.null;
            return;
        }
        if (!bl) {
            return;
        }
        Vector2f vector2f = new Vector2f((ReadableVector2f)this.target.getLocation());
        float f3 = Utils.\u00d800000(this.target.getLocation(), this.fighter.getLocation());
        float f4 = this.fighter.getMaxSpeed();
        float f5 = this.target.getVelocity().length();
        if (f5 >= 0.0f && f4 >= 0.0f) {
            float f6 = f3 / f4;
            vector2f.x += this.target.getVelocity().x * f6;
            vector2f.y += this.target.getVelocity().y * f6;
        }
        Vector2f vector2f2 = Vector2f.sub((Vector2f)vector2f, (Vector2f)this.runStart, (Vector2f)new Vector2f());
        Vector2f.add((Vector2f)this.runStart, (Vector2f)vector2f2, (Vector2f)this.runEnd);
    }

    private void executeAttackRun() {
        float f2 = M.o00000(this.fighter, this.runEnd, false);
        if (f2 < 100.0f) {
            this.task = o.null;
            return;
        }
    }

    private void turnTowardsRunEnd() {
        float f2 = M.o00000(this.fighter, this.runEnd);
        M.\u00d300000(this.fighter, 25.0f);
        if (f2 < 10.0f) {
            this.task = o.\u00d600000;
        }
    }

    private void navigateToRunStart() {
        float f2 = M.o00000(this.fighter, this.runStart, true);
        if (f2 < 100.0f) {
            this.task = o.class;
            this.recheckTargetAndUpdateRunEnd(this.updateInterval, true);
            return;
        }
        float f3 = Utils.\u00d800000(this.target.getLocation(), this.fighter.getLocation());
        if (f3 > this.approachDistance + 100.0f) {
            this.task = o.null;
        }
    }

    private void pickStartLocation() {
        float f2 = Utils.\u00d800000(this.target.getLocation(), this.fighter.getLocation());
        float f3 = Utils.new(this.fighter.getFacing(), this.fighter.getLocation(), this.target.getLocation());
        if (f2 < this.approachDistance && f2 > this.approachDistance / 2.0f && f3 < 30.0f) {
            this.runStart.set((ReadableVector2f)this.fighter.getLocation());
            this.task = o.\u00d600000;
        } else {
            this.runStart.set((ReadableVector2f)this.target.getLocation());
            float f4 = this.fighter.getMaxSpeed();
            float f5 = this.target.getVelocity().length();
            float f6 = Utils.\u00d300000(this.target.getVelocity());
            float f7 = 1.0f - Math.min(f5 / f4, 1.0f);
            f7 *= f7;
            float f8 = f7 * 360.0f;
            float f9 = f6 - f8 / 2.0f;
            float f10 = f9 + (float)Math.random() * f8;
            f10 = (float)Math.toRadians(f10);
            this.runStart.x += (float)Math.cos(f10) * this.attackRunLength * 0.75f;
            this.runStart.y += (float)Math.sin(f10) * this.attackRunLength * 0.75f;
            this.task = o.\u00d800000;
        }
    }

    private boolean isTargetValid() {
        CombatEngine combatEngine = CombatEngine.getInstance();
        List list = combatEngine.getObjects().getList(new.class);
        return this.target != null && list.contains(this.target);
    }

    @Override
    public void render() {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static enum o {
        null,
        \u00d400000,
        \u00d300000,
        \u00d800000,
        class,
        \u00d600000,
        new;

    }
}

