/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CoreUITabId;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.RuleBasedDialog;
import com.fs.starfarer.api.campaign.econ.AbandonMarketPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.ListenerUtil;
import com.fs.starfarer.api.impl.campaign.BaseGenericPlugin;
import com.fs.starfarer.api.impl.campaign.intel.deciv.DecivTracker;
import com.fs.starfarer.api.impl.campaign.rulecmd.FireAll;
import com.fs.starfarer.api.impl.campaign.rulecmd.ShowDefaultVisual;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class AbandonMarketPluginImpl
extends BaseGenericPlugin
implements AbandonMarketPlugin {
    public static int MAX_SIZE = 4;
    public static int COST_PER_SIZE_MINUS_2 = 50000;

    @Override
    public boolean canAbandon(MarketAPI market) {
        return market.getSize() <= MAX_SIZE;
    }

    public int getAbandonCost(MarketAPI market) {
        return Math.max(1, market.getSize() - 2) * COST_PER_SIZE_MINUS_2;
    }

    @Override
    public void createAbandonButtonTooltip(TooltipMakerAPI info, float width, boolean expanded, MarketAPI market) {
        info.addPara("Can only abandon colonies of size %s or smaller.", 0.0f, Misc.getNegativeHighlightColor(), Misc.getHighlightColor(), "" + MAX_SIZE);
    }

    @Override
    public boolean isAbandonButtonTooltipExpandable(MarketAPI market) {
        return false;
    }

    @Override
    public boolean abandonButtonHasTooltip(MarketAPI market) {
        return !this.canAbandon(market);
    }

    @Override
    public void createConfirmationPrompt(MarketAPI market, TooltipMakerAPI prompt) {
        Color h;
        float opad = 10.0f;
        int cost = this.getAbandonCost(market);
        int refund = Misc.computeTotalShutdownRefund(market);
        int credits = (int)Global.getSector().getPlayerFleet().getCargo().getCredits().get();
        Color cc = h = Misc.getHighlightColor();
        String costStr = "cost";
        if (refund > cost) {
            costStr = "payout";
        }
        if (cost - refund > credits) {
            cc = Misc.getNegativeHighlightColor();
        }
        FactionAPI faction = market.getFaction();
        LabelAPI label = prompt.addPara("Abandoning %s, a size %s colony, requires %s in evacuation expenses. Shutting down all operations will generate %s credits, for a net " + costStr + " of %s.", 0.0f, h, market.getName(), "" + market.getSize(), Misc.getDGSCredits(cost), Misc.getDGSCredits(refund), Misc.getDGSCredits(Math.abs(cost - refund)));
        label.setHighlightColors(faction.getBaseUIColor(), h, h, h, cc);
        prompt.addPara("You have %s credits.", opad, h, Misc.getDGSCredits(credits));
        prompt.addPara("This action can not be undone. All items in storage and in use by industries will be lost.", opad);
    }

    @Override
    public boolean isConfirmEnabled(MarketAPI market) {
        int cost = this.getAbandonCost(market);
        int refund = Misc.computeTotalShutdownRefund(market);
        return Global.getSector().getPlayerFleet().getCargo().getCredits().get() >= (float)(cost - refund);
    }

    @Override
    public float getConfirmationPromptWidth(MarketAPI market) {
        return 550.0f;
    }

    @Override
    public void abandonConfirmed(MarketAPI market) {
        int cost = this.getAbandonCost(market);
        int refund = Misc.computeTotalShutdownRefund(market);
        int diff = cost - refund;
        Global.getSector().getPlayerFleet().getCargo().getCredits().subtract(diff);
        if (diff > 0) {
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage(String.format("Spent %s", Misc.getDGSCredits(diff)), Misc.getTooltipTitleAndLightHighlightColor(), Misc.getDGSCredits(diff), Misc.getHighlightColor());
        } else if (diff < 0) {
            Global.getSector().getCampaignUI().getMessageDisplay().addMessage(String.format("Received %s", Misc.getDGSCredits(-diff)), Misc.getTooltipTitleAndLightHighlightColor(), Misc.getDGSCredits(-diff), Misc.getHighlightColor());
        }
        DecivTracker.removeColony(market, false);
        ListenerUtil.reportPlayerAbandonedColony(market);
        InteractionDialogAPI dialog = Global.getSector().getCampaignUI().getCurrentInteractionDialog();
        if (dialog != null && dialog.getPlugin() instanceof RuleBasedDialog) {
            RuleBasedDialog rbd = (RuleBasedDialog)((Object)dialog.getPlugin());
            rbd.updateMemory();
            market.getMemoryWithoutUpdate().unset("$tradeMode");
            if (market.getPrimaryEntity() != null) {
                market.getPrimaryEntity().getMemoryWithoutUpdate().unset("$tradeMode");
            }
            new ShowDefaultVisual().execute(null, dialog, Misc.tokenize(""), rbd.getMemoryMap());
            dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$menuState", "main", 0.0f);
            dialog.getInteractionTarget().getMemoryWithoutUpdate().set("$tradeMode", "NONE", 0.0f);
            dialog.getInteractionTarget().getMemoryWithoutUpdate().unset("$hasMarket");
            dialog.getVisualPanel().closeCoreUI();
            rbd.updateMemory();
            FireAll.fire(null, dialog, rbd.getMemoryMap(), "OpenInteractionDialog");
        } else {
            Global.getSector().getCampaignUI().showCoreUITab(CoreUITabId.OUTPOSTS);
        }
    }
}

