/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.util.DelayedActionScript;
import java.util.ArrayList;
import java.util.List;

public class DelayedBlueprintLearnScript
extends DelayedActionScript {
    public static float LEARNED_HULL_FREQUENCY = 0.1f;
    protected List<String> fighters = new ArrayList<String>();
    protected List<String> weapons = new ArrayList<String>();
    protected List<String> ships = new ArrayList<String>();
    protected List<String> industries = new ArrayList<String>();
    protected String factionId;

    public DelayedBlueprintLearnScript(String factionId) {
        this(factionId, 30.0f);
    }

    public DelayedBlueprintLearnScript(String factionId, float daysLeft) {
        super(daysLeft);
        this.factionId = factionId;
    }

    @Override
    public void doAction() {
        FactionAPI faction = Global.getSector().getFaction(this.factionId);
        if (faction != null) {
            if (!this.ships.isEmpty()) {
                faction.clearShipRoleCache();
            }
            for (String id : this.ships) {
                if (faction.knowsShip(id)) continue;
                faction.addKnownShip(id, true);
                faction.addUseWhenImportingShip(id);
                faction.getHullFrequency().put(id, Float.valueOf(LEARNED_HULL_FREQUENCY));
            }
            for (String id : this.fighters) {
                if (faction.knowsFighter(id)) continue;
                faction.addKnownFighter(id, true);
            }
            for (String id : this.weapons) {
                if (faction.knowsWeapon(id)) continue;
                faction.addKnownWeapon(id, true);
            }
            for (String id : this.industries) {
                if (faction.knowsIndustry(id)) continue;
                faction.addKnownIndustry(id);
            }
        }
    }

    public List<String> getFighters() {
        return this.fighters;
    }

    public List<String> getWeapons() {
        return this.weapons;
    }

    public List<String> getShips() {
        return this.ships;
    }

    public List<String> getIndustries() {
        return this.industries;
    }
}

