/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.fleet.MutableFleetStatsAPI;
import com.fs.starfarer.api.impl.campaign.ids.Stats;
import com.fs.starfarer.api.impl.campaign.procgen.ConditionGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.themes.DerelictThemeGenerator;
import com.fs.starfarer.api.plugins.SurveyPlugin;
import com.fs.starfarer.api.util.Misc;
import java.util.LinkedHashMap;
import java.util.Map;

public class SurveyPluginImpl
implements SurveyPlugin {
    public static int FLAT_SUPPLIES = 10;
    public static int BASE_MACHINERY = 10;
    public static int BASE_CREW = 50;
    public static int BASE_SUPPLIES = 10;
    public static int MIN_SUPPLIES_OR_MACHINERY = 5;
    public static float MIN_PLANET_RADIUS = 70.0f;
    public static float MAX_PLANET_RADIUS = 250.0f;
    public static float MULT_AT_MAX_PLANET_RADIUS = 5.0f;
    private CampaignFleetAPI fleet;
    private PlanetAPI planet;
    private MutableStat costMult = new MutableStat(1.0f);
    private MutableStat xpMult = new MutableStat(1.0f);

    @Override
    public void init(CampaignFleetAPI fleet, PlanetAPI planet) {
        float size;
        this.fleet = fleet;
        this.planet = planet;
        float hazard = this.getHazardMultiplier();
        if (hazard != 1.0f) {
            this.costMult.modifyMult("planet_hazard", hazard, "Hazard rating");
        }
        if ((size = this.getSizeMultiplier()) != 1.0f) {
            this.costMult.modifyMult("planet_size", size, "Planet size");
        }
        this.xpMult.applyMods(this.costMult);
        if (fleet != null) {
            MutableFleetStatsAPI stats = fleet.getStats();
            MutableStat stat = stats.getDynamic().getStat("survey_cost_mult");
            for (MutableStat.StatMod mod : stat.getMultMods().values()) {
                this.costMult.modifyMult(mod.source, mod.value, mod.desc);
            }
        }
    }

    protected float getHazardMultiplier() {
        float hazard = this.planet.getMarket().getHazardValue();
        return hazard;
    }

    protected float getSizeMultiplier() {
        float radius = this.planet.getRadius();
        float range = MAX_PLANET_RADIUS - MIN_PLANET_RADIUS;
        if (range <= 0.0f) {
            return 1.0f;
        }
        if (radius < MIN_PLANET_RADIUS) {
            radius = MIN_PLANET_RADIUS;
        }
        if (radius > MAX_PLANET_RADIUS) {
            radius = MAX_PLANET_RADIUS;
        }
        float mult = 1.0f + (radius - MIN_PLANET_RADIUS) / range * (MULT_AT_MAX_PLANET_RADIUS - 1.0f);
        mult = (float)((int)(mult * 20.0f)) / 20.0f;
        return mult;
    }

    @Override
    public Map<String, Integer> getRequired() {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        float mult = this.getCostMult().getModifiedValue();
        int machinery = Math.round((float)BASE_MACHINERY * mult);
        machinery -= (int)Misc.getFleetwideTotalMod(this.fleet, Stats.getSurveyCostReductionId("heavy_machinery"), 0.0f);
        if ((machinery = Math.round((float)machinery / 10.0f) * 10) < MIN_SUPPLIES_OR_MACHINERY) {
            machinery = MIN_SUPPLIES_OR_MACHINERY;
        }
        result.put("crew", Math.round((float)((int)((float)BASE_CREW * mult)) / 10.0f) * 10);
        result.put("heavy_machinery", machinery);
        return result;
    }

    @Override
    public Map<String, Integer> getConsumed() {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        float mult = this.getCostMult().getModifiedValue();
        int supplies = Math.round((float)BASE_SUPPLIES * mult);
        supplies += FLAT_SUPPLIES;
        supplies = Math.round((float)supplies / 10.0f) * 10;
        if ((supplies -= (int)Misc.getFleetwideTotalMod(this.fleet, Stats.getSurveyCostReductionId("supplies"), 0.0f)) < MIN_SUPPLIES_OR_MACHINERY) {
            supplies = MIN_SUPPLIES_OR_MACHINERY;
        }
        result.put("supplies", supplies);
        return result;
    }

    @Override
    public MutableStat getCostMult() {
        return this.costMult;
    }

    @Override
    public long getXP() {
        float xp = 0.0f;
        if (this.planet.getMarket() != null) {
            for (MarketConditionAPI mc : this.planet.getMarket().getConditions()) {
                xp += (float)this.getBaseXPForCondition(mc.getId());
            }
        }
        return (long)(xp *= this.getXPMult().getModifiedValue());
    }

    @Override
    public long getBaseXPForCondition(String conditionId) {
        long xp = 0L;
        float base = Global.getSettings().getFloat("baseSurveyXP");
        ConditionGenDataSpec data = (ConditionGenDataSpec)Global.getSettings().getSpec(ConditionGenDataSpec.class, conditionId, true);
        if (data != null) {
            xp = (long)((float)xp + base * data.getXpMult());
        }
        return xp;
    }

    @Override
    public MutableStat getXPMult() {
        return this.xpMult;
    }

    @Override
    public String getImageCategory() {
        return "illustrations";
    }

    @Override
    public String getImageKey() {
        return "survey";
    }

    @Override
    public String getSurveyDataType(PlanetAPI planet) {
        float hazard;
        if (planet.getMarket() == null) {
            return null;
        }
        int count = 0;
        float value = 0.0f;
        for (MarketConditionAPI mc : planet.getMarket().getConditions()) {
            if (DerelictThemeGenerator.interestingConditionsWithRuins.contains(mc.getId())) {
                ++count;
            }
            if (mc.getGenSpec() == null) continue;
            value += mc.getGenSpec().getRank();
        }
        if (planet.getMarket().hasCondition("habitable")) {
            value += 4.0f;
        }
        if ((value -= ((hazard = planet.getMarket().getHazardValue()) - 1.0f) * 2.0f) <= 5.0f) {
            return "survey_data_1";
        }
        if (value <= 8.0f) {
            return "survey_data_2";
        }
        if (value <= 11.0f && count <= 1) {
            return "survey_data_3";
        }
        if (value <= 14.0f && count <= 2) {
            return "survey_data_4";
        }
        return "survey_data_5";
    }

    @Override
    public Map<String, Integer> getOutpostConsumed() {
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        result.put("crew", 1000);
        result.put("heavy_machinery", 100);
        result.put("supplies", 200);
        return result;
    }
}

