/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.econ.impl;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.Industry;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.listeners.FleetEventListener;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.impl.campaign.DebugFlags;
import com.fs.starfarer.api.impl.campaign.econ.impl.BaseIndustry;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV3;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParamsV3;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolAssignmentAIV4;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.impl.campaign.rulecmd.salvage.MarketCMD;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.Pair;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class MilitaryBase
extends BaseIndustry
implements RouteManager.RouteFleetSpawner,
FleetEventListener {
    public static float OFFICER_PROB_MOD_PATROL_HQ = 0.1f;
    public static float OFFICER_PROB_MOD_MILITARY_BASE = 0.2f;
    public static float OFFICER_PROB_MOD_HIGH_COMMAND = 0.3f;
    public static float DEFENSE_BONUS_PATROL = 0.1f;
    public static float DEFENSE_BONUS_MILITARY = 0.2f;
    public static float DEFENSE_BONUS_COMMAND = 0.3f;
    public static int IMPROVE_NUM_PATROLS_BONUS = 1;
    protected IntervalUtil tracker = new IntervalUtil(Global.getSettings().getFloat("averagePatrolSpawnInterval") * 0.7f, Global.getSettings().getFloat("averagePatrolSpawnInterval") * 1.3f);
    protected float returningPatrolValue = 0.0f;
    public static float ALPHA_CORE_BONUS = 0.25f;

    @Override
    public void apply() {
        int size = this.market.getSize();
        boolean patrol = this.getSpec().hasTag("patrol");
        boolean militaryBase = this.getSpec().hasTag("military");
        boolean command = this.getSpec().hasTag("command");
        super.apply(!patrol);
        if (patrol) {
            this.applyIncomeAndUpkeep(3.0f);
        }
        int extraDemand = 0;
        int light = 1;
        int medium = 0;
        int heavy = 0;
        if (patrol) {
            extraDemand = 0;
        } else if (militaryBase) {
            extraDemand = 2;
        } else if (command) {
            extraDemand = 3;
        }
        if (patrol) {
            light = 2;
            medium = 0;
            heavy = 0;
        } else if (size <= 3) {
            light = 2;
            medium = 0;
            heavy = 0;
        } else if (size == 4) {
            light = 2;
            medium = 0;
            heavy = 0;
        } else if (size == 5) {
            light = 2;
            medium = 1;
            heavy = 0;
        } else if (size == 6) {
            light = 3;
            medium = 1;
            heavy = 0;
        } else if (size == 7) {
            light = 3;
            medium = 2;
            heavy = 0;
        } else if (size == 8) {
            light = 3;
            medium = 3;
            heavy = 0;
        } else if (size >= 9) {
            light = 4;
            medium = 3;
            heavy = 0;
        }
        if (militaryBase || command) {
            medium = Math.max(medium + 1, size / 2 - 1);
            heavy = Math.max(heavy, medium - 1);
        }
        if (command) {
            ++medium;
            ++heavy;
        }
        this.market.getStats().getDynamic().getMod("patrol_num_light_mod").modifyFlat(this.getModId(), light);
        this.market.getStats().getDynamic().getMod("patrol_num_medium_mod").modifyFlat(this.getModId(), medium);
        this.market.getStats().getDynamic().getMod("patrol_num_heavy_mod").modifyFlat(this.getModId(), heavy);
        this.demand("supplies", size - 1 + extraDemand);
        this.demand("fuel", size - 1 + extraDemand);
        this.demand("ships", size - 1 + extraDemand);
        this.supply("crew", size);
        if (!patrol) {
            this.supply("marines", size);
        }
        this.modifyStabilityWithBaseMod();
        float mult = this.getDeficitMult("supplies");
        String extra = "";
        if (mult != 1.0f) {
            String com = (String)this.getMaxDeficit((String[])new String[]{"supplies"}).one;
            extra = " (" + MilitaryBase.getDeficitText(com).toLowerCase() + ")";
        }
        float bonus = DEFENSE_BONUS_MILITARY;
        if (patrol) {
            bonus = DEFENSE_BONUS_PATROL;
        } else if (command) {
            bonus = DEFENSE_BONUS_COMMAND;
        }
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").modifyMult(this.getModId(), 1.0f + bonus * mult, String.valueOf(this.getNameForModifier()) + extra);
        MemoryAPI memory = this.market.getMemoryWithoutUpdate();
        Misc.setFlagWithReason(memory, "$patrol", this.getModId(), true, -1.0f);
        if (militaryBase || command) {
            Misc.setFlagWithReason(memory, "$military", this.getModId(), true, -1.0f);
        }
        float officerProb = OFFICER_PROB_MOD_PATROL_HQ;
        if (militaryBase) {
            officerProb = OFFICER_PROB_MOD_MILITARY_BASE;
        } else if (command) {
            officerProb = OFFICER_PROB_MOD_HIGH_COMMAND;
        }
        this.market.getStats().getDynamic().getMod("officer_prob").modifyFlat(this.getModId(0), officerProb);
        if (!this.isFunctional()) {
            this.supply.clear();
            this.unapply();
        }
    }

    @Override
    public void unapply() {
        super.unapply();
        MemoryAPI memory = this.market.getMemoryWithoutUpdate();
        Misc.setFlagWithReason(memory, "$patrol", this.getModId(), false, -1.0f);
        Misc.setFlagWithReason(memory, "$military", this.getModId(), false, -1.0f);
        this.unmodifyStabilityWithBaseMod();
        this.market.getStats().getDynamic().getMod("patrol_num_light_mod").unmodifyFlat(this.getModId());
        this.market.getStats().getDynamic().getMod("patrol_num_medium_mod").unmodifyFlat(this.getModId());
        this.market.getStats().getDynamic().getMod("patrol_num_heavy_mod").unmodifyFlat(this.getModId());
        this.market.getStats().getDynamic().getMod("ground_defenses_mod").unmodifyMult(this.getModId());
        this.market.getStats().getDynamic().getMod("officer_prob").unmodifyFlat(this.getModId(0));
    }

    @Override
    protected boolean hasPostDemandSection(boolean hasDemand, Industry.IndustryTooltipMode mode) {
        return mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional();
    }

    @Override
    protected void addPostDemandSection(TooltipMakerAPI tooltip, boolean hasDemand, Industry.IndustryTooltipMode mode) {
        if (mode != Industry.IndustryTooltipMode.NORMAL || this.isFunctional()) {
            this.addStabilityPostDemandSection(tooltip, hasDemand, mode);
            boolean patrol = this.getSpec().hasTag("patrol");
            boolean command = this.getSpec().hasTag("command");
            float bonus = DEFENSE_BONUS_MILITARY;
            if (patrol) {
                bonus = DEFENSE_BONUS_PATROL;
            }
            if (command) {
                bonus = DEFENSE_BONUS_COMMAND;
            }
            this.addGroundDefensesImpactSection(tooltip, bonus, "supplies");
        }
    }

    @Override
    protected int getBaseStabilityMod() {
        boolean patrol = this.getSpec().hasTag("patrol");
        boolean militaryBase = this.getSpec().hasTag("military");
        boolean command = this.getSpec().hasTag("command");
        int stabilityMod = 1;
        if (patrol) {
            stabilityMod = 1;
        } else if (militaryBase) {
            stabilityMod = 2;
        } else if (command) {
            stabilityMod = 2;
        }
        return stabilityMod;
    }

    @Override
    public String getNameForModifier() {
        if (this.getSpec().getName().contains("HQ")) {
            return this.getSpec().getName();
        }
        return Misc.ucFirst(this.getSpec().getName().toLowerCase());
    }

    @Override
    protected Pair<String, Integer> getStabilityAffectingDeficit() {
        boolean patrol = this.getSpec().hasTag("patrol");
        if (patrol) {
            return this.getMaxDeficit("supplies", "fuel", "ships");
        }
        return this.getMaxDeficit("supplies", "fuel", "ships");
    }

    @Override
    public String getCurrentImage() {
        PlanetAPI planet;
        boolean military = "militarybase".equals(this.getId());
        if (military && ((planet = this.market.getPlanetEntity()) == null || planet.isGasGiant())) {
            return Global.getSettings().getSpriteName("industry", "military_base_orbital");
        }
        return super.getCurrentImage();
    }

    @Override
    public boolean isDemandLegal(CommodityOnMarketAPI com) {
        return true;
    }

    @Override
    public boolean isSupplyLegal(CommodityOnMarketAPI com) {
        return true;
    }

    @Override
    public boolean isAvailableToBuild() {
        boolean canBuild = false;
        for (Industry ind : this.market.getIndustries()) {
            if (ind == this || !ind.isFunctional() || !ind.getSpec().hasTag("spaceport")) continue;
            canBuild = true;
            break;
        }
        return canBuild;
    }

    @Override
    public String getUnavailableReason() {
        return "Requires a functional spaceport";
    }

    @Override
    protected void buildingFinished() {
        super.buildingFinished();
        this.tracker.forceIntervalElapsed();
    }

    @Override
    protected void upgradeFinished(Industry previous) {
        super.upgradeFinished(previous);
        this.tracker.forceIntervalElapsed();
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (Global.getSector().getEconomy().isSimMode()) {
            return;
        }
        if (!this.isFunctional()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        float spawnRate = 1.0f;
        float rateMult = this.market.getStats().getDynamic().getStat("combat_fleet_spawn_rate_mult").getModifiedValue();
        spawnRate *= rateMult;
        if (Global.getSector().isInNewGameAdvance()) {
            spawnRate *= 3.0f;
        }
        float extraTime = 0.0f;
        if (this.returningPatrolValue > 0.0f) {
            float interval = this.tracker.getIntervalDuration();
            extraTime = interval * days;
            this.returningPatrolValue -= days;
            if (this.returningPatrolValue < 0.0f) {
                this.returningPatrolValue = 0.0f;
            }
        }
        this.tracker.advance(days * spawnRate + extraTime);
        if (DebugFlags.FAST_PATROL_SPAWN) {
            this.tracker.advance(days * spawnRate * 100.0f);
        }
        if (this.tracker.intervalElapsed()) {
            String sid = this.getRouteSourceId();
            int light = this.getCount(FleetFactory.PatrolType.FAST);
            int medium = this.getCount(FleetFactory.PatrolType.COMBAT);
            int heavy = this.getCount(FleetFactory.PatrolType.HEAVY);
            int maxLight = this.getMaxPatrols(FleetFactory.PatrolType.FAST);
            int maxMedium = this.getMaxPatrols(FleetFactory.PatrolType.COMBAT);
            int maxHeavy = this.getMaxPatrols(FleetFactory.PatrolType.HEAVY);
            WeightedRandomPicker<FleetFactory.PatrolType> picker = new WeightedRandomPicker<FleetFactory.PatrolType>();
            picker.add(FleetFactory.PatrolType.HEAVY, maxHeavy - heavy);
            picker.add(FleetFactory.PatrolType.COMBAT, maxMedium - medium);
            picker.add(FleetFactory.PatrolType.FAST, maxLight - light);
            if (picker.isEmpty()) {
                return;
            }
            FleetFactory.PatrolType type = (FleetFactory.PatrolType)((Object)picker.pick());
            PatrolFleetData custom = new PatrolFleetData(type);
            RouteManager.OptionalFleetData extra = new RouteManager.OptionalFleetData(this.market);
            extra.fleetType = type.getFleetType();
            RouteManager.RouteData route = RouteManager.getInstance().addRoute(sid, this.market, Misc.genRandomSeed(), extra, this, custom);
            extra.strength = Float.valueOf(MilitaryBase.getPatrolCombatFP(type, route.getRandom()));
            extra.strength = Float.valueOf(Misc.getAdjustedStrength(extra.strength.floatValue(), this.market));
            float patrolDays = 35.0f + (float)Math.random() * 10.0f;
            route.addSegment(new RouteManager.RouteSegment(patrolDays, this.market.getPrimaryEntity()));
        }
    }

    @Override
    public void reportAboutToBeDespawnedByRouteManager(RouteManager.RouteData route) {
    }

    @Override
    public boolean shouldRepeat(RouteManager.RouteData route) {
        return false;
    }

    public int getCount(FleetFactory.PatrolType ... types) {
        int count = 0;
        block0: for (RouteManager.RouteData data : RouteManager.getInstance().getRoutesForSource(this.getRouteSourceId())) {
            if (!(data.getCustom() instanceof PatrolFleetData)) continue;
            PatrolFleetData custom = (PatrolFleetData)data.getCustom();
            FleetFactory.PatrolType[] patrolTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                FleetFactory.PatrolType type = patrolTypeArray[n2];
                if (type == custom.type) {
                    ++count;
                    continue block0;
                }
                ++n2;
            }
        }
        return count;
    }

    public int getMaxPatrols(FleetFactory.PatrolType type) {
        if (type == FleetFactory.PatrolType.FAST) {
            return (int)this.market.getStats().getDynamic().getMod("patrol_num_light_mod").computeEffective(0.0f);
        }
        if (type == FleetFactory.PatrolType.COMBAT) {
            return (int)this.market.getStats().getDynamic().getMod("patrol_num_medium_mod").computeEffective(0.0f);
        }
        if (type == FleetFactory.PatrolType.HEAVY) {
            return (int)this.market.getStats().getDynamic().getMod("patrol_num_heavy_mod").computeEffective(0.0f);
        }
        return 0;
    }

    public String getRouteSourceId() {
        return String.valueOf(this.getMarket().getId()) + "_" + "military";
    }

    @Override
    public boolean shouldCancelRouteAfterDelayCheck(RouteManager.RouteData route) {
        return false;
    }

    @Override
    public void reportBattleOccurred(CampaignFleetAPI fleet, CampaignFleetAPI primaryWinner, BattleAPI battle) {
    }

    @Override
    public void reportFleetDespawnedToListener(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        RouteManager.RouteData route;
        if (!this.isFunctional()) {
            return;
        }
        if (reason == CampaignEventListener.FleetDespawnReason.REACHED_DESTINATION && (route = RouteManager.getInstance().getRoute(this.getRouteSourceId(), fleet)).getCustom() instanceof PatrolFleetData) {
            PatrolFleetData custom = (PatrolFleetData)route.getCustom();
            if (custom.spawnFP > 0) {
                float fraction = fleet.getFleetPoints() / custom.spawnFP;
                this.returningPatrolValue += fraction;
            }
        }
    }

    public static int getPatrolCombatFP(FleetFactory.PatrolType type, Random random) {
        float combat = 0.0f;
        switch (type) {
            case FAST: {
                combat = (float)Math.round(3.0f + random.nextFloat() * 2.0f) * 5.0f;
                break;
            }
            case COMBAT: {
                combat = (float)Math.round(6.0f + random.nextFloat() * 3.0f) * 5.0f;
                break;
            }
            case HEAVY: {
                combat = (float)Math.round(10.0f + random.nextFloat() * 5.0f) * 5.0f;
            }
        }
        return Math.round(combat);
    }

    @Override
    public CampaignFleetAPI spawnFleet(RouteManager.RouteData route) {
        PatrolFleetData custom = (PatrolFleetData)route.getCustom();
        FleetFactory.PatrolType type = custom.type;
        Random random = route.getRandom();
        CampaignFleetAPI fleet = MilitaryBase.createPatrol(type, this.market.getFactionId(), route, this.market, null, random);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        fleet.addEventListener(this);
        this.market.getContainingLocation().addEntity(fleet);
        fleet.setFacing((float)Math.random() * 360.0f);
        fleet.setLocation(this.market.getPrimaryEntity().getLocation().x, this.market.getPrimaryEntity().getLocation().y);
        fleet.addScript(new PatrolAssignmentAIV4(fleet, route));
        fleet.getMemoryWithoutUpdate().set("$cfai_ignoreOtherFleets", true, 0.3f);
        if (custom.spawnFP <= 0) {
            custom.spawnFP = fleet.getFleetPoints();
        }
        return fleet;
    }

    public static CampaignFleetAPI createPatrol(FleetFactory.PatrolType type, String factionId, RouteManager.RouteData route, MarketAPI market, Vector2f locInHyper, Random random) {
        return MilitaryBase.createPatrol(type, 0.0f, factionId, route, market, locInHyper, random);
    }

    public static CampaignFleetAPI createPatrol(FleetFactory.PatrolType type, float extraTankerPts, String factionId, RouteManager.RouteData route, MarketAPI market, Vector2f locInHyper, Random random) {
        if (random == null) {
            random = new Random();
        }
        float combat = MilitaryBase.getPatrolCombatFP(type, random);
        float tanker = 0.0f;
        float freighter = 0.0f;
        String fleetType = type.getFleetType();
        switch (type) {
            case FAST: {
                break;
            }
            case COMBAT: {
                tanker = Math.round(random.nextFloat() * 5.0f);
                break;
            }
            case HEAVY: {
                tanker = Math.round(random.nextFloat() * 10.0f);
                freighter = Math.round(random.nextFloat() * 10.0f);
            }
        }
        FleetParamsV3 params = new FleetParamsV3(market, locInHyper, factionId, route == null ? null : route.getQualityOverride(), fleetType, combat, freighter, tanker += extraTankerPts, 0.0f, 0.0f, 0.0f, 0.0f);
        if (route != null) {
            params.timestamp = route.getTimestamp();
        }
        params.random = random;
        CampaignFleetAPI fleet = FleetFactoryV3.createFleet(params);
        if (fleet == null || fleet.isEmpty()) {
            return null;
        }
        if (!fleet.getFaction().getCustomBoolean("patrolsHaveNoPatrolMemoryKey")) {
            fleet.getMemoryWithoutUpdate().set("$isPatrol", true);
            if (type == FleetFactory.PatrolType.FAST || type == FleetFactory.PatrolType.COMBAT) {
                fleet.getMemoryWithoutUpdate().set("$isCustomsInspector", true);
            }
        } else if (fleet.getFaction().getCustomBoolean("pirateBehavior")) {
            fleet.getMemoryWithoutUpdate().set("$isPirate", true);
            if (market != null && market.isHidden()) {
                fleet.getMemoryWithoutUpdate().set("$isRaider", true);
            }
        }
        String postId = Ranks.POST_PATROL_COMMANDER;
        String rankId = Ranks.SPACE_COMMANDER;
        switch (type) {
            case FAST: {
                rankId = Ranks.SPACE_LIEUTENANT;
                break;
            }
            case COMBAT: {
                rankId = Ranks.SPACE_COMMANDER;
                break;
            }
            case HEAVY: {
                rankId = Ranks.SPACE_CAPTAIN;
            }
        }
        fleet.getCommander().setPostId(postId);
        fleet.getCommander().setRankId(rankId);
        return fleet;
    }

    @Override
    protected void applyAlphaCoreModifiers() {
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").modifyMult(this.getModId(), 1.0f + ALPHA_CORE_BONUS, "Alpha core (" + this.getNameForModifier() + ")");
    }

    @Override
    protected void applyNoAICoreModifiers() {
        this.market.getStats().getDynamic().getMod("combat_fleet_size_mult").unmodifyMult(this.getModId());
    }

    @Override
    protected void applyAlphaCoreSupplyAndDemandModifiers() {
        this.demandReduction.modifyFlat(this.getModId(0), DEMAND_REDUCTION, "Alpha core");
    }

    @Override
    protected void addAlphaCoreDescription(TooltipMakerAPI tooltip, Industry.AICoreDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String pre = "Alpha-level AI core currently assigned. ";
        if (mode == Industry.AICoreDescriptionMode.MANAGE_CORE_DIALOG_LIST || mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            pre = "Alpha-level AI core. ";
        }
        float a = ALPHA_CORE_BONUS;
        String str = "\u00d7" + (1.0f + a);
        if (mode == Industry.AICoreDescriptionMode.INDUSTRY_TOOLTIP) {
            CommoditySpecAPI coreSpec = Global.getSettings().getCommoditySpec(this.aiCoreId);
            TooltipMakerAPI text = tooltip.beginImageWithText(coreSpec.getIconName(), 48.0f);
            text.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases fleet size by %s.", 0.0f, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
            tooltip.addImageWithText(opad);
            return;
        }
        tooltip.addPara(String.valueOf(pre) + "Reduces upkeep cost by %s. Reduces demand by %s unit. " + "Increases fleet size by %s.", opad, highlight, (int)((1.0f - UPKEEP_MULT) * 100.0f) + "%", "" + DEMAND_REDUCTION, str);
    }

    @Override
    public boolean canImprove() {
        return true;
    }

    @Override
    protected void applyImproveModifiers() {
        String key = "mil_base_improve";
        if (this.isImproved()) {
            boolean patrol = this.getSpec().hasTag("patrol");
            if (patrol) {
                this.market.getStats().getDynamic().getMod("patrol_num_medium_mod").modifyFlat(key, IMPROVE_NUM_PATROLS_BONUS);
            } else {
                this.market.getStats().getDynamic().getMod("patrol_num_heavy_mod").modifyFlat(key, IMPROVE_NUM_PATROLS_BONUS);
            }
        } else {
            this.market.getStats().getDynamic().getMod("patrol_num_medium_mod").unmodifyFlat(key);
            this.market.getStats().getDynamic().getMod("patrol_num_heavy_mod").unmodifyFlat(key);
        }
    }

    @Override
    public void addImproveDesc(TooltipMakerAPI info, Industry.ImprovementDescriptionMode mode) {
        float opad = 10.0f;
        Color highlight = Misc.getHighlightColor();
        String str = "" + IMPROVE_NUM_PATROLS_BONUS;
        boolean patrol = this.getSpec().hasTag("patrol");
        String type = "medium patrols";
        if (!patrol) {
            type = "heavy patrols";
        }
        if (mode == Industry.ImprovementDescriptionMode.INDUSTRY_TOOLTIP) {
            info.addPara("Number of " + type + " launched increased by %s.", 0.0f, highlight, str);
        } else {
            info.addPara("Increases the number of " + type + " launched by %s.", 0.0f, highlight, str);
        }
        info.addSpacer(opad);
        super.addImproveDesc(info, mode);
    }

    @Override
    public MarketCMD.RaidDangerLevel adjustCommodityDangerLevel(String commodityId, MarketCMD.RaidDangerLevel level) {
        return level.next();
    }

    @Override
    public MarketCMD.RaidDangerLevel adjustItemDangerLevel(String itemId, String data, MarketCMD.RaidDangerLevel level) {
        return level.next();
    }

    public static class PatrolFleetData {
        public FleetFactory.PatrolType type;
        public int spawnFP;

        public PatrolFleetData(FleetFactory.PatrolType type) {
            this.type = type;
        }
    }
}

