/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.enc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.NascentGravityWellAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.enc.AbyssalFrequencies;
import com.fs.starfarer.api.impl.campaign.enc.AbyssalLocationDespawner;
import com.fs.starfarer.api.impl.campaign.enc.BaseEPEncounterCreator;
import com.fs.starfarer.api.impl.campaign.enc.EncounterManager;
import com.fs.starfarer.api.impl.campaign.enc.EncounterPoint;
import com.fs.starfarer.api.impl.campaign.procgen.AccretionDiskGenPlugin;
import com.fs.starfarer.api.impl.campaign.procgen.PlanetGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarGenDataSpec;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.impl.campaign.procgen.TerrainGenDataSpec;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceAbyssPluginImpl;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.StarCoronaTerrainPlugin;
import com.fs.starfarer.api.impl.campaign.world.GateHaulerLocation;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;

public class AbyssalRogueStellarObjectEPEC
extends BaseEPEncounterCreator {
    public static float MIN_THREAT_PROB = 0.25f;
    public static float MAX_THREAT_PROB = 0.75f;
    public static float MAX_THREAT_PROB_DEPTH = 5.0f;
    public static float MIN_DEPTH_FOR_GUARANTEED = 3.0f;
    public static float BONUS_PROB_PER_FAIL = 0.125f;
    public static float PROB_BLACK_HOLE_ORBITERS = 0.1f;
    public static WeightedRandomPicker<RogueStellarObjectType> STELLAR_OBJECT_TYPES = new WeightedRandomPicker();
    public static WeightedRandomPicker<String> PLANETOID_TYPES;
    public static WeightedRandomPicker<String> GAS_GIANT_TYPES;
    public static WeightedRandomPicker<String> BLACK_HOLE_TYPES;

    static {
        STELLAR_OBJECT_TYPES.add(RogueStellarObjectType.PLANETOID, 100.0f);
        STELLAR_OBJECT_TYPES.add(RogueStellarObjectType.GAS_GIANT, 20.0f);
        STELLAR_OBJECT_TYPES.add(RogueStellarObjectType.BLACK_HOLE, 7.0f);
        PLANETOID_TYPES = new WeightedRandomPicker();
        PLANETOID_TYPES.add("cryovolcanic", 5.0f);
        PLANETOID_TYPES.add("frozen", 2.5f);
        PLANETOID_TYPES.add("frozen1", 2.5f);
        PLANETOID_TYPES.add("frozen2", 2.5f);
        PLANETOID_TYPES.add("frozen3", 2.5f);
        PLANETOID_TYPES.add("barren", 2.5f);
        PLANETOID_TYPES.add("barren2", 2.5f);
        PLANETOID_TYPES.add("barren3", 2.5f);
        PLANETOID_TYPES.add("barren_castiron", 2.5f);
        PLANETOID_TYPES.add("barren-bombarded", 5.0f);
        PLANETOID_TYPES.add("rocky_metallic", 5.0f);
        PLANETOID_TYPES.add("rocky_ice", 5.0f);
        GAS_GIANT_TYPES = new WeightedRandomPicker();
        GAS_GIANT_TYPES.add("ice_giant", 10.0f);
        GAS_GIANT_TYPES.add("gas_giant", 5.0f);
        BLACK_HOLE_TYPES = new WeightedRandomPicker();
        BLACK_HOLE_TYPES.add("black_hole", 10.0f);
    }

    @Override
    public float getFrequencyForPoint(EncounterManager manager, EncounterPoint point) {
        return AbyssalFrequencies.getAbyssalRogueStellarObjectFrequency(manager, point);
    }

    @Override
    public void createEncounter(EncounterManager manager, EncounterPoint point) {
        HyperspaceAbyssPluginImpl.AbyssalEPData data = (HyperspaceAbyssPluginImpl.AbyssalEPData)point.custom;
        SectorAPI sector = Global.getSector();
        StarSystemAPI system = sector.createStarSystem("Deep Space");
        system.setProcgen(true);
        system.setName("Deep Space");
        system.setOptionalUniqueId(Misc.genUID());
        system.setType(StarSystemGenerator.StarSystemType.DEEP_SPACE);
        system.addTag("theme_hidden");
        system.addTag("theme_special");
        system.addTag("temporary_location");
        system.addTag("system_abyssal");
        if (data.nearest == null) {
            float prob = (data.depth - 1.0f) / (MAX_THREAT_PROB_DEPTH - 1.0f) * MAX_THREAT_PROB;
            if (prob > MAX_THREAT_PROB) {
                prob = MAX_THREAT_PROB;
            }
            if (prob > 0.0f && prob < MIN_THREAT_PROB) {
                prob = 0.25f;
            }
            String failKey = "$threatSpawnsFailedToRoll";
            float numFails = Global.getSector().getMemoryWithoutUpdate().getInt(failKey);
            float probBonus = 0.0f;
            if (data.depth >= MIN_DEPTH_FOR_GUARANTEED) {
                probBonus = numFails * BONUS_PROB_PER_FAIL;
            }
            if (data.random.nextFloat() < prob + probBonus) {
                system.addTag("system_can_spawn_threat");
                numFails = 0.0f;
            } else {
                numFails += 1.0f;
            }
            Global.getSector().getMemoryWithoutUpdate().set(failKey, (int)numFails);
        }
        system.setBackgroundTextureFilename("graphics/backgrounds/background4.jpg");
        system.getLocation().set(point.loc.x, point.loc.y);
        SectorEntityToken center = system.initNonStarCenter();
        system.setLightColor(GateHaulerLocation.ABYSS_AMBIENT_LIGHT_COLOR);
        center.addTag("ambient_ls");
        RogueStellarObjectType objectType = STELLAR_OBJECT_TYPES.pick(data.random);
        if (objectType == null) {
            return;
        }
        WeightedRandomPicker<StarAge> agePicker = new WeightedRandomPicker<StarAge>(data.random);
        agePicker.add(StarAge.OLD, 10.0f);
        agePicker.add(StarAge.AVERAGE, 5.0f);
        agePicker.add(StarAge.YOUNG, 3.0f);
        StarAge age = (StarAge)((Object)agePicker.pick());
        String nebulaId = "nebula_center_old";
        if (age == StarAge.AVERAGE) {
            nebulaId = "nebula_center_average";
        } else if (age == StarAge.YOUNG) {
            nebulaId = "nebula_center_young";
        }
        StarGenDataSpec starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, nebulaId, false);
        StarSystemGenerator.CustomConstellationParams params = new StarSystemGenerator.CustomConstellationParams(age);
        Random prev = StarSystemGenerator.random;
        StarSystemGenerator.random = data.random;
        StarSystemGenerator gen = new StarSystemGenerator(params);
        gen.init(system, age);
        StarSystemGenerator.GenContext context = new StarSystemGenerator.GenContext(gen, system, system.getCenter(), starData, null, 0, age.name(), 0.0f, 1000.0f, null, -1);
        context.lagrangeParent = new StarSystemGenerator.GeneratedPlanet(null, null, false, 0.0f, 0.0f, 0.0f);
        context.excludeCategories.add("cat_hab5");
        context.excludeCategories.add("cat_hab4");
        context.excludeCategories.add("cat_hab3");
        context.excludeCategories.add("cat_hab2");
        PlanetAPI main = null;
        if (objectType == RogueStellarObjectType.BLACK_HOLE) {
            main = this.addBlackHole(system, context, data);
            if (main != null) {
                system.setStar(main);
                system.setCenter(main);
                system.removeEntity(center);
                center = main;
                data.random.nextFloat();
                context.starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, "black_hole", false);
                StarSystemGenerator.addOrbitingEntities(system, main, age, 1, 3, 500.0f, 0, false, false);
            }
        } else {
            String planetType = objectType == RogueStellarObjectType.PLANETOID ? PLANETOID_TYPES.pick(data.random) : GAS_GIANT_TYPES.pick(data.random);
            PlanetGenDataSpec planetData = (PlanetGenDataSpec)Global.getSettings().getSpec(PlanetGenDataSpec.class, planetType, false);
            StarSystemGenerator.GenResult result = gen.addPlanet(context, planetData, false, true);
            if (result == null || result.entities.isEmpty() || !(result.entities.get(0) instanceof PlanetAPI)) {
                return;
            }
            main = (PlanetAPI)result.entities.get(0);
        }
        if (main == null) {
            return;
        }
        main.setOrbit(null);
        main.setLocation(0.0f, 0.0f);
        boolean multiple = context.generatedPlanets.size() > 1;
        int index = data.random.nextInt(20);
        ArrayList<PlanetAPI> sorted = new ArrayList<PlanetAPI>(system.getPlanets());
        Collections.sort(sorted, new Comparator<PlanetAPI>(){

            @Override
            public int compare(PlanetAPI o1, PlanetAPI o2) {
                return (int)Math.signum(o2.getRadius() - o1.getRadius());
            }
        });
        for (PlanetAPI planet : sorted) {
            Misc.CatalogEntryType type = Misc.CatalogEntryType.PLANET;
            if (planet.isGasGiant()) {
                type = Misc.CatalogEntryType.GIANT;
            }
            if (planet.getSpec().isBlackHole()) {
                type = Misc.CatalogEntryType.BLACK_HOLE;
            }
            String firstChar = null;
            if (multiple) {
                firstChar = "" + Character.valueOf((char)(65 + index % 26));
                ++index;
            }
            String name = Misc.genEntityCatalogId(firstChar, -1, -1, -1, type);
            planet.setName(name);
            if (planet.getMarket() != null) {
                planet.getMarket().setName(name);
                planet.getMarket().removeCondition("ruins_scattered");
                planet.getMarket().removeCondition("ruins_widespread");
                planet.getMarket().removeCondition("ruins_extensive");
                planet.getMarket().removeCondition("ruins_vast");
                planet.getMarket().removeCondition("decivilized");
                planet.getMarket().removeCondition("decivilized_subpop");
                planet.getMarket().removeCondition("pollution");
            }
            if (!planet.getSpec().getDescriptionId().equals("barren")) continue;
            planet.setDescriptionIdOverride("barren_deep_space");
        }
        StarSystemGenerator.random = prev;
        system.autogenerateHyperspaceJumpPoints(true, false, false);
        AbyssalRogueStellarObjectEPEC.setAbyssalDetectedRanges(system);
        system.addScript(new AbyssalLocationDespawner(system));
        this.addSpecials(system, manager, point, data);
    }

    protected void addSpecials(StarSystemAPI system, EncounterManager manager, EncounterPoint point, HyperspaceAbyssPluginImpl.AbyssalEPData data) {
    }

    public static void setAbyssalDetectedRanges(StarSystemAPI system) {
        if (system.getAutogeneratedJumpPointsInHyper() != null) {
            for (JumpPointAPI jp : system.getAutogeneratedJumpPointsInHyper()) {
                if (jp.isStarAnchor()) {
                    jp.addTag("star_hidden_on_map");
                }
                float range = HyperspaceAbyssPluginImpl.JUMP_POINT_DETECTED_RANGE;
                if (jp.isGasGiantAnchor()) {
                    range = HyperspaceAbyssPluginImpl.GAS_GIANT_DETECTED_RANGE;
                } else if (jp.isStarAnchor()) {
                    range = HyperspaceAbyssPluginImpl.STAR_DETECTED_RANGE;
                }
                AbyssalRogueStellarObjectEPEC.setAbyssalDetectedRange(jp, range);
            }
        }
        if (system.getAutogeneratedNascentWellsInHyper() != null) {
            for (NascentGravityWellAPI well : system.getAutogeneratedNascentWellsInHyper()) {
                AbyssalRogueStellarObjectEPEC.setAbyssalDetectedRange(well, HyperspaceAbyssPluginImpl.NASCENT_WELL_DETECTED_RANGE);
            }
        }
    }

    public static void setAbyssalDetectedRange(SectorEntityToken entity, float range) {
        float detectedRange = range / HyperspaceTerrainPlugin.ABYSS_SENSOR_RANGE_MULT;
        float desired = detectedRange * HyperspaceTerrainPlugin.ABYSS_SENSOR_RANGE_MULT;
        float maxSensorRange = Global.getSettings().getSensorRangeMaxHyper();
        if (desired > maxSensorRange) {
            entity.setExtendedDetectedAtRange(Float.valueOf(desired - maxSensorRange));
        }
        entity.setSensorProfile(Float.valueOf(1.0f));
        entity.setDiscoverable(false);
        entity.getDetectedRangeMod().modifyFlat("jpDetRange", detectedRange);
        float mult = Math.min(0.5f, 400.0f / range);
        entity.setDetectionRangeDetailsOverrideMult(Float.valueOf(mult));
    }

    public PlanetAPI addBlackHole(StarSystemAPI system, StarSystemGenerator.GenContext context, HyperspaceAbyssPluginImpl.AbyssalEPData data) {
        StarGenDataSpec starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, "black_hole", false);
        system.setLightColor(starData.getLightColorMin());
        float radius = starData.getMinRadius() + (starData.getMaxRadius() - starData.getMinRadius()) * data.random.nextFloat();
        PlanetAPI planet = system.addPlanet(null, null, null, "black_hole", 0.0f, radius, 0.0f, 0.0f);
        StarCoronaTerrainPlugin coronaPlugin = Misc.getCoronaFor(planet);
        if (coronaPlugin != null) {
            system.removeEntity(coronaPlugin.getEntity());
        }
        starData = (StarGenDataSpec)Global.getSettings().getSpec(StarGenDataSpec.class, planet.getSpec().getPlanetType(), false);
        float corona = planet.getRadius() * (starData.getCoronaMult() + starData.getCoronaVar() * (data.random.nextFloat() - 0.5f));
        if (corona < starData.getCoronaMin()) {
            corona = starData.getCoronaMin();
        }
        SectorEntityToken eventHorizon = system.addTerrain("event_horizon", new StarCoronaTerrainPlugin.CoronaParams(planet.getRadius() + corona, (planet.getRadius() + corona) / 2.0f, planet, starData.getSolarWind(), starData.getMinFlare() + (starData.getMaxFlare() - starData.getMinFlare()) * data.random.nextFloat(), starData.getCrLossMult()));
        eventHorizon.setCircularOrbit(planet, 0.0f, 0.0f, 100.0f);
        Collection<TerrainGenDataSpec> terrainDataSpecs = Global.getSettings().getAllSpecs(TerrainGenDataSpec.class);
        TerrainGenDataSpec terrainData = null;
        for (TerrainGenDataSpec curr : terrainDataSpecs) {
            if (!curr.getId().equals("accretion_disk")) continue;
            terrainData = curr;
            break;
        }
        if (terrainData != null) {
            AccretionDiskGenPlugin diskGen = new AccretionDiskGenPlugin();
            context.parent = planet;
            context.currentRadius = 500.0f + data.random.nextFloat() * 1000.0f;
            diskGen.generate(terrainData, context);
        }
        StarSystemGenerator.GeneratedPlanet p = new StarSystemGenerator.GeneratedPlanet(null, planet, false, 0.0f, 0.0f, 0.0f);
        context.generatedPlanets.add(p);
        return planet;
    }

    public static enum RogueStellarObjectType {
        PLANETOID,
        GAS_GIANT,
        BLACK_HOLE;

    }
}

