/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.fleets;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.ShipVariantAPI;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.PersonalFleetScript;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;

public abstract class SDFBase
extends PersonalFleetScript {
    protected PersonAPI person;

    public SDFBase() {
        super(null);
        this.setMinRespawnDelayDays(10.0f);
        this.setMaxRespawnDelayDays(20.0f);
        this.person = this.createOrGetPerson();
        this.setDefeatTrigger(this.getDefeatTriggerToUse());
    }

    protected abstract String getFactionId();

    protected String getDefeatTriggerToUse() {
        return null;
    }

    protected OfficerManagerEvent.SkillPickPreference getCommanderShipSkillPreference() {
        return OfficerManagerEvent.SkillPickPreference.ANY;
    }

    protected PersonAPI createOrGetPerson() {
        int commanderLevel = 7;
        OfficerManagerEvent.SkillPickPreference pref = this.getCommanderShipSkillPreference();
        PersonAPI commander = OfficerManagerEvent.createOfficer(Global.getSector().getFaction(this.getFactionId()), commanderLevel, pref, false, null, true, true, -1, this.random);
        if (commander.getPersonalityAPI().getId().equals("timid")) {
            commander.setPersonality("cautious");
        }
        commander.setRankId(Ranks.SPACE_ADMIRAL);
        commander.setPostId(Ranks.POST_FLEET_COMMANDER);
        return commander;
    }

    @Override
    public PersonAPI getPerson() {
        return this.person;
    }

    public ShipVariantAPI getVariant(String id) {
        return Global.getSettings().getVariant(id);
    }

    @Override
    public boolean canSpawnFleetNow() {
        MarketAPI source = this.getSourceMarket();
        if (source == null || source.hasCondition("decivilized")) {
            return false;
        }
        if (!source.hasIndustry("militarybase") && !source.hasIndustry("highcommand")) {
            return false;
        }
        return source.getFactionId().equals(this.getFactionId());
    }

    @Override
    public boolean shouldScriptBeRemoved() {
        return false;
    }
}

