/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.group.FGBlockadeAction;
import com.fs.starfarer.api.impl.campaign.intel.group.GenericRaidFGI;
import com.fs.starfarer.api.ui.Alignment;
import com.fs.starfarer.api.ui.LabelAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class BlockadeFGI
extends GenericRaidFGI {
    protected FGBlockadeAction.FGBlockadeParams blockadeParams;
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);

    public BlockadeFGI(GenericRaidFGI.GenericRaidParams params, FGBlockadeAction.FGBlockadeParams blockadeParams) {
        super(null);
        if (params.noun == null) {
            params.noun = "blockade";
        }
        if (params.forcesNoun == null) {
            params.forcesNoun = "blockading forces";
        }
        this.params = params;
        this.blockadeParams = blockadeParams;
        this.setRandom(params.random);
        this.initActions();
    }

    @Override
    protected GenericRaidFGI.GenericPayloadAction createPayloadAction() {
        return new FGBlockadeAction(this.blockadeParams, this.params.payloadDays);
    }

    public float getAccessibilityPenalty() {
        int str = this.getRelativeFGStrength(this.getTargetSystem());
        if (str < 0) {
            return 0.0f;
        }
        if (str == 0) {
            return this.blockadeParams.accessibilityPenalty * 0.5f;
        }
        return this.blockadeParams.accessibilityPenalty;
    }

    @Override
    public void advance(float amount) {
        super.advance(amount);
        if (this.isEnded() || this.isEnding() || this.isAborted() || this.isSpawning()) {
            return;
        }
        float days = Misc.getDays(amount);
        this.interval.advance(days);
        if (this.interval.intervalElapsed()) {
            if (this.isCurrent(PAYLOAD_ACTION)) {
                this.applyBlockadeCondition();
            } else {
                this.unapplyBlockadeCondition();
            }
            this.periodicUpdate();
        }
    }

    protected void periodicUpdate() {
    }

    protected void applyBlockadeCondition() {
        int str = this.getRelativeFGStrength(this.getTargetSystem());
        if (str < 0) {
            this.unapplyBlockadeCondition();
            return;
        }
        for (MarketAPI market : Misc.getMarketsInLocation(this.getTargetSystem(), this.blockadeParams.targetFaction)) {
            if (market.hasCondition("blockaded")) continue;
            market.addCondition("blockaded", this);
        }
    }

    protected void unapplyBlockadeCondition() {
        for (MarketAPI market : Misc.getMarketsInLocation(this.getTargetSystem(), this.blockadeParams.targetFaction)) {
            market.removeCondition("blockaded");
        }
    }

    @Override
    protected void notifyEnding() {
        super.notifyEnding();
        this.unapplyBlockadeCondition();
    }

    @Override
    protected void addBasicDescription(TooltipMakerAPI info, float width, float height, float opad) {
        info.addImage(this.getFaction().getLogo(), width, 128.0f, opad);
        StarSystemAPI system = this.raidAction.getWhere();
        String noun = this.getNoun();
        info.addPara(String.valueOf(Misc.ucFirst(this.faction.getPersonNamePrefixAOrAn())) + " %s " + noun + " " + this.getOfString() + " " + "the " + system.getNameWithLowercaseTypeShort() + ".", opad, this.faction.getBaseUIColor(), this.faction.getPersonNamePrefix());
    }

    protected String getOfString() {
        return "of";
    }

    @Override
    protected void addAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
        Color h = Misc.getHighlightColor();
        Color bad = Misc.getNegativeHighlightColor();
        FactionAPI faction = this.getFaction();
        List<MarketAPI> targets = this.params.raidParams.allowedTargets;
        String noun = this.getNoun();
        String forcesNoun = this.getForcesNoun();
        if (!(this.isEnding() || this.isSucceeded() || this.isFailed())) {
            String days;
            FactionAPI other = Global.getSector().getFaction(this.blockadeParams.targetFaction);
            boolean hostile = this.getFaction().isHostileTo(this.blockadeParams.targetFaction);
            info.addSectionHeading("Assessment", faction.getBaseUIColor(), faction.getDarkUIColor(), Alignment.MID, opad);
            boolean started = this.isCurrent(PAYLOAD_ACTION);
            float remaining = this.getETAUntil(PAYLOAD_ACTION, true) - this.getETAUntil(TRAVEL_ACTION, true);
            if (remaining > 0.0f && remaining < 1.0f) {
                remaining = 1.0f;
            }
            String string = days = (int)remaining == 1 ? "day" : "days";
            if (started) {
                days = "more " + days;
            }
            LabelAPI label = info.addPara("The " + noun + " will last for approximately %s " + days + ", causing a %s accessibility penalty " + "for all %s colonies in the " + this.getTargetSystem().getNameWithLowercaseTypeShort() + ".", opad, h, "" + (int)remaining, Math.round(this.blockadeParams.accessibilityPenalty * 100.0f) + "%", other.getPersonNamePrefix());
            label.setHighlight("" + (int)remaining, Math.round(this.blockadeParams.accessibilityPenalty * 100.0f) + "%", other.getPersonNamePrefix());
            label.setHighlightColors(h, h, other.getBaseUIColor());
            if (!hostile) {
                info.addPara("The " + forcesNoun + " are not nominally hostile, but will harass shipping and " + "attempt to maintain control over the system's jump-points.", opad, Misc.getHighlightColor(), "not nominally hostile");
            } else {
                info.addPara("The " + forcesNoun + " are actively hostile, but will not directly attack colonies " + "in the system and will instead " + "attempt to maintain control over the system's jump-points. If a defended planet " + "happens to be near a jump-point, however, the situation is apt to get hot very quickly.", opad, Misc.getNegativeHighlightColor(), "actively hostile");
            }
            this.addStrengthDesc(info, opad, this.getTargetSystem(), forcesNoun, "the " + noun + " is unlikely to be effective", "the " + noun + " is likely to only be partially effective", "the " + noun + " is likely to be fully effective");
            this.addPostAssessmentSection(info, width, height, opad);
        }
    }

    @Override
    protected void addPostAssessmentSection(TooltipMakerAPI info, float width, float height, float opad) {
    }

    public FGBlockadeAction.FGBlockadeParams getBlockadeParams() {
        return this.blockadeParams;
    }
}

