/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.group;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.impl.campaign.fleets.RouteLocationCalculator;
import com.fs.starfarer.api.impl.campaign.fleets.RouteManager;
import com.fs.starfarer.api.impl.campaign.intel.group.BaseFGAction;
import com.fs.starfarer.api.impl.campaign.intel.group.FleetGroupIntel;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class FGTravelAction
extends BaseFGAction {
    protected SectorEntityToken from;
    protected SectorEntityToken to;
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.3f);
    protected String travelText;
    protected String waitingAtDestinationText;
    protected String rendezvousTravelText;
    protected String waitingRendezvousText;
    protected boolean doNotGetSidetracked = true;

    public FGTravelAction(SectorEntityToken from, SectorEntityToken to) {
        StarSystemAPI system;
        this.from = from;
        this.to = to;
        this.travelText = "traveling to " + to.getName();
        this.waitingAtDestinationText = "orbiting " + to.getName();
        this.waitingRendezvousText = "waiting at rendezvous point";
        this.rendezvousTravelText = "traveling to rendezvous point";
        if (to.getContainingLocation() instanceof StarSystemAPI && to == (system = (StarSystemAPI)to.getContainingLocation()).getCenter()) {
            this.travelText = "traveling to the " + system.getNameWithLowercaseTypeShort();
        }
        this.interval.forceIntervalElapsed();
    }

    @Override
    public void addRouteSegment(RouteManager.RouteData route) {
        float travelDays = RouteLocationCalculator.getTravelDays(this.from, this.to);
        RouteManager.RouteSegment segment = new RouteManager.RouteSegment(null, travelDays *= 1.5f, this.from, this.to, null);
        route.addSegment(segment);
    }

    public static float computeETADays(CampaignFleetAPI fleet, SectorEntityToken dest) {
        boolean destIsSystem;
        boolean sameLoc = fleet.getContainingLocation() == dest.getContainingLocation();
        float dist = 0.0f;
        boolean bl = destIsSystem = dest.getStarSystem() != null && dest.getStarSystem().getCenter() == dest;
        if (sameLoc) {
            dist = Misc.getDistance(fleet, dest);
            if (destIsSystem) {
                dist = 0.0f;
            }
        } else {
            dist = Misc.getDistance(fleet.getLocationInHyperspace(), dest.getLocationInHyperspace());
            if (!destIsSystem) {
                dist += 5000.0f;
            }
            if (fleet.getContainingLocation() != null && dest.getContainingLocation() != null && !fleet.getContainingLocation().isHyperspace() && !dest.getContainingLocation().isHyperspace()) {
                dist += 5000.0f;
            }
        }
        return dist / 1000.0f;
    }

    @Override
    public float getEstimatedDaysToComplete() {
        if (this.intel.isSpawnedFleets()) {
            float totalETA = 0.0f;
            float totalStr = 0.0f;
            for (CampaignFleetAPI fleet : this.intel.getFleets()) {
                float eta = FGTravelAction.computeETADays(fleet, this.to);
                float w = fleet.getEffectiveStrength();
                totalETA += eta * w;
                totalStr += w;
            }
            float eta = totalETA / Math.max(1.0f, totalStr);
            return eta;
        }
        RouteManager.RouteSegment segment = this.intel.getSegmentForAction(this);
        if (segment == null) {
            return 0.0f;
        }
        return Math.max(0.0f, segment.daysMax - segment.elapsed);
    }

    @Override
    public void notifySegmentFinished(RouteManager.RouteSegment segment) {
        super.notifySegmentFinished(segment);
        if (FleetGroupIntel.DEBUG) {
            System.out.println("FGTravelAction.notifySegmentFinished() " + segment.getTransitProgress() + " [" + this.from.getName() + " -> " + this.to.getName() + "]");
        }
    }

    @Override
    public void notifyFleetsSpawnedMidSegment(RouteManager.RouteSegment segment) {
        super.notifyFleetsSpawnedMidSegment(segment);
        if (FleetGroupIntel.DEBUG) {
            System.out.println("FGTravelAction.notifyFleetsSpawnedMidSegment() " + segment.getTransitProgress() + " [" + this.from.getName() + " -> " + this.to.getName() + "]");
        }
    }

    @Override
    public void directFleets(float amount) {
        StarSystemAPI system;
        boolean allInSameLocation;
        List<CampaignFleetAPI> fleets = this.intel.getFleets();
        if (fleets.isEmpty()) {
            this.setActionFinished(true);
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        LinkedHashSet<LocationAPI> locations = new LinkedHashSet<LocationAPI>();
        LinkedHashSet<LocationAPI> locationsWithBattles = new LinkedHashSet<LocationAPI>();
        int inFrom = 0;
        int inTo = 0;
        int inHyper = 0;
        for (CampaignFleetAPI fleet : fleets) {
            LocationAPI conLoc = fleet.getContainingLocation();
            locations.add(conLoc);
            if (fleet.getBattle() != null) {
                locationsWithBattles.add(conLoc);
            }
            if (this.to.getContainingLocation() == conLoc) {
                ++inTo;
                continue;
            }
            if (this.from.getContainingLocation() == conLoc && !conLoc.isHyperspace()) {
                ++inFrom;
                continue;
            }
            ++inHyper;
        }
        for (CampaignFleetAPI fleet : fleets) {
            if (!this.doNotGetSidetracked || locationsWithBattles.contains(fleet.getContainingLocation())) continue;
            fleet.getMemoryWithoutUpdate().set("$doNotGetSidetracked", true, 0.4f);
        }
        boolean bl = allInSameLocation = locations.size() == 1;
        if (allInSameLocation && inTo > 0 && this.to.getContainingLocation() instanceof StarSystemAPI && this.to == (system = (StarSystemAPI)this.to.getContainingLocation()).getCenter()) {
            this.setActionFinished(true);
            return;
        }
        if (allInSameLocation) {
            boolean allNear = true;
            Vector2f com = new Vector2f();
            float weight = 0.0f;
            String string = "$FGTravelAction_ignoreFleetForCenterOfMass";
            for (CampaignFleetAPI fleet : fleets) {
                boolean near = fleet.getContainingLocation() == this.to.getContainingLocation() && Misc.getDistance(fleet, this.to) < this.to.getRadius() + 500.0f;
                allNear &= near;
                if (Misc.isSlowMoving(fleet)) {
                    fleet.getMemoryWithoutUpdate().set(string, true, 2.0f);
                }
                if (fleet.getMemoryWithoutUpdate().getBoolean(string)) continue;
                float w = fleet.getFleetPoints();
                Vector2f loc = new Vector2f((ReadableVector2f)fleet.getLocation());
                loc.scale(w);
                Vector2f.add((Vector2f)com, (Vector2f)loc, (Vector2f)com);
                weight += w;
            }
            if (weight < 1.0f) {
                weight = 1.0f;
                if (!fleets.isEmpty()) {
                    com.set((ReadableVector2f)fleets.get(0).getLocation());
                }
            }
            com.scale(1.0f / weight);
            Vector2f dest = null;
            if (inFrom > 0) {
                jp = RouteLocationCalculator.findJumpPointToUse(fleets.get(0), this.from);
                dest = jp.getLocation();
            } else if (inHyper > 0) {
                jp = RouteLocationCalculator.findJumpPointToUse(fleets.get(0), this.to);
                SectorEntityToken jumpExit = null;
                for (JumpPointAPI.JumpDestination jd : jp.getDestinations()) {
                    if (jd.getDestination() == null || !jd.getDestination().isInHyperspace()) continue;
                    jumpExit = jd.getDestination();
                    break;
                }
                dest = jumpExit != null ? jumpExit.getLocation() : this.to.getLocationInHyperspace();
            } else {
                dest = this.to.getLocation();
            }
            if (dest == null) {
                this.setActionFinished(true);
                return;
            }
            float angle = Misc.getAngleInDegrees(com, dest);
            float distComToDest = Misc.getDistance(com, dest);
            float offset = Math.min(distComToDest, 5000.0f);
            Vector2f dir = Misc.getUnitVectorAtDegreeAngle(angle);
            dir.scale(offset);
            dest = new Vector2f((ReadableVector2f)dest);
            Vector2f.add((Vector2f)com, (Vector2f)dir, (Vector2f)dest);
            SectorEntityToken movementToken = fleets.get(0).getContainingLocation().createToken(dest);
            float comLeashRange = 750.0f;
            int numFleets = fleets.size();
            comLeashRange += Math.min((float)Math.max(numFleets - 5, 0) * 100.0f, 500.0f);
            for (CampaignFleetAPI fleet : fleets) {
                fleet.clearAssignments();
                float toCom = Misc.getDistance(fleet.getLocation(), com);
                float toDest = Misc.getDistance(fleet.getLocation(), dest);
                if (inTo > 0 && distComToDest < 500.0f + this.to.getRadius() && toCom < 500.0f) {
                    fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, this.to, 3.0f, this.waitingAtDestinationText);
                    continue;
                }
                if (inTo <= 0 && toCom < 1000.0f && (toDest < 750.0f || distComToDest < 500.0f)) {
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.to, 3.0f, this.travelText);
                    continue;
                }
                if (toCom > comLeashRange) {
                    angle = Misc.getAngleInDegrees(fleet.getLocation(), com);
                    dir = Misc.getUnitVectorAtDegreeAngle(angle);
                    dir.scale(5000.0f);
                    Vector2f overshootCom = Vector2f.add((Vector2f)com, (Vector2f)dir, (Vector2f)new Vector2f());
                    SectorEntityToken comToken = fleets.get(0).getContainingLocation().createToken(overshootCom);
                    fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, comToken, 3.0f, this.travelText);
                    continue;
                }
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, movementToken, 3.0f, this.travelText);
            }
            if (allNear) {
                this.setActionFinished(true);
                return;
            }
        } else {
            SectorEntityToken rendezvous = null;
            if (inTo <= 0) {
                JumpPointAPI jp = RouteLocationCalculator.findJumpPointToUse(fleets.get(0), this.from);
                SectorEntityToken jumpExit = null;
                for (JumpPointAPI.JumpDestination jumpDestination : jp.getDestinations()) {
                    if (jumpDestination.getDestination() == null || !jumpDestination.getDestination().isInHyperspace()) continue;
                    jumpExit = jumpDestination.getDestination();
                    break;
                }
                if (jumpExit != null) {
                    rendezvous = jumpExit;
                }
            } else {
                ArrayList<JumpPointAPI> potential = new ArrayList<JumpPointAPI>();
                for (CampaignFleetAPI fleet : fleets) {
                    JumpPointAPI test;
                    if (fleet.getContainingLocation() != this.to.getContainingLocation() || (test = Misc.findNearestJumpPointTo(fleet)) == null) continue;
                    potential.add(test);
                }
                float bestScore = Float.MAX_VALUE;
                for (SectorEntityToken sectorEntityToken : potential) {
                    float score = 0.0f;
                    for (CampaignFleetAPI fleet : fleets) {
                        if (fleet.getContainingLocation() != this.to.getContainingLocation()) continue;
                        float dist = Misc.getDistance(sectorEntityToken, fleet);
                        score += dist * (float)fleet.getFleetPoints();
                    }
                    if (!(score < bestScore)) continue;
                    bestScore = score;
                    rendezvous = sectorEntityToken;
                }
            }
            if (rendezvous == null) {
                this.setActionFinished(true);
                return;
            }
            for (CampaignFleetAPI fleet : fleets) {
                fleet.clearAssignments();
                if (fleet.getContainingLocation() != rendezvous.getContainingLocation()) {
                    fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, this.to, 3.0f, this.travelText);
                    continue;
                }
                float f = Misc.getDistance(rendezvous, fleet);
                if (f < 500.0f) {
                    fleet.addAssignment(FleetAssignment.ORBIT_PASSIVE, rendezvous, 3.0f, this.waitingRendezvousText);
                    continue;
                }
                fleet.addAssignment(FleetAssignment.GO_TO_LOCATION, rendezvous, 3.0f, this.rendezvousTravelText);
            }
        }
    }

    public String getTravelText() {
        return this.travelText;
    }

    public void setTravelText(String travelText) {
        this.travelText = travelText;
    }

    public String getWaitingAtDestinationText() {
        return this.waitingAtDestinationText;
    }

    public void setWaitingAtDestinationText(String waitingAtDestinationText) {
        this.waitingAtDestinationText = waitingAtDestinationText;
    }

    public String getRendezvousTravelText() {
        return this.rendezvousTravelText;
    }

    public void setRendezvousTravelText(String rendezvousTravelText) {
        this.rendezvousTravelText = rendezvousTravelText;
    }

    public String getWaitingRendezvousText() {
        return this.waitingRendezvousText;
    }

    public void setWaitingRendezvousText(String waitingRendezvousText) {
        this.waitingRendezvousText = waitingRendezvousText;
    }

    public SectorEntityToken getFrom() {
        return this.from;
    }

    public SectorEntityToken getTo() {
        return this.to;
    }

    public void setFrom(SectorEntityToken from) {
        this.from = from;
    }

    public void setTo(SectorEntityToken to) {
        this.to = to;
    }

    public boolean isDoNotGetSidetracked() {
        return this.doNotGetSidetracked;
    }

    public void setDoNotGetSidetracked(boolean doNotGetSidetracked) {
        this.doNotGetSidetracked = doNotGetSidetracked;
    }
}

