/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.misc;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CustomEntitySpecAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.IntelInfoPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.BaseIntelPlugin;
import com.fs.starfarer.api.impl.campaign.terrain.DebrisFieldTerrainPlugin;
import com.fs.starfarer.api.ui.SectorMapAPI;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SalvorsTallyIntel
extends BaseIntelPlugin {
    protected StarSystemAPI system;
    protected long removalCheckTimestamp = 0L;
    protected float daysUntilRemoveCheck = 1.0f;
    protected transient long tallyTimestamp;
    protected transient SalvorsTally cached;

    public SalvorsTallyIntel(StarSystemAPI system) {
        this.system = system;
    }

    @Override
    public boolean shouldRemoveIntel() {
        float daysSince;
        if (!this.system.isCurrentLocation() && (daysSince = Global.getSector().getClock().getElapsedDaysSince(this.removalCheckTimestamp)) > this.daysUntilRemoveCheck) {
            SalvorsTally tally = this.computeTally();
            if (tally.value == SalvageValue.NONE) {
                return true;
            }
            this.removalCheckTimestamp = Global.getSector().getClock().getTimestamp();
            this.daysUntilRemoveCheck = 3.0f + (float)Math.random() * 3.0f;
        }
        return super.shouldRemoveIntel();
    }

    public StarSystemAPI getSystem() {
        return this.system;
    }

    @Override
    protected void addBulletPoints(TooltipMakerAPI info, IntelInfoPlugin.ListInfoMode mode, boolean isUpdate, Color tc, float initPad) {
        String s;
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        float pad = 3.0f;
        float opad = 10.0f;
        SalvorsTally tally = this.computeTally();
        this.bullet(info);
        if (mode != IntelInfoPlugin.ListInfoMode.IN_DESC) {
            Color highlight = h;
            if (tally.value == SalvageValue.NONE) {
                highlight = tc;
            }
            info.addPara("Projected value: %s", initPad, tc, highlight, tally.value.getValueString());
            initPad = 0.0f;
        }
        if (tally.ruins > 0) {
            s = tally.ruins > 1 ? "s" : "";
            s = "s";
            info.addPara("%s unexplored planetside ruin" + s, initPad, tc, h, "" + tally.ruins);
            initPad = 0.0f;
        }
        if (tally.orbital > 0) {
            s = tally.orbital > 1 ? "s" : "";
            info.addPara("%s orbital installation" + s, initPad, tc, h, "" + tally.orbital);
            initPad = 0.0f;
        }
        if (tally.derelicts > 0) {
            s = tally.derelicts > 1 ? "s" : "";
            info.addPara("%s derelict ship" + s, initPad, tc, h, "" + tally.derelicts);
            initPad = 0.0f;
        }
        if (tally.debris > 0) {
            s = tally.debris > 1 ? "s" : "";
            info.addPara("%s unexplored debris field" + s, initPad, tc, h, "" + tally.debris);
            initPad = 0.0f;
        }
        if (tally.other > 0) {
            s = tally.other > 1 ? "s" : "";
            info.addPara("%s other source" + s + " of salvage", initPad, tc, h, "" + tally.other);
            initPad = 0.0f;
        }
        this.unindent(info);
    }

    @Override
    public void createSmallDescription(TooltipMakerAPI info, float width, float height) {
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float small = 3.0f;
        float opad = 10.0f;
        SalvorsTally tally = this.computeTally();
        info.addImage(Global.getSettings().getSpriteName("illustrations", "salvor_explore_hull"), width, opad);
        if (tally.value == SalvageValue.NONE) {
            info.addPara("No salvage is known to be available in the " + this.system.getNameWithLowercaseTypeShort() + ".", opad);
        } else {
            info.addPara("A log of the salvage known to be available in the " + this.system.getNameWithLowercaseTypeShort() + ". The projected total value of the known salvage is %s.", opad, h, tally.value.getValueString());
        }
        this.addBulletPoints(info, IntelInfoPlugin.ListInfoMode.IN_DESC);
        info.addPara("Other, as yet undiscovered, salvage may be present in the system.", opad);
        this.addLogTimestamp(info, tc, opad);
        this.addDeleteButton(info, width);
    }

    @Override
    public String getIcon() {
        SalvorsTally tally = this.computeTally();
        if (tally.value == SalvageValue.NONE) {
            return Global.getSettings().getSpriteName("intel", "salvors_tally_none");
        }
        if (tally.value == SalvageValue.LOW) {
            return Global.getSettings().getSpriteName("intel", "salvors_tally_low");
        }
        if (tally.value == SalvageValue.MEDIUM) {
            return Global.getSettings().getSpriteName("intel", "salvors_tally_medium");
        }
        return Global.getSettings().getSpriteName("intel", "salvors_tally_high");
    }

    @Override
    public Set<String> getIntelTags(SectorMapAPI map) {
        Set<String> tags = super.getIntelTags(map);
        SalvorsTally tally = this.computeTally();
        if (tally.value != SalvageValue.NONE && tally.value != SalvageValue.LOW) {
            tags.add("Exploration");
        }
        tags.add("Salvage");
        return tags;
    }

    @Override
    public SectorEntityToken getMapLocation(SectorMapAPI map) {
        SalvorsTally tally = this.computeTally();
        if (tally.all.size() == 1) {
            return tally.all.get(0);
        }
        return this.system.createToken(0.0f, 0.0f);
    }

    @Override
    public String getName() {
        return "Salvor's Tally - " + this.system.getBaseName();
    }

    @Override
    public String getCommMessageSound() {
        return super.getCommMessageSound();
    }

    @Override
    public String getSortString() {
        return this.getSortStringNewestFirst();
    }

    public SalvorsTally computeTally() {
        long ts = Global.getSector().getClock().getTimestamp();
        if (this.cached != null && ts == this.tallyTimestamp) {
            return this.cached;
        }
        SalvorsTally tally = new SalvorsTally();
        int value = 0;
        for (SectorEntityToken sectorEntityToken : this.system.getEntitiesWithTag("salvageable")) {
            if (sectorEntityToken.isDiscoverable() || sectorEntityToken.hasTag("not_random_mission_target") || sectorEntityToken.hasTag("fading_out_and_expiring") || sectorEntityToken.hasTag("expires")) continue;
            boolean wreck = SalvorsTallyIntel.isDerelictShip(sectorEntityToken);
            boolean station = SalvorsTallyIntel.isOrbitalInstallation(sectorEntityToken);
            if (wreck) {
                ++tally.derelicts;
                ++value;
            } else if (station) {
                ++tally.orbital;
                value += 10;
            } else {
                ++tally.other;
                ++value;
            }
            if (sectorEntityToken.hasTag("neutrino_high")) {
                value += 20;
            }
            tally.all.add(sectorEntityToken);
        }
        for (CampaignTerrainAPI campaignTerrainAPI : this.system.getTerrainCopy()) {
            DebrisFieldTerrainPlugin plugin;
            if (campaignTerrainAPI.isDiscoverable() || campaignTerrainAPI.hasTag("expires") || !(campaignTerrainAPI instanceof CampaignTerrainAPI) || !(campaignTerrainAPI.getPlugin() instanceof DebrisFieldTerrainPlugin) || (plugin = (DebrisFieldTerrainPlugin)campaignTerrainAPI.getPlugin()).isScavenged()) continue;
            ++tally.debris;
            ++value;
            tally.all.add(campaignTerrainAPI);
        }
        for (PlanetAPI planetAPI : this.system.getPlanets()) {
            MarketAPI market;
            if (planetAPI.isStar() || (market = planetAPI.getMarket()) == null || market.getSurveyLevel() != MarketAPI.SurveyLevel.FULL || !Misc.hasUnexploredRuins(market)) continue;
            ++tally.ruins;
            tally.all.add(planetAPI);
            if (market.hasCondition("ruins_scattered")) {
                value += 2;
                continue;
            }
            if (market.hasCondition("ruins_widespread")) {
                value += 6;
                continue;
            }
            if (market.hasCondition("ruins_extensive")) {
                value += 10;
                continue;
            }
            if (!market.hasCondition("ruins_vast")) continue;
            value += 20;
        }
        tally.value = value <= 0 ? SalvageValue.NONE : (value < 10 ? SalvageValue.LOW : (value < 20 ? SalvageValue.MEDIUM : SalvageValue.HIGH));
        this.tallyTimestamp = ts;
        this.cached = tally;
        return tally;
    }

    public static boolean isDerelictShip(SectorEntityToken entity) {
        boolean wreck = "wreck".equals(entity.getCustomEntityType());
        return wreck |= entity.hasTag("wreck");
    }

    public static boolean isOrbitalInstallation(SectorEntityToken entity) {
        CustomEntitySpecAPI spec;
        boolean station = false;
        if (entity.getCustomEntitySpec() != null && ((spec = entity.getCustomEntitySpec()).getShortName().toLowerCase().contains("station") || spec.getShortName().toLowerCase().contains("habitat") || spec.getShortName().toLowerCase().contains("orbital") || entity.hasTag("salvor_orbital"))) {
            station = true;
        }
        return station;
    }

    public static SalvorsTallyIntel getSalvorsTallyIntel(StarSystemAPI system) {
        for (IntelInfoPlugin intel : Global.getSector().getIntelManager().getIntel(SalvorsTallyIntel.class)) {
            if (((SalvorsTallyIntel)intel).getSystem() != system) continue;
            return (SalvorsTallyIntel)intel;
        }
        return null;
    }

    public static enum SalvageValue {
        NONE("none"),
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high");

        private String valueString;

        private SalvageValue(String value) {
            this.valueString = value;
        }

        public String getValueString() {
            return this.valueString;
        }
    }

    public static class SalvorsTally {
        public int ruins;
        public int orbital;
        public int derelicts;
        public int debris;
        public int other;
        public SalvageValue value;
        public List<SectorEntityToken> all = new ArrayList<SectorEntityToken>();
    }
}

