/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.intel.raid;

import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.intel.raid.BaseRaidStage;
import com.fs.starfarer.api.impl.campaign.intel.raid.RaidIntel;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class OrganizeStage
extends BaseRaidStage {
    protected MarketAPI market;
    protected IntervalUtil interval = new IntervalUtil(0.1f, 0.2f);
    protected boolean wasMilitary = false;

    public OrganizeStage(RaidIntel raid, MarketAPI market, float durDays) {
        super(raid);
        this.market = market;
        this.maxDays = durDays;
        this.wasMilitary = market.getMemoryWithoutUpdate().getBoolean("$military");
    }

    @Override
    public void advance(float amount) {
        if (this.status == RaidIntel.RaidStageStatus.ONGOING && (!this.market.isInEconomy() || !this.market.getMemoryWithoutUpdate().getBoolean("$military") && this.wasMilitary)) {
            this.abort();
            return;
        }
        super.advance(amount);
    }

    @Override
    protected void updateStatus() {
        if (this.maxDays <= this.elapsed) {
            this.status = RaidIntel.RaidStageStatus.SUCCESS;
        }
    }

    public void abort() {
        this.status = RaidIntel.RaidStageStatus.FAILURE;
    }

    public MarketAPI getMarket() {
        return this.market;
    }

    @Override
    public void showStageInfo(TooltipMakerAPI info) {
        int curr = this.intel.getCurrentStage();
        int index = this.intel.getStageIndex(this);
        Color h = Misc.getHighlightColor();
        Color g = Misc.getGrayColor();
        Color tc = Misc.getTextColor();
        float pad = 3.0f;
        float opad = 10.0f;
        int days = Math.round(this.maxDays - this.elapsed);
        String strDays = RaidIntel.getDaysString(days);
        String timing = String.valueOf(this.getForcesString()) + " should begin assembling in %s " + strDays + ".";
        if (days < 2) {
            timing = String.valueOf(this.getForcesString()) + " should begin assembling shortly.";
        }
        String raid = this.getRaidString();
        if (this.status == RaidIntel.RaidStageStatus.FAILURE) {
            info.addPara("The " + raid + " has been disrupted in the planning stages and will not happen.", opad);
        } else if (curr == index) {
            boolean known;
            boolean bl = known = !this.market.isHidden() || !this.market.getPrimaryEntity().isDiscoverable();
            if (known) {
                info.addPara("The " + raid + " is currently being planned " + this.market.getOnOrAt() + " " + this.market.getName() + ". " + timing, opad, h, "" + days);
            } else {
                info.addPara("The " + raid + " is currently in the planning stages. " + timing, opad, h, "" + days);
            }
        }
    }

    protected String getForcesString() {
        return "The raiding forces";
    }

    protected String getRaidString() {
        return "raid";
    }
}

