/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.academy;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.ids.People;
import com.fs.starfarer.api.impl.campaign.missions.academy.GABaseMission;
import com.fs.starfarer.api.impl.campaign.missions.hub.HubMissionWithTriggers;
import com.fs.starfarer.api.ui.TooltipMakerAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class GAKallichore
extends GABaseMission {
    protected PersonAPI baird;
    protected PersonAPI arroyo;
    protected PersonAPI gargoyle;
    protected PersonAPI loke;
    protected SectorEntityToken relay;

    @Override
    protected boolean create(MarketAPI createdAt, boolean barEvent) {
        if (!this.setGlobalReference("$gaKA_ref", "$gaKA_inProgress")) {
            return false;
        }
        this.setName("The Kallichore Archive");
        this.baird = this.getImportantPerson(People.BAIRD);
        this.arroyo = this.getImportantPerson(People.ARROYO);
        this.gargoyle = this.getImportantPerson(People.GARGOYLE);
        this.loke = this.getImportantPerson(People.CLONE_LOKE);
        if (this.baird == null) {
            return false;
        }
        if (this.arroyo == null) {
            return false;
        }
        if (this.gargoyle == null) {
            return false;
        }
        if (this.loke == null) {
            return false;
        }
        this.relay = Global.getSector().getEntityById("aztlan_relay");
        if (this.relay == null) {
            return false;
        }
        StarSystemAPI mayasura = this.gargoyle.getMarket().getStarSystem();
        StarSystemAPI galatia = this.baird.getMarket().getStarSystem();
        if (mayasura == null || galatia == null) {
            return false;
        }
        MarketAPI coatl = Global.getSector().getEconomy().getMarket("coatl");
        if (coatl == null) {
            return false;
        }
        this.setStoryMission();
        this.setStartingStage((Object)Stage.TALK_TO_ARROYO);
        this.addSuccessStages(new Object[]{Stage.COMPLETED});
        this.makeImportant(this.arroyo, "$gaKA_contact", Stage.TALK_TO_ARROYO);
        this.makeImportant(this.arroyo.getMarket(), "$gaKA_visitChalet", Stage.VISIT_ARROYO);
        this.makeImportant(this.gargoyle, "$gaKA_contact", Stage.TALK_TO_GARGOYLE);
        this.makeImportant(this.loke.getMarket(), "$gaKA_getHack", Stage.GET_HACK_HARDWARE);
        this.makeImportant(this.relay, "$gaKA_installHack", Stage.INSTALL_HACK);
        this.makeImportant(this.gargoyle, "$gaKA_contactRetrieve", Stage.RETRIEVE_ARCHIVE);
        this.makeImportant(this.baird.getMarket(), "$gaKA_returnHere", Stage.RETURN_TO_ACADEMY);
        this.setStageOnGlobalFlag((Object)Stage.VISIT_ARROYO, "$gaKA_visitArroyo");
        this.setStageOnGlobalFlag((Object)Stage.TALK_TO_GARGOYLE, "$gaKA_talkToGargoyle");
        this.setStageOnGlobalFlag((Object)Stage.GET_HACK_HARDWARE, "$gaKA_getHackHardware");
        this.setStageOnGlobalFlag((Object)Stage.INSTALL_HACK, "$gaKA_installHack");
        this.setStageOnGlobalFlag((Object)Stage.RETRIEVE_ARCHIVE, "$gaKA_retrieveArchive");
        this.setStageOnGlobalFlag((Object)Stage.RETURN_TO_ACADEMY, "$gaKA_returnToAcademy");
        this.setStageOnGlobalFlag((Object)Stage.COMPLETED, "$gaKA_completed");
        this.beginStageTrigger(new Object[]{Stage.TALK_TO_ARROYO});
        this.triggerUnhideCommListing(this.arroyo);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.TALK_TO_GARGOYLE});
        this.triggerUnhideCommListing(this.gargoyle);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.RETURN_TO_ACADEMY});
        this.triggerHideCommListing(this.gargoyle);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.RETURN_TO_ACADEMY});
        SectorEntityToken fleetLocation = this.gargoyle.getMarket().getPrimaryEntity();
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.VERY_LARGE, HubMissionWithTriggers.FleetQuality.DEFAULT, "hegemony", "taskForce", fleetLocation);
        this.triggerAutoAdjustFleetStrengthModerate();
        this.triggerMakeAllFleetFlagsPermanent();
        this.triggerMakeFleetIgnoreOtherFleets();
        this.triggerMakeFleetIgnoredByOtherFleets();
        this.triggerSetPatrol();
        this.triggerPickLocationAtClosestToEntityJumpPoint(mayasura, fleetLocation, 4000.0f);
        this.triggerPickLocationTowardsEntity(null, 30.0f, 5000.0f);
        this.triggerSpawnFleetAtPickedLocation(null, null);
        this.triggerFleetSetPatrolActionText("standing off with Port Tse Station");
        this.triggerFleetSetPatrolLeashRange(100.0f);
        this.triggerOrderFleetPatrol(fleetLocation);
        this.triggerOrderFleetEBurn(1.0f);
        this.triggerIncreaseMarketHostileTimeout(this.gargoyle.getMarket(), 90.0f);
        this.endTrigger();
        this.beginWithinHyperspaceRangeTrigger(this.gargoyle.getMarket(), 1.0f, true, new Object[]{Stage.RETURN_TO_ACADEMY});
        this.triggerCreateFleet(HubMissionWithTriggers.FleetSize.LARGE, HubMissionWithTriggers.FleetQuality.SMOD_1, "hegemony", "taskForce", mayasura);
        this.triggerSetFleetOfficers(HubMissionWithTriggers.OfficerNum.MORE, HubMissionWithTriggers.OfficerQuality.HIGHER);
        this.triggerMakeHostileAndAggressive();
        this.triggerFleetAllowLongPursuit();
        this.triggerSetFleetAlwaysPursue();
        this.triggerSetPatrol();
        this.triggerPickLocationTowardsEntity(galatia.getHyperspaceAnchor(), 90.0f, GAKallichore.getUnits(0.5f));
        this.triggerSpawnFleetAtPickedLocation("$gaKA_patrol", null);
        this.triggerOrderFleetInterceptPlayer();
        this.triggerOrderFleetEBurn(1.0f);
        this.triggerFleetMakeImportant(null, Stage.RETURN_TO_ACADEMY);
        this.endTrigger();
        this.triggerCreateMediumPatrol(coatl, "hegemony", this.relay, (Object)Stage.INSTALL_HACK, 0.0f);
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerRemoveTags(this.relay, "story_critical");
        this.triggerMakeNonStoryCritical(this.gargoyle.getMarket(), this.arroyo.getMarket(), this.loke.getMarket(), coatl);
        this.triggerMovePersonToMarket(this.gargoyle, this.baird.getMarket(), true);
        this.triggerUnhideCommListing(this.gargoyle);
        this.endTrigger();
        float baseDelay = 90.0f;
        this.beginStageTrigger(new Object[]{Stage.RETRIEVE_ARCHIVE});
        this.triggerSetGlobalMemoryValueAfterDelay(this.genDelay(baseDelay), "$gaKA_triTachyonVisit", true);
        this.triggerSetGlobalMemoryValueAfterDelay(this.genDelay(baseDelay), "$gaKA_hegemonyVisit", true);
        this.endTrigger();
        this.beginStageTrigger(new Object[]{Stage.COMPLETED});
        this.triggerSetGlobalMemoryValue("$gaKA_missionCompleted", true);
        this.endTrigger();
        return true;
    }

    @Override
    protected void updateInteractionDataImpl() {
        this.set("$gaKA_stage", this.getCurrentStage());
    }

    @Override
    public void addDescriptionForNonEndStage(TooltipMakerAPI info, float width, float height) {
        float opad = 10.0f;
        Color h = Misc.getHighlightColor();
        FactionAPI heg = Global.getSector().getFaction("hegemony");
        if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("You've recovered the data archive of the Academy's previous Provost, Tomas Kallichore, which contains the results of failed gate activation experiments.", opad);
        } else {
            info.addPara("Recover the data archive of the Academy's previous Provost, Tomas Kallichore, which contains the results of failed gate activation experiments.", opad);
            info.addPara("The archive is currently in the ultra-secure data vaults of the Hegemony Ministry of Technology Standards.", opad, heg.getBaseUIColor(), "Hegemony");
        }
        if (this.currentStage == Stage.TALK_TO_ARROYO) {
            info.addPara(String.valueOf(this.getGoTalkToPersonText(this.arroyo)) + ". He has a relationship with Provost Baird that " + "can be leveraged to compel his cooperation.", opad);
        } else if (this.currentStage == Stage.VISIT_ARROYO) {
            info.addPara("Visit " + this.arroyo.getNameString() + " in person, at his planetside chalet.", opad);
        } else if (this.currentStage == Stage.TALK_TO_GARGOYLE) {
            info.addPara(String.valueOf(this.getGoTalkToPersonText(this.gargoyle)) + ", a hacker, to arrange a break in to the data vaults. " + "Arroyo is sure a job \"as stupid as you're proposing\" " + "will prove irresistible.", opad);
        } else if (this.currentStage == Stage.GET_HACK_HARDWARE) {
            info.addPara(String.valueOf(this.getGoToMarketText(this.loke.getMarket())) + " and pick up the hack device from a " + "storage unit.", opad);
        } else if (this.currentStage == Stage.INSTALL_HACK) {
            info.addPara(String.valueOf(this.getGoToSystemTextShort(this.relay.getStarSystem())) + " and install the hack transmitter " + "on " + this.relay.getName() + ".", opad);
        } else if (this.currentStage == Stage.RETRIEVE_ARCHIVE) {
            info.addPara(String.valueOf(this.getGoToMarketText(this.gargoyle.getMarket())) + " and retrieve Kallichore's archive from Gargoyle.", opad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("Return to the Galatia Academy and talk to Provost Baird.", opad);
        }
    }

    @Override
    public boolean addNextStepText(TooltipMakerAPI info, Color tc, float pad) {
        Color h = Misc.getHighlightColor();
        if (this.currentStage == Stage.TALK_TO_ARROYO) {
            info.addPara(this.getGoTalkToPersonText(this.arroyo), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.VISIT_ARROYO) {
            info.addPara("Visit " + this.arroyo.getNameString() + " in person, at his planetside chalet", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.TALK_TO_GARGOYLE) {
            info.addPara(this.getGoTalkToPersonText(this.gargoyle), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.GET_HACK_HARDWARE) {
            info.addPara(String.valueOf(this.getGoToMarketText(this.loke.getMarket())) + " and pick up the hack device", tc, pad);
            return true;
        }
        if (this.currentStage == Stage.INSTALL_HACK) {
            info.addPara(String.valueOf(this.getGoToSystemTextShort(this.relay.getStarSystem())) + " and install the hack transmitter " + "on the " + this.relay.getName(), tc, pad);
            return true;
        }
        if (this.currentStage == Stage.RETRIEVE_ARCHIVE) {
            info.addPara(String.valueOf(this.getGoToMarketText(this.gargoyle.getMarket())) + " and retrieve Kallichore's archive", tc, pad);
        } else if (this.currentStage == Stage.RETURN_TO_ACADEMY) {
            info.addPara("Return to the Galatia Academy and talk to Provost Baird", tc, pad);
        }
        return false;
    }

    @Override
    public String getPostfixForState() {
        if (this.startingStage != null) {
            return "";
        }
        return super.getPostfixForState();
    }

    public static enum Stage {
        TALK_TO_ARROYO,
        VISIT_ARROYO,
        TALK_TO_GARGOYLE,
        GET_HACK_HARDWARE,
        INSTALL_HACK,
        RETRIEVE_ARCHIVE,
        RETURN_TO_ACADEMY,
        COMPLETED;

    }
}

