/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.missions.hub;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.ai.CampaignFleetAIAPI;
import com.fs.starfarer.api.campaign.ai.FleetAssignmentDataAPI;
import com.fs.starfarer.api.campaign.ai.ModularFleetAIAPI;
import com.fs.starfarer.api.impl.campaign.missions.hub.BaseHubMission;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MissionFleetInterceptPlayerIfNearby
implements EveryFrameScript {
    protected CampaignFleetAPI fleet;
    protected BaseHubMission mission;
    protected Set<Object> stages = new HashSet<Object>();
    protected boolean done = false;
    protected float delay;
    protected float delayRemaining;
    protected float maxRange;
    protected boolean repeatable;
    protected boolean mustBeStrongEnoughToFight;
    protected IntervalUtil interval = new IntervalUtil(0.05f, 0.1f);

    public MissionFleetInterceptPlayerIfNearby(CampaignFleetAPI fleet, BaseHubMission mission, boolean mustBeStrongEnoughToFight, float maxRange, boolean repeatable, float repeatDelay, List<Object> stages) {
        this.delay = repeatDelay;
        this.mission = mission;
        this.fleet = fleet;
        this.mustBeStrongEnoughToFight = mustBeStrongEnoughToFight;
        this.maxRange = maxRange;
        this.repeatable = repeatable;
        this.stages.addAll(stages);
    }

    @Override
    public void advance(float amount) {
        if (this.done) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.delayRemaining -= days;
        if (this.delayRemaining < 0.0f) {
            this.delayRemaining = 0.0f;
        }
        if (this.delayRemaining > 0.0f) {
            return;
        }
        this.interval.advance(days);
        if (!this.interval.intervalElapsed()) {
            return;
        }
        if (this.fleet.getMemoryWithoutUpdate().getBoolean("$turnOffAutoInterceptScript")) {
            this.done = true;
            return;
        }
        Object stage = this.mission.getCurrentStage();
        if (!this.stages.contains(stage)) {
            this.done = true;
            return;
        }
        if (this.fleet.getAI() instanceof ModularFleetAIAPI) {
            ModularFleetAIAPI ai = (ModularFleetAIAPI)this.fleet.getAI();
            CampaignFleetAPI player = Global.getSector().getPlayerFleet();
            if (this.mustBeStrongEnoughToFight && ai.getTacticalModule() != null) {
                CampaignFleetAIAPI.EncounterOption option = ai.getTacticalModule().pickEncounterOption(null, player);
                boolean recentlyBeaten = this.fleet.getMemoryWithoutUpdate().getBoolean("$cfai_recentlyDefeatedByPlayer");
                if (recentlyBeaten) {
                    option = CampaignFleetAIAPI.EncounterOption.DISENGAGE;
                }
                if (option == CampaignFleetAIAPI.EncounterOption.DISENGAGE || option == CampaignFleetAIAPI.EncounterOption.HOLD_VS_STRONGER) {
                    return;
                }
            }
            if (ai.getAssignmentModule() != null) {
                FleetAssignmentDataAPI curr = ai.getAssignmentModule().getCurrentAssignment();
                if (curr != null && curr.getTarget() == player && (curr.getAssignment() == FleetAssignment.INTERCEPT || curr.getAssignment() == FleetAssignment.FOLLOW)) {
                    return;
                }
                if (player.getContainingLocation() == this.fleet.getContainingLocation() && Misc.getDistance(player, this.fleet) <= this.maxRange + player.getRadius() + this.fleet.getRadius() && this.fleet.getVisibilityLevelOfPlayerFleet() != SectorEntityToken.VisibilityLevel.NONE) {
                    ai.getAssignmentModule().addAssignmentAtStart(FleetAssignment.INTERCEPT, player, 3.0f, null);
                    this.delayRemaining = this.delay;
                    if (!this.repeatable) {
                        this.done = true;
                    }
                }
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }
}

