/*
 * Decompiled with CFR 0.152.
 */
package com.fs.starfarer.api.impl.campaign.skills;

import com.fs.starfarer.api.characters.CharacterStatsSkillEffect;
import com.fs.starfarer.api.characters.DescriptionSkillEffect;
import com.fs.starfarer.api.characters.LevelBasedEffect;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.characters.ShipSkillEffect;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class BestOfTheBest {
    public static int EXTRA_MODS = 1;
    public static float DEPLOYMENT_BONUS = 0.1f;

    public static class Level0
    implements DescriptionSkillEffect {
        @Override
        public String getString() {
            int max = Misc.MAX_PERMA_MODS;
            return "*The base maximum number of permanent hullmods you're able to build into a ship is " + max + ".";
        }

        @Override
        public Color[] getHighlightColors() {
            Color h = Misc.getHighlightColor();
            h = Misc.getDarkHighlightColor();
            return new Color[]{h, h, h};
        }

        @Override
        public String[] getHighlights() {
            int max = Misc.MAX_PERMA_MODS;
            return new String[]{"" + max};
        }

        @Override
        public Color getTextColor() {
            return null;
        }
    }

    public static class Level1
    implements ShipSkillEffect {
        @Override
        public void apply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id, float level) {
            stats.getDynamic().getMod("max_permanent_hullmods_mod").modifyFlat(id, EXTRA_MODS);
        }

        @Override
        public void unapply(MutableShipStatsAPI stats, ShipAPI.HullSize hullSize, String id) {
            stats.getDynamic().getMod("max_permanent_hullmods_mod").unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Able to build " + EXTRA_MODS + " more permanent hullmod* into ships";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.FLEET;
        }
    }

    public static class Level2
    implements CharacterStatsSkillEffect {
        @Override
        public void apply(MutableCharacterStatsAPI stats, String id, float level) {
            stats.getDynamic().getMod("deployment_points_min_fraction_of_battle_size_bonus_mod").modifyFlat(id, DEPLOYMENT_BONUS);
        }

        @Override
        public void unapply(MutableCharacterStatsAPI stats, String id) {
            stats.getDynamic().getMod("deployment_points_min_fraction_of_battle_size_bonus_mod").unmodifyFlat(id);
        }

        @Override
        public String getEffectDescription(float level) {
            return "Deployment points bonus from objectives is at least " + Math.round(DEPLOYMENT_BONUS * 100.0f) + "% of the battle size, even if holding no objectives";
        }

        @Override
        public String getEffectPerLevelDescription() {
            return null;
        }

        @Override
        public LevelBasedEffect.ScopeDescription getScopeDescription() {
            return LevelBasedEffect.ScopeDescription.ALL_SHIPS;
        }
    }
}

